// ************************************************************
// afterain.pov, 08/98 (c) Nicolas Calimet
// ************************************************************

// no ambient light
global_settings { ambient_light 0.0 }

// global variables
#declare SkyRadius = 80
#declare SunColor = rgb <1.0,0.9,0.6>
#declare YLake = -78

// ------------------------------------------------------------
// camera settings
// ------------------------------------------------------------
#declare RATIO = 4. / 3.	// image ratio
#declare DIST  = -100		// distance
#declare ANGLE = 50		// lens horizontal angle

camera
{
   perspective
   right    <RATIO, 0, 0>
   up       <0, 1, 0>
   location <0,0,DIST>
   angle    ANGLE
   look_at  <0,0,0>

   focal_point <0,0,1500>
   aperture 1.0
   blur_samples 100
}

// ------------------------------------------------------------
// atmosphere settings
// ------------------------------------------------------------
fog   // hilight the scene
{
   distance 4000
   color SunColor transmit 0.93
}

atmosphere   // `wet' atmosphere
{
   type 2
   samples 150
   distance 2300
   scattering 0.15
   aa_level 4
   aa_threshold 0.1
   jitter 0.2
}

// ------------------------------------------------------------
// light sources
// ------------------------------------------------------------
light_source   // ambient light
{
   <-30, 30, DIST>
   color rgb <0.05, 0.05, 0.00>
   shadowless
   atmosphere off
}

light_source   // sun
{
   <2e3, 2e3, 1e4>
   color SunColor
   atmospheric_attenuation on
}

// ------------------------------------------------------------
// sky settings
// ------------------------------------------------------------
background { color rgb <1.0,0.8,0.5> }

sphere   // clouds
{
   <0,0,0>, SkyRadius
   pigment
   {
      bozo
      turbulence 0.6
         octaves 6
         omega 0.7
         lambda 2.2
      color_map
      {
         [0.0 0.2 color rgb <0.00, 0.00, 0.00>
                  color rgb <0.25, 0.25, 0.25>]
         [0.2 0.4 color rgb <0.25, 0.25, 0.25>
                  color rgb <0.75, 0.75, 0.75>]
         [0.4 0.6 color rgb <0.75, 0.75, 0.75>
                  color rgbt <1, 1, 1, 1>]
         [0.6 1.0 color rgbt <1, 1, 1, 1>
                  color rgbt <1, 1, 1, 1>]
      }
      scale <0.2*SkyRadius, 2*SkyRadius, 0.2*SkyRadius>
   }
   hollow
   scale <30, 1, 50>
   rotate <0,-3,0>
   clipped_by { box { <-3000,10,-40000> <3000,1000,40000> } }
}

// ------------------------------------------------------------
// lake settings
// ------------------------------------------------------------
plane
{
   y, YLake
   pigment { color rgb<0.5,0.5,0.8> }
   normal { bumps 0.15 scale 1.33 }
   finish { reflection 1.0 }
}

// `lights carpet' on the lake
#declare a = seed(31415)
#declare b = seed(14142)

#declare i = 0
#while (i<5)
   #declare j = 0
   #while (j<20)

      #declare X = j*8 - (182 + i*30)
      #declare Y = YLake + 0.01
      #declare Z = 390 + 150*i
      #declare Xnoise = rand(a)
      #declare Znoise = rand(b)

      //#declare Xnoise = (Xnoise * 8) - 4
      #declare Xnoise = (Xnoise * 8*(i+1)) - 4*(i+1)
      #declare Znoise = (Znoise * 150*(i+1)) - 75*(i+1)
      //#declare FadeDist = 62 - i*7.5
      #declare FadeDist = 62 - i*10

      light_source
      {
         <X + Xnoise, Y, Z + Znoise>
         color SunColor * 0.1
         spotlight
            radius 0.1
            falloff 2
            tightness 10
            point_at <0, 0, DIST>
         fade_distance FadeDist
         fade_power 2
         atmospheric_attenuation on
      }

      #declare j = j + 1

   #end
   #declare i = i+1
#end

// ------------------------------------------------------------
// moutains settings
// ------------------------------------------------------------
#declare MountainTexture = pigment
{
   bozo
   turbulence 0.9
      octaves 7
      omega 0.7
      lambda 8.0
   color_map
   {
      [0.0 0.1 color rgb <0.10, 0.50, 0.30>
               color rgb <0.30, 0.80, 0.20>]
      [0.1 0.3 color rgb <0.30, 0.75, 0.25>
               color rgb <0.45, 0.90, 0.40>]
      [0.3 0.6 color rgb <0.85, 0.95, 0.90>
               color rgb <0.80, 0.90, 0.85>]
      [0.6 0.7 color rgb <0.60, 0.55, 0.45>
               color rgb <0.50, 0.45, 0.40>]
      [0.7 1.0 color rgb <0.80, 0.85, 0.75>
               color rgb <0.85, 0.90, 0.80>]
   }
   rotate y*90
}

#declare mountains = height_field   // moutains
{
   tga "mountain.tga"
   smooth
   pigment { MountainTexture }
   pigment { color rgb <1,1,1> }
   translate <-.5, -.5, -.5>
}

object   // background mountains
{
   mountains
   normal { bumps 50 scale 1}
   scale <3300,900,2000>
   translate <80,-157,1500>
}

object   // hill for the chapel
{
   mountains
   scale <600,150,600>
   translate <100, -135, 450>
}

// ------------------------------------------------------------
// include file objects
// ------------------------------------------------------------

// chapel
#include "chapel.inc"
object { Chapel  scale 10  rotate y*88  translate <-102, -65, 325> }

// tree on the hill
#include "tree.inc"
object { Tree  scale 0.11  rotate <0,45,-10>  translate <-68, -63, 330> }

// bushs on the hill
#include "bush.inc"
object { Bush  scale 0.13                translate <-72, -61, 328> }
object { Bush  scale 0.14  rotate y*150  translate <-88, -64, 330> }
object { Bush  scale 0.11  rotate y*55   translate <-83, -62, 326> }
object { Bush  scale 0.12  rotate y*80   translate <-112, -68, 315> }
object { Bush  scale 0.12  rotate y*120  translate <-72, -65, 290> }
object { Bush  scale 0.14  rotate y*15   translate <-76, -65, 287> }
object { Bush  scale 0.14  rotate y*150  translate <-75, -65, 284> }
object { Bush  scale 0.12  rotate y*45   translate <-120, -72, 285> }
object { Bush  scale 0.14  rotate y*110  translate <-114, -71, 289> }
object { Bush  scale 0.13  rotate y*270  translate <-123, -70, 286> }
object { Bush  scale 0.14  rotate y*180  translate <-50, -71, 277> }
object { Bush  scale 0.13  rotate y*130  translate <-135, -72, 340> }

// foreground bushs
object { Bush  rotate y*180  translate <40,-35,-10> }
object { Bush  rotate y*270  translate <-38,-52,-8> }
