// ************************************************************
// chapel.inc, 08/98 (c) Nicolas Calimet
// ************************************************************

// ------------------------------------------------------------
// "tiles" texture
// ------------------------------------------------------------
#declare ChapelTiles = texture
{
   pigment
   {
      bozo
      turbulence 0.9
         octaves 7
         omega 0.8
         lambda 10.0
      color_map
      {
         [0.0 0.4 color rgb <0.60, 0.40, 0.40>
                  color rgb <0.55, 0.35, 0.45>]
         [0.4 1.0 color rgb <0.30, 0.20, 0.25>
                  color rgb <0.35, 0.15, 0.20>]
      }
   }
   normal { bumps 0.5 scale 0.01 }
}

// ------------------------------------------------------------
// wood texture
// ------------------------------------------------------------
#declare Wood = texture
{
   pigment
   {
      bozo
      turbulence 0.9
         octaves 7
         omega 0.8
         lambda 10.0
      color_map
      {
         [0.0 0.4 color rgb <0.2, 0.1, 0.0>
                  color rgb <0.15, 0.15, 0.0>]
         [0.4 1.0 color rgb <0.3, 0.15, 0.0>
                  color rgb <0.20, 0.10, 0.0>]
      }
   }
   normal { bumps 0.5 scale 0.01 }
}

// ------------------------------------------------------------
// wall texture
// ------------------------------------------------------------
#declare WallTexture = texture
{
   pigment
   {
      bozo
      turbulence 0.9
         octaves 7
         omega 0.8
         lambda 10.0
      color_map
      {
         [0.0 0.4 color rgb <0.75, 0.75, 0.75>
                  color rgb <0.85, 0.85, 0.85>]
         [0.4 1.0 color rgb <0.95, 0.95, 0.95>
                  color rgb <1.00, 1.00, 1.00>]
      }
   }
   normal { bumps 0.5 scale 0.01 }
}

// ------------------------------------------------------------
// front door
// ------------------------------------------------------------
#declare door = union
{
   box { <0.2, -0.5, -0.2> <0.6, -0.1, 0.2> }
   intersection
   {
      box { <0.2, -0.5, -0.2> <0.6, 1.5, 0.2> }
      cylinder { <0.2, -0.1, 0.8> <0.6, -0.1, 0.8> 1.0  }
      cylinder { <0.2, -0.1, -0.8> <0.6, -0.1, -0.8> 1.0 }
   }
   texture { Wood }
}

// ------------------------------------------------------------
// front circular window
// ------------------------------------------------------------
#declare window = cylinder
{
   <0.2, 0.0, 0.0> <0.7, 0.0, 0.0> 0.09
   scale <1.0, 1.7, 1.0>
   translate y
   pigment
   {
      bozo
      turbulence 0.9
         octaves 7
         omega 0.8
         lambda 10.0
      color_map
      {
         [0.0 color rgb <1.0, 0.0, 0.0>]
         [0.2 color rgb <0.0, 1.0, 0.0>]
         [0.4 color rgb <0.0, 0.0, 1.0>]
         [0.6 color rgb <1.0, 1.0, 0.0>]
         [0.8 color rgb <1.0, 0.0, 1.0>]
         [1.0 color rgb <0.0, 1.0, 1.0>]
      }
   }
}

// ------------------------------------------------------------
// room
// ------------------------------------------------------------
#declare room = union
{
   // walls
   box { <-1.0, -0.5, -0.5> <0.5, 0.5, 0.5> }
   box
   {
      <-1.0, -0.5, -0.5> <0.5, 0.5, 0.5>
      rotate x*45
      scale <1.0, sqrt(2), 1./sqrt(2)>
      translate 0.5*y
   }
   cylinder { <-1.0, -0.5, 0> <-1.0, 0.5, 0> 0.5 }

   // roof
   union
   {
      cylinder { <-1.0, 0.50, -0.50> <0.50, 0.50, -0.50> 0.03 }
      triangle { <-1.0, 0.50, -0.50> <0.50, 1.50, 0.00> <0.50, 0.50, -0.50> }
      triangle { <-1.0, 0.50, -0.50> <-1.0, 1.50, 0.00> <0.50, 1.50, 0.00> }
      cylinder { <-1.0, 1.50, 0.00> <0.50, 1.50, 0.00> 0.03 }
      triangle { <-1.0, 0.50, 0.50> <0.50, 1.50, 0.00> <0.50, 0.50, 0.50> }
      triangle { <-1.0, 0.50, 0.50> <-1.0, 1.50, 0.00> <0.50, 1.5, 0.0> }
      cylinder { <-1.0, 0.50, 0.50> <0.50, 0.50, 0.50> 0.03 }
      cone { <-1.0, 0.5, 0> 0.5 <-1.0, 1.5, 0> 0 }
      texture { ChapelTiles }
   }

   // window border
   cylinder
   {
      <0.0, 0.0, 0.0> <0.6, 0.0, 0.0> 0.12
      scale <1.0, 1.7, 1.0>
      translate y
   }
}

// ------------------------------------------------------------
// bell tower
// ------------------------------------------------------------
#declare wall = union
{
   box { <0.2, 1.0, -0.2> <0.5, 2.0, 0.2> }
   box
   {
      <0.2, -0.2, -0.2> <0.5, 0.2, 0.2>
      rotate x*45
      scale <1.0, 1.667, 1./sqrt(2)>
      translate 2.0*y
   }
}

#declare tower = union
{
   difference  // wall
   {
      object { wall }
      box { <0.0,  1.6, -0.12> <0.6, 2.0, 0.12> }
      cylinder { <0.0, 2.0, 0.0> <0.6, 2.0, 0.0> 0.12 }
   }
   union  // roof
   {
      cylinder { <0.20, 2.00, -0.20> <0.50, 2.00, -0.20> 0.03 }
      triangle { <0.20, 2.00, -0.20> <0.50, 2.5, 0.0> <0.50, 2.00, -0.20> }
      triangle { <0.20, 2.00, -0.20> <0.20, 2.5, 0.0> <0.50, 2.50, 0.00> }
      cylinder { <0.20, 2.50, 0.00> <0.50, 2.50, 0.00> 0.03 }
      triangle { <0.20, 2.00, 0.20> <0.50, 2.5, 0.0> <0.50, 2.00, 0.20> }
      triangle { <0.20, 2.00, 0.20> <0.20, 2.5, 0.0> <0.50, 2.50, 0.00> }
      cylinder { <0.20, 2.00, 0.20> <0.50, 2.00, 0.20> 0.03 }
      texture { ChapelTiles }
   }
   union  // bell
   {
      cone { <0.35, 1.70, 0.0>, 0.08, <0.35, 1.95, 0.0>, 0.0 }
      sphere { <0.35, 1.95, 0.0>, 0.04 }
      cylinder { <0.35, 1.95, -0.15> <0.35, 1.95, 0.15> 0.02 }
      pigment { color rgb <0.2, 0.2, 0.1> }
   }
   union  // cross
   {
      cylinder { <0.35, 2.5, 0.0> <0.35, 3.0, 0.0> 0.03 }
      cylinder { <0.35, 2.8, -0.1> <0.35, 2.8, 0.1> 0.03 }
      pigment { color rgb <0,0,0> }
   }
   translate -0.2*x
}

// ------------------------------------------------------------
// chapel object
// ------------------------------------------------------------
#declare Chapel = union
{
   difference
   {
      union
      {
         object { room }
         object { tower }
      }
      object { door }
      object { window }
   }

   box { <0.1, -0.5, -0.1> <0.35, 0.1, 0.1>  texture { Wood } }

   // wall texture
   texture { WallTexture }

   scale <1.5, 1.1, 1.7>
}
