
// Persistence of Vision Ray Tracer Scene Description File
// File: Airbrush.pov
// Vers: 3.02
// Desc: A variety of Elements
// Date: 27th August 1998
// Auth: ewgr@abaddon.globalnet.co.uk


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

//- A gaggle of cameras.
 
    camera { location  <0.0 , 3.0 ,-10.5> look_at   <0.0 , 1.0 , 0.0>}
 // camera { location  <30.0 , 40.0 ,5.0> look_at   <0.0 , 0.0 , 5.0>}
 // camera { location  <-40,5,-1.5> look_at  <-5.5,-4.5,1.5>}
 // camera { location  <0.0 , 40.0 ,-10.5> look_at   <0.0 , 1.0 , 0.0>}
 // camera { location  <0.0 , 10.0 ,25.0> look_at   <0.0 , 0.0 , 5.0>}
 // camera { location  <-5.5,0,-1.5> look_at  <-5.5,-4.5,1.5>}

//- A rake of lights.
 
    light_source { 0*x color rgb<.5,.5,.5> shadowless translate < 120, 90, 80>}
    light_source { 0*x color rgb<.5,.5,.5> shadowless translate < 0, 80, 45>}
    light_source { 0*x color rgb<.5,.5,.5> shadowless translate < -120, 90, 80>}
    light_source { 0*x  color rgb <.65,.85,.85>
                    spotlight
                    translate <10, 60, -20> point_at <4, -2, 2>
                    radius 70 tightness 10 falloff 80
                 }
                 
//- The lightnning.
                  
  sky_sphere {
    pigment { marble scale .4 turbulence .56
    color_map { [0.1 color Mica]
                [0.6 color MidnightBlue]
                [0.945 color Thistle]
                [0.978 color Silver]
                [0.995 color White]
              }
           } rotate <-3,152,0>
          }

//- The sea.

   plane { y, -6 pigment{ bozo scale.7
             colour_map{ [0 colour rgbf <.51,.35,.64,.5>]
                         [.4 colour rgbf <.344,.577,.6,.6>]
                         [.8 colour rgbf <.314,.312,.4,.7>]} }
             finish { ambient 0.2 specular 0.5 reflection 0.2 }

                normal { dents 50 scale 1 }
               }

//- The hills.

  height_field { gif  "plasma3.gif"
               water_level .3
               smooth
               rotate 6*z
               scale <500,40,20>
               translate <-350,-30,350>
           pigment{ crackle scale 4 turbulence .9
             colour_map{ [0 color rgb <0.337, 0.456, 0.237>]
                         [.2 DarkOliveGreen]
                         [.9 color rgb <.45,.45,.3>]} }
                finish { ambient .4 crand 0.3} normal { dents 6 scale 12 } }        

  
//--------------------------------------------------------------------------------------
//- Loads of declarations, just scroll on by unless you're masochistic.
//--------------------------------------------------------------------------------------

//- The Nut ------------------------------

 #declare Side=
   box{<1.0099,6,2.5><-1.0099,-6,-2.5> }

 #declare Hex=
   merge{
  object{Side}
  object{Side rotate 45*y}
  object{Side rotate 90*y}
  object{Side rotate 135*y}
    }

 #declare Template=
 difference{
  box{<-5,-5.5,-5><5,5.5,5>  }

  object {Hex}
    }

  #declare NutA=
 difference{
  sphere { 0*y, 2.8  }

  object{Template scale <1,5,1>}
  box{<-5,-1.3,-5><5,-3,5>  }
  box{<-5,1.3,-5><5,3,5>  }
   }

   #declare NutB=
   difference{
   object{NutA}

   cylinder{<0,3,0><0,-3,0>1.8  }
     }

   #declare Thread=
   difference{
   cylinder{<0,.3,0><0,-.3,0>1.9  }

   cone{ -1*y, 0.2, .5*y, 2.2  }
   cone{ 1*y, 0.2, -.5*y, 2.2  }
              }
   #declare Threads=
   union{
    object {Thread scale <1,1.2,1>}
    object {Thread scale <1,1.2,1> translate .4*y}
    object {Thread scale <1,1.2,1> translate -.4*y}
        }

    #declare Nut=
    union{
      object {NutB}
      object {Threads translate -.58*y}
      object {Threads translate .56*y}
       }

//- The Bearing ----------------------------------------------

 #declare Hub1=
  difference{
   cylinder  { -.5*y,  .5*y,  3 }

   cylinder  { -.51*y,  .51*y,  2.3 }
   torus     { 2.35, 0.4 texture{New_Brass}}
  object{Thread scale 1.65 translate .75*y}
  object{Thread scale 1.65 translate -.75*y}
           }

    #declare Hub2=
 difference{
  cylinder  { -.5*y,  .5*y,  1.8 }

  cylinder  { -.51*y,  .51*y,  1 }
  torus     { 1.9, 0.4 texture{New_Brass}}
           }

#declare Bearing=
union{
 sphere { <0, 0, 0>  0.46 translate 2.065*x}
 sphere { <0, 0, 0>  0.46 translate -2.065*x}
 sphere { <0, 0, 0>  0.46 translate 2.065*z}
 sphere { <0, 0, 0>  0.46 translate -2.065*z}
 sphere { <0, 0, 0>  0.46 translate <1.485,0,1.485>}
 sphere { <0, 0, 0>  0.46 translate <-1.485,0,-1.485>}
 sphere { <0, 0, 0>  0.46 translate <-1.485,0,1.485>}
 sphere { <0, 0, 0>  0.46 translate <1.485,0,-1.485>}
 object{Hub1 }
 object{Hub2 }
  }

//- The Airbrush ------------------------------------------------

    #declare Ups=
   union{
    sphere{ 0*y, 1 translate<1.9,4.4,0>}
    sphere{ 0*y, 1 translate<4.4,1.9,0>}
    sphere{ 0*y, 1 translate<4.4,-1.9,0>}
    sphere{ 0*y, 1 translate<1.9,-4.4,0>}
    sphere{ 0*y, 1 translate<-1.9,4.4,0>}
    sphere{ 0*y, 1 translate<-4.4,1.9,0>}
    sphere{ 0*y, 1 translate<-4.4,-1.9,0>}
    sphere{ 0*y, 1 translate<-1.9,-4.4,0>}
    }

    #declare Downs=
   union{
    sphere{ 0*y, .95 translate<0,5.5,0>}
    sphere{ 0*y, .95 translate<3.9,3.9,0>}
    sphere{ 0*y, .95 translate<5.5,0,0>}
    sphere{ 0*y, .95 translate<3.9,-3.9,0>}
    sphere{ 0*y, .95 translate<0,-5.5,0>}
    sphere{ 0*y, .95 translate<-3.9,3.9,0>}
    sphere{ 0*y, .95 translate<-5.5,0,0>}
    sphere{ 0*y, .95 translate<-3.9,-3.9,0>}
    }

  #declare Us=
   union{
    object {Ups translate -8*z}
    object {Ups translate -6*z}
    object {Ups translate -4*z}
    object {Ups translate -2*z}
    object {Ups translate 0*z}
    object {Ups translate 2*z}
    object {Ups translate 4*z}
    object {Ups translate 6*z}
    object {Ups translate 8*z}
        }

  #declare Ds=
   union{
    object {Downs translate -8*z}
    object {Downs translate -6*z}
    object {Downs translate -4*z}
    object {Downs translate -2*z}
    object {Downs translate 0*z}
    object {Downs translate 2*z}
    object {Downs translate 4*z}
    object {Downs translate 6*z}
    object {Downs translate 8*z}
        }

 #declare Air=
 difference{
 union{
    object {Us }
    cylinder { <0,0,-9.5><0,0,9.5> 5.25  }
     }
     object {Ds }
     }

  #declare Noz=
     union{
       cone { 0*x,  4, -7*x, 2.0 pigment{CadetBlue} finish{Metal} }
   cylinder { <-7.5,0,0><-8.2,0,0> 3 texture{Chrome_Texture} }
   cylinder { <-6.9,0,0><-12,0,0> .5 texture{Spun_Brass scale .1} }
       }
       
  #declare Han=
   union{
     sphere{0*y, .505 pigment{Gray} normal { bumps .25 scale .1 } finish{Metal} translate 4*y}
     sphere{0*y, .8 pigment{Gold} finish{Metal} translate <4.25,4,0>}
   cylinder{<0,0,0><0,1,0> 2 pigment{Silver} finish{Metal} }
   cylinder{<0,0.95,0><0,4,0> .5 pigment{Gray} normal { bumps .25 scale .1 } finish{Metal} }
   cylinder{<0,4,0><4,4,0> .5 pigment{Gray} normal { bumps .25 scale .1 } finish{Metal} }

    difference{
   cylinder{<0,0,0><0,1.2,0> 2.4 pigment{White} finish{Metal} }

   cylinder{<0,-.1,0><0,1.21,0> 2.01 pigment{White} finish{Metal} }
    }
    }

  #declare Seg=
   union{
 cylinder{<0,0,0><0,0,1> 2.5}
 cylinder{<0,0,0.95><0,0,2.05> 3.3}
        }
        
  #declare Cable=
   union{
    object{ Seg}
    object{ Seg translate 2*z}
    object{ Seg translate 4*z}
    object{ Seg translate 6*z}
    object{ Seg translate 8*z}
    object{ Seg translate 10*z}
    object{ Seg translate 12*z}
    object{ Seg translate 14*z}
    object{ Seg translate 16*z}
        }

  #declare Brush=
  union{
    object{Han translate <-6.25,4.75,0>}
    object{Cable rotate 90*y texture{Polished_Chrome} translate 9.5*x}
    object{Air rotate 90*y pigment{Pink} finish{Metal} }
    object{Noz translate -9.4*x}
      }

//- The spilt paints -----------------------------------------------
       
     #declare Pool=
   blob{ sphere {<  -1, 0,  0> 3, .8}
         sphere {<   1, 0.25,  0> 1.5, 1}
         sphere {< 1.2, 0,  -1> 1.5, 1}
         sphere {< 0.2, 0.2, -1.0> 1.5, .8}
         sphere {<   2, 0, -1.4> 1.5, 1}
         sphere {<-1.6, 0.225, -1.8> 1.3, .8}
       }

         #declare Pool1=
   blob{ sphere {<  -1, 0,  0> 3, .8}
         sphere {<   1, 0,  0> 1.5, 1}
         sphere {< 1.2, 0,  -1> 1.5, 1}
         sphere {< 0.2, 0, -1.0> 1.5, .8}
         sphere {<   2, 0, -1.4> 1.5, 1}
         sphere {<-1.6, 0, -1.8> 1.3, .8}
       }

         #declare Pool2=
   blob{ sphere {<-0.6, 0.1,  0> 3.0, .8}
         sphere {< 0.8, 0,  0> 1.5,  1}
         sphere {< 1.2, 0.1, -1> 1.5,  1}
         sphere {< 0.2, 0, -1.0> 1.5, .8}
         sphere {<1.65, 0.1, -1.4> 1.5,  1}
       }

          #declare Pool3=
   blob{ sphere {<  -1, 0,  0> 3, .8}
         sphere {<   1, 0.33,  0> 1.5, 1}
         sphere {< 1.2, 0,  -1> 1.5, 1}
         sphere {< 0.2, 0.2, -1.0> 1.5, .8}
         sphere {<   2, 0, -1.4> 1.5, 1}
         sphere {<-1.6, 0.3, -1.8> 1.3, .8}
       }

//- Tile colours

    #declare Ceramic1= rgb < .32,.28,.52>
    #declare Ceramic2= rgb < .85,.70,.79>
    
//- Metals

    #declare MyMetal2= rgb < .42,.34,.12>
    #declare MyMetal4= rgb < .82,.75,.45>
    
//- Sets of the ceramics

    #declare Glaze = finish { reflection .16 irid { .2 thickness .275 turbulence .65} }

    #declare Tile1 = superellipsoid { <0.5, 0.1> pigment{Ceramic1} finish{Glaze} scale <2, .05, 2> translate -5*y}
    #declare Tile2 = superellipsoid { <0.5, 0.1> pigment{Ceramic2} finish{Glaze} scale <2, .05, 2> translate -5*y}

    #declare Sp = 4.1
    #declare Row =
     union {
    object { Tile1 }
    object { Tile2 translate z*Sp }
    object { Tile1 translate z*Sp*2 }
    object { Tile2 translate z*Sp*3 }
    object { Tile1 translate z*Sp*4 }
    object { Tile2 translate z*Sp*5 }
    object { Tile1 translate z*Sp*6 }
    object { Tile2 translate z*Sp*7 }
    object { Tile1 translate z*Sp*8 }
    object { Tile2 translate z*Sp*9 }
    object { Tile1 translate z*Sp*10 }
    object { Tile2 translate -z*Sp }
    object { Tile1 translate -z*Sp*2 }
    object { Tile2 translate -z*Sp*3 }
    object { Tile1 translate -z*Sp*4 }
    object { Tile2 translate -z*Sp*5 }
    object { Tile1 translate -z*Sp*6 }
  }

  #declare Table=
  union{
    object { Row }
    object { Row translate < 4.1, 0, 4.1> }
    object { Row translate < 8.2, 0, 0> }
    object { Row translate <12.3, 0, -4.1> }
    object { Row translate <16.4, 0, 0>}
    object { Row translate <20.5, 0, -4.1> }
    object { Row translate <24.6, 0, 0>}
    object { Row translate <28.7, 0, -4.1> }
    object { Row translate <-4.1, 0, -4.1> }
    object { Row translate <-8.2, 0, 0> }
    object { Row translate <-12.3, 0, -4.1> }
    object { Row translate <-16.4, 0, 0> }
    object { Row translate <-20.5, 0, -4.1> }
    object { Row translate <-24.6, 0, 0> }
    object { Row translate <-28.7, 0, -4.1> }
       }

//- Very lazy
      
   #declare Window=
      difference{
        torus{ 18, 5 pigment { colour rgbf <.9,.9,.9,.9>} translate <1,-5.4,18>}

        cylinder {<0,-28,0><0,24,0> 21 pigment {Clear}  translate <1,0,18> }
        box{<-40,40,-6><40,-40,16> pigment {Clear}}
        }
        
//- Cork

   #declare Stopper=
   union {
      cone { 1.5*y,  0.95, 0*y, 0.55 texture{Cork scale .7} scale < 1, 1.2, 1> }
      cone { .375*y,  0.65, 0*y, 0.5505 pigment{colour rgbft <.6,0,.65,.5,.5>} scale < 1, 1.2, 1> }
         }
//- The wind generators ---------------------------------------------

 #declare Nose=
  blob { threshold 0.6
   sphere { < 0, 0, 0.8> 1.0, 0.75 }
   sphere { < 0, 0, 1.3> 0.8, 0.50 }
 cylinder {<0,0,.5><0,0,.9> 0.4, 0.4 }
   sturm
   scale 2.5
     }

 #declare Sail=
   cone { 1*y,  0.15, 0*y, 0.6 pigment {White} finish{Metal} scale <1,9,.33> }

 #declare Sails=
  union {
   object{Sail}
   object{Sail rotate 118*z translate <-.8,-1.1,0>}
   object{Sail rotate 242*z translate <.8,-1.1,0>}
        }

 #declare Stan=
  union{
   cylinder {<0,0,-1><0,21,-1> .8 pigment{Silver} }
   cylinder {<0,19.5,-2.3><0,19.5,1> 1.1 pigment{Pink} }
   cylinder {<0,19.5,1.3><0,19.5,1> 1.5 pigment{Salmon} }
   cylinder {<5,.4,-1><0,16,-1> .2 pigment{CornflowerBlue} }
   cylinder {<-5,.4,-1><0,16,-1> .2 pigment{CornflowerBlue} }
   cylinder {<0,.4,-8><0,16,-1> .2 pigment{CornflowerBlue} }
   cylinder {<0,.4,6><0,16,-1> .2 pigment{CornflowerBlue} }
      }

 #declare Wind=
   union{
     object {Nose pigment {SkyBlue} translate <0,-.6,-3>}
     object {Sails }
        }

   #declare Crop=
     union{
      object {Wind rotate <0,13,20> translate <0,15,52>}
      object {Wind rotate <0,13,40> translate <-32,15,65>}
      object {Wind rotate <0,13,-20> translate <32,15,65>}
      object {Wind rotate <0,13,10> translate <20,15,75>}
      object {Wind rotate <0,13,19> translate <-20,15,75>}
      object {Wind rotate <0,13,-30> translate <49,15,75>}
      object {Wind rotate <0,13,-30> translate <-49,15,75>}
          }
          
    #declare CropStan=
     union{
      object {Stan translate <0,-5,55>}
      object {Stan translate <-32,-5,68>}
      object {Stan translate <32,-5,68>}
      object {Stan translate <20,-5,78>}
      object {Stan translate <-20,-5,78>}
      object {Stan translate <49,-5,78>}
      object {Stan translate <-49,-5,78>}
          }
          
    #declare Generators=
     union{
       object {Crop translate z*50}
       object {Crop translate <50,0,90> }
       object {Crop translate <-45,0,90>}
       object {CropStan translate z*50}
       object {CropStan translate <50,0,90> }
       object {CropStan translate <-45,0,90>}
          }

// Chris Colefax's contribution include file.

  // SPRAY OPTIONS
   #declare use_blob = true
   #declare components_only = true
   #declare spray_loop = true
   #declare spray_turb = .15
   #declare spin_turb = 4
   #declare angle_turb = 2
   #declare particle_count = 850
   #declare particle_life = 2.5
   #declare particle_dist = .2
   #declare particle_size = .09
   #declare particle_stretch = 1.2
   #declare evaporate = .05
   #declare nozzle_angle = 12

 // CREATE SPRAY BLOB OBJECT
    blob {threshold .5
      #declare spray_location = <3.95, -1.5, -.12>
      #declare spray_direction = <-2.75, -1, 11>
      #declare spray_strength = 20
      #declare spray_texture = texture{Chrome_Texture}
      #include "Spray.inc"}
                                       
//----------------------------------------------------------------------------
//- Place the objects.
//----------------------------------------------------------------------------

  object {Brush scale .08 rotate 72*y translate <4.5,-1.5,-1.8>}
  object {Nut scale .8 texture{Polished_Chrome} pigment{Gray70} rotate <-40, -35, 10> translate <0, -2.7, 7.5>}
  object {Bearing texture{Polished_Chrome} pigment{Gray60} rotate <-70, 35,0> translate <7.8,-1.6, 8>}
  object {Bearing texture{Polished_Chrome} pigment{Gray60} rotate <-50,-55,0> translate <-5, -1, 3>}
  object {Stopper scale <.5,.65,.5> rotate<-94, 105, -16> translate<-6.05,-4.7,1.5>}
  object {Window rotate -8*x scale<2,5,1>  translate 15*y}
  object {Generators scale <1.5,1.7,1.5> rotate -55*y translate<-90,10,400>}   
  object {Pool texture{Polished_Chrome} pigment{Cyan} scale <2, .9, 4> translate <1.3, -5.74, 5.5>}
  object {Pool1 texture{Polished_Chrome} pigment{Gray80} scale <1, .4, 0.6> translate <0, -5.1, 6.3>}
  object {Pool2 rotate -95*y texture{Polished_Chrome} pigment{Yellow} scale <5, 1.2, 8> translate <5.4, -6, 18>}
  object {Pool3 rotate -30*y texture{Chrome_Texture} pigment{Magenta} scale <2, .9, 2> translate <-7, -5.765, 1.5>}
  object {Table rotate 25*y }

//miscellaneous bits and pieces.

   box{<-200,100,100><200,101,-120> pigment{Gray90} } //prevents chrome reflecting sky_sphere
   box {<-30,-5.15,-20><30,-5.5,42.5> pigment {Gray30} rotate 25*y} // the table grout
   torus{ 32, 2 pigment {MyMetal4} finish {Metal} translate <4,-5.4,9>} // the table edge
   torus{ 32, 1.5 pigment {White} finish {Metal} rotate 90*z scale <1,1,.7> translate <24,-5.4,14>} //window bars
   torus{ 32, 1.5 pigment {White} finish {Metal} rotate 90*z scale <1,1,.7> translate <-24,-5.4,11>}
   torus{ 32, .15 pigment {Black} finish {Metal} translate <1, 1, 13>}
   torus{ 32, .15 pigment {Black} finish {Metal} translate <1,5.5, 12>}
   torus{ 32, .15 pigment {Black} finish {Metal} translate <1, 10, 10.5>}
   torus{ 32, .15 pigment {Black} finish {Metal} translate <1.3,14.5, 8.2>}

//-------------------------------------------------------------------------------------------

//- Finally, sign the picture.

     text { ttf    "comicbd.ttf", "EGrant'98",   .25,  0.05
         pigment{ gradient x scale 6.4
                  colour_map {[0.000 Red]     
                              [0.143 Orange]  
                              [0.286 Yellow]  
                              [0.429 Green]   
                              [0.572 Turquoise]
                              [0.715 Blue]
                              [0.858 Violet]
                              [1.000 Black]
                             }
                           } scale .5 rotate <18,5,-3> translate <3.35,-3.25,-2.1>
                           }

//- Render!
