
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//
#version 3



#declare R2 = seed(25);
//#declare TestMode=1
//#declare UseAreaLights=1
#declare UseAsIncludeFile=1


#include "colors.inc"
#include "finish.inc"
#include "metals.inc"
#include "textures.inc"
#include "golds.inc"

#include "alchemy.inc"
#include "bolts.inc"
#include "clamps.inc"

global_settings{
  assumed_gamma 2.2
  max_trace_level 7
}

// ----------------------------------------

camera{
  location  <-148, 20, -130>
  direction 1.4*z
  right     4/3*x
  look_at   <-159, 23,  0>
}

//======================<< start add lights >>===================
#ifndef (TestMode)
  light_source {<-175,25,0> color White*.25 rotate<0,-20,0>  shadowless  }

  #declare yRotate=-60
  #declare fadeDistance=15
  #while (yRotate < 37)
    object{lightFixture translate<-178,45,0> rotate<0,yRotate,0>}
    #declare yRotate= yRotate + 7.5
  #end

  #declare yRotate=-60
  #declare fadeDistance=40
  #declare Brightness=0.10
  #while (yRotate < 37)
    object{lightFixture translate<-178,75,0> rotate<0,yRotate,0>}
    #declare yRotate= yRotate + 7.5
  #end
#else
  light_source {<-175,40,0> color White*.5 looks_like { sphere{<0,0,0> 2 pigment{Yellow*4.25}} }}
  light_source {<-175,75,0> color White*.5 rotate<0,-45,0> looks_like { sphere{<0,0,0> 2 pigment{Yellow*4.25}} }}
  light_source {<-175,75,0> color White*.5 rotate<0,-35,0> looks_like { sphere{<0,0,0> 2 pigment{Yellow*4.25}} }}
#end
//======================<< end add lights >>===================


object{clamp rotate<0,90,0>  translate<-150.0,38.4,0> rotate<0,-30,0>}
object{clamp rotate<0,90,0>  translate<-150,40,0> rotate<0,-15,0>}
object{clamp rotate<0,90,0>  translate<-150,36,0> rotate<0,-15,0>}


object{mainFloor}
object{upperFloor}
object{outerWall}
object{cyclotron}
object{mainConduit}
object{roof}
object{junctionBox}
object{upperCoilArray}
object{bigCoilArray}

#include "chamber.inc"
object{collisionChamber rotate<0,90,0> translate<-140,0,0> rotate<0,-23,0>}



#include "forklift.inc"
 object{forkLift scale 1/12 rotate<0,-45,0> translate<-178,0,0> rotate<0,-7,0>}

#include "ladder.inc"
object{ladder rotate<0,65,0> translate<-160,0,0> rotate<0,-25,0>}

#include "crate.inc"
object{crate scale 1/12 rotate<0,-3,0> translate<-186,0,0> rotate<0,-9,0> }
object{crate scale 1/12 rotate<0,0,0> translate<-186,25.5/12,0> rotate<0,-9,0> }
object{crate scale 1/12 rotate<0,3,0> translate<-186,25.5*2/12,0> rotate<0,-9,0> }

object{crate scale 1/12 rotate<0,0,0> translate<-190.5,0,0> rotate<0,-9,0> }
object{crate scale 1/12 rotate<0,2,0> translate<-190.5,25.5/12,0> rotate<0,-9,0> }
object{crate scale 1/12 rotate<0,-3,0> translate<-190.5,25.5*2/12,0> rotate<0,-9,0> }

#include "workstat.inc"
object{workStation translate<-157,0,0> rotate<0,-9.5,0>}


#include "chair.inc"
object{chair rotate<0,-150,0> translate<-152,0,0> rotate<0,-10.5,0>}
object{chair rotate<0,-45,0> translate<-157,0,0> rotate<0,-10.5,0>}
object{chair rotate<0,160,0> translate<-162,0,0> rotate<0,-10.5,0>}



//===================================================================

