
#version 3

#include "colors.inc"
#include "metals.inc"
#include "textures.inc"
#include "woods.inc"

#ifndef (UseAsIncludeFile)

global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------
camera
{
  location  <25.75, 30, -200>
  direction 1.5*z
  right     4/3*x
  look_at   <25.75, 20,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color White*2
  translate <-100, 150, -150>
}

plane { y, 0 pigment {color rgb <0.7,0.5,0.3>}}

#end

#declare steelAngle=
union{
  box{<-.25,-6,0>,<4,6,-.25>}
  box{<-.25,-6,-.25>,<0,6,4>}
  texture{
    pigment{White*.2}
    finish {
      ambient 0.35
      brilliance 2
      diffuse 0.3
      metallic
      specular 0.80
      roughness 1/10
      reflection 0.17
      crand 0.05
    }
  }
}



#declare oneBoard=
  box{<-24,0,-.875>,<24,9.75,.875> texture{T_Wood7 translate<10,0,0> rotate<0,89.5,0> scale<1,2,1>}}

#declare floorBoard=
  box{<-3,0,-.375>,<3,4.5,48.375> texture{T_Wood7 translate<3,0,0> rotate<0,0,90> scale<1,2,1>}}


#declare crate=
union{
  object{floorBoard}
  object{floorBoard  translate<22.75,0,0>}
  object{floorBoard translate<-22.75,0,0>}

  object{oneBoard translate<0,4.5,0> }
  object{oneBoard rotate<180,180,0> translate<0,20.25+4.5,0>}

  object{oneBoard translate<0,4.5,48> }
  object{oneBoard rotate<180,180,0> translate<0,20.25+4.5,48>}

  object{oneBoard scale<1.0346,1,1> rotate<0,90,0> translate<-24.875,4.5,24> }
  object{oneBoard scale<1.0346,1,1> rotate<180,90,0> translate<-24.875,20.25+4.5,24>}

  object{oneBoard scale<1.0346,1,1> rotate<0,90,0> translate<24.875,4.5,24> }
  object{oneBoard scale<1.0346,1,1> rotate<180,90,0> translate<24.875,20.25+4.5,24>}
  box{<-25.75,3.5,-0.875>,<25.75,4.5,48.875> texture{T_Wood7 translate<10,0,0> rotate<0,89.5,0>}}

  box{<-25.375,24.75,-0.5>,<25.375,25.5,48.5> texture{T_Wood7 translate<10,0,0> rotate<0,89.5,0>}}

  object{steelAngle translate<-25.75,14.5,-0.875>}
  object{steelAngle rotate<0,-90,0> translate<25.75,14.5,-0.875>}
  object{steelAngle rotate<180,0,0> translate<-25.75,14.5,48.875>}
  object{steelAngle rotate<0,180,0> translate<25.75,14.5,48.875>}
}

#ifndef (UseAsIncludeFile)
  object{crate rotate<0,0,0>}
  object{crate rotate<0,-5,0> translate<1,25.5,-1>}
  object{crate rotate<0,5,0> translate<1,25.5*2,-1>}
#end


