#version 3

#include "colors.inc"
#include "finish.inc"
#include "metals.inc"

#ifndef (UseAsIncludeFile)

global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------
camera
{
  location  <8, 17, -50>
  direction 2.5*z
  right     4/3*x
  look_at   <8, 18,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color White*1
  translate <-30, 30, -30>
}

light_source
{
  0*x // light's position (translated below)
  color White*1
  translate <30, 30, -30>
}

plane { y, 0 pigment {color rgb <0.7,0.5,0.3>}}

#ifndef (UseAsIncludeFile)



#declare  silver2=
texture {
  pigment { rgb <.90, .91, .95> }
  finish { F_MetalA  }
}

#declare wheel=
union{
  cylinder {<2/12,2.875/12,.75/12>, <2/12,2.875/12,-.75/12>, 2.875/12 pigment{White*.1}}
  box{<-.25/12,2.5/12,-.875/12>,<2.5/12,6/12,-1/12> texture{silver2}}
  box{<-.25/12,2.5/12,.875/12>,<2.5/12,6/12,1/12> texture{silver2}}
  box{<-.25/12,5.875/12,1/12>,<2.5/12,6/12,-1/12> texture{silver2}}
  cylinder {<0,6/12,0>, <0,7.5/12,0>, .4375/12 texture{silver2}}
}


#declare oneStep=
  box{<-1.5,0,0>,<1.5,2/12,8/12> pigment{Yellow}}

#declare ladder=
union{
  #declare zz = 0.57
  #declare yy = 1
  #while (yy < 15)
    object{oneStep translate<0,yy,zz>}
    #declare zz=zz+0.57
    #declare yy=yy+1
  #end

  box{<-1.5,0,0>,<1.5,2/12,3> pigment{Yellow} translate<0,yy,zz>}

  object{
    box{<0,0,.5>,<.25/12,8/12,18>
      pigment{Red} rotate<-60,0,0>
      translate<1.5,0,.6>
    }
    clipped_by{plane{y,yy+2/12 }}
    clipped_by{plane{y,.75 inverse}}
  }

  object{
    box{<0,0,.5>,<.25/12,8/12,18>
      pigment{Red} rotate<-60,0,0>
      translate<-1.5,0,.6>
    }
    clipped_by{plane{y,yy+2/12 }}
    clipped_by{plane{y,.75 inverse}}
  }


  union{
    cylinder {<1.56,0,5.98>, <1.56,0,20.79>, .5/12 pigment{Yellow}}
    cylinder {<1.56,0,9>, <1.56,-2.25,9>, .5/12 pigment{Yellow}}
    cylinder {<1.56,0,15>, <1.56,-2.25,15>, .5/12 pigment{Yellow}}
    rotate<-60,0,0>
    translate<0,0,-2.5>
  }
  union{
    cylinder {<-1.56,0,5.98>, <-1.56,0,20.79>, .5/12 pigment{Yellow}}
    cylinder {<-1.56,0,9>, <-1.56,-2.25,9>, .5/12 pigment{Yellow}}
    cylinder {<-1.56,0,15>, <-1.56,-2.25,15>, .5/12 pigment{Yellow}}
    rotate<-60,0,0>
    translate<0,0,-2.5>
  }

  cylinder {<1.56,0.75,.5>, <1.56,5.21,.5>, .5/12 pigment{Yellow}}
  cylinder {<1.56,13,7.89>, <1.56,18,7.89>, .5/12 pigment{Yellow}}
  cylinder {<1.56,18,7.88>, <1.56,18,zz+3>, .5/12 pigment{Yellow}} //8888888

  cylinder {<-1.56,0.75,.5>, <-1.56,5.21,.5>, .5/12 pigment{Yellow}}
  cylinder {<-1.56,13,7.89>, <-1.56,18,7.89>, .5/12 pigment{Yellow}}
  cylinder {<-1.56,18,7.88>, <-1.56,18,zz+3>, .5/12 pigment{Yellow}} //8888888


  cylinder {<1.56,0.75,zz+3>, <1.56,18,zz+3>, .5/12 pigment{Yellow}}
  cylinder {<-1.56,0.75,zz+3>, <-1.56,18,zz+3>, .5/12 pigment{Yellow}}

  cylinder {<-1.56,0.75,.5>, <-1.56,0.75,zz+3>, .5/12 pigment{Yellow}}
  cylinder {<1.56,0.75,.5>, <1.56,0.75,zz+3>, .5/12 pigment{Yellow}}
  cylinder {<1.56,7.5,4.5>, <1.56,7.5,zz+3>, .5/12 pigment{Yellow}} //8888888
  cylinder {<1.56,0.75,4.54>, <1.56,7.5,zz+3>, .5/12 pigment{Yellow}} //8888888
  cylinder {<-1.56,0.75,4.54>, <-1.56,7.5,zz+3>, .5/12 pigment{Yellow}} //8888888

  cylinder {<-1.56,0.75,zz+3>, <1.56,7.5,zz+3>, .5/12 pigment{Yellow}} //8888888
  cylinder {<1.56,0.75,zz+3>, <-1.56,7.5,zz+3>, .5/12 pigment{Yellow}} //8888888
  cylinder {<-1.56,15,zz+3>, <1.56,7.5,zz+3>, .5/12 pigment{Yellow}} //8888888
  cylinder {<1.56,15,zz+3>, <-1.56,7.5,zz+3>, .5/12 pigment{Yellow}} //8888888


  cylinder {<-1.56,7.5,4.5>, <-1.56,7.5,zz+3>, .5/12 pigment{Yellow}}
  cylinder {<1.56,7.5,zz+3>, <-1.56,7.5,zz+3>, .5/12 pigment{Yellow}}
  cylinder {<1.56,18,zz+3>, <-1.56,18,zz+3>, .5/12 pigment{Yellow}}
  cylinder {<1.56,0.75,zz+3>, <-1.56,0.75,zz+3>, .5/12 pigment{Yellow}}

  cylinder {<-1.56,0.75,4.54>, <-1.56,7.5,4.54>, .5/12 pigment{Yellow}}
  cylinder {<1.56,0.75,4.54>, <1.56,7.5,4.54>, .5/12 pigment{Yellow}} //8888888
  cylinder {<1.56,0.75,4.54>, <-1.56,0.75,4.54>, .5/12 pigment{Yellow}}
  cylinder {<1.56,7.5,9>, <1.56,15,9>, .5/12 pigment{Yellow}}

  object{wheel rotate<0,-15,0> translate<-1.56,0,.5>}
  object{wheel rotate<0,15,0> translate<-1.56,0,zz+3>}
  object{wheel rotate<0,30,0> translate<1.56,0,zz+3>}
  object{wheel rotate<0,-15,0> translate<1.56,0,.5>}

  #include "laddermn.inc"
  object{manOnLadder translate<0,0.3407,0> scale 8.805 rotate<0,-90,0> translate<0,14.145,10.7>}

}


#ifndef (UseAsIncludeFile)
  object{ladder rotate<0,90,0>}
#end
