global_settings { max_trace_level 5 }

camera {  //  Camera StdCam
  location  <-9.265, -17.430, 8.735>
  direction <0.0,     0.0,  1.9067>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.000, 0.000, 0.000>
}

light_source {   // Spotlight SpotL001
  <36.795, -52.030, 117.075>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <36.544, -51.639, 116.190>
    falloff   7.0  // outer radius (in deg)
      radius    5.0  // inner radius
}

light_source { // AreaL001
  <-53.795, -46.850, 53.705>
  color  rgb<1.000, 1.000, 1.000>
  area_light <10.382, 0.000, 14.827>, <-10.112, 13.238, 7.080>, 3, 3
  adaptive 1
  jitter
}


light_source {   // Light1
  <-75.025, -17.585, 116.840>
  color rgb <2.004, 2.004, 2.004>
}



#include "atoms.inc"
#include "atoms.in2"
#include "backgrnd.inc"


box { // Cube2
  <-1, -1, -1>, <1, 1, 1>
  texture {
    veggtex
    scale <1.0, 1.0, 2.0>
  translate <0.000000, 0.000000, -1.000000>
  }
  scale <85.769997, 108.769997, 154.474991>
  rotate -43.0*z
  translate  <0.37, 1.51, -0.5>
}


plane { // tak
  z,0
  texture { taktex }
  translate  100.0*z
}


plane { // golv
  z,0
  texture {
    golvtex
  }
  translate  -50.0*z
}


box { // Cube001
  <-1, -1, -1>, <1, 1, 1>
  scale <11.11, 13.83, 0.5>
  texture { tabletex }
  rotate -43.0*z
  translate  <0.37, 1.51, -0.5>
}
                      



#declare lda1 = difference {
  box { // grund1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 5.0, 1.0>
  }
  box { // bort2
    <-1, -1, -1>, <1, 1, 1>
    scale <2.95, 4.95, 1.0>
    translate  0.2*z
  }
  scale <1.0, 1.0, 0.25>
  rotate <180.0, 0.0, -90.0>
  translate  <0.0, -3.0, 0.25>
}
#declare ask1 = merge {
  object { lda1 }
  box { // fack12
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.025, 0.25>
    rotate <180.0, 0.0, -90.0>
    translate  <3.0, -3.0, 0.25>
  }
  box { // fack11
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.025, 0.25>
    rotate <180.0, 0.0, -90.0>
    translate  <1.0, -3.0, 0.25>
  }
  box { // fack10
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.025, 0.25>
    rotate <180.0, 0.0, -90.0>
    translate  <-1.0, -3.0, 0.25>
  }
  box { // fack9
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.025, 0.25>
    rotate <180.0, 0.0, -90.0>
    translate  <-3.0, -3.0, 0.25>
  }
  box { // fack8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 5.0, 0.25>
    rotate <180.0, 0.0, -90.0>
    translate  <0.0, -4.0, 0.25>
  }
  box { // fack7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 5.0, 0.25>
    rotate <180.0, 0.0, -90.0>
    translate  <0.0, -2.0, 0.25>
  }
  rotate -165.0*x
  translate  <0.0, 3.0, 1.0>
}
#declare lda = difference {
  box { // grund
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 5.0, 1.0>
  }
  box { // bort1
    <-1, -1, -1>, <1, 1, 1>
    scale <2.95, 4.95, 1.0>
    translate  0.05*z
  }
}
#declare ask = merge {
  object { lda }
  box { // fack1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 5.0, 1.0>
    translate  -1.0*x
  }
  box { // fack2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 5.0, 1.0>
    translate  1.0*x
  }
  box { // fack3
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.025, 1.0>
    translate  3.0*y
  }
  box { // fack4
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.025, 1.0>
    translate  1.0*y
  }
  box { // fack5
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.025, 1.0>
    translate  -1.0*y
  }
  box { // fack6
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.025, 1.0>
    translate  -3.0*y
  }
  rotate -90.0*z
}

union{
merge { // laada
  object { ask1 }
  object { ask }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <-2.5, 3.0, 1.0>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate 90.0*y
    translate  <2.5, 3.0, 1.0>
  }
  texture { plastic }
  translate  1.0*z
}
  object { C       translate <-4, -2, 0>}
  object { Cl      translate <-4, 0, 0> }
  object { pinnar  translate <-4, 2, 0>}
  object { H       translate <-2, -2, 0>}
  object { O       translate <-2, 0, 0>}
  object { Cl      rotate 90*z translate <-2, 2, 0>}
  object { pinnar  rotate 90*z translate <0, -2, 0>}
  object { pinnar  rotate 180*z translate <0, 0, 0>}
  object { H       rotate 90*z translate <0, 2, 0>}
  object { H       rotate 180*z translate <2, -2, 0>}
  object { Cl      rotate 180*z translate <2, 0, 0>}
  object { O       rotate 90*z translate <2, 2, 0>}
  object { O       rotate -90*z translate <4, -2, 0>}
  object { C       rotate 90*z translate <4, 0, 0>}
  object { pinnar  rotate -90*z translate <4, 2, 0>}
translate .0001*z
}


sky_sphere{
  pigment{
    gradient z
    color_map{
      [ 0 color rgb <.5, .5, 1,>]
      [.25 color rgb <0, 0, 1> ]
      [ 1 color rgb <0, 0, .75> ]
     }
   }
  
  pigment {
    granite
    color_map{
      [ 0  color rgbf <1,1,1,1> ]
      [ .375  color rgbf <1,1,1,1> ]
      [ 1  color rgb <1,1,1> ]
    }
    scale <2,2,.125>
    translate .5*z
  }
}

