
// Balloon.inc  July 1998  Neil Alexander

// Hot air balloons for Balloon.pov

//--------------------------- Lights & Camera for object development -------
/*#declare V1 = 0  // 1 = working view, else = scene view
#if (V1 = 1)
camera {
  location <2000,300,0>
  look_at <0,300,0>
  angle 35
  }
#else
camera {
  location  <100, 10, 100>
  angle 65
  look_at   <0, 60, 0>
  }
#end

background { color rgb 0.8 }

light_source {
  <0, 0, -10000000000000>
  color rgb 1
  rotate <130,90,0>
  shadowless
  }
*/

//-------------------------- Textures ---------------------------------

#declare Btext1 = texture {  // envelope colors, main balloon
    pigment { gradient y
      color_map {
        [0.3 color rgbf <1,0.25,0,0.1>]
        [0.3 color rgbf <1,1,0,0.1>]
        [0.45 color rgbf <1,1,0,0.1>]
        [0.45 color rgbf <0.5,1,0,0.1>]
        [0.6 color rgbf <0.5,1,0,0.1>]
        [0.6 color rgbf <1,1,1,0.1>]
        [0.75 color rgbf <1,1,1,0.1>]
        [0.75 color rgbf <0.5,0.5,1,0.1>]
        }
      frequency 2
      scale 640
      }
    finish { ambient 0.3 }
    }
  texture {
    pigment { radial
      color_map {
        [0.00 color rgbt 0.3]
        [0.01 color rgbt 1.0]
        [0.99 color rgbt 1.0]
        [1.00 color rgbt 0.3]
        }
      frequency 18
      }
    }  // end Btext1

#declare Btext2 = texture {  // envelope colors for 2nd distant balloon
    pigment { gradient y
      color_map {
        [0.4 color rgbf <0,0.7,0,0.3>]
        [0.4 color rgbf <1,1,0,0.3>]
        [0.6 color rgbf <1,1,0,0.3>]
        [0.6 color rgbf <1,0.5,0,0.3>]
        [0.8 color rgbf <1,0.5,0,0.3>]
        [0.8 color rgbf <1,1,0,0.3>]
        [0.9 color rgbf <1,1,0,0.3>]
        [0.9 color rgbf <0,0.7,0,0.3>]
        }
      frequency 1.8
      scale 640
      }
    finish { ambient 0.3 }
    } // end Btext2

//--------------------------- Objects -----------------------------------

#declare Section = merge {  // balloon envelope segment
  sphere {0,240}
  cone { <0,-120,0>,207.8460969083,<0,-404.0384757729,0>,43.85640646055
    }
  translate y*404.0384757729
  scale <0.5,1,1>
  hollow
  }  // end Section

  #declare R1 = seed (1)
  #declare C1 = 0
  
  #declare Envelope = merge {  // balloon envelope
    #while (C1<9)
      object { Section
        rotate y*C1*20
        }
      #declare C1 = C1 + 1
      #end
    cone {<0,0,0>,43.85640646055,<0,-24,0>,30  // skirt
      open
      texture { pigment { color rgb 0.75 }
        }
      }
    torus { 43.86, 1
      texture { pigment { color rgb 0.75 }
        }
      }
    torus { 30, 1
      texture { pigment { color rgb 0.75 }
        }
      translate y*-24
      }
    cone {<0,-24,0>,30,<0,-56,0>,8  // cables
      open
      texture {
        pigment { radial
          color_map {
            [0.05 color rgb 0.75]
            [0.05 color rgbt 1]
            }
          frequency 12
          }
        }
      }
  hollow
  }  // end Envelope

#declare Frame1 = union {  // basket support frame, half
  cylinder {<0,0,18>,<0,32,18>,2}
  cylinder {<0,0,-18>,<0,32,-18>,2}
  cylinder {<0,42,-8>,<0,42,8>,2}
  torus { 10, 2
    clipped_by {
      box {<0,-3,0>,<13,3,13>}
      }
    rotate z*90
    translate <0,32,8>
    }
  torus { 10, 2
    clipped_by {
      box {<0,-3,-13>,<13,3,0>}
      }
    rotate z*90
    translate <0,32,-8>
    }
  }  // end Frame1

#declare Frame = union {  // basket support frame
  object { Frame1
    rotate z*14
    translate x*16
    }
  object { Frame1
    rotate z*-14
    translate x*-16
    }
  cylinder {<-6,41,8>,<6,41,8>,1}
  cylinder {<-6,41,-8>,<6,41,-8>,1}
  texture {
    pigment { color rgb 0.8 }
    finish { phong 1 phong_size 50 }
    }
  }  // end Frame

#declare Burner = union {  
  box {<-5,0,-5>,<5,10,5>
    texture {
      pigment { color rgb 0.4 }
      }
    }
  cylinder { <0,10,0>,<0,30,0>,5
    open
    texture {
      pigment { spiral1 1
        color_map {
          [0.5 color rgb 0.4]
          [0.5 color rgbt 1]
          }
        scale 2
        rotate x*90
        }
      }
    hollow
    }
  hollow
  }  // end Burner

#declare Basket = union {
  superellipsoid {
    <0.25, 0.25>
    translate <0, 1, 0>
    scale <21,23, 24>
    texture {
      pigment { color rgb <1,0.9,0.6> }
      }
    texture {
      pigment { quilted control0 1 control1 1
        color_map {
          [0 color rgbt <0,0,0,0.4>]
          [0.3 color rgbt <0,0,0,1>]
          }
        scale <3.5,1.5,3.5>
        }
      }

    clipped_by {
      cylinder { <-22,80,0>,<22,80,0>,42
        inverse
        }
      }
    }
  object { Frame
    translate y*40
    }
  object { Burner
    translate y*71
    }
  }  // end Basket

#declare Flame = sphere { 0, 1
  pigment { color rgbt 1 }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 0.5
    color_map {
      [0 color rgbt <0.4,0.5,1,1>]
      [0.4 color rgbt <0.4,0.5,1,0.2>]
      [0.4 color rgbt <1,0.25,0,0.5>]
      [1 color rgbt <1,0.8,0,-4>]
      }
    samples 20
    scale 0.75
    }
  scale <16,72,16>
  hollow
  }  // end Flame

#declare Balloonist = union {  // Balloonist
  blob {  // head
      threshold 0.5
      sphere { 0, 1, 1 // lower face
        scale <3,5,2>
        rotate x*-30
        translate <0,0,2>
        }
      sphere { 0, 1, 1  // cranium
        scale <5,6,7>
        translate y*2
        }
      sphere { 0,1,1  // nose
        scale <0.625,1.5,0.75>
        rotate x*-40
        translate <0,0.25,4>
        }
      sphere {0,1,1  // nostrils
        scale <1,0.625,1>
        translate <0,-0.125,3.875>
        }
      sphere { 0, 1, 1 // lower lip
        scale <1,0.5,1>
        translate <0,-1.5,3.125>
        }
      cylinder {0,y*2,4,1  // neck
        translate <0,-5,-1>
        }
      sphere {0,1,1  // right ear
        scale <0.5,1.25,1>
        rotate <-10,-15,-10>
        translate <2.625,0.875,0>
        }
      sphere {0,1,-0.75 // right ear hole
        scale <0.5,0.875,0.75>
        translate <3,0.938,0.312>
        }
      sphere {0,1,1  // left ear
        scale <0.5,1.25,1>
        rotate <-10,15,10>
        translate <-2.625,0.875,0>
        }
      sphere {0,1,-0.75 // left ear hole
        scale <0.5,0.875,0.75>
        translate <-3,0.938,0.312>
        }
      texture {
        pigment { color rgb <1,0.8,0.6>}
        }
      } // end head blob
  sphere {0,1  // sunglasses, right
    scale <0.875,0.625,0.125>
    clipped_by { plane {-z,0}}
    texture {
      pigment { color rgbf 0.3}
      finish {phong 1 phong_size 25}
      }
    rotate y*20
    translate <1.125,1.375,4>
    }
  sphere {0,1  // sunglasses, left
    scale <0.875,0.625,0.125>
    clipped_by { plane {-z,0}}
    texture {
      pigment { color rgbf 0.3}
      finish {phong 1 phong_size 25}
      }
    rotate y*-20
    translate <-1.125,1.375,4>
    }
  cylinder {  // sunglasses right arm
    <2,1.375,3.938>,<2.688,1.875,0.375>,0.125
    texture { pigment { color rgb 0.3}}
    }
  cylinder {  // sunglasses left arm
    <-2,1.375,3.938>,<-2.688,1.875,0.375>,0.125
    texture { pigment { color rgb 0.3}}
    }
  cylinder {  // sunglasses bridge
    <0.25,1.375,4.062>,<-0.25,1.375,4.062>,0.125
    texture { pigment { color rgb 0.3}}
    }
  difference {  // cap
    sphere { 0,1
      scale <3,3.375,3.875>
      texture { pigment { color rgb <1,0,0>}}
      rotate x*-10
      }
    plane {y,0
      rotate x*-10
      }
    cylinder {  // under peak
      <0,-4,0>,<0,-4,7>,4.25
      translate y*1
      }
    translate y*2
    }
  cylinder {  // peak
    <0,-4,-4>,<0,-4,7>,4.25
    clipped_by {
      sphere {0,1
        scale <3,1,3.75>
        translate z*3
        }
      }
    texture { pigment { color rgb <1,0,0>}}
    translate y*3
    }
  blob {  // shoulders
    threshold 0.5
    sphere {0,1,1
      scale <6,10,6>
      translate <2.5,0,0>
      }
    sphere {0,1,1
      scale <6,10,6>
      translate <-2.5,0,0>
      }
    cylinder {0,x*8,3,1  // right arm
      rotate z*-45
      translate <5.5,3,0>
      }
    cylinder {0,x*-8,3,1  // left arm
      rotate z*45
      translate <-5.5,3,0>
      }
    translate <0,-8,-1.5>
    texture { pigment { color rgb <0.25,0.219,0.5>}}
    }  // end shoulders

  translate y*15
  }  // end Balloonist


#declare Balloon = union {
  object { Envelope
    texture { Btext1 }
    translate y*24
    scale <1,0.8,1>
    translate y*108
    }
  object { Basket }
  object { Flame
    translate y*130
    }
  object { Balloonist
    rotate y*90
    rotate z*-60
    translate <5,50,-3>
    }

  }  // end Balloon

#declare Balloon2 = union {
  object { Envelope
    texture { Btext2 }
    translate y*24
    scale <1,0.8,1>
    translate y*108
    }
  object { Basket }
  }  // end Balloon2

//---------------------- Object placement for development -------------------

/*#if (V1 = 1)  // working view
object { Balloon
  rotate y*45
  }
#else           // scene view
object { Balloon
  rotate <-30,30,0>
  translate <-150,100,-50>
  }
object {Balloon2
  translate 12000*-z
  rotate <20,25,0>
  }
#end*/
