
// Hills.pov    July 1998  Neil Alexander

// This file is used to create a height field image.
// Hillstxt.pov creates a matching image map for the texture.
// This image should be rendered at the highest resolution.


camera {
  location  <0, 0, 50>
  orthographic
  look_at   <0, 0, 0>
  }


plane {z,0
  texture {  // cracked texture for rocks
    pigment {
      crackle
      color_map {
        [0.375 color rgb 0.95] 
        [0.688 color rgb 1]
        }
      turbulence 0.4
      scale 1
      }
    finish { ambient 1 }
    }
  texture {
    pigment { bozo // ground slopes away to black
      color_map {
        [0 color rgbt <0,0,0,1>]
        [0.5 color rgbt 0 ]
        }
      turbulence 0.5
      translate <-5,1,6>
      scale 20
      }
    finish { ambient 1 }
    }
  texture {
    pigment { bozo // fade out overlay to eliminate flat hill tops
      pigment_map {
        [0 bozo color_map {
          [0 color rgbt <0,0,0,0.8>]
          [1 color rgbt 1]
          } turbulence 0.4 scale 0.125 ]
        [0.25 color rgbt 1 ]
        }
      turbulence 0.5
      translate <-5,1,6>
      scale 20
      }
    finish { ambient 1 }
    }
  }
