
// Splash.inc  July 10 1998  Neil Alexander

// creates splashing water blob object for Balloon.pov

// This model is based on set of paraboli arcing up from the origin and
// falling back to the x-z plane.
// The equation used for the paraboli is:
//   y = (2ax-x^2)
// where a is the distance of the peak from the y-axis, and 0 <= x <= 1.
// The peak of the arc is a^2 high.

#declare factx = 18                 // radius factor (max radius)
#declare facty = 24                 // height factor (max height)
#declare C1 = 0                     // counter for main loop
#declare R1 = seed(1)

#declare Splash= blob {
  threshold 0.56
  #while (C1 < 200)                 // main loop,  # of paraboli
    #declare C2 = 0                 // counter for sub-loop
    #declare distx = rand(R1)       // distance of peak from y-axis
    #declare rot = rand(R1)*360     // rotation of parabola around y-axis
    #while (C2 < (75*distx))        // sub-loop, # of drops along parabola, more for higher arc
      #declare locx = rand(R1)      // x-location of drop alomg parabola
      #declare locx = locx*locx*locx*distx  // cubed for more drops earlier on the arc,
                                         // factored by x-length of rising leg of arc
      #declare locy = (2*distx*locx - locx*locx)  // y-location on parabola at locx
      sphere {<locx*factx, locy*facty, 0>,0.5,0.375  // drop, located, factored
        rotate y*rot                                 // and rotated
        }
      #declare C2 = C2 + 1          // increment sub-loop counter
      #end                          // end sub-loop
    #declare C1 = C1 + 1            // increment main loop counter
    #end                            // end main loop
  texture {                         // water texture
    pigment { color rgbf <1,1,1,0.5>}
    finish { reflection 0.3 phong 1 phong_size 50 }
    }
  } // end Splash
















