
// Glenn's POV-Ray Scene File - Atomic Manipulation
// created 29-Jul-98
// last update 29-Jul-98
// copyright 1998 Glenn McCarter

#include "GIncludeRH.inc"
//#include "GRuler.inc"

#version 3.1;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  /* // Radiosity section: uncomment to enable radiosity
  // calculations; must also turn on radiosity in ini file.
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
  */ // end radiosity section
}

//===============================================
//             Variables
//===============================================


//===============================================
//             Cameras
//===============================================


#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 60
//    direction z*50
  location <-3, -2, 3>
  look_at <0, 0, .5>
  }

camera {
    Special_Cam
  }

//===============================================
//             Textures
//===============================================


#declare YellowAtom =
	texture {
		pigment { color rgb<.97,1.03,0.44> }
		normal { bumps .5 scale .04 }
		finish { ambient .1 specular .4 roughness .02 }
	}

#declare BlueAtom =
	texture {
		pigment { color rgb<.37,.33,0.94> }
		normal { bumps .5 scale .04 }
		finish { ambient .1 specular .5 roughness .02 }
	}
#declare GreyAtom =
	texture {
		pigment { color rgb<.67,.63,0.64> }
		normal { bumps .5 scale .04 }
		finish { ambient .1 specular .4 roughness .02 }
	}

//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <4*Feet,8*Feet,7*Feet> } // quick sun
object {StdBulb60Watt translate <-10*Feet,1.2*Feet,5*Feet> } // over shoulder
#declare FillSpot =
  light_source {
    <4,-4,5>
    color rgb <.78, .75, .61>*.5
    spotlight
    point_at <0,0,0>
    radius 22    // degrees fully lit (*2)
    falloff 42   // degrees no lighting (*2)
    tightness 1
  }
object { FillSpot }



//===============================================
//             Environment
//===============================================

//background { color rgb <0.0, 0.0, 0.0> } // black
//object {GroundPlaneWhite translate z*-0}

//===============================================
//             Objects
//===============================================

#declare AtomField =
	blob {
		threshold .6
		#local Brad = 0.8;
		#declare Row=0;
		#while ( Row < 18 )
			#declare Column=0;
			#while ( Column < 18 )
				sphere { <0,0,0>,Brad,1 translate <Row,Column,0> }
				#declare Column = Column + 1;
			#end
			#declare Row = Row + 1;
		#end
		texture { YellowAtom }
	}

#declare SingleAtom =
	sphere { <0,0,0>,.3 texture { BlueAtom } }

#declare NanoTip =
	blob {
		threshold .6
		#local Brad=0.66;
		sphere { <0,0,0>,Brad,1 translate <  0,0,0> }
		sphere { <0,0,0>,Brad,1 translate < .8,0,0> }
		sphere { <0,0,0>,Brad,1 translate < 1.6,0,0> }
		sphere { <0,0,0>,Brad,1 translate < 2.4,0,0> }
		sphere { <0,0,0>,Brad,1 translate < 3.2,0,0> }
		sphere { <0,0,0>,Brad,1 translate < 4.0,0,0> }
		sphere { <0,0,0>,Brad*.5,1 translate <  .4,0,.4> }
		sphere { <0,0,0>,Brad*.5,1 translate < 1.2,0,.4> }
		sphere { <0,0,0>,Brad*.5,1 translate < 2.0,0,.4> }
		sphere { <0,0,0>,Brad*.5,1 translate < 2.8,0,.4> }
		sphere { <0,0,0>,Brad*.5,1 translate < 3.6,0,.4> }
		sphere { <0,0,0>,Brad*.5,1 translate < 4.4,0,.4> }
		texture { GreyAtom }
	}
#declare TipWithAtom =
	union {
		object { NanoTip }
		object { SingleAtom translate <-.4,.1,-0.1> }
	}



//===============================================
//             Object Placement
//===============================================

object { AtomField translate <-1,-1,-0> } // main plain
object { AtomField rotate x*-90 translate <-1,-1,-0> } // side wall
object { AtomField rotate y*-90 translate <3.5,-.5,-0> } // back wall
object { TipWithAtom rotate <0,-25,160> translate <-0.5,.5,1> }

//object { TestSphere scale 4 translate <0,-6,3> }
//object { CheckFloor (.5) }
