
// Glenn's POV-Ray Scene File - Construction and Destruction
// created 17-Jul-98 for the Internet Raytracing Competition at www.irtc.org
// last update 30-Aug-98
// copyright 1998 Glenn McCarter (gmccarter@hotmail.com)
//
// This is the master file for the scene.
//
// NOTE: these files have many embedded tabs.
// For best viewing, use the POV-Ray for Windows editor,
// and set Editor | Tabs | Real Tabs, with tab size 2.

#include "GIncludeRH.inc"
//#include "GRuler.inc"
#include "GShapes31.inc"
#include "NanoTron.inc"
#include "Eiffel.inc"
#include "Coffee.inc"
#include "Eyeglasses.inc"
#include "Chairs.inc"
#include "Tables.inc"
#include "CafeObjects.inc"
#include "Cafe.inc"
#include "Dummy.inc"
#include "DistantBuildings.inc"


#version 3.1;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  /* // Radiosity section: uncomment to enable radiosity
  // calculations; must also turn on radiosity in ini file.
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
  */ // end radiosity section
}

//===============================================
//             Variables
//===============================================

#declare mm= 1/25.4;
#declare GroundHeight = -70*Feet; // distance from local origin
                                  // to the outside ground plane
//#declare TowerPosition = <1300*Feet,1800*Feet,GroundHeight>; // far
#declare TowerPosition = <630*Feet,830*Feet,GroundHeight>; // near

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
	perspective
	direction <0.0,     1.0,  0.0>
	sky       <0.0,     0.0,  1.0>  // Use right handed-system!
	up        <0.0,     0.0,  1.0>  // Where Z is up
	right     <1.33333, 0.0,  0.0>
  /* // Focal Blur section: uncomment to enable focal blur
	blur_samples 6
	aperture .5    //lower value = wider range in focus
	focal_point <0,0,0>
  */ // end focal blur
	location <-5, -4, 2.5> // render view
	look_at <0, 1, 2>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 60
//    direction z*50
//	location <-5, -4, 3> // render view
//	look_at <0, 1, 2>
//	location <-1, -1, 6> // origin look-down
//	look_at <0, 0, 0>
//	location <-4, -4, 3> // origin 3/4
//	look_at <0, 0, 0>
//	location <-8*Feet, 12, 5.6*Feet-36> // overall room scene (zero is at tabletop, 36 above floor)
//	look_at <0, -2*Feet, 15>
//	location <-4*Feet, -8*Feet, 5.6*Feet-36> // scene over the shoulder
//	look_at <0, -2*Feet, 15>
	location <-1*Feet, -11*Feet, 5.6*Feet-36> // scene side view distant
	look_at <0, -2*Feet, 15>
//	location <-4, -4*Feet, 6> // scene side view near
//	look_at <0, -6, 6>
//	location <4*Feet, -10, 6> // scene reverse angle
//	look_at <0, 4, 6>
//	location <-5, 7.1, 3> // coffee Xview
//	look_at <0, 7, 2>
//	location <-5, 5, 3> // coffee 3/4view
//	look_at <0, 7, 2>
//	location <2, -1, 1.8> // NanoTron imager
//	look_at <4, 1, 1>
//	location <2, -1, 480*Feet> // helicoptor Eiffel view
//	look_at <1300*Feet,1800*Feet,-70*Feet>
  }

camera {
//    Special_Cam
    Render_Cam
  }

//===============================================
//             Textures
//===============================================

#declare SugarWhite =
	texture {
		pigment { color rgbt<1.0,1.1,1.0,.4> }
		normal { bumps .5 scale .04 }
		finish { ambient .6 specular .9 roughness .02 }
	}

#declare TinyBotTex = // robot
	texture {
		pigment { color rgb<.30,.46,1.30> }
		finish { ambient .28 metallic specular 1.0 roughness .010 }
	}

#declare EarthTex = // for ground plain
	texture {
		pigment {
			bozo
			color_map
			{
		[ 0.1  color rgb<.4,.4,.4> ]
		[ 0.3  color rgb<.9,.9,.6> ]
		[ 0.5  color rgb<.5,.4,.2> ]
		[ 0.7  color rgb<.1,.5,.2> ]
		[ 1.0  color rgb<.4,.4,.4> ]
			} // color_map
			scale 5000
			turbulence .02
		}
		normal { bumps .13 scale 400 }
		finish { ambient .15 diffuse .7 specular .2 roughness .05 }
	}
#declare GreenTex = // for ground plain
	texture {
		pigment {
			bozo
			color_map
			{
		[ 0.1  color rgb<.42,.67,.41> ]
		[ 0.2  color rgb<.62,.94,.61> ]
		[ 0.3  color rgbt<.35,.74,.23,.5> ]
		[ 0.4  color rgbt<1,1,1,1> ]
		[ 1.0  color rgbt<1,1,1,1> ]
			} // color_map
			scale 800
			turbulence .03
		}
		normal { bumps .13 scale 400 }
		finish { ambient .15 diffuse .7 specular .2 roughness .05 }
	}

#declare DeepBrass = // curtain rod
	texture {
		pigment { color rgb<.85,.79,.55> }
		finish { ambient .07 specular .85 roughness .01 metallic reflection .45 }
	}
#declare CurtainRingTex =
	texture {
		pigment { color rgb<.85,.79,.85> }
		finish { ambient .12 specular .65 roughness .08 }
	}
#declare ClearSatin = // curtain
	texture {
//		pigment { color rgb<.96,.94,.98> } // white test
		pigment { color rgbf<.96,.94,.98,.66> } // white render
		normal { bumps 0.15 scale <3,3,7> }
		finish { ambient .18 specular .3 roughness .012 }
	}


//===============================================
//             Lighting
//===============================================

//object { StdBulb60Watt translate <4*Feet,8*Feet,7*Feet> } // quick sun test
//object { FadeBulb35Watt translate <-7*Feet,4.2*Feet,5*Feet> } // test highlight NanoTron

object { FadeBulb50Watt translate <-7*Feet,-8.2*Feet,5*Feet> } // over shoulder
object { FadeBulb15Watt translate <7*Feet,-8.2*Feet,5*Feet> } // forward

#declare NanoSpot = // sky highlight on NanoTron
	light_source {
		<-7*Feet,4.2*Feet,5*Feet>
		color rgb <.35, .35, .45>
		spotlight
		point_at <3,-1,1>
		radius 2    // degrees fully lit (*2)
		falloff 22   // degrees no lighting (*2)
		tightness 1
	}
object { NanoSpot }

#declare Sun =
	light_source {
		<0,0,0>
		colour rgb <1, 1, 1>
		fade_distance 2*Miles
		fade_power 1
		looks_like {
			sphere {
				<0,0,0>, 1
				texture {
					pigment { color rgb<1,1,1> }
					finish { ambient .99 diffuse .2 }
				}
			}
		}
	}
object { Sun translate <2*Miles,4*Miles,3.7*Miles> }

#declare SkySpot = // lights front of tower
	light_source {
		TowerPosition+<200*Feet,-1200*Feet,500*Feet>
		color rgb <.68, .85, .91>*.7
		spotlight
		point_at TowerPosition+<0,0,300*Feet>
		radius 8    // degrees fully lit (*2)
		falloff 22   // degrees no lighting (*2)
		tightness 1
	}
object { SkySpot }


//===============================================
//             Environment
//===============================================

background { color rgb <0.17, 0.35, 0.67> } // light blue
//background { color rgb <0.0, 0.0, 0.0> } // black
//object {GroundPlaneWhite translate z*-0}
#declare Plain =
	plane { z,0 texture { EarthTex } texture { GreenTex } }
object { Plain translate <0,0,GroundHeight> }

sky_sphere {
    pigment {
      gradient z
      color_map {
        [ 0.5  color rgb<.72,.73,.99> ]
        [ 0.6  color rgb<.22,.24,.70> ]
      }
      scale 2
      translate -1
    }
  }

fog {
	fog_type 1 // general fog adds distance
		distance 7800*Feet
//		color rgbt<.800,.800,.998,.366> // transmittance (lower trans dulls out sky)
		color rgbt<.560,.560,.998,.366> // blue test
		turbulence .001
	}

//===============================================
//             Objects
//===============================================

#declare CurtainMain =
	#include "CURTAIN.POV"
	object { CurtainSurf
		scale <4,12,6>
		rotate <90,0,90>
		texture { ClearSatin }
	}
#declare CurtainHem =
	object { CurtainSurf
		scale <4,12,6>
		rotate <90,0,90>
		texture { ClearSatin }
		clipped_by { box { <-6,-5*Feet,-28>,<6,5*Feet,-20> } }
	}
#declare CurtainRod =
	cylinder {
		<0,-6*Feet,0>,<0,6*Feet,0>,.38
		texture { DeepBrass }
	}
#declare CurtainRingGroup =
	union {
		#local CRS = seed(77463);
		#local CRCount = 0;
		#while ( CRCount < 20 )
			torus {
				1.3,.14
				rotate <0,0,-20+rand(CRS)*40>
				translate <0,-3*Feet+CRCount*3,-0.9>
				texture { CurtainRingTex }
			}
			#local CRCount = CRCount + 1;
		#end
	}

#declare SheerCurtain = // origin at top edge, rod in Y-direction
	union {
		object { CurtainRod }
		object { CurtainRingGroup }

		object { CurtainMain scale <.7,.7,.5> translate <0,0,-7> } // main
		object { CurtainHem scale <.7,.7,.5> translate <-0.4,0,-7.4> } // bottom
		object { CurtainHem scale <.7,.7,.5> translate <-0.4,0,8.5> } // top

		object { CurtainMain scale <.7,.7,.5> translate <0,-2*Feet,-7> }
		object { CurtainHem scale <.7,.7,.5> translate <-0.4,-2*Feet,-7.4> }
		object { CurtainHem scale <.7,.7,.5> translate <-0.4,-2*Feet,8.5> } // top
		bounded_by { box { <-6,-5*Feet,-30>,<6,8*Feet,6> } }
	}

#declare SugarCube =
	object { RoundedBox(.15)
		scale <.4,.4,.4>
		translate <0,0,.2>
		texture { SugarWhite }
	}
#macro SugarCrystal(Seed)
	#local SS = seed(Seed);
	box {
		<0,0,0>,<1,1,1>
		scale <rand(SS)*.2*mm+.4*mm,rand(SS)*.2*mm+.4*mm,rand(SS)*.2*mm+.4*mm>
		texture { SugarWhite }
	}
#end

#macro SugarGroup(XC,YC,NumCrystals,Seed)
	union {
		#local SGS = seed(Seed);
		#local SGCount = 0;
		#while ( SGCount < NumCrystals )
			object {	SugarCrystal(Seed)
				rotate z*rand(SGS)*360
				translate <rand(SGS)*XC-XC/2,rand(SGS)*YC-YC/2,0>
			}
		#local SGCount = SGCount + 1;
		#end
	}
#end

#declare SugarStack =
	difference {
		box { <0,0,0>,<.12,.12,.12> }
		box { <0,0,0>,<.12,.12,.12> translate <.02,-.06,.06> }
		scale .7
		texture { SugarWhite }
	}

#declare TBotArm =
	cylinder {
		<0,0,0>,<1*mm,0,0>,0.12*mm
	}
#declare TinyBot = // faces +X
	union {
		object { RoundedBox(.3) // base
			scale <1.1*mm,1.3*mm,.5*mm>
			rotate <0,15,0>
			translate <.3*mm,0,.2*mm>
		}
		cone { // body
			<0,0,0>,0.3*mm,<0,0,1.8*mm>,0.2*mm
		}
		sphere { // head
			<0,0,0>,0.43*mm
			scale <1,1,.6>
			translate <0,0,1.8*mm>
		}
		object { TBotArm rotate y*-20 translate <0, 0.30*mm,1.1*mm> }
		object { TBotArm rotate y*-20 translate <0,-0.30*mm,1.1*mm> }
		object { SugarCrystal(1) translate <.75*mm,-0.3*mm,1.2*mm> }
		texture { TinyBotTex }
	}
#declare UnitBot =
	object { TinyBot scale 12 } // roughly one inch

//------------ Big Robot --------------------------
#declare HandPose = 1;
#declare FFat = 1.23; // finger fatness ratio ( 1 = normal, 1.4 = too fat )
#declare TA  = 44; // thumb, outer joint
#declare TB  = 50; // thumb, middle joint
#declare TRot  = 33; // thumb rotation angle
#declare TExt  = 0; // thumb extension from hand
#declare F1A  = 74; // index finger, outer joint
#declare F1B  = 82; // index finger, middle joint
#declare F1C  = 16; // index finger angle
#declare F1Rot  = 10; // index finger rotation
#declare F2A  = 70; // middle finger, outer joint
#declare F2B  = 80; // middle finger, middle joint
#declare F2C  = 20; // middle finger angle
#declare F2Rot  = 0; // middle finger rotation
#declare F3A  = 55; // ring finger, outer joint
#declare F3B  = 68; // ring finger, middle joint
#declare F3C  = 26; // ring finger angle
#declare F3Rot  = -4; // ring finger rotation
#declare F4A  = 42; // pinky finger, outer joint
#declare F4B  = 66; // pinky finger, middle joint
#declare F4C  = 32; // pinky finger angle
#declare F4Rot  = -10; // pinky finger rotation
#declare WRot = 1; // wrist rotation angle
#declare WCock = -12; // wrist cock side-to-side

#declare Pose =1;
// Pose Angles ( in order )
#declare HPan     = 56;   // head, positive = towards his left
#declare HTiltFwd = 15;   // head forward tilt
#declare HCock    = 0;    // head right/left tilt, positive = to the left
#declare TTwist   = 80;    // torso twist, positive = right hip fwd
#declare HipTude  = -20;    // hip attitude, positive = right hip up
#declare RWCock   = 0;    // wrist side-to-side (golf)
#declare RWAng    = 0;    // wrist angle
#declare RETwist  = 50;   // twists the hand, positive = palms up
#declare REAng    = 85;  // elbow
#declare RAFwd    = 43;   // total arm
#declare RARot    = -32;   // claps hands
#declare RAOut    = 4;   // opens underarm
#declare RAFwd2   = 0;    // total arm
#declare RARot2   = 0;    // claps hands
#declare RKnee    = 68;    // duh
#declare RLTwist  = 0;    // leg twist
#declare RLAng    = 40;    // leg angle
#declare RLOut    = 5;    // spread eagle
#declare LWCock   = 20;   // wrist side-to-side (golf)
#declare LWAng    = 0;    // wrist angle
#declare LETwist  = 140;  // twists the hand, positive = palms up
#declare LEAng    = 36;   // elbow
#declare LAFwd    = 12;   // total arm
#declare LARot    = 12;   // claps hands
#declare LAOut    = 70;    // opens underarm
#declare LAFwd2   = 0;    // total arm
#declare LARot2   = -20;  // claps hands
#declare LKnee    = 24;    // duh
#declare LLTwist  = 0;    // leg twist
#declare LLAng    = -5;    // leg angle fwd
#declare LLOut    = 18;    // spread eagle
#include "Robot31.inc"


//===============================================
//             Object Placement
//===============================================


object { Cafe(1) translate <0,-12*Feet,-36> }
object { SheerCurtain rotate z*90 translate <3.5*Feet,16,1.5*Feet> }

object { RoomObjects }
object { SDummy rotate <0,0,180> translate <-16.4,0,8.3> }
object { MChair rotate z*172 translate <-13,4,-36> }

object { PatternTable(24,30,1) translate <10,0,0> }

object { Eyeglasses(22,12) rotate <180,5,20> translate <-1,-1.1,1.48/2> }

object { Saucer translate <0,7,0> }
object { CoffeeCupSpilling rotate <14,0,8> translate <0,7,0.9> }

object { SugarCube rotate z*-18 translate <-1.1,1.8,0> } // coffee
object { SugarCube rotate z*48 rotate <6,4,0> translate <-1.8,0,0> } // near
object { SugarGroup(1,2,5,10212) translate <-1.6,-0.7,0> }
object { SugarGroup(1,1,2,31047) rotate z*30 translate <-1.7,.7,0> }

object { NanoTron(110,135) rotate z*15 translate <5,3,0> }

object { TinyBot rotate z*-53 translate <.5,-1.78,0> }
object { SugarGroup(.30,.36,4,53703) translate <.40,-2.0,0> } // robot front
object { SugarStack translate <.3,-1.5,0> }

object { FallingEiffelTower scale <1,1,1> rotate <0,0,0> translate TowerPosition }
object { Robot scale 170 rotate <30,0,30> translate TowerPosition+<-210*Feet,250*Feet,510*Feet> }
object { DistantBuildings(2*Miles,2*Miles,60) translate TowerPosition }


// TEST OBJECTS -- DO NOT RENDER
//object { TestSphere scale 4 translate <0,-6,3> }
//object { CheckFloor (.5) translate <0,0,-1> }
//object { Magnifier(3,5,0.75) scale 1 rotate <-8,0,8> translate <-2,1,1> }
//object { Magnifier(3,5,0.75) scale 1 rotate <40,0,-40> translate <0,-2,1> }
//object { UnitBot rotate z*-53 translate <.5,-1.7,0> }
//object { Room translate <0,-12*Feet,-36> }
//object { XBrace(6*Feet,18) texture { GirderTex } rotate z*65 translate <30,30,-12> }
//object { SheerCurtain rotate z*90 translate <1.5*Feet,16,-2> }
//object { NanoTron(110,135) rotate z*15 translate <5,3,0> }
