
// Glenn's POV-Ray Object File - Tables
// created 17-Aug-98
// last update 30-Aug-98
// copyright 1998 Glenn McCarter
// This file does not render.  #include "Tables.inc" in another .pov file
//
// Objects:
// SteelTable(Xsize,Ysize)
// CarbonFiberTable(Xsize,Ysize,Quality)
//
// All tables are centered on XY plane, with legs extending 36 into -Z

// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// For POV-Ray version 3.1+

//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare CheckerTex =
	texture {
		pigment {
			checker
				color rgb<1,1,1>
				color rgb<.6,.6,.6>
				scale 1
		}
//		finish { ambient .02 specular .8 roughness .012 } // test
		finish { ambient .02 specular .8 roughness .012 reflection .3 } // render
	}

#declare BrightSteel = // table edge
	texture {
		pigment { color rgb<.56,.67,.88> }
//		finish { ambient .02 metallic specular .8 roughness .005               } // test
		finish { ambient .02 metallic specular .8 roughness .005 reflection .5 } // render
	}

#declare XFiberTex =
	texture {
		pigment { color rgb<.92,.89,.64> }
		normal { bumps .9 scale <1,.15,1> }
		finish { ambient .05 metallic specular .5 roughness .08 }
	}

#declare BlackLucite =
	texture {
		pigment { color rgb<.137,.116,.083> } // well, not quite black
		normal {
			average
			normal_map {
				[ 1.0 bumps .1 scale 4 turbulence .08 ] // slight overall waviness
				[ 1.0 bumps .005 scale .04 turbulence .11 ] // tiny irregularities
			}
		}
//		finish { phong .6 phong_size 200               } // test
		finish { phong .6 phong_size 200 reflection .09 } // render
	}

#declare FilterLucite = // slight see-through
	texture {
		pigment { color rgbf<.12,.12,.10,.8> }
//		pigment { color rgb<.097,.096,.093> } // test black
		normal {
			average
			normal_map {
				[ 1.0 bumps .1 scale 4 turbulence .08 ] // slight overall waviness
				[ 1.0 bumps .005 scale .04 turbulence .11 ] // tiny irregularities
			}
		}
//		finish { phong .6 phong_size 200               } // test
		finish { phong .6 phong_size 200 reflection .3 } // render
	}

#declare ClearLucite = // basically clear -- interior does all the work
	texture {
		pigment { color rgbt<.97,.96,.93,.97> }
//		pigment { color rgb<.097,.096,.093> } // test black
		normal {
			average
			normal_map {
				[ 1.0 bumps .1 scale 4 turbulence .08 ] // slight overall waviness
				[ 1.0 bumps .005 scale .04 turbulence .11 ] // tiny irregularities
			}
		}
//		finish { phong .6 phong_size 200               } // test
		finish { phong .6 phong_size 200 reflection .3 } // render
	}

#declare CarbonMatrix =
	interior {
//		fade_distance .01 fade_power 1
		fade_distance .1 fade_power 1
		media { absorption <.83,.92,.98> } // yellowish brown
	}

#declare DeepChrome =
	texture {
		pigment { color rgb <0.39, 0.41, 0.43> }
		finish {
			ambient 0.1
			brilliance 6
			diffuse 0.7
			metallic
			specular 0.80
			roughness .01
			reflection 0.6
		}
	}


//===============================================
//             Objects
//===============================================

#macro RimEdge(X1,X2) // runs along X-axis, front in +Y
	union {
		box { <X1,0,-1.0>,<X2,0.1,0> }
		cylinder { <X1,0.1,0>,<X2,0.1,0>,.1 scale <1,1,.5> } // top edge
		cylinder { <X1,0.1,0>,<X2,0.1,0>,.1 scale <1,1,.5> translate <0,0,-1> } // bottom edge
		cylinder { <X1,0,-0.2>,<X2,0,-0.2>,.2 clipped_by {box{<X1-.01,1,0>,<X2+.01,.08,-0.4>}} }
		cylinder { <X1,0,-0.5>,<X2,0,-0.5>,.2 clipped_by {box{<X1-.01,1,-0.3>,<X2+.01,.08,-0.7>}} }
		cylinder { <X1,0,-0.8>,<X2,0,-0.8>,.2 clipped_by {box{<X1-.01,1,-0.6>,<X2+.01,.08,-1.0>}} }
		texture { BrightSteel }
	}
#end

#declare TranSeed = seed(15730);
#macro CarbonFiberBundle(Dummy)
	superellipsoid {
		<.2,.6>
		texture { XFiberTex translate <rand(TranSeed)*20,rand(TranSeed)*20,rand(TranSeed)*20> }
		scale .17
	}
#end
#macro CFUnitSquare(Randomness) // use Randomness from 0 to 1, higher = more random sizes
	#local RS = seed(73709);
	union {
		object { CarbonFiberBundle(1) scale <1,rand(RS)*Randomness+(1-Randomness),rand(RS)*Randomness/3+(1-Randomness/3)> }
		object { CarbonFiberBundle(1) scale <1,rand(RS)*Randomness+(1-Randomness),rand(RS)*Randomness/3+(1-Randomness/3)> translate <.25,.25,0> }
		object { CarbonFiberBundle(1) scale <1,rand(RS)*Randomness+(1-Randomness),rand(RS)*Randomness/3+(1-Randomness/3)> rotate z*90 translate <.25,0,0> }
		object { CarbonFiberBundle(1) scale <1,rand(RS)*Randomness+(1-Randomness),rand(RS)*Randomness/3+(1-Randomness/3)> rotate z*90 translate <0,.25,0> }
	}
#end
#macro CFYGroup(Ysize)
	union {
		#local YCount = 0;
		#while ( YCount < Ysize*2 ) // *2 because the unit cell is only 1/2-inch
			object { CFUnitSquare(.3) translate <0.125,YCount*.5+.125,-0.1> }
			#local YCount = YCount + 1;
		#end
	}
#end
#macro CarbonFiberTableTop(Xsize,Ysize,Quality)
	union {
	#switch ( Quality )
	#case ( 0 )
		box { // shiny black top
			<0,0,-.3>,<Xsize,Ysize,.16>
			texture { BlackLucite }
		}
	#break
	#case ( 1 )
		#local XCount = 0;
		#while ( XCount < Xsize*2 ) // *2 because the unit cell is only 1/2-inch
			object { CFYGroup(Ysize) translate <XCount*.5,0,0> }
			#local XCount = XCount + 1;
		#end
		box { // clear top
			<0,0,-.3>,<Xsize,Ysize,.16>
			hollow
				texture { ClearLucite }
				interior { CarbonMatrix }
		}
	#end
		box { // opaque bottom
			<0,0,-.4>,<Xsize,Ysize,0>
			texture { pigment { color rgb<0,0,0> } }
		}
		translate <0,0,-.16> // top at zero
	}
#end


//------------- Pattern Table ---------------------
// This tabletop uses any pattern you want.
// Just use a bitmap "Pattern.png" for the pattern.

#macro PatternTableTop(Xsize,Ysize,Quality)
	union {
	#switch ( Quality )
	#case ( 0 )
		box { // shiny black top
			<0,0,-.3>,<Xsize,Ysize,.16>
			texture { BlackLucite }
		}
	#break
	#case ( 1 )
		box { // fabric
			<0,0,-.5>,<Xsize,Ysize,-.3>
			texture {
				pigment {
					image_map { // image is always projected from -z, with front facing +z
					png "Pattern.png"
					}
					scale <4,4,1>
				}
				finish { ambient .9 }
			}
		}
/*
		box { // clear top
			<0,0,-.3>,<Xsize,Ysize,.16>
			hollow
				texture { ClearLucite }
				interior { CarbonMatrix }
		}
*/
		box { // clear top
			<0,0,-.3>,<Xsize,Ysize,.16>
			hollow
				texture { FilterLucite }
//				interior { CarbonMatrix }
		}

	#end
		translate <0,0,-.16> // top at zero
	}
#end

#declare Pedestal =
	union {
		cylinder { // main
			<0,0,-36>,<0,0,-.5>,2.8
			texture { DeepChrome }
		}
		difference {
			sphere {
				<0,0,0>,9
				scale <1,1,.3>
			}
			box { <-22,-22,-22>,<22,22,0> } // cut off bottom
			texture { BlackPaint }
			translate <0,0,-36>
		} // end difference
		sphere {
			<0,0,0>,7
			scale <1,1,.5>
			translate <0,0,-36>
			texture { BlackPaint }
		}
	}

#macro SteelTableTop(Xsize,Ysize)
   box {
     <-Xsize/2,-Ysize/2,-1>,<Xsize/2,Ysize/2,0>
        texture { CheckTex}
   }
#end

#macro SteelTable(Xsize,Ysize)
	union {
		object { SteelTableTop(Xsize,Ysize) }
		object { Pedestal }
		object { RimEdge(0,Xsize) translate <-Xsize/2,Ysize/2,0> }
		object { RimEdge(0,Ysize) rotate z*90 translate <-Xsize/2,-Ysize/2,0> }
		object { RimEdge(0,Xsize) rotate z*180 translate <Xsize/2,-Ysize/2,0> }
		object { RimEdge(0,Ysize) rotate z*270 translate <Xsize/2,Ysize/2,0> }
   }
#end

#macro CarbonFiberTable(Xsize,Ysize,Quality) // Quality 0 (black) or 1 (translucent)
	union {
		object { CarbonFiberTableTop(Xsize,Ysize,Quality) translate <-Xsize/2,-Ysize/2,0> }
		object { Pedestal }
		object { RimEdge(0,Xsize) translate <-Xsize/2,Ysize/2,0> }
		object { RimEdge(0,Ysize) rotate z*90 translate <-Xsize/2,-Ysize/2,0> }
		object { RimEdge(0,Xsize) rotate z*180 translate <Xsize/2,-Ysize/2,0> }
		object { RimEdge(0,Ysize) rotate z*270 translate <Xsize/2,Ysize/2,0> }
		bounded_by { box { <-Xsize/2-1,-Ysize/2-1,-40>,<Xsize/2+1,Ysize/2+1,.5> } }
   }
#end

#macro PatternTable(Xsize,Ysize,Quality) // Quality 0 (black) or 1 (translucent)
	union {
		object { PatternTableTop(Xsize,Ysize,Quality) translate <-Xsize/2,-Ysize/2,0> }
		object { Pedestal }
		object { RimEdge(0,Xsize) translate <-Xsize/2,Ysize/2,0> }
		object { RimEdge(0,Ysize) rotate z*90 translate <-Xsize/2,-Ysize/2,0> }
		object { RimEdge(0,Xsize) rotate z*180 translate <Xsize/2,-Ysize/2,0> }
		object { RimEdge(0,Ysize) rotate z*270 translate <Xsize/2,Ysize/2,0> }
		bounded_by { box { <-Xsize/2-1,-Ysize/2-1,-40>,<Xsize/2+1,Ysize/2+1,.5> } }
   }
#end
