
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "woods.inc"

camera {
  location <3, -15.0 , 6.0>
  sky <0,0,1>
  right <0,1.33,0>
  look_at   <-0.5 , 0.0 , 1.5>
  angle 40
}

light_source {<3,-15,10> color Gray60
   fade_distance 10
   fade_power 3

}

light_source {<0,-5,8> color White
/*   area_light x/3,y/3,3,3
   jitter*/
   spotlight
   point_at x*2.5
   radius 180
   falloff 360
}

light_source {<10,-5,8> color White/1.8
/*   area_light x/3,y/3,3,3
   jitter*/
   spotlight
   point_at <-4,1,1.5>
   radius 10
   falloff 20
}


#declare Steam =
cylinder {<0,0,0><0,0,2> 01.1
 pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      planar_mapping
      linear
      turbulence 0.4
      color_map {
        [ 0 color rgbt <1, 1, 1, 1.0> ]
        [ 1 color rgbt <1, 1, 1, 0.6> ]
      }
      samples 10
    rotate x*90
    scale <0.4,0.4,1.4>}
    hollow
  translate z*1
}
#declare Coffee =
cylinder {<0,0,1><0,0,1.21> 01.1
  texture {pigment {color Brown/10}}
  finish {Shiny reflection 0.2}}

#include "java.inc"

#declare Cup =
union {
  object {Layer1   texture {pigment {color White} finish {Shiny reflection 0.2}}}
  object {Layer3   texture {pigment {color White} finish {Shiny reflection 0.2}}}
  object {Layer4 texture {Chrome_Texture} rotate y*45}
  rotate x*90
  rotate z*240

}

union {
  object {Cup}
  object {Coffee}
  object {Steam}
  scale 0.8
  translate x*2.5
}


#include "monitor.inc"
object {Monitor scale 1.5 rotate z*35 translate <-3,0,-0.13>}


plane {-y, -6 pigment {color rgb <0.8,0.8,0.75>} normal {granite turbulence 0.4}}

union {
  box {<-10,-5,-0.5> <10,4,-0.1>}
  cylinder {<-10,-5,-0.3><10,-5,-0.3> 0.2}
  box {<-10,-5.2,-0.5> <10,-5.2,-0.3>}
  texture {T_Wood3 rotate y*80 scale 2 translate x*5}
  }

box {
  <0,0,-0.11><1,1,-0.099>
  pigment {image_map{gif "elements.gif" once} }
  scale <1*3,8/6*3,1>
  rotate z*30
  translate <0,-5,0>
}

