#ifdef(Polyreg_Inc_Temp)
// do nothing
#else
#declare Polyreg_Inc_Temp = version;
#version 3.1

#ifdef(View_POV_Include_Stack)
#   debug "including polyreg.inc\n"
#end

/*
              Persistence of Vision Raytracer Version 3.0
         Implements additional, useful, but seldom used shapes

                    Contents:
                    =========
            Tetraedre
            Octaedre
            Dodecaedre
            Icosaedre
*/
#local n1 = (sqrt(5)-1)/2
#local n2 = (sqrt(5)+1)/2
#local n3 = (sqrt(5)+3)/2
#local n4 = sqrt((sqrt(5)+3)/6)
#local n5 = tan(radians(54))


#declare Tetraedre1 =
 intersection
  {plane { <1, 1, 1> 1/sqrt(3) }
   plane { <-1, 1, -1> 1/sqrt(3) }
   plane { <1, -1, -1> 1/sqrt(3) }
   plane { <-1, -1, 1> 1/sqrt(3) }
  }


#declare Tetraedre2 =
 intersection
  {plane { <1, 1, -1> 1/sqrt(3) }
   plane { <-1, 1, 1> 1/sqrt(3) }
   plane { <1, -1, 1> 1/sqrt(3) }
   plane { <-1, -1, -1> 1/sqrt(3) }
  }


#declare Octaedre =
 intersection
  { plane { <1, 1, 1> 1/sqrt(3) }
    plane { <-1, 1, -1> 1/sqrt(3) }
    plane { <1, -1, -1> 1/sqrt(3) }
    plane { <-1, -1, 1> 1/sqrt(3) }
    plane { <1, 1, -1> 1/sqrt(3) }
    plane { <-1, 1, 1> 1/sqrt(3) }
    plane { <1, -1, 1> 1/sqrt(3) }
    plane { <-1, -1, -1> 1/sqrt(3) }
  }

#declare Dodecaedre1 =
 intersection
  { plane { <-1, 0, -n1> n5 }
    plane { <-1, 0, n1> n5 }
    plane { <-n1, -1, 0> n5 }
    plane { <-n1, 1, 0> n5 }
    plane { <0, -n1, -1> n5 }
    plane { <0, -n1, 1> n5 }
    plane { <0, n1, -1> n5 }
    plane { <0, n1, 1> n5 }
    plane { <n1, -1, 0> n5 }
    plane { <n1, 1, 0> n5 }
    plane { <1, 0, -n1> n5 }
    plane { <1, 0, n1> n5 }
    }



#declare Dodecaedre2 =
 intersection
  { plane { <-n1, 0, -1> n5 }
    plane { <-n1, 0, 1> n5 }
    plane { <-1, -n1, 0> n5 }
    plane { <-1, n1, 0> n5 }
    plane { <0, -1, -n1> n5 }
    plane { <0, -1, n1> n5 }
    plane { <0, 1, -n1> n5 }
    plane { <0, 1, n1> n5 }
    plane { <1, -n1, 0> n5 }
    plane { <1, n1, 0> n5 }
    plane { <n1, 0, -1> n5 }
    plane { <n1, 0, 1> n5 }
    }



#declare Icosaedre1 =
 intersection
  { plane { <-n1, 0, -n2> n4 }
    plane { <-n1, 0, n2> n4 }
    plane { <-1, -1, -1> n4 }
    plane { <-1, -1, 1> n4 }
    plane { <-1, 1, -1> n4 }
    plane { <-1, 1, 1> n4 }
    plane { <-n2, -n1, 0> n4 }
    plane { <-n2, n1, 0> n4 }
    plane { <0, -n2, -n1> n4 }
    plane { <0, -n2, n1> n4 }
    plane { <0, n2, -n1> n4 }
    plane { <0, n2, n1> n4 }
    plane { <n2, -n1, 0> n4 }
    plane { <n2, n1, 0> n4 }
    plane { <1, -1, -1> n4 }
    plane { <1, -1, 1> n4 }
    plane { <1, 1, -1> n4 }
    plane { <1, 1, 1> n4 }
    plane { <n1, 0, -n2> n4 }
    plane { <n1, 0, n2> n4 }
  }



#declare Icosaedre2 =
 intersection
  { plane { <-n2, 0, -n1> n4 }
    plane { <-n2, 0, n1> n4 }
    plane { <-1, -1, -1> n4 }
    plane { <-1, -1, 1> n4 }
    plane { <-1, 1, -1> n4 }
    plane { <-1, 1, 1> n4 }
    plane { <-n1, -n2, 0> n4 }
    plane { <-n1, n2, 0> n4 }
    plane { <0, -n1, -n2> n4 }
    plane { <0, -n1, n2> n4 }
    plane { <0, n1, -n2> n4 }
    plane { <0, n1, n2> n4 }
    plane { <n1, -n2, 0> n4 }
    plane { <n1, n2, 0> n4 }
    plane { <1, -1, -1> n4 }
    plane { <1, -1, 1> n4 }
    plane { <1, 1, -1> n4 }
    plane { <1, 1, 1> n4 }
    plane { <n2, 0, -n1> n4 }
    plane { <n2, 0, n1> n4 }
  }


// Vertex of the cube
#declare vcube = array[8][3]
{
{1,1,1},
{1,1,-1},
{1,-1,-1},
{1,-1,1},
{-1,-1,1},
{-1,-1,-1},
{-1,1,-1},
{-1,1,1}
}

// Vertex of the tetrahedron1
#declare vtetra1 = array[4][3]
{
{-1,1,1},
{1,1,-1},
{-1,-1,-1},
{1,-1,1}
}

// Vertex of the tetrahedron2
#declare vtetra2 = array[4][3]
{
{-1,1,-1},
{1,1,1},
{-1,-1,1},
{1,-1,-1}
}

// Vertex of the octahedron
#declare vocta = array[6][3]
{
{0,0,1},
{0,1,0},
{1,0,0},
{0,0,-1},
{0,-1,0},
{-1,0,0}
}

// Vertex of the dodecahedron1
#declare vdodec1 = array[20][3]
{
{-n1, 0, -n2},
{-n1, 0, n2},
{-1, -1, -1},
{-1, -1, 1},
{-1, 1, -1},
{-1, 1, 1},
{-n2, -n1, 0},
{-n2, n1, 0},
{0, -n2, -n1},
{0, -n2, n1},
{0, n2, -n1},
{0, n2, n1},
{n2, -n1, 0},
{n2, n1, 0},
{1, -1, -1},
{1, -1, 1},
{1, 1, -1},
{1, 1, 1},
{n1, 0, -n2},
{n1, 0, n2}
}

// Vertex of the dodecahedron2
#declare vdodec2 = array[20][3]
{
{-n2, 0, -n1},
{-n2, 0, n1},
{-1, -1, -1},
{-1, -1, 1},
{-1, 1, -1},
{-1, 1, 1},
{-n1, -n2, 0},
{-n1, n2, 0},
{0, -n1, -n2},
{0, -n1, n2},
{0, n1, -n2},
{0, n1, n2},
{n1, -n2, 0},
{n1, n2, 0},
{1, -1, -1},
{1, -1, 1},
{1, 1, -1},
{1, 1, 1},
{n2, 0, -n1},
{n2, 0, n1}
}

// Vertex of the icosahedron1
#declare vicos1 = array[12][3]
{
{-1, 0, -n1 },
{-1, 0, n1 },
{-n1, -1, 0 },
{-n1, 1, 0 },
{0, -n1, -1 },
{0, -n1, 1 },
{0, n1, -1 },
{0, n1, 1 },
{n1, -1, 0 },
{n1, 1, 0 },
{1, 0, -n1 },
{1, 0, n1 }
}

// Vertex of the icosahedron2
#declare vicos2 = array[12][3]
{
{-n1, 0, -1 },
{-n1, 0, 1 },
{-1, -n1, 0 },
{-1, n1, 0 },
{0, -1, -n1 },
{0, -1, n1 },
{0, 1, -n1 },
{0, 1, n1 },
{1, -n1, 0 },
{1, n1, 0 },
{n1, 0, -1 },
{n1, 0, 1 }
}


#version Polyreg_Inc_Temp;
#end
