// Persistence of Vision Raytracer
// Sol en parquet simple

#ifndef (MAIN_POV)
#include "common.inc"
#end

/******************************************************************************
   A faire:
******************************************************************************/



/******************************************************************************

        textures

******************************************************************************/

#declare Sol_T=
    texture { pigment { P_WoodGrain4A color_map { M_Wood8A }} rotate 1*z}
    texture {
       pigment { P_WoodGrain4B color_map { M_Wood8B }}
       normal {wood turbulence <0.04, 0.04, 1> octaves 4
          scale <0.05, 0.05, 1> * 0.66 bump_size .1}
       finish {specular 1 roughness 0.0001 reflection 0.05}
       finish {specular 1 roughness 0.001 reflection 0.05}
       rotate 1*z
       }

/******************************************************************************

        objets

******************************************************************************/

//////////////////////////////////////////////////////////////////////// SOL
#declare Sol0=object{
   box {<-500, -5, -400>, <500, -1, 2000>}
   pigment {Tan*.3}
   }


#declare Sol=union{
   object {Sol0}
   }

//////////////////////////////////////////////////////////////////////// MURS


#declare Murs1=object{
   difference{
      box {<-501, -11, -401>, <501, 601, 2001>}
      box {<-500, -10, -400>, <500, 600, 2000>}
      box {<-40, 80, -300>, <40, 200, -10000>}
      }
   pigment {Tan*.75}
   normal  {crackle 1 scale <3, .5, 3>}
   finish  {phong 0.3 phong_size .2 metallic}
   }

#declare Murs=union{
   object {Murs1}
   }


//////////////////////////////////////////////////////////////////////// FENETRE

#declare Fenetre1=object{
   box {<-39, 80, -.11>, <39, 200, .11>}
   //pigment {rgbf <0.8, 1, 1, 1>}
   texture{
      pigment {
         image_map{
            png "skye.png"
            map_type 0
            interpolate 2
            once
            }
         scale <80, 120, 1>
         translate <-40, 80, 0>
         }
      finish {ambient 1 diffuse 0}
      }
   no_shadow
   }

#declare Fenetre2=object{
   box {<-39, 80, -.1>, <39, 200, .1>}
   texture{
      pigment {
         image_map{
            png "skye.png"
            map_type 0
            interpolate 2
            once
            //filter all 1
            transmit all 1
            }
         scale <80, 120, 1>
         translate <-40, 80, 0>
         }
      }
   }

#declare Fenetre3=object{
   difference {
      //box {<-39, 80, -.1>, <39, 200, .1>}
      box {<-42, 0, -3>, <42, 205, 3>}
      box {<-39, 0, -4>, <39, 200, -.5>}
      box {<-39, 0, 4>, <39, 200, .5>}
      
      box {<-39, 80, -2>, <-20, 99, 2>}
      box {<-19, 80, -2>, <0, 99, 2>}
      box {<1,   80, -2>, <20, 99, 2>}
      box {<21,  80, -2>, <39, 99, 2>}
      
      box {<-39, 100, -2>, <-20, 119, 2>}
      box {<-19, 100, -2>, <0,   119, 2>}
      box {<1,   100, -2>, <20,  119, 2>}
      box {<21,  100, -2>, <39,  119, 2>}
      
      box {<-39, 120, -2>, <-20, 139, 2>}
      box {<-19, 120, -2>, <0,   139, 2>}
      box {<1,   120, -2>, <20,  139, 2>}
      box {<21,  120, -2>, <39,  139, 2>}
      
      box {<-39, 140, -2>, <-20, 159, 2>}
      box {<-19, 140, -2>, <0,   159, 2>}
      box {<1,   140, -2>, <20,  159, 2>}
      box {<21,  140, -2>, <39,  159, 2>}
      
      box {<-39, 160, -2>, <-20, 179, 2>}
      box {<-19, 160, -2>, <0,   179, 2>}
      box {<1,   160, -2>, <20,  179, 2>}
      box {<21,  160, -2>, <39,  179, 2>}
      
      box {<-39, 180, -5>, <-20, 199, 5>}
      box {<-19, 180, -5>, <0,   199, 5>}
      box {<1,   180, -5>, <20,  199, 5>}
      box {<21,  180, -5>, <39,  199, 5>}
      }
   pigment {White}
   }

#declare Fenetre=union{
   object {Fenetre1}
   //object {Fenetre2}
   object {Fenetre3}
   }


//////////////////////////////////////////////////////////////////////// FUTS

#declare Futs1=object {
   difference{
      intersection {
         box {<-200, 0, -400>, <200, 400, 400>}
         sphere {0, 1 scale <400, 150, 150> translate 180*y}
         }
      cone {<195, 180, 0>, 120, <210, 180, 0>, 130}
      }
   pigment {Tan}
   }

#declare Futs_=union {
   object {Futs1}
   scale <1, .8, .8>
   }

#declare Futs=union {
   object {Fut rotate 681*y translate -50*y rotate -90*z translate <-150, 40, -280>}
   object {Fut rotate 45*y translate -50*y rotate -90*z translate <-150, 40, -200>}
   object {Fut rotate 157*y translate -50*y rotate -90*z translate <-150, 40, -120>}
   object {Fut rotate 731*y translate -50*y rotate -90*z translate <-150, 40, -040>}
   object {Fut rotate 614*y translate -50*y rotate -90*z translate <-150, 40,  040>}
   object {Fut rotate 037*y translate -50*y rotate -90*z translate <-150, 40,  120>}
   object {Fut rotate 987*y translate -50*y rotate -90*z translate <-150, 100, -240>}
   object {Fut rotate 675*y translate -50*y rotate -90*z translate <-150, 100, -160>}
   object {Fut rotate 354*y translate -50*y rotate -90*z translate <-150, 100, -80>}
   object {Fut rotate 541*y translate -50*y rotate -90*z translate <-150, 100, 0>}
   object {Fut rotate 133*y translate -50*y rotate -90*z translate <-150, 100,  080>}
   object {Fut rotate 127*y translate -50*y rotate -90*z translate <-150, 100,  160>}
   object {Fut rotate 790*y translate -50*y rotate -90*z translate <-150, 160, -200>}
   object {Fut rotate 739*y translate -50*y rotate -90*z translate <-150, 160, -120>}
   object {Fut rotate 034*y translate -50*y rotate -90*z translate <-150, 160, -040>}
   object {Fut rotate 861*y translate -50*y rotate -90*z translate <-150, 160,  040>}
   object {Fut rotate 681*y translate -50*y rotate -90*z translate <-150, 160,  120>}
   }

#declare Decor=union{
   object {Murs}
   object {Futs translate <0,0,40>}
   //object {Futs translate <-300, 0, -200>}
   //object {Futs translate <-300, 0, 50>}
   //object {Futs translate <-300, 0, 300>}
   //object {Futs translate <-300, 0, 550>}
   //object {Futs translate <-300, 0, 800>}
   object {Fenetre translate <0, 0, -400>}
   object {Sol}
   }
