// Persistence of Vision Raytracer
// Fut et autres objets

#ifndef (MAIN_POV)
#include "common31.inc"
#end
#include "bouteille.inc"
/******************************************************************************
   A faire:
******************************************************************************/



/******************************************************************************

        textures

******************************************************************************/

#declare Sol_T=
    texture { pigment { P_WoodGrain4A color_map { M_Wood8A }} rotate 1*z}
    texture {
       pigment { P_WoodGrain4B color_map { M_Wood8B }}
       normal {wood turbulence <0.04, 0.04, 1> octaves 4
          scale <0.05, 0.05, 1> * 0.66 bump_size .1}
       finish {specular 1 roughness 0.0001 reflection 0.05}
       finish {specular 1 roughness 0.001 reflection 0.05}
       rotate 1*z
       }

/******************************************************************************

        objets

******************************************************************************/

//////////////////////////////////////////////////////////////////////// FUT

#declare FutColor=color red 0.30 green 0.20 blue 0.12
//#declare FutColor=color red 0.36 green 0.20 blue 0.09  // BakersChoc

#declare Fut0=object{
   difference{
      sphere {0, 1 scale <40, 80, 40>}
      sphere {0, 1 scale <38, 78, 38>}
      cone {90*y, 40, 50*y, 28}
      plane {x, 0}
      plane {x, 0 rotate (180-11.5)*y}
      }
   translate 50*y
   }

#declare Fut1=object {
   cylinder {99*y, 100*y, 28.5}
   pigment {FutColor*1.3}
         normal {
            wood poly_wave .2
            turbulence .05
            rotate 25*y
            translate <10, 90, 50>
            }
         finish {
            phong 1
            phong_size 10
            metallic
            }
   }

#declare Fut=union{
   #declare fut_i=0
   #declare fut_seed=seed(0)
   #while (fut_i<360)
      object {
         Fut0
         pigment {FutColor*.8}
         normal {
            wood poly_wave .2 turbulence .05
            rotate 90*x
            translate 40*x+rand(fut_seed)*100*y
            }
         finish {
            phong 1.0
            phong_size 10
            metallic
            }
         rotate fut_i*y
         }
      #declare fut_i = fut_i+12
      #end
   object {
      Fut1
      }
   bounded_by {box {<-40, 0, -40>, <40, 105, 40>}}
   }


//////////////////////////////////////////////////////////////////////// BOUTEILLE

#declare Density1=
  density {
    spherical
    ramp_wave
    color_map {
      [0.0 color rgb <0.0, 0.0, 0.0>*2]
      [0.2 color rgb <.2, 0.8, 0.1>*2]
      [1.0 color rgb <1.0, 1.0, 0.1>*2]
    }
  }

#declare T_Bottle_glass=texture{
   pigment {rgbf <.7, 1, .7, 1>}
   finish {F_Glass1}
   }

#declare T_Bottle_cap=texture{
   pigment {rgb <.7, 1, .85>*.4}
   finish {phong .3 phong_size 1 metallic}
   }

#declare T_Bottle_label=texture {
   pigment {
      bozo turbulence .3 color_map {
         [0 rgb <1, .95, .9>]
         [1 rgb <1, .9, .8>]
         }
      }
   }

#declare Bouteille=object {
   bouteille
   bounded_by {cylinder{ 0, 1.1*y, .2}}
   scale 30
   //texture {T_Bouteille_verre}
   texture {
      material_map {  // uses Corel Draw 16 colors palette
         png "bottle.png"
         map_type 2 //cylindre
         interpolate 2
         texture {pigment {Black}} //0 blue    -> label writings
         texture {pigment {White}} //1 ???     -> n/a
         texture {pigment {White}} //2 ???     -> n/a
         texture {pigment {White}} //3 ???     -> n/a
         texture {pigment {White}} //4 ???     -> n/a
         texture {pigment {White}} //5 ???     -> n/a
         texture {pigment {White}} //6 ???     -> n/a
         texture {pigment {White}} //7 ???     -> n/a
         texture {pigment {White}} //8 ???     -> n/a
         texture {T_Gold_1B}       //9 red     -> golden writings
         texture {T_Bottle_cap}    //10 green  -> Bottle cap
         texture {T_Bottle_label}  //11 yellow -> label
         //texture {pigment {ForestGreen}} //12 blue -> bottle itself
         texture {T_Bottle_glass}  //12 blue   -> bottle itself
         texture {pigment {White}} //13 ???    -> n/a
         texture {pigment {White}} //14 ???    -> n/a
         texture {pigment {White}} //15 ???    -> n/a
         }
      scale <-30, 30, 30>
      rotate 40*y
      }
   interior{
      ior 1.3
      caustics 5
      media {
         emission 0.05
         intervals 5
         samples 10, 10
         confidence 0.9999
         variance 1/1000
         density {
            Density1
            scale <1.2, 5, 1.2>
            translate y*15
            }
         }
      }
   }

#declare Objets=union{
   object {Fut}
   object {Bouteille rotate 240*y translate <15, 99, 0> rotate -240*y}
   }
