// Persistence of Vision Raytracer
// Theme "Elements" 07-08/98: Whisky
// Sizes in cm

#version 3.0

global_settings {
   max_trace_level 16
   adc_bailout 1/255
   assumed_gamma 1.9
/*
   radiosity{
      distance_maximum 300     // def.   0, essais=500, puis 35
      brightness       3.3     // def.   3.3
      count            200     // def. 100
      error_bound        0.38  // def.   0.4
      gray_threshold     0.0   // def.   0.5 was 0.5
      low_error_factor   0.8   // def.   0.8
      minimum_reuse      0.015 // def.   0.015
      nearest_count     10     // def.   6
      recursion_limit    2     // def.   1
      }
*/
   }

/******************************************************************************

        Gnralits

******************************************************************************/

#declare MAIN_POV=1
#include "common.inc"

#include "objets.inc"
#include "decor.inc"

#declare WideLight = 1

#declare Vue_1= camera {
   perspective
   location  <30, 120, 80>
   up        y
   right     -4/3 * x
   look_at   <0, 120, 0>
   angle 50 //Attention: angle  la base et non sur la diagonale!
}

#declare Lampes=union{
   object {  // light from above
      light_source {
         <-100, 550, -200>
         color rgb <1, .7, .4>*3
         fade_distance 200
         fade_power 2
         spotlight
         radius 65
         falloff 80
         tightness 10
         point_at <0, 0, -200>
         }
      }
   object {  // light from outside
      light_source {
         <0, 140, -500>
         color rgb <1, .8, .6>*.7
         }
      }
   object {  // front light
      light_source {
         <50, 150, 100>
         color rgb <1, .7, .4>*.5
         fade_distance 200
         fade_power 10
         }
      }
   object {  // back light for bottle and accessories
      light_source {
         <-50, 150, -100>
         color rgb <1, .9, .6>*.3
         fade_distance 100
         fade_power 10
         spotlight
         radius 65
         falloff 80
         tightness 10
         point_at <0, 100, 0>
         }
      }
   }

#declare Lampes_E=union{
   object {  // light from above
      light_source {
         <-100, 550, -200>
         color rgb <1, .7, .4>*3
         fade_distance 200
         fade_power 2
         spotlight
         radius 65
         falloff 80
         tightness 10
         point_at <0, 0, -200>
         }
      }
   object {  // light from outside
      light_source {
         <0, 140, -500>
         color rgb <1, .8, .6>*.7
         area_light
         <80, 0, 0>, <0, 80, 0>
         6, 6
         adaptive 4 jitter
         }
      }
   object {  // front light
      light_source {
         <50, 150, 100>
         color rgb <1, .7, .4>*.5
         area_light
         <7, 0, 7>, <0, 10, 0>
         3, 3
         adaptive 0 jitter
         fade_distance 200
         fade_power 10
         }
      }
   object {  // back light for bottle and accessories
      light_source {
         <-50, 150, -100>
         color rgb <1, .9, .6>*.3
         area_light
         <7, 0, 7>, <0, 10, 0>
         3, 3
         adaptive 0 jitter
         fade_distance 100
         fade_power 10
         spotlight
         radius 65
         falloff 80
         tightness 10
         point_at <0, 100, 0>

         }
      }
   }
/******************************************************************************

        Scne complte

******************************************************************************/

union{
   object {Decor translate <0, 0, 0>}
   object {Objets translate <0, 0, 0>}

#ifdef (WideLight)
   object {Lampes_E}
   #debug "Lumieres etendues\n"
#else
   object {Lampes}
   #debug "Lumieres ponctuelles\n"
#end
rotate 0*y
}

camera {Vue_1}
