
// Persistence of Vision Ray Tracer Scene Description File
// File:mdg_tbl.pov
// Vers: 3
// Desc: Periodic Table of elements
// Date: August 4, 1998
// Auth: Marjorie Diez de Graterol


// ==== Standard POV-Ray Includes ====
#include "colors.inc"
#include "textures.inc"
#include "mdg_tbl.inc"

global_settings { ambient_light Very_Light_Purple }
camera
{
  location  <10,105,-40>
  look_at   <-100 ,.95 ,100>

}

light_source
{
    <100,100,-100>
    color White}

light_source
{
    <-400,500,1000>
    color Tan}

light_source {
    <-1500,1000,2000>
color rgbft
<0.858824,0.576471,0.439216,0.5,0.5>
    looks_like {Mol
    scale 50

    }
  }

light_source {
    <-1500,500,5000>
color Cyan
    looks_like {Mol
    scale 20
    }
  }

light_source
{ <-10000,3000,5000>
color rgbft <0.89,0.47 ,0.20,0.5,0.5>}

union{
//primer campo de alturas
union{
 height_field {
    gif "mdg_hf1.gif"
    water_level 0.1
    smooth
    pigment {agate}
    translate <-.45, 3.0, -.5>
    rotate 180*y
    rotate 180*z
    scale <700, 2.0, -500>}
torus {
  100,   3
pigment {  color rgbft < 0.858824,0.576471 ,0.439216, 0.5,0.5>}
finish { phong  0.6 }
rotate <0,0,90>
translate <-50,0,-80> hollow}


merge{
torus
{
  50,   3
pigment {  color rgbft < 0.858824,0.576471 ,0.439216, 0.5,0.5>}
finish { phong  0.6 }
rotate <0,0,90>
translate <-50,20,110> hollow}

torus
{
  42,   3
pigment {  color rgbft < 0.858824,0.576471 ,0.439216,0.5, 0.5>}
finish { phong  0.6 }
rotate <0,90,0>
translate <-50,20,90>}

torus
{
  30,   3
pigment {  color rgbft < 0.858824,0.576471 ,0.439216,0.5, 0.5>}
finish { phong  0.6 }
rotate <0,90,0>
translate <-50,10,90>//-30,20,90

}}}
//finaliza primer campo de alturas

//segundo campo de alturas
height_field
{
  gif "mdg_hf2.gif"
smooth
texture
  {
    pigment
    {
      image_map { gif "mdg_hf2.gif" map_type 0 interpolate 4}

      rotate x*90
      turbulence 0.8
    }
finish { ambient 0.3 diffuse 0.2 phong  0.8 }

  }
  scale <3000,-8,2000>
  rotate <0,10,0>
  translate <-1700,-0.10,-10>
}

//objeto
union{
object{Grupo_b
pigment{ color rgbf <0.498039,1.0,0,0.8>}
    finish { ambient 0.3 diffuse 0.2 phong  0.8 }
rotate <0,-30,0>
translate <-14,1.5,7>
scale 21}

object{Grupo_b
pigment{ color rgbf <0.498039,1.0,0,0.8>}
    finish { ambient 0.3 diffuse 0.2 phong  0.8 }
translate <-12,-1.5,7>
scale 21}
}}


