// Persistence of Vision Ray Tracer Scene Description File
// File: Sample.pov
// Vers: 3.00e Watcom Win32
// Desc: Sample imahe of trees
// Date: May 5, 1997
// Auth: Sonya Roberts
// Note: Sample Trees

// ==== Standard Includes ====
#include "COLORS.inc"
#include "TEXTURES.inc"
#include "METALS.inc"
#include "SHAPES.inc"
#include "STONES.inc"
#include "STONES2.inc"
#include "WOODMAPS.inc"
#include "WOODS.inc"
#include "GLASS.inc"

#declare True=1
#declare False=0

camera {
	location	<0,10,-25>
	up		<0,1,0>
	right		<1.33,0,0>
	look_at		<0,10,0>
}

light_source {
	<200,200,-200>,
	color White
	area_light
	<15,0,0>,<0,15,0>,6,6
	adaptive 2
	jitter
}

light_source {
	<-200,100,-20>,
	color Gray30
}

object {
	sphere {<0,0,0>,5000}
	hollow
	texture {
		pigment {
			gradient y
			color_map {
				[0	color LightBlue]
				[1.0	color NavyBlue]
			}
			scale <1,5000,1>
		}
	}
	texture {
		pigment {
			bozo
			turbulence 0.5
			octaves 3
			lambda 6.0
			color_map {
				[0.0 color rgbf <1, 1, 1, 1>]
				[0.8 color rgb <0.737, 0.788, 0.820>]
				[1.0 color rgb <1, 1, 1>]
			}
		}
		finish {
			ambient 1.0
			diffuse 0.0
		}
		scale <3000, 1500, 2000>
	}
}

object {
	plane {<0,1,0>,0}
	pigment {color SpringGreen}
}

object {
	#declare LeafShape=6
	#declare LeafTexture=2
	#declare BarkTexture=5
	#include "trees.inc"
	translate <-6,0,0>
}

object {
	#include "defaults.inc"
	#declare IncSplits=1.1
	#declare IncXDeg=2
	#declare Tip=3
	#declare TipPercent=.9
	#declare FlowerShape=5
	#declare FlowerTexture=5
	#declare TipOther=2
	#declare FruitShape=1
	#declare Fruits=
	object {
		torus {.25,.15}
		rotate x*90
		translate <0,.25,0>
		texture {
			pigment {color Coral}
			finish {
				ambient .3
			}
		}
	}
	#declare LeafShape=1
	#declare Leave=
	object {
		sphere {<0,0,.195>,.2}
		scale <.75,.1,1.5>
	}
	#include "trees.inc"
	texture {
		pigment {
			bozo
			color_map {
				[0 color Cyan]
				[1 color Aquamarine]
			}
		}
		finish {
			ambient .3
		}
		scale <3,3,3>
	}
	translate <6,0,0>
}

object {
	#include "defaults.inc"
	#declare BarkTexture=2
	#declare LeafShape=3
	#declare LeafTexture=4
	#declare MaxSplits=5
	#declare MinSplits=4
	#declare BaseLen=1.25
	#declare SD1=seed(30)
	#declare LeafRandRot=True
	#include "trees.inc"
	translate <0,0,5>
}
