/*
** POVRay 3.1b4 Scene File
** written by Micha Riser
** visit my homepage:
**  http://www.geocities.com/SiliconValley/Pines/7992/
** 
** This scene was made four participating at the IRTC.
** (topic: elements)
** Image description: 
**   The four classic elements, Water, Fire, Earth and Air, as elements of a 
**   tetrahedronical fraktal with a galaxy background.
*/

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

global_settings{ max_trace_level 7
                 adc_bailout 1/32
                }
camera 
 { 
  location  <1.2 , 2.5 ,-5.5>*1.49
  look_at   <0.0 , 0.0 , 0.0> 
 }


#declare r=seed(21)
;


//------------------------------------------------------
//***************** Earth macro ************************
//------------------------------------------------------

#macro Earth_elem (quality)

blob{
 threshold 0.4
 
#declare za=0;
#while (za<(400/quality)) 
 #declare posi=<sqrt(rand(r))-0.5,sqrt(rand(r))-0.5,sqrt(rand(r))-0.5>*0.5;
 #if (za=1) 
   #declare posi=<0.0,-0.0,0.0>;
   #end
 #declare radi=(1.34-pow(2,vlength(posi)))*0.5*pow(level,0.4);
 #declare za=za+1;
 #if (radi>0) sphere{posi,radi,sqrt(radi)*sqrt(level)} 
#end
 #end 
pigment{rgbt<0.5,0.24,0>*1.2}
finish {
    crand 0.35
    ambient 0.35
    diffuse 0.85
   }
}

#end

//-------------------------------------------------------
//***************** Water macro *************************
//-------------------------------------------------------

#macro Water_elem (quality)

blob{ 
 threshold 0.15
  
#declare za=0;
#while (za<(40/quality))  
 #declare posi=<rand(r)-0.5,rand(r)-0.5,rand(r)-0.5>;
 #if (za=1)  
  #declare posi=<0.05,-0.05,0.05>;
  #end 
 #declare radi=(1-sqrt(sqrt(vlength(posi))))*0.75*pow(level,0.4);  //..level,0.45)
 #declare za=za+1;  
 sphere{posi,radi,sqrt(radi)*sqrt(level)} 
 #end  
pigment{rgbt<0.4,0.4,1,0.8>} 
finish { 
   reflection 0.35
   }
interior{
    ior 1.33
  }
}

#end

//---------------------------------------------------------
//*************** Fire macro ******************************
//---------------------------------------------------------

#declare cm1= density{radial
frequency 5
color_map{
 [0 rgb<1,1,0.1>]
 [1 rgb 0]
}}

#declare rf=seed(123)

#declare cm2 =density{gradient x 
 density_map{
 [0. color_map{[0 rgb 0]}]
 }
}

#macro Fire_elem (quality,bigness)

#declare SourceVector=<rand(rf),rand(rf),rand(rf)>*50;

#local r2=density{radial frequency 4 color_map {
   [0 Black]
   [0.34 Black]
   [0.35 (Orange+Yellow)*1.25]
   [0.45 Black]
   [0.55 Black]
   [0.6 Yellow *2]   
   [0.63 (Orange+Yellow)*1.25]   
   [0.66 Black]
   [1 Black]
    }
 translate -SourceVector
 warp{ turbulence 0.2}
 translate SourceVector
 }



#local r1=density{radial frequency 4 density_map {
   [0 color_map{[0 rgb 0]}]
   [0.5 r2 rotate x*-90] 
   [1 color_map{[0 rgb 0]}]
    }
 translate -SourceVector
 warp{turbulence 0.2}
 translate SourceVector
 }

#local fire_inn=density{spherical color_map{
   [0 Black]
   [.5 Black]
   [0.65 rgb <1,0.35,0>*1.1]
   [1 rgb <1,1,.25>*1.5]
  } 
 translate -SourceVector
 warp {turbulence 0.05
 lambda 1.44
 omega 1.53}
 translate SourceVector
 }
  

#local fire_sphere=sphere{0,1
pigment{color rgbt 1}
hollow
no_shadow

interior{

media{ emission 2.5*.5/pow(bigness,.5)  
 intervals 11-quality
  density{
  spherical
  density_map{
   [0 color_map{[0 rgb 0]}]
   [1 r1]
   }
 }
}

media{ emission 2*.6/bigness
 intervals 11-quality
 density{fire_inn}
 }
}
}

#if (quality>2) 
 fire_sphere
#else
 union{
 object{fire_sphere}
 #debug "Light source!"
  light_source{0, color rgb<1,1,0.6>*1.2/level } 
 }
#end

#end

//_-------------------------------------------------------
//***************** Air macro ***************************
//-------------------------------------------------------

#macro Air_elem (quality)

#declare color1=rgb<0.55,0.54,0.7>     ;     //    *0.5*quality; //*pow(quality,2);
#declare color2=rgb<0.3,0.3,1>*.7     ;      //    *0.5*pow(quality,1.5);

#declare ra=seed(232);

#declare SourceVector=<rand(ra),rand(ra),rand(ra)>*50;

#local air_inn=density{planar color_map{
   [0 color2]
   [0.35 color2]
   [.45 color1]
   [0.7 color1]
   [0.9 color2] 
   [1 color2]
   } 
 frequency 2
 translate -SourceVector
 warp{turbulence 0.35}
 translate SourceVector
 }


sphere{0,1
 pigment{color rgbt 1}
 hollow 
 
 interior{
  media{
#local intervls=11-2*quality;
#if (intervls<4) #local intervls=4; #end
  intervals intervls
   emission 0.5/pow(obj_radius,0.77)
   density{
    spherical
    density_map{

     [0 color_map{[0 rgb 0]}]
     [.1 color_map{[0 rgb 0]}]
     [0.3 spherical color_map{[0 color2]}]
     [0.5 air_inn]
     [1 air_inn]
     }
     
     scale 0.94
     turbulence 0.2
     

    }
   }
  }
 }

#end

//----------------------------------------------------
//**************** Fraktal ***************************
//----------------------------------------------------

// Options: 
 
#declare level_to=6;   //number of levels which are calculated
#declare rkleiner=0.55; 
#declare rad_const=0.78;
 
//-------------------------------------------- 


#macro make_object (obj_type,obj_radius)
#debug str(level,3,3)
#debug "\n"
#if (obj_type=4) object{Earth_elem (level) scale 2.05} #end
#if (obj_type=3) object{Water_elem (level) scale 1.28} #end
#if (obj_type=1) object{Fire_elem (level,obj_radius)}  #end
#if (obj_type=2) object{Air_elem (level) scale 0.85 } //0.85//0.82  //
                             #end
#end

//------------------------------------------

#declare Frak_Obj=union{
 
//--------------------------------------------- 
 
#macro Tet_Punkte (rt,P,nv0)  //calculates the location of the elements
 
#local nv=nv0/vlength(nv0)*vlength(rt)*sqrt(8)/3; 
#declare rs=vlength(rt)*rad_const; 
#declare MA=P-(4/3)*rt+nv; 
#declare MB=P-(4/3)*rt+-nv/2+(vcross(nv,rt)/vlength(vcross(nv,rt)))*sqrt(3)/2*vlength(nv); 
#declare MC=P-(4/3)*rt+-nv/2-(vcross(nv,rt)/vlength(vcross(nv,rt)))*sqrt(3)/2*vlength(nv); 

#end 
 

#declare P_arr=array[10000] 
#declare rt_arr=array[10000] 
#declare nv0_arr=array[10000] 
#declare type_arr=array[10000] 

#declare P_Anz=1; 


#declare rt_arr[1]=<0,1,0>; 
#declare P_arr[1]=<0,1,0>; 
#declare nv0_arr[1]=<0,0,1>;
#declare type_arr[1]=1;
#declare P_Anz_Old=0; 

#declare level=1;  
object{make_object (1,rad_const)
scale rad_const
translate <0,1,0>
}
#declare level=0;

#while(level<level_to) 
 
 #declare level=level+1; 
#debug "Level OK\n"
 #declare i=P_Anz_Old; 
 #declare P_Anz_Old=P_Anz;   
 
 #while (i<P_Anz_Old) 
 #declare i=i+1; 
 
 Tet_Punkte (rt_arr[i],P_arr[i],nv0_arr[i]) 

 #if (type_arr[i]=1) #declare type_plus=1; #else #declare type_plus=0; #end
 
 #declare P_Anz=P_Anz+1; 
 #declare MP=P_arr[i]-rt_arr[i]; 
 #declare rt_arr[P_Anz]=-(MA-MP)*rkleiner; 
 #declare nv0_arr[P_Anz]=vcross((MA-MP),<0,1,0>); 
 #declare P_arr[P_Anz]=MA;
 #declare type_arr[P_Anz]=1+type_plus;
 object{make_object (1+type_plus,rs)
 scale rs
 translate MA
 }
 
 #if (type_arr[i]=2) #declare type_plus=1;  #end
 #declare rt_arr[P_Anz+1]=-(MB-MP)*rkleiner; 
 #declare nv0_arr[P_Anz+1]=vcross((MB-MP),<0,1,0>); 
 #declare P_arr[P_Anz+1]=MB;
 #declare type_arr[P_Anz+1]=2+type_plus;
 object{make_object (2+type_plus,rs)
 scale rs
 translate MB
 }

 #if (type_arr[i]=3) #declare type_plus=1;  #end
 #declare rt_arr[P_Anz+2]=-(MC-MP)*rkleiner; 
 #declare nv0_arr[P_Anz+2]=vcross((MC-MP),<0,1,0>); 
 #declare P_arr[P_Anz+2]=MC; 
 #declare type_arr[P_Anz+2]=3+type_plus;
 object{make_object(3+type_plus,rs)
 scale rs
 translate MC
 }
 
 #if (level=1) 
  #declare rt_arr[P_Anz+3]=-(P_arr[i]-MP)*rkleiner; 
  #declare nv0_arr[P_Anz+3]=vcross((P_arr[i]-MP),<0,0,1>); 
  #declare P_arr[P_Anz+3]=P_arr[i];
  #declare type_arr[P_Anz+3]=1;
  #declare P_Anz=P_Anz+1;  
  #end 
 
 #declare P_Anz=P_Anz+2; 

 #end 
 
#end 
}

object{
Frak_Obj
scale 1.52
rotate y*10
}

union{
light_source{<0,3,0> color rgb<1,1,0.6>*0.5 media_interaction off}
light_source{<-2,-1,-2> color rgb <1,1,0.6>*0.5 media_interaction off}
light_source{<2,-1,-2> color rgb <1,1,0.6>*0.5 media_interaction off}
light_source{<0,-1,3> color rgb <1,1,0.6>*0.5 media_interaction off}
scale 1.52
}
// *********************************************
// -------------------- Galaxy -----------------
// *********************************************
#include "my_galax.inc"
#declare debug_options = true
#include "galaxy.bg"
#include "galaxy.obj"
#include "galaxy.sf"

global_settings{max_trace_level 14
adc_bailout 1/64
} 

