//
// mount.inc
//
// objects:
//	ladder1
//	(ladder2)
//	mount

/*

i___j       k___l
 | |         | |
e| |f       g/ |h
  \ \ c   d / /
   \ ------- /
    \       /
     \     /
      -----
     a     b
*/


#include "metals.inc"
#include "tex.inc"


// front vectors
#declare v1a = <-1.8, 0, -1.5>;
#declare v1b = < 1.8, 0, -1.5>;
#declare v1c = <-1.6, 2, -1.5+(1.5-.5)*(2/4.8)>;
#declare v1d = < 1.6, 2, -1.5+(1.5-.5)*(2/4.8)>;
#declare v1e = <-4.00, 4.8, -.5>;
#declare v1f = <-3.5, 4.8, -.5>;
#declare v1g = < 3.5, 4.8, -.5>;
#declare v1h = < 4.00, 4.8, -.5>;
#declare v1i = <-4.00, 5.8, -.5>;
#declare v1j = <-3.5, 5.8, -.5>;
#declare v1k = < 3.5, 5.8, -.5>;
#declare v1l = < 4.00, 5.8, -.5>;

// back vectors
#declare v2a = v1a*<1,1,-1>;
#declare v2b = v1b*<1,1,-1>;
#declare v2c = v1c*<1,1,-1>;
#declare v2d = v1d*<1,1,-1>;
#declare v2e = v1e*<1,1,-1>;
#declare v2f = v1f*<1,1,-1>;
#declare v2g = v1g*<1,1,-1>;
#declare v2h = v1h*<1,1,-1>;
#declare v2i = v1i*<1,1,-1>;
#declare v2j = v1j*<1,1,-1>;
#declare v2k = v1k*<1,1,-1>;
#declare v2l = v1l*<1,1,-1>;

// big front/back
#declare mount1 =
union
{
	triangle { v1a v1b v1c }
	triangle { v1c v1d v1b }
	triangle { v1a v1c v1e }
	triangle { v1c v1e v1f }
	triangle { v1b v1d v1g }
	triangle { v1g v1h v1b }
}

// big side
#declare mount2 =
union
{
	triangle { v1b v1h v2b }
	triangle { v2b v1h v2h }
}

// inner side
#declare mount3 =
union
{
	triangle { v1d v2d v1g }
	triangle { v2d v1g v2g }
}

// top side of inner "U"
#declare mount4 =
union
{
	triangle { v1c v2c v1d }
	triangle { v2c v1d v2d }
}


/*
	1---3
	|
	|
	2      10
	\    9
	 \  8
	  4                     7
	  |                     |
	  |                     |
	  5---------------------6
*/

#declare r = 0.03;	// rail radius

#declare pl1 = <5-r,4.9,-.6+r>;
#declare pu1 = pl1+y*.6;
#declare pl2 = <5-r,4.9,1-r>;
#declare pu2 = pl2+y*.6;
#declare pl3 = <4+r,4.9,-.6+r>;
#declare pu3 = pl3+y*.6;

#declare pl4 = <4-r,1.6,3.2+r>;
#declare pu4 = pl4+y*.6;
#declare pl5 = <4-r,1.6,4.6-r>;
#declare pu5 = pl5+y*.6;
#declare pl6 = <-4+r,1.6,4.6-r>;
#declare pu6 = pl6+y*.6;
#declare pl7 = <-4+r,1.6,3+r>;
#declare pu7 = pl7+y*.6;

#declare pl8 = <3,1.6,3>;
#declare pu8 = pl8 + y*.6;
#declare pl9 = <2,1.6,2>;
#declare pu9 = pl9 + y*.6;
#declare pl10 = <2,1.6,.8>;
#declare pu10 = pl10 + y*.6;

#declare stair_and_upper_platform =
union
{
	// upper platform
	box { <4,4.8,-.6> <5,4.9,1> }
	cylinder { <3.3,4,-.4> <4.8,4.8,-.4> .05 }
	cylinder { <3.3,4,.4> <4.8,4.8,.4> .05 }

	union {
		cylinder { pl1 pu1 r }
		cylinder { pl2 pu2 r }
		cylinder { pu1 pu2 r }
		cylinder { (pl1+pu1)/2 (pl2+pu2)/2 r }
		cylinder { pl3 pu3 r }
		cylinder { pu1 pu3 r }
		cylinder { (pl1+pu1)/2 (pl3+pu3)/2 r }
		cylinder { (pl2+pu2)/2 (pl4+pu4)/2 r }
		cylinder { (pl2+pl4)/2 (pu2+pu4)/2 r }

		texture {  T_Chrome_4A }
	}

	// stairs
	box { <-.02,-.05,-.1> <.02,.05,4.1> rotate x*55-26*y translate pl2 }
	box { <-.02,-.05,-.1> <.02,.05,4.1> rotate x*55-26*y translate <4+r,4.9,1-r> }
	#declare N = 12;
	#declare c = 1;
	#while (c < N)
		#declare s1vect = vrotate(z*(4.1-c*.345),x*55-26*y)+pl2;
		box { <-.05,-.07,-.05> <-1,0,.15> rotate y*-1 translate s1vect }
		#declare c = c + 1;
	#end
}

#declare lower_rail =
union
{
	cylinder { pl8 pu8 r }
	cylinder { pl9 pu9 r }
	cylinder { pu8 pu9 r }
	cylinder { (pl8+pu8)/2 (pl9+pu9)/2 r }
	cylinder { pl10 pu10 r }
	cylinder { pu9 pu10 r }
	cylinder { (pl9+pu9)/2 (pl10+pu10)/2 r }
}

#declare platforms =
union
{
	// main platform
	prism
	{
		linear_sweep
		linear_spline
		1.5 1.6
		9, <4,3> <4,4.6> <-4,4.6> <-4,3> <-2,2> <-2,.8> <2,.8> <2,2> <4,3>
	}
	box { <-.1,-.1,0> <.1,.1,3> rotate x*-24 translate <-1,.28,1> }
	box { <-.1,-.1,0> <.1,.1,3> rotate x*-24 translate <1,.28,1> }

	object { stair_and_upper_platform }
	object { stair_and_upper_platform scale <-1,1,1> }

	// rail
	union
	{
		cylinder { pl4 pu4 r }
		cylinder { pl5 pu5 r }
		cylinder { pu4 pu5 r }
		cylinder { pu2 pu4 r }
		cylinder { (pl4+pu4)/2 (pl5+pu5)/2 r }
		cylinder { pl6 pu6 r }
		cylinder { pu5 pu6 r }
		cylinder { (pl5+pu5)/2 (pl6+pu6)/2 r }
		cylinder { pl7 pu7 r }
		cylinder { pu6 pu7 r }
		cylinder { (pl6+pu6)/2 (pl7+pu7)/2 r }

		cylinder { pl5-x*8/3 pu5-x*8/3 r }
		cylinder { pl5-x*16/3 pu5-x*16/3 r }

		object { lower_rail }
		object { lower_rail scale <-1,1,1> }

		texture {  T_Chrome_4A }
	}
}

#declare ladder1 =
union
{
	cylinder { y*0 y*3 .035 }
	cylinder { y*0 y*3 .035 translate z*.6 }

	#declare c = 0;
	#while (c < 7)
		cylinder { y*(c*.4+.4) y*(c*.4+.4)+z*.6 .035 }
		#declare c = c + 1;
	#end
}

#declare ladder2 =
union
{
	cylinder { y*0 y*1.3 .035 }
	cylinder { y*0 y*1.3 .035 translate z*.6 }

	cylinder { y*.4 y*.4+z*.6 .035 }
	cylinder { y*.8 y*.8+z*.6 .035 }
}

#declare mount =
union
{
	object { mount1 }
	object { mount1 scale <1,1,-1> }
	object { mount2 }
	object { mount2 scale <-1,1,1> }
	object { mount3 }
	object { mount3 scale <-1,1,1> }
	object { mount4 }
	box { v1e v2j }
	box { v1g v2l }

	// motors
	box { <-1.1,2,-.8> <1.1,2.5,.8> }	// lower drive
	box { <4,5,-.4> <4.5,5.6,.4> }
	box { <-4,5,-.4> <-4.5,5.6,.4> }

	#if (use_platforms)
		object { platforms }
		object { ladder1 rotate z*-40 translate <2.95,2.5,0> }
		object { ladder2 rotate z*-25 translate <2.25,.8,0> }
	#end

//	texture { WhitePaint filter .5 }
//	pigment { White filter .2 }
}
