// objects.inc
// by Robert Fremin
#version 3.1;

#include "woods.inc"
#include "stones.inc"
#include "metals.inc"

#ifndef (OBJECTS_INC)
#declare OBJECTS_INC = true;

#debug "=#= included objects.inc =#=\n"

/* ===========================================================================
Macros defined:  >>>------------->
*	Notes           ( )
*	Matchbox        ( )
*	Oxygen_tube     ( )
*	Periodic_table  ( )
*	Water_bottle    ( )
*	Antenna         (HiQuality)
*	Pencil          (Length)
*	Eraser          ( )
*	Towers_of_Hanoi ( )
*	Book            (Width, Height, Depth, TheText, Color)
*	Glass_o_balls   (Balls)
*	Notepad			( )
*	Flowerpot		( )
=========================================================================== */


#macro Notes()
box
{
	-.5 .5
	pigment { image_map { png "post-it.png" interpolate 2 } translate <-.5,-.5,0> }
	finish { ambient .3 }
	scale <10,10,.05>
}
#end


#macro Matchbox()
union
{
	// Top
	box
	{
		-.5 .5
		pigment { image_map { png "manstickan.png" interpolate 2 } translate <-.5,-.5,0> }
		scale <6.6,12,.1>
		rotate x*90
	}
	// Bottom
	box
	{
		-.5 .5
		pigment { White }
		scale <6.6,12,.1>
		rotate x*90
		translate y*-3
	}
	#declare BSide =
	box
	{
		-.5 .5
		pigment { image_map { png "manstickan_side.png" } translate <-.5,-.5,0> }
		scale <3,12,.1>
		rotate x*90
		rotate z*-90
	}
	object { BSide translate <3.3,-1.5,0> }
	object { BSide translate <-3.3,-1.5,0> }

	#local Pushed = 1.5;

	difference
	{
		box
		{
			-.5 .5
			scale <6.5,3,11.6>
		}
		box
		{
			-.5 .5
			scale <6.4,3,11.5>
			translate <0,.1,0>
		}
		translate <0,-1.5,-Pushed>
		pigment { White }
	}

	// matches
	#local i = 0;
	#local R = seed(546786);
	#while (i < 50)
		box
		{
			-.5 .5
			scale <.1,.1,3>
			rotate <rand(R)-.5,rand(R)-.5,rand(R)-.5>
			translate <3.3-i*.1,-.5-rand(R),-Pushed-4+rand(R)*.5>

			pigment { rgb <1,.9,.55> }
			finish { ambient .1 }
		}
		#local i = i + 1;
	#end

	finish { ambient .3 }
}
#end


#macro Oxygen_tube()
union
{
	#local Radius = 7;
	#local Height = 20;
	#local ValveH = Height + Radius/2;

	union
	{
		difference
		{
			cylinder { y*0 y*Height Radius }
			cylinder { y*-1 y*4 Radius*.96 }
			#local i = 0;
			#while (i < 8)
				cylinder { x*0 x*20 1.2 rotate y*360*(i/8) translate y*1.75 }
				#local i = i + 1;
			#end
			torus { Radius .2 translate y*4 }
			torus { Radius .2 translate y*(Height-1) }
		}
		sphere { y*Height Radius }	// top

		pigment { rgb <.2,.3,.8> }
		finish { specular .4 phong .9 phong_size 50 }
		normal { dents scale 1 bump_size .2 }
	}

	// valve
	union
	{
		union
		{
			cylinder { y*(ValveH-1) y*(ValveH+4) 1.3 }
			cylinder { y*ValveH y*(ValveH+7) 1 }	// bottom T
			cylinder { x*-3 x*2.7 1 translate y*(ValveH+7) }	// side T
			cylinder { x*2.7 x*3 1.1 translate y*(ValveH+7) }
			texture { T_Brass_2A }
			finish { diffuse .2 specular .1 metallic }
			normal { dents scale .1 bump_size .2 }
		}
		// wheel
		union
		{
			cylinder { y*-1 y*.71 .5 texture { T_Chrome_3C } }
			cylinder { y*0 y*.7 1.1 }
			#local i = 0;
			#while (i < 20)
				cylinder { y*0 y*.6 .1 translate x*1.1 rotate y*i*(360/20) }
				#local i = i + 1;
			#end
			pigment { Red }
			finish { ambient .3 diffuse .2 specular .4 phong .7 phong_size 250 }
			translate y*.3
			translate <0,ValveH+7.9,0>
		}
		union
		{
			superellipsoid
			{
				<1,.08>
				scale <3,3,1> rotate y*90
			}
			cylinder { x*0 x*2 1.5 rotate z*10 }
			rotate z*-10 translate <-3.5,ValveH+7,0>
			texture { T_Chrome_3B }
			normal { bumps bump_size .1 }
		}
		difference
		{
			union
			{
				cone { x*3 .8 x*4 .6 }	// tube grip
				cone { x*4 .7 x*5 .5 }
				cone { x*5 .6 x*6 .4 }
			}
			cylinder { x*0 x*10 .3 }
			texture { T_Brass_2C }
			translate y*(ValveH+7)
		}
		rotate y*13
	}

	// Label
	cylinder
	{
		y*-8 y*8 Radius+.0001
		clipped_by { plane { z,0 } }
		pigment { image_map { png "oxygen.png" interpolate 2 map_type 0 once } translate <-.5,-.5,0> scale 13 }
		rotate y*-60
		translate y*12
	}
}
#end


#macro Periodic_table()
union
{
	box
	{
		-.5 .5
		pigment { image_map { png "periodic_table.png" interpolate 2 } translate <-.5,-.5,0> }
		scale <79.0,51.6,.1>
		finish { ambient .2 specular .2 phong .4 reflection .05 }
	}
	box { -.5 .5 scale <90,60,.099999> pigment { White } finish { ambient .2 specular .2 phong .4 reflection .05 } }
	cylinder { x*-44.9 x*44.9 1 scale <1,1,.5> pigment { Gray10 } finish { Phong_Shiny } normal { bumps bump_size .1 } translate y*30 }

	scale <1.5,1.5,1>
}
#end


#macro Water_bottle()
union
{
	// hat
	union
	{
		superellipsoid { <1,.1> rotate x*90 scale <1.5,1,1.5> translate y*21 }
		#local i = 0;
		#while (i < 8)
			cylinder { x*1.5 x*1.5+y*1.8 .2 rotate y*360*(i/8) translate y*20 }
			#local i = i + 1;
		#end
		torus { 1.5 .3 scale <1,.5,1> translate y*20 }

		pigment { rgb 1.7 }
		finish { ambient .1 specular .5 phong .8 phong_size 150 }
	}

	// Body
	merge
	{
		difference
		{
			superellipsoid { <1,.2> rotate x*90 scale .5 scale <8,15,8> translate y*7.5 }
			superellipsoid { <1,.2> rotate x*90 scale .5 scale <7.7,14.8,7.7> translate y*7.5 }
			cylinder { y*10 y*20 3.72 }
		}
		difference
		{
			cone { y*0 3.72 y*5.9 1.2 }
			cone { y*0 3.72 y*5.9 1.2 translate y*-.3 }
			translate y*14.52
		}

		pigment { White*1.2 filter .4 }
		finish { diffuse .4 ambient .3 specular .1 phong .1 crand .015 }
		interior { ior 1.1 fade_distance 20 fade_power 2 caustics .2 }
		hollow on
	}

	// Label
	difference
	{
		cylinder { y*-2 y*2 4.0011 }
		cylinder { y*-3 y*3 4.001 }
		pigment { image_map { png "h2o.png" interpolate 2 map_type 0 once } translate <-.5,-.5,0> scale <3,2,3> }
		clipped_by { plane { z,0 } }
		hollow on
		rotate y*-34
		translate y*10
	}

	// Water
	cylinder
	{
		y*.5 y*12 3.84
		pigment { rgb <.96,.98,1> filter .95 }
		interior { ior 1.3 fade_distance 6 fade_power 2 caustics .3 }
	}

	// The pipe...
	union
	{
		#local Diam = .4;
		cylinder { y*4 y*25 Diam }
		#local pipe_sector =
		intersection
		{
			torus { 1 Diam rotate x*90 }
			box { -1 1 translate <1,1,0> }
		}
		object { pipe_sector scale .9999999 translate <-1,25,0 > }
		union
		{
			object { pipe_sector }
			cone { y*1 Diam x*-7+y*1 Diam*.8 }
			cone { x*-7+y*1 Diam*.8 x*-9+y*1 .1 }
			rotate z*50
			translate <-1,25,0 >
		}

		pigment { rgb 1.9 filter .2 }
		finish { diffuse .3 ambient .1 specular .5 phong .1 }
		interior { caustics .5 }
	}

	scale .8		// make it about 20 cm in height instead of 25
}
#end


// HiQuality = boolean use high details etc.
// --- Placed to the right on the lower shelf.
//
#macro Antenna(HiQuality)

// (on the dish)
#declare use_corrugation	= HiQuality;
#declare use_framework		= HiQuality;
#declare use_platforms		= HiQuality;
#declare final				= HiQuality;
#declare UP_ANGLE			= 65 -20;
#declare SIDE_ANGLE			= 40-7;

// These files are taken from my socorro.zip file. Use those files
// and not these please.
#include "tex.inc"
#include "mount.inc"
#include "the_stand.inc"
#include "dish.inc"

#local complete_antenna =
union
{
	object { the_stand }
	union
	{
		object { mount translate y*8 }
		object { the_dish translate z*-8 rotate x*UP_ANGLE translate y*13 }
		rotate y*SIDE_ANGLE
	}

	texture { WhitePaint }
}

union
{
	object { complete_antenna translate y*1 }
	object { pods clipped_by { plane { -y,0 } } pigment { Gray50 } translate y*1 }
	superellipsoid
	{
		<.1,.1> scale .5 scale <16,1,16>
		texture { T_Chrome_4B }
		translate y*.5
	}
}
#end


// Length = length of the main part of the pencil
//
#macro Pencil(Length)
union
{
	cylinder { x*0 x*Length .4 pigment { Red } finish { ambient .1 specular .4 phong .4 } }

	union
	{
		cylinder { x*-.000001 x*Length .39 }
		cone { x*Length .4 x*(Length+1.5) .2 }
		pigment { rgb <.8,.7,.6> } finish { ambient .1 diffuse .4 }
	}

	union
	{
		cylinder { x*-.00001 x*Length .15 }
		cone { x*(Length+1.5) .15 x*(Length+2) .1 }
		pigment { Gray10 } finish { specular .2 phong .3 }
	}
}
#end


#macro Eraser()
superellipsoid
{
	<.6,.3> rotate x*90 scale .5 scale <2,1,3.5>
	pigment { White }
	finish { diffuse .8 }
}
#end


#macro Towers_of_Hanoi()
union
{
	superellipsoid
	{
		<.1,.1> scale .5 scale <20,1.5,10>
		texture { T_Wood3 rotate z*90 scale 5 }
		finish { diffuse .4 specular .1 phong .1 }
	}
	union
	{
		cylinder { y*0 y*7 .4 }
		cylinder { y*0 y*7 .4 translate x*-6 }
		cylinder { y*0 y*7 .4 translate x*6  }
		texture { T_Chrome_3B }
	}
	union
	{
		superellipsoid { <1,.3> rotate x*90 scale .5 scale <5.5,1,5.5> translate < 0,1.25,0> }
		superellipsoid { <1,.3> rotate x*90 scale .5 scale <  5,1,  5> translate <-6,1.25,0> }
		superellipsoid { <1,.3> rotate x*90 scale .5 scale <4.5,1,4.5> translate <-6,2.25,0> }
		superellipsoid { <1,.3> rotate x*90 scale .5 scale <  4,1,  4> translate <-6,3.25,0> }
		superellipsoid { <1,.3> rotate x*90 scale .5 scale <3.5,1,3.5> translate <-6,4.25,0> }
		superellipsoid { <1,.3> rotate x*90 scale .5 scale <  3,1,  3> translate < 0,2.25,0> }
		texture { T_Copper_3B }
	}

	scale 1.5
}
#end


// Width	= width of book
// Height	= height of book
// Depth	= depth of book
// TheText	= title on the back
// Color	= main color of the cover
// --- Placed at origin, standing on ground level 0.
//
#macro Book(Width, Height, Depth, TheText, Color)
union
{
	#local Width = Width * .95;

	// cover
	union
	{
		box { -.5 .5 scale <.05*Width,Height,Depth> translate <-Width/2,Height/2,0> }	// cover left
		box { -.5 .5 scale <.05*Width,Height,Depth> translate < Width/2,Height/2,0> }	// cover right
		pigment { Color } finish { diffuse .3 specular .2 phong .5 } normal { granite scale 3 bump_size .1 }
	}
	// pages
	box
	{
		-.5 .5
		scale <.9*Width,.95*Height,.95*Depth> translate <0,Height/2,.05*Depth>
		pigment
		{
			gradient x scale .3
			color_map
			{
				[ 0 rgb <1,.95,.9>]
				[.5 rgb <.6,.55,.5>]
				[ 1 rgb <1,.95,.9>]
			}
		}
	}
	// back
	union
	{
		cylinder { y*0 y*Height (Width*1.02)/2 scale <1,1,.1> pigment { Color } finish { diffuse .3 specular .2 phong .5 } normal { granite scale 3 bump_size .1 } }
		text
		{
			ttf "crystal.ttf" TheText .1 0
			rotate z*90 translate <0,.2*strlen(TheText)/2,-.125*(1.05*Width/2)>
			#if (Color.x+Color.y+Color.z > 1)
				pigment { Black }
			#else
				pigment { White }
			#end
			finish { phong .5 reflection .05 metallic }
		}
		translate z*-.99*Depth/2
	}
}
#end


// Balls = boolean if balls included
//
#macro Glass_o_balls(Balls)
union
{
	merge
	{
		difference
		{
			superellipsoid { <1,.3> rotate x*90 scale .5 scale <10,15,10> translate y*7.5 }
			cylinder { y*1.5 y*30 4.6 }
		}
		torus { 5.05 .15 translate y*13.5 }
		pigment { rgb .98 filter .9 }
		finish { diffuse 0 specular .15 phong 1 phong_size 300 reflection .05 }
		interior { ior 1.45 caustics .4 fade_distance 10 fade_power 2 }
	}

	#if (Balls)
		#local i = 0;
		#local R = seed(6254);
		#while (i < 8*6)
			#local j = int(i/8);
			sphere
			{
				0 1
				translate <3.9-3*rand(R),2+1.5*j,0> rotate y*i*(360/(8+.5*rand(R)))
				pigment { rgb <rand(R),rand(R),rand(R)> }
				finish { Phong_Shiny }
			}
			#local i = i + 1;
		#end
	#end
}
#end


#macro Notepad()
union
{
	// cover
	box
	{
		-.5 .5
		scale <21.1,.05,30.02> translate <.1, .5,0>
		pigment { image_map { png "rutat_block.png" interpolate 2 map_type 0 once } translate <-.5,-.5,0> rotate x*90 scale <21.1,1,30.02> }
		finish { ambient .35 diffuse .5 specular .3 phong .4 reflection .01 }
	}

	// back
	box { -.5 .5 scale <21.1,.05,30.02> translate <.1,-.5,0> pigment { Grey } }

	// pages
	superellipsoid
	{
		<.05,.05> scale .5 scale <21,.8,30>
		pigment
		{
			gradient y scale .2
			color_map
			{
				[ 0 rgb <1,.98,.95>]
				[.5 rgb <.6,.5,.4>]
				[ 1 rgb <1,.98,.95>]
			}
		}
		finish { diffuse .4 }
	}

	// binding
	#local i = 0;
	#while (i < 40)
		torus { .75 .05 rotate x*90 translate <-10.6,0,15-i*3/4> texture { T_Chrome_3C } }
		#local i = i + 1;
	#end

	translate y*.5
}
#end


#macro Flowerpot()
union
{
	union
	{
		// pot
		difference
		{
			union
			{
				cone { y*0 5 y*12 8 }
				cone { y*10 7.65 y*12 8.25 }	// top edge
				cone { y*0 5.25 y*2 5.65 }	// bottom edge
				torus { 8.125 .125 translate y*12 }
			}
			cone { y*0 5 y*12 8 translate y*1 }

			pigment { rgb <1,.55,.2> }
			finish { diffuse .5 specular .4 crand .03 }
			normal { bumps scale .1 bump_size .1 }
		}

		// dirt
		union
		{
			cone { y*1 5 y*11 7.5 }

			#local i = 0;
			#local R = seed(3254765);
			#while (i < 100)
				#local T = rand(R);
				sphere { 0 T translate x*(7.5-T)*(rand(R)*.8+.1) rotate y*360*rand(R) translate y*11.3-T*.6 }
				#local i = i + 1;
			#end

			pigment
			{
				granite
				color_map
				{
					[0. Black ]
					[.3 rgb <.3,.2,.1> ]
					[1. rgb <.6,.5,.4> ]
				}
			}
			finish { diffuse 1 specular .01 crand .1 }
			normal { dents scale .3 bump_size .7 }
		}

		// Sonya Roberts' Tree include file
		object
		{
			#declare BaseLen		= .9;
			#declare LengthInc		= 3.25;
			#declare IncXDeg		= 10;
			#declare PlusMinus		= -30;
			#declare LeafShape		= 6;
			#declare MaxSplits		= 6;
			#declare MinSplits		= 5;
			#declare Tip			= 3;
			#declare FlowerShape	= 0;
			#declare FlowerTexture	= 0;
			#declare BarkTexture	= 3;
			#declare FlowerShape	= 1;

			#declare PetalNum_ = 5;

			#declare TreeFlowerTexture_ =
			texture
			{
				pigment
				{
					gradient y
					color_map
					{
						[0	color White]
						[.25	color White]
						[1	color Orchid]
					}
				}
				finish { ambient .25 }
				scale <.2,.2,.2>
			}

			#declare FlowerPetal_ =
			object {
				sphere {<0,.095,0>,.1}
				texture {TreeFlowerTexture_	scale <.2,.2,.2>}
				rotate x*90
				scale <4/PetalNum_,.01,1.5>
			}

			#declare Flowers =
			union {
				sphere {
					<0,0,0>,.075
					scale <1,.25,1>
					pigment {color Yellow}
				}
				#declare P1=1;
				#while (P1<=PetalNum_)
					object {
						FlowerPetal_
						rotate z*25
						rotate x*-20
						translate <0,0,.04>
						rotate y*((360/PetalNum_)*P1)
					}
					#declare P1=P1+1;
				#end

				rotate x*90
				scale 1.65	// this is the difference from the original
			}

			#include "trees.inc"
			rotate y*-50
			translate y*9
		}

		translate y*.5
	}

	// plate
	union
	{
		difference
		{
			cone { y*0 6 y*1 8 }
			cone { y*0 6.5 y*1 8.5 translate y*.5 }
		}
		torus { 7.9 .2 translate y*1 }

		pigment { White }
		finish { Phong_Shiny }
	}
}
#end


#end	// ifndef
