// ====================================
//       Title: Science project
//          by Robert Fremin
//  for the IRTC August 1998 contest
//          theme: Elements
// ====================================
#version 3.1;

// final rendering:
// +fn +am2 +w800 +h600 +a.3
//
//	Display_Gamma = 1.4

global_settings
{
	assumed_gamma 1.0
	max_trace_level 10
}

// >--- system ---<
#include "colors.inc"
#include "textures.inc"
#include "chars.inc"
#include "consts.inc"

// >--- user ---<
#include "ljus.inc"
#include "desk.inc"
#include "objects.inc"
#include "atom.inc"

// ===========================================================================

// SCALE: 1 unit = 1 cm

// ===========================================================================

camera
{
	location  < 35, 25, -60>
	look_at   <-10, 11,   0>
	rotate z*2
}

// ===========================================================================


// Faster than skysphere? Not seen anyway, reflected in objects as ceiling.
background { White }


// LightSources = #N of lights (>0), if 1 then pointlight, else arealight NxN
//
#macro Main_light(LightSources)
light_source
{
	<-1000, 1000, -2000>
	rgb <251/255,239/255,239/255>
	#switch (LightSources)
		#case (0)
			#error "Number of lightsources must be >0 !"
		#break
		#else
			area_light x*50 y*50 LightSources LightSources
			jitter
			translate <-25,-25,0>
		#break
	#end
	fade_distance 1700
	fade_power 2
}
#end


#macro Fill_light()
light_source
{
	<500,500,-500> Gray50 fade_distance 600 fade_power 2 shadowless
}
#end


#macro The_floor()
plane
{
	y,-71.5
	pigment { Gray30 }
	hollow on
}
#end


// Texture = boolean if walltexture
//
#macro The_wall(Texture)
plane
{
	z,35
	pigment { White }
	finish { ambient .1 diffuse .5 specular .2 phong .2 }
	#if (Texture)
		normal { granite scale 20 bump_size .9 }
	#end
	hollow on
}
#end


// ===========================================================================
// The object control center
// ===========================================================================

// --- lighting ---
Main_light(5)
Fill_light()

// --- main objects ---
object { The_floor() }
object { The_wall(yes) }
object { Desk(yes,yes) }
object { Shelves(yes)										translate <-20-5,0,20> }
object { Periodic_table()									rotate x*-.5 translate <-180,21,34> }

// --- topmost shelf ---
object { Book(4,19,16,"POVray essentials",Brown)			rotate z*-90 rotate y*11 translate <-15-10,43.5,15> }
object { Glass_o_balls(no)									rotate y*16 translate <-55,41,25> }

// --- middle shelf ---
object { Antenna(yes)										scale .62 rotate y*9 translate <10-12,21,20> }
object { Book(5,16,14,"Physics for beginners",Brown)		translate <-20,21,20> }
object { Book(8,16,15,"Rendering statistics",ForestGreen)	translate <-21.5-5,21,20> }
object { Book(3,18,15,"Digital illusions",Red)				translate <-27-5,21,20.3> }
object { Book(4,17,15,"Raytracing principles",White)		translate <-30.5-5,21,19> }
object { Book(5,17,15,"     Algebra",Brown)					translate <-36-5,21,19> }
object { Book(3,17,15,"Projects and stuff",Yellow)			translate <-41-5,21,18> }
object { Book(4,17,15,"    Calculus",Grey)					translate <-45.5-5,21,16> }
object { Book(7,17,15,"        MAGIC",Gray20)				translate <-52-5,21,17> }

// --- on desk ---
object { Book(4,17,15,"The elements",Gray20)				rotate z*-90 rotate y*13 translate <-45-5,2.5,15> }
object { Book(3,22,18,"Molecular physics",Red)				rotate z*-90 rotate y*-6 translate <-46-5,7,15> }
object { Varmeljus(yes,yes, no, no, no)						rotate y*-70 translate <18,0,-15> }	// Unused
object { Varmeljus(yes, no,yes,yes, no)						rotate y*-20 translate <17,0, -5> }	// Lit
object { Varmeljus(yes, no, no, no, no)						rotate y*145 translate <25,0, -7> }	// Used
object { Pencil(12)											rotate y*-127 translate <29,.4,-19> }
object { H2O()												scale 1.5 rotate y*34 translate <-19+20-5,0,16-15> }
object { Towers_of_Hanoi()									rotate y*16 translate <3-15,.75,18> }
object { Matchbox()											rotate y*-60 translate <20,3,-25> }
object { Oxygen_tube() 										rotate y*-30 translate <-39,0,-11> }
object { Water_bottle()										rotate y*-45 translate <3,0,-20> }
object { Notes()											rotate x*90+y*-10 translate <1,0,-31> }
object { Pencil(7)											rotate y*-116 translate <9.5,.4,-32> }
object { Eraser()											rotate y*-54 translate <6.25,.5,-31.25> }
object { Ethanol()											scale 1.5 rotate y*-12 translate <-34-10,0,-29.5> }
object { Notepad() 											rotate y*7 translate <-15,0,-21> }
object { Flowerpot()										translate <25+2,0,15-5> }

// ===========================================================================
