#debug "including elements.inc\n"

//Include file containing the nessecary stuff to make the elemental
//spheres.

#declare rationalBrown = rationalBrown*0.6;

//The containing sphere
#declare Sphere = sphere{<0, 0, 0>, 2.5001
                         hollow
                         pigment{rgbf 1.0}
                          finish{diffuse 0.75 ambient 0.0
                                 roughness 0.0025 reflection 0.1
                                 irid{0.08 thickness 0.8 turbulence 0.5}}}

//The earth height field - deliberately not smoothed
#declare Soil = height_field{#debug "reading earth.gif\n"
                             gif "earth.gif"
                             scale<20, 0.5, 20>
                             translate<-5, -0.25, -5>}

//The earth texture - brown with some lighter flecks
#declare earthTexture = 
                 texture{
                    pigment{granite
                            turbulence 2.0
                            omega 0.75
                            lambda 2.5
                            color_map{[0.0, 0.35  color earthBrown
                                                  color earthBrown]
                                      [0.35, 0.5  color earthBrown
                                                  color rationalBrown]        
                                      [0.5, 0.6   color rationalBrown
                                                  color rationalBrown]
                                      [0.5, 0.575 color rgb 0.35
                                                  color rgb 0.35]
                                      [0.575, 0.7 color rationalBrown
                                                  color earthBrown]
                                      [0.7, 0.8   color rgb 0.35
                                                  color rgb 0.35]
                                      [0.8, 1.001 color earthBrown
                                                  color earthBrown]}}
                     finish{diffuse 1.0 ambient 0.1}
                     normal{dents 1.0 turbulence 1.5 scale 0.05}
                    scale 5}

//The fire media
#declare Flame = media{intervals 10
                       samples 1, 10
                       confidence 0.95
                       variance 1/128
                       absorption<0, 0.4, 0.5>
                       emission<1.0, 0.8, 0>
                       density{gradient -y
                               turbulence<0, 0.25, 0>
                               octaves 4
                               omega 0.4
                               lambda 1.5
                               scale<1, 5, 1>
                               translate y*-2.5
                               color_map{[0.0, 0.25   color rgb<1.0, 0.1, 0.0>
                                                      color rgb<1.0, 0.1, 0.0>]
                                         [0.25, 0.4   color rgb<1.0, 0.1, 0.0>
                                                      color rgb<1.0, 0.75, 0.0>]
                                         [0.4, 0.55   color rgb<1.0, 0.75, 0.0>
                                                      color rgb 0.0]
                                         [0.55, 1.001 color rgb 0.0
                                                      color rgb 0.0]}}}

//The air media
#declare Mist = media{intervals 10
                      samples 1, 10
                      confidence 0.95
                      variance 1/128
                      scattering{1 rgb 1.0}
                      density{spherical
                              turbulence 0.25
                              octaves 4
                              lambda 1.0
                              omega 0.75}
                      scale 2}

//Put the earth sphere together
#declare Earth = union{object{Sphere}
                       union{intersection{object{Soil}
                                          sphere{<0, 0, 0>, 2.5}}
                             intersection{object{Soil rotate y*90}
                                          sphere{<0, 0, 0>, 2.5}}
                             texture{earthTexture}}}

//Plus the water sphere
#declare Water = union{object{Sphere}
                       intersection{
                            box{<-2.5, -2.5, -2.5>,<2.5, 0, 2.5>}
                            sphere{<0, 0, 0>, 2.5}
                            pigment{rgbf<0.7, 0.85, 0.95, 0.8>}
                             finish{diffuse 1.0 ambient 0.0
                                    specular 0.75 roughness 0.005
                                    reflection 0.2}
                           interior{ior 1.33 caustics 1.0 
                                    fade_power 1 fade_distance 5}
                             normal{ripples 0.2 frequency 0.025
                                    scale 0.01}}}

//And finally the air and fire
#declare Air = object{Sphere
                      interior{media{Mist}}}

#declare Fire = object{Sphere
                       interior{media{Flame}}}
