// Atom generator file. Given the number of protons and neutrons, will generate the nucleus
// and a electron sphere. Does not generate correct shaped electron shells

#include "colors.inc"

//Default=iron

#ifndef (Proton_Number)
 #declare Proton_Number=14
#end

#ifndef (Neutron_Number)
 #declare Neutron_Number=14
#end

#declare Radius=pow((Proton_Number+Neutron_Number),0.3)*1.2

#declare Position=seed(2)
#declare Rot=seed(5)

#declare Atom=
 union {
  #declare Pr_No=0
  #while (Pr_No<Proton_Number)
   sphere {
    <rand(Position)*Radius,0,0>,1.2
    rotate <rand(Rot)*360,rand(Rot)*360,rand(Rot)*360>
    pigment {Red}
    finish {phong 0.50 phong_size 60}
   }
   #declare Pr_No=Pr_No+1
  #end
  #declare Nr_No=0
  #while (Nr_No<Neutron_Number)
   sphere {
    <rand(Position)*Radius,0,0>,1.2
    rotate <rand(Rot)*360,rand(Rot)*360,rand(Rot)*360>
    pigment {White}
    finish {phong 0.50 phong_size 60}
   }
   #declare Nr_No=Nr_No+1
  #end
  #declare El_No=0
  #while (El_No<Proton_Number)
   sphere {
    <50,0,0>,0.1
    rotate <rand(Rot)*360,rand(Rot)*360,rand(Rot)*360>
    pigment {Green}
    finish {reflection <0,1,0>}
   }
   #declare El_No=El_No+1
  #end
 }

 object {Atom}

 camera {
  location <0,0,-20>
  look_at <0,0,0>
 }

 light_source {
  <10,10,-10> color White
 }
 
 light_source {
  <-10,2,-10> color White
 }
