// A computer screen and tower case
// 1unit = 1cm

#include "colors.inc"
#include "shapes2.inc"
#include "finish.inc"
#include "metals.inc"
#include "glass.inc"
#include "stones1.inc"

#declare DMFLightOak =
pigment {
    wood
    turbulence 0.05            // For best results,  keep this low!
    scale <0.2, 0.2, 1>        // Scaled for a unit object
    color_map {
        [0.0, 0.1 color rgb <0.42, 0.26, 0.15>
                  color rgb <0.42, 0.26, 0.15>]
        [0.1, 0.9 color rgb <0.42, 0.26, 0.15>
                  color rgb <0.52, 0.37, 0.26>]
        [0.9, 1.0 color rgb <0.52, 0.37, 0.26>
                  color rgb <0.52, 0.37, 0.26>]
    }
}

#declare ScreenTop=
 union {
  difference {
   union {
    box {
     <0,11,0>,<35,40,9>
     pigment {LightSteelBlue}
    }
    box {
     <1.5,13,-0.2>,<33.5,39,0.5>
     pigment {Gray70}
    }
   }
   object {Pyramid2
           rotate x*90
           scale <30,24,10>
           translate <17.6,26,0>
           pigment {Gray70}
          }
  }
  box {
   <2,13.5,0.2>,<33,38.5,1.4>
   pigment {Clear}
   finish {Shiny}
  }
  box {
   <2,13.5,0.21>,<33,38.5,1.3>
   pigment {Black}
  }
  box {
   <1.5,11.3,-0.001>,<6.5,12.5,0.01>
   pigment {Gray20}
  }
  text {ttf "coprgtb.ttf" "SBM" 0.1,0
        texture {T_Gold_3A}
        scale 1.2
        translate <2.5,11.5,-0.002>
       }
  box {
   <2,9,0.4>,<33,11,5>
   pigment {LightSteelBlue}
  }
  box {
   <27.5,9,0.399>,<30.5,10.5,0.41>
   pigment {Black}
  }
  box {
   <27.6,9.01,0.398>,<30.4,10.4,0.41>
   pigment {LightSteelBlue*0.9}
  }
  box {
   <25.5,9.3,0.399>,<26.5,9.6,0.41>
   pigment {LimeGreen}
   finish {ambient 1 diffuse 0}
  }
  object {Pyramid2
          rotate x*90
          scale <12,10,12>
          translate <17.6,26,20>
          pigment {LightSteelBlue}
         }
  difference {
   box {
    <4.5,15.2,11>,<30,36.9,27>
   pigment {LightSteelBlue}
   }
   box {
    <1,-4,5>,<32.5,3,40>
    pigment {LightSteelBlue}
    rotate x*20
    translate y*45
   }
  }
  box {
   <4.5,0,3>,<30,5,28>
   rotate x*-15
   pigment {LightSteelBlue}
   translate y*8.2
  }
  sphere {
   <17.25,17,15>,8
   pigment {LightSteelBlue}
  }
 }

#declare Screen=
 union {
  object {ScreenTop
          rotate x*9
         }
  cylinder {
   <17.25,6,17.5>,<17.25,8,17.5>,5.5
   pigment {LightSteelBlue*1.5}
  }
  box {
   <4,5.5,4>,<30,6,25>
   pigment {LightSteelBlue*1.3}
  }
  box {
   <3,4,3>,<31,5.5,26>
   pigment {LightSteelBlue*1.3}
  }
 }

#declare StiffyDrive=
 union {
  difference {
   box {
    <0,0,0>,<10.3,2.6,5>
    pigment {LightSteelBlue}
   }
   union {
    box {
     <0.3,1.2,-1>,<9.7,2,0.3>
     pigment {LightSteelBlue}
    }
    cylinder {
     <3,1.5,-0.5>,<7,1.5,-0.5>,0.8
     pigment {LightSteelBlue}
    }
    box {
     <7.6,0.4,-0.1>,<9.4,1,0.05>
     pigment {Black}
    }
   }
   box {
    <0.3,1.2,0.299>,<9.7,2,0.31>
    pigment {Black}
   }
   box {
    <0.35,1.25,0.295>,<9.65,2,0.33>
    pigment {LightSteelBlue}
   }
   box {
    <2.1,0.5,-0.002>,<2.6,0.7,0.05>
    pigment {LimeGreen}
    finish {ambient 0.5 diffuse 0}
   }
   box {
    <7.65,0.45,-0.3>,<9.35,0.95,0.1>
    pigment {LightSteelBlue}
   }
  }
 }

#declare CDROMDrive=
 union {
  difference {
   box {
    <0,0,0>,<14.5,4,1>
    pigment {NewTan}
   }
   union {
    cylinder {
     <1.8,0.8,-0.05>,<1.8,0.8,0.5>,0.25
     pigment {Black}
    }
    box {
     <2.6,0.7,-0.05>,<4.4,1.1,0.5>
     pigment {Black}
    }
    box {
     <11.4,0.5,-0.05>,<13.4,1.2,0.5>
     pigment {Black}
    }
    box {
     <0.6,2,-0.05>,<14.1,3.7,0.5>
     pigment {Black}
    }
    box {
     <0.55,1.95,-0.05>,<14.15,3.75,0.05>
     pigment {LightWood}
    }
    cylinder {
     <5,0.9,0.003>,<5,0.9,-0.02>,0.1
     pigment {LightWood}
     finish {ambient 1 diffuse 0}
    }
   }
  }
  difference {
   cylinder {
    <1.8,0.8,-0.02>,<1.8,0.8,1>,0.21
    texture {T_Silver_3D}
   }
   cylinder {
    <1.8,0.8,-0.05>,<1.8,0.8,0.8>,0.16
    texture {T_Silver_3D}
   }
  }
  cylinder {
   <3.2,0.75,0.9>,<3.2,1.05,0.9>,1.1
   scale <1.08,1,1>
   pigment {LightWood}
   normal { gradient x+z, 0.2 scallop_wave scale 0.1}
  }
  box {
   <0.65,2.05,0>,<14.05,3.65,0.5>
   pigment {LightWood}
  }
  box {
   <11.45,0.55,-0.05>,<12.37,1.15,0.2>
   pigment {LightWood}
  }
  box {
   <12.43,0.55,-0.05>,<13.35,1.15,0.2>
   pigment {LightWood}
  }
  cylinder {
   <5,0.9,0.002>,<5,0.9,0.02>,0.09
   pigment {LimeGreen}
   finish {ambient 1 diffuse 0}
  }
 }

#declare ComputerBase=
 union {
  difference {
   box {
    <0,0,0>,<18,33.5,3>
    pigment {LightSteelBlue}
   }
   union {
    box {
     <1.4,23.7,-0.1>,<16.5,32.4,0.5>
     pigment {Black}
    }
    box {
     <1.4,18.2,-0.1>,<11.7,23.7,0.5>
     pigment {Black}
    }
    cylinder {
     <11,4.85,0>,<14,4.85,0>,0.35
     pigment {LightSteelBlue}
     scale <1,1,2>
    }
    sphere {
     <0,0,0>,0.35
     scale <1.5,1,2>
     pigment {LightSteelBlue}
     translate <11,4.85,0>
    }
    sphere {
     <0,0,0>,0.35
     scale <1.5,1,2>
     pigment {LightSteelBlue}
     translate <14,4.85,0>
    }
    cylinder {
     <11,7.55,0>,<14,7.55,0>,0.35
     pigment {LightSteelBlue}
     scale <1,1,2>
    }
    sphere {
     <0,0,0>,0.35
     scale <1.5,1,2>
     pigment {LightSteelBlue}
     translate <11,7.55,0>
    }
    sphere {
     <0,0,0>,0.35
     scale <1.5,1,2>
     pigment {LightSteelBlue}
     translate <14,7.55,0>
    }
    cylinder {
     <11,9.95,0>,<14,9.95,0>,0.35
     pigment {LightSteelBlue}
     scale <1,1,2>
    }
    sphere {
     <0,0,0>,0.35
     scale <1.5,1,2>
     pigment {LightSteelBlue}
     translate <11,9.95,0>
    }
    sphere {
     <0,0,0>,0.35
     scale <1.5,1,2>
     pigment {LightSteelBlue}
     translate <14,9.95,0>
    }
    box {
     <13.8,19.2,-0.1>,<16.5,22.2,0.1>
     pigment {LightSteelBlue}
    }
    box {
     <-5,-0.3,-0.5>,<5,0.3,0.3>
     pigment {LightSteelBlue}
     rotate z*20
     translate <6,12.5,0>
    }
    box {
     <-5,0.1,-0.5>,<5,0.3,0.4>
     pigment {Black}
     rotate z*20
     translate <6,12.5,0>
    }
    box {
     <-5,-0.3,-0.5>,<5,0.3,0.3>
     pigment {LightSteelBlue}
     rotate z*20
     translate <6,14.3,0>
    }
    box {
     <-5,0.1,-0.5>,<5,0.3,0.4>
     pigment {Black}
     rotate z*20
     translate <6,14.3,0>
    }
    box {
     <-5,-0.3,-0.5>,<5,0.3,0.3>
     pigment {LightSteelBlue}
     rotate z*20
     translate <6,16.1,0>
    }
    box {
     <-5,0.1,0.2>,<5,0.3,0.4>
     pigment {Black}
     rotate z*20
     translate <6,16.1,0>
    }
    box {
     <-1,0,2.6>,<0.3,33.5,2.9>
     pigment {LightSteelBlue}
    }
    box {
     <0,33.2,2.6>,<18,34,2.9>
     pigment {LightSteelBlue}
    }
    box {
     <17.7,0,2.6>,<19,33.5,2.9>
     pigment {LightSteelBlue}
    }
   }
  }
  box {
   <1.45,23.75,0.05>,<16.45,28,0.5>
   pigment {LightSteelBlue}
  }
  box {
   <1.45,18.25,0.05>,<11.65,20.9,0.5>
   pigment {LightSteelBlue}
  }
  object {CDROMDrive
          scale <1.03,1.03,1>
          translate <1.45,28.15,0.05>
         }
  object {StiffyDrive
          scale <0.98,1,1>
          translate <1.45,21,0.05>
         }
  box {
   <0,0,0>,<2.2,2.8,0.01>
   pigment {LightSteelBlue}
   pigment {image_map { tga "intelwarning.tga"
                      }
            scale <2.5,2.8,1>
           }
   translate <14.1,19.3,0.09>
  }
  box {
   <11.52,4.55,0.1>,<11.97,5.15,0.5>
   pigment { rgbf <1,0,0,1> }
   finish {F_Glass2}
  }
  box {
   <12.02,4.55,0.1>,<12.47,5.15,0.5>
   pigment { rgbf <1,0,0,1>}
   finish {F_Glass2}
  }
  box {
   <12.52,4.55,0.1>,<12.97,5.15,0.5>
   finish {F_Glass2}
   pigment {rgbf <1,0,0,1>}
  }
  box {
   <13.02,4.55,0.1>,<13.47,5.15,0.5>
   finish {F_Glass2}
   pigment {rgbf <1,0,0,1>}
  }
  light_source {
   <12.5,5,0.6>
   color White
   fade_distance 1.5
   fade_power 2
  }
  box {
   <11.52,7.25,0.1>,<11.97,7.85,0.5>
   pigment { rgbf <1,0.8,0,1> }
   finish {F_Glass2}
  }
  box {
   <12.02,7.25,0.1>,<12.47,7.85,0.5>
   pigment { rgbf <1,0.8,0,1>}
   finish {F_Glass2}
  }
  box {
   <12.52,7.25,0.1>,<12.97,7.85,0.5>
   finish {F_Glass2}
   pigment {rgbf <1,0.8,0,1>}
  }
  box {
   <13.02,7.25,0.1>,<13.47,7.85,0.5>
   finish {F_Glass2}
   pigment {rgbf <1,0.8,0,1>}
  }
  light_source {
   <12.5,7.7,0.6>
   color White
   fade_distance 1.5
   fade_power 2
  }
  box {
   <11.52,9.65,0.1>,<11.97,10.25,0.5>
   pigment { rgbf <0,1,0,1> }
   finish {F_Glass2}
  }
  box {
   <12.02,9.65,0.1>,<12.47,10.25,0.5>
   pigment { rgbf <0,1,0,1>}
   finish {F_Glass2}
  }
  box {
   <12.52,9.65,0.1>,<12.97,10.25,0.5>
   finish {F_Glass2}
   pigment {rgbf <0,1,0,1>}
  }
  box {
   <13.02,9.65,0.1>,<13.47,10.25,0.5>
   finish {F_Glass2}
   pigment {rgbf <0,1,0,1>}
  }
  light_source {
   <12.5,10.1,0.6>
   color White
   fade_distance 1.5
   fade_power 2
  }
  sphere {
   <0,0,0>,1.3
   scale <1,0.4,0.2>
   rotate z*45
   translate <15,15,0>
   pigment {SlateBlue}
  }
   sphere {
   <0,0,0>,1.1
   scale <1,0.4,0.2>
   rotate z*-45
   translate <3,6.5,0>
   pigment {SlateBlue}
  }
   sphere {
   <0,0,0>,1.1
   scale <1,0.4,0.2>
   rotate z*-45
   translate <3,9,0>
   pigment {SlateBlue}
  }
  text { ttf "coprgtb.ttf" "Power" 0.1,0
         scale 0.5
         translate <12,15,-0.01>
         pigment {Black}
       }
  text { ttf "coprgtb.ttf" "Turbo" 0.1,0
         scale 0.5
         translate <4,9.6,-0.01>
         pigment {Black}
       }
  text { ttf "coprgtb.ttf" "Reset" 0.1,0
         scale 0.5
         translate <4,7.1,-0.01>
         pigment {Black}
       }
  text { ttf "coprgtb.ttf" "Power" 0.1,0
         scale 0.5
         translate <15,10,-0.01>
         pigment {Black}
       }
  text { ttf "coprgtb.ttf" "Turbo" 0.1,0
         scale 0.5
         translate <15,7.6,-0.01>
         pigment {Black}
       }
  text { ttf "coprgtb.ttf" "H.D.D" 0.1,0
         scale 0.5
         translate <15,4.9,-0.01>
         pigment {Black}
       }
  box {
    <0,0,3>,<18,33.5,42>
    pigment {LightSteelBlue}
   }
 }

camera {
 location <7,27,-60>
 look_at <7,19,0>
}

light_source {
 <-55,100,-10> color White
}

light_source {
 <-20,80,-15> color Gray70
}

light_source {
 <70,50,40> color Gray80
}

object {ComputerBase
        translate <-30,10,35>
       }

object { Screen
         translate <10,6,30>
       }
box {
 <-46,10,20>,<66,7,80>
 texture {T_Stone13
          scale 5
         }
}

box {
 <-48,14,18>,<-45,-28,82>
 texture {T_Stone13
          scale 5}
}

box {
 <65,14,18>,<68,-28,82>
 texture {T_Stone13
          scale 5}
}

box {
 <-46,-20,40>,<66,7,43>
 texture {T_Stone13
          scale 5
          rotate <20,20,10>
         }
}

box {
 <-100,-30,-30>,<120,-28,85>
 pigment { rgb <0.22,0.69,0.87>}
 finish { ambient 0.1 diffuse 0.4}
 normal { wrinkles 0.6
          turbulence 0.2
          scale 5
        }
}

box {
 <-100,-29,85>,<120,150,87>
 pigment { rgb <0.9,1,0.9>}
 normal {
   bumps 0.4
   turbulence 0.4
   scale <0.1, 0.1, 0.1>
 }
 finish {
   ambient 0.1 diffuse 0.4
 }
}

#declare Frame_Width=60
#declare Frame_Height=45
#declare Frame_Depth=0.5
#declare Edge_Size=3
#declare Frame_Texture=texture {T_Brass_2D}
#declare Picture=
 pigment { image_map { tga "Periodic.tga"
                     }
         }

#include "myobjects.inc"

object {Frame
        translate <70,60,84.5>
       }

 union {
  difference {
   cylinder {
    <0,0,0>,<0,0,1>,5
   }
   cylinder {
    <0,0,-1>,<0,0,2>,4.7
   }
   pigment {Black}
   finish {phong 1.0}
  }
  cylinder {
   <0,0,0.4>,<0,0,0.6>,4.8
   pigment {image_map { tga "memory.tga"
                      }
            translate <-2.5,2.5,0>
            scale 19
           }
   finish {diffuse 0.5 ambient 0.5}
  }
  scale 2
  translate <5,40,0>
  no_shadow
 }

cylinder {
 <1,31,1>,<-12,35,70>,0.4
 pigment {Black}
 finish {ambient 0 diffuse 0}
 no_shadow
}

union {
  difference {
   cylinder {
    <0,0,0>,<0,0,1>,5
   }
   cylinder {
    <0,0,-1>,<0,0,2>,4.7
   }
   pigment {Black}
   finish {phong 1.0}
  }
  cylinder {
   <0,0,0.4>,<0,0,0.6>,4.8
   pigment {image_map { tga "hdd.tga"
                      }
            translate <-2.5,2.5,0>
            scale <14,11,1>
           }
   finish {diffuse 0.5 ambient 0.5}
  }
  scale 2
  rotate y*-10
  translate <-25,10,0>
  no_shadow
 }

cylinder {
 <-20,19,1>,<-28,36.5,36>,0.4
 pigment {Black}
 finish {ambient 0 diffuse 0}
 no_shadow
}

union {
  difference {
   cylinder {
    <0,0,0>,<0,0,1>,5
   }
   cylinder {
    <0,0,-1>,<0,0,2>,4.7
   }
   pigment {Black}
   finish {phong 1.0}
  }
  cylinder {
   <0,0,0.4>,<0,0,0.6>,4.8
   pigment {image_map { tga "cpu.tga"
                      }
            translate <-2.5,2.5,0>
            scale <15,12,1>
           }
   finish {diffuse 0.5 ambient 0.5}
  }
  scale 2
  translate <14,2,0>
  no_shadow
 }

cylinder {
 <9,9,1>,<-13,20,50>,0.4
 pigment {Black}
 finish {ambient 0 diffuse 0}
 no_shadow
}

union {
  difference {
   cylinder {
    <0,0,0>,<0,0,1>,5
   }
   cylinder {
    <0,0,-1>,<0,0,2>,4.7
   }
   texture {T_Silver_3D}
  }
  cylinder {
   <0,0,0.4>,<0,0,0.6>,4.8
   pigment {image_map { tga "gold.tga"
                      }
            translate <-2.5,2.5,0>
            scale 8
           }
   finish {diffuse 0.5 ambient 0.5}
  }
  scale 1.3
  translate <-15,42,0>
  no_shadow
 }

cylinder {
 <-9,42,1>,<-5,40,1>,0.3
 texture {T_Silver_2D}
 no_shadow
}

 union {
  difference {
   cylinder {
    <0,0,0>,<0,0,1>,5
   }
   cylinder {
    <0,0,-1>,<0,0,2>,4.7
   }
   texture {T_Silver_2D}
  }
  cylinder {
   <0,0,0.4>,<0,0,0.6>,4.8
   pigment {image_map { tga "aluminium.tga"
                      }
            translate <-2.5,2.5,0>
            scale 12
           }
   finish {diffuse 0.5 ambient 0.5}
  }
  scale 1.3
  rotate x*10
  translate <-13,-5,0>
  no_shadow
 }
 
cylinder {
 <-13,1,1.3>,<-15,10,1>,0.3
 texture {T_Silver_2D}
 no_shadow
}

union {
  difference {
   cylinder {
    <0,0,0>,<0,0,1>,5
   }
   cylinder {
    <0,0,-1>,<0,0,2>,4.7
   }
   texture {T_Silver_2D}
  }
  cylinder {
   <0,0,0.4>,<0,0,0.6>,4.8
   pigment {image_map { tga "silicon.tga"
                      }
            translate <-2.5,2.5,0>
            scale <15,12,1>
           }
   finish {diffuse 0.5 ambient 0.5}
  }
  scale 1.3
  rotate y*10
  rotate x*10
  translate <35,4,0>
  no_shadow
 }

cylinder {
 <29,4,1>,<24,2,1>,0.3
 texture {T_Silver_2D}
 no_shadow
}
