// The interior of a computer hard drive.

#include "colors.inc"
#include "metals.inc"

#declare HardDriveTexture=
 texture {
  pigment {Gray50}
  finish {phong 0.3 phong_size 5 metallic}
 }

#declare HardDrive=
 union {
  difference {
   union {
    box {
     <0,0,0>,<14,2,19.2>
     texture {HardDriveTexture}
    }
    cylinder {
     <7,1.5,13.1>,<7,2,13.1>,6.8
     texture {HardDriveTexture}
    }
    box {
     <7,1.5,19.2>,<14,2,20>
     texture {HardDriveTexture}
    }
    cylinder {
     <1.5,1.2,18.5>,<1.5,2.1,18.5>,0.35
     texture {HardDriveTexture}
    }
    cylinder {
     <12.2,1.2,18.5>,<12.2,2.1,18.5>,0.35
     texture {HardDriveTexture}
    }
    cylinder {
     <0.8,1.2,1.3>,<0.8,2.1,1.3>,0.35
     texture {HardDriveTexture}
    }
    cylinder {
     <12.9,1.2,1.3>,<12.9,2.1,1.3>,0.35
     texture {HardDriveTexture}
    }
   }
   union {
    box {
     <-0.1,0.4,17.8>,<0.5,2.2,18.8>
     texture {HardDriveTexture}
    }
    box {
     <13.5,0.4,17.8>,<14.6,2.2,18.8>
     texture {HardDriveTexture}
    }
    cylinder {
     <0.25,0.5,18.3>,<0.25,-0.2,18.3>,0.2
     texture {HardDriveTexture}
    }
    cylinder {
     <14.25,0.5,18.3>,<14.25,-0.2,18.3>,0.2
     texture {HardDriveTexture}
    }
    cylinder {
     <1.5,-0.2,18.5>,<1.5,2.2,18.5>,0.15
     texture {HardDriveTexture}
    }
    cylinder {
     <12.2,-0.2,18.5>,<12.2,2.2,18.5>,0.15
     texture {HardDriveTexture}
    }
    cylinder {
     <0.8,-0.2,1.3>,<0.8,2.2,1.3>,0.15
     texture {HardDriveTexture}
    }
    cylinder {
     <12.9,-0.2,1.3>,<12.9,2.2,1.3>,0.15
     texture {HardDriveTexture}
    }
   }
  }
  difference {
   cylinder {
    <10.6,1.9,3.7>,<10.6,2.4,3.7>,2.1
    texture {HardDriveTexture}
   }
   union {
    cylinder {
     <10.6,2.2,3.7>,<10.6,2.5,3.7>,1
     texture {HardDriveTexture}
    }
    cylinder {
     <12.6,2.3,3.7>,<12.6,2.5,3.7>,0.15
     texture {HardDriveTexture}
    }
    cylinder {
     <8.7,2.3,3.7>,<8.7,2.5,3.7>,0.15
     texture {HardDriveTexture}
    }
    cylinder {
     <10.6,2.3,1.8>,<10.6,2.5,1.8>,0.15
     texture {HardDriveTexture}
    }
    cylinder {
     <10.6,2.3,5.6>,<10.6,2.5,5.6>,0.15
     texture {HardDriveTexture}
    }
   }
  }
  difference {
   cylinder {
    <10.6,2.2,3.7>,<10.6,2.35,3.7>,0.95
    texture {T_Chrome_2D}
   }
   torus {
    0.6,0.03
    translate <10.6,2.35,3.7>
    texture {T_Chrome_2D}
   }
  }
  cylinder {
   <10.6,2.3,3.7>,<10.6,3.8,3.7>,0.3
   texture {HardDriveTexture}
  }
  // Edging
  box {
   <0.5,1.9,2.8>,<0.6,2.3,12.8>
   texture {HardDriveTexture}
  }
  box {
   <13.3,1.9,2.8>,<13.5,2.3,12.8>
   texture {HardDriveTexture}
  }
  difference {
   cylinder {
    <7,1.9,12.8>,<7,2.3,12.8>,6.5
   }
   union {
    cylinder {
     <7,1.9,12.8>,<7,2.4,12.8>,6.3
    }
    box {
     <0,0,0>,<14,2.5,12.8>
    }
   }
   texture {HardDriveTexture}
  }
  box {
   <0,1.9,0>,<0.2,2.3,-3.5>
   texture {HardDriveTexture}
   rotate y*-45
   translate <0.45,0,2.8>
  }
  box {
   <0,1.9,0>,<0.2,2.3,-3.4>
   texture {HardDriveTexture}
   rotate y*45
   translate <13.3,0,2.8>
  }
  box {
   <2.9,1.9,0.3>,<11.2,2.3,0.5>
   texture {HardDriveTexture}
  }
  // Platters
  cylinder {
   <7,1.9,12.8>,<7,3.5,12.8>,2.65
   texture {T_Chrome_2A}
  }
  difference {
   union {
    cylinder {
     <7,1.9,12.8>,<7,3.7,12.8>,2.6
     texture {T_Chrome_2A}
    }
    cylinder {
     <7,1.9,12.8>,<7,3.71,12.8>,0.4
     pigment {Gray30}
     finish {phong 0.3 phong_size 5 metallic}
    }
   }
   union {
    box {
     <6.8,3.65,12.75>,<7.2,3.75,12.85>
     pigment {Gray30}
     finish {phong 0.3 phong_size 5 metallic}
    }
    torus {
     0.4,0.05
     translate <7,3.7,12.8>
     texture {T_Chrome_2A}
    }
   }
  }
  cylinder {
   <7,2.35,12.8>,<7,2.5,12.8>,6.4
   texture {
    pigment { Copper}
    finish { reflection rgb <0.72,0.45,0.2>
             diffuse 0.3
           }
   }
  }
  cylinder {
   <7,3.2,12.8>,<7,3.45,12.8>,6.4
   texture {
    pigment { Copper}
    finish { reflection rgb <0.72,0.45,0.2>
             diffuse 0.3
           }
   }
  }
  //Arm
  union {
   difference {
    cylinder {
     <3.5,2.5,6.6>,<3.5,3.1,6.6>,7.4
     texture {HardDriveTexture}
    }
    union {
     cylinder {
      <3.5,2.9,6.6>,<3.5,3.2,6.6>,7.25
     }
     box {
      <0,0,0>,<-16,3.2,16>
      rotate y*44
      translate x*4.3
     }
     box {
      <0,0,0>,<-16,3.2,16>
      rotate y*-40
      translate x*10.5
     }
    }
    translate y*-2.8
    rotate x*2
    translate y*2.8
   }
   box {
    <0,2.5,0>,<6.6,2.78,1>
    rotate y*12
    translate <3.4,0,4>
   }
   box {
    <0,2.5,0>,<6.6,2.85,0.1>
    rotate y*12
    translate <3.4,0,4>
   }
   box {
    <1,2.5,0.9>,<6.6,2.85,1>
    rotate y*12
    translate <3.4,0,4>
   }
   box {
    <4.5,2.5,0>,<4.6,2.85,1>
    rotate y*12
    translate <3.4,0,4>
   }
   box {
    <0,2.5,0>,<1.4,2.78,2.7>
    rotate y*-20
    translate <3.4,0,4>
   }
   pigment {Gray50}
   finish {phong 0.3 phong_size 5
           metallic
           irid {
            0.25
            thickness 2
            turbulence .5
           }
          }
  }
  difference {
   union {
    cylinder {
     <3.2,1.9,6.1>,<3.2,4,6.1>,0.75
     texture {HardDriveTexture}
    }
    box {
     <-0.5,0,0>,<0.1,0.1,1.3>
     rotate y*-20
     translate <4.1,3.9,5.8>
     texture {HardDriveTexture}
    }
   }
   cylinder {
    <3.2,3.9,6.1>,<3.2,4.2,6.1>,0.5
    texture {HardDriveTexture}
   }
  }
  torus {
   0.5,0.1
   translate <3.2,3.9,6.1>
   texture {HardDriveTexture}
  }
  difference {
   box {
    <0,0,0>,<3.2,0.2,1.3>
   }
   union {
    box {
     <0,-0.1,0>,<3.6,0.3,-0.4>
     rotate y*-6
    }
    cylinder {
     <1,-0.1,0.7>,<1,0.3,0.65>,0.15
    }
    cylinder {
     <2.55,-0.1,0.7>,<2.55,0.3,0.65>,0.15
    }
    box {
     <0,-0.1,1.3>,<3.6,0.3,1.7>
     rotate y*6
    }
   }
   texture {HardDriveTexture}
   rotate y*-20
   translate <4.1,3.8,5.8>
  }
  difference {
   union {
    box {
     <3.2,0,0>,<6,0.03,1.3>
    }
    box {
     <3.18,0,0>,<3.2,0.3,1.3>
    }
   }
   union {
    box {
     <-0.1,-0.1,0>,<6.4,0.4,-0.7>
     rotate y*-6
    }
    box {
     <-0.1,-0.1,1.3>,<6.4,0.4,2>
     rotate y*6
    }
   }
   texture {T_Chrome_2C}
   rotate y*-20
   translate <4.1,3.7,5.8>
  }
  box {
   <5.4,3.45,0.5>,<6,3.7,0.8>
   rotate y*-20
   translate <4.1,0,5.8>
   pigment {Gray10}
   finish {ambient 0.2 diffuse 0.5}
  }
  box {
   <3.8,3.71,0.6>,<5.8,3.75,0.7>
   rotate y*-20
   translate <4.1,0,5.8>
   pigment {Red*0.8}
   finish {phong 1.0}
  }
  box {
   <0,3.71,0>,<0.7,3.75,0.1>
   rotate y*-30
   translate <3.4,0,0.3>
   rotate y*-20
   translate <4.1,0,5.8>
   pigment {Red*0.8}
   finish {phong 1.0}
  }
  box {
   <4.4,3,2.5>,<6.3,3.9,2.6>
   texture {T_Chrome_3B}
  }
  box {
   <4.4,2.05,2.5>,<4.9,3.9,2.6>
   texture {T_Chrome_3B}
  }
  box {
   <4.4,2.05,1.1>,<4.9,2.25,2.6>
   texture {T_Chrome_3B}
  }
  box {
   <4.4,2.05,1.1>,<6.3,2.25,1.7>
   texture {T_Chrome_3B}
  }
  difference {
   cylinder {
    <4.3,3.1,4.25><4.3,4,4.25>,1.55
    pigment {rgbf <0.72,0.45,0.20,0.8>}
    finish {reflection <0.72,0.45,0.20,0.5>*0.5}
   }
   union {
    cylinder {
     <4.3,3,4.25>,<4.3,4.2,4.25>,1.53
     pigment {rgbf <0.72,0.45,0.20,0.5>}
     finish {reflection <0.72,0.45,0.20,0.5>*0.5}
    }
    box {
     <0,3,0>,<4,4.2,4>
     pigment {rgbf <0.72,0.45,0.20,0.5>}
     finish {reflection <0.72,0.45,0.20,0.5>*0.5}
     rotate y*-20
     translate <4.67,0,2.6>
    }
   }
  }
  difference {
   cylinder {
    <0,0,0>,<0.7,0,0>,1.9
   }
   union {
    cylinder {
     <-1,0,0>,<1.7,0,0>,1.87
    }
    box {
     <-1,-2,-5>,<2,2,0>
    }
    box {
     <-1,0,-5>,<2,6,2>
    }
   }
   pigment {rgbf <0.72,0.45,0.20,0.5>}
   finish {reflection <0.72,0.45,0.20,0.5>*0.5}
   translate <5,3.9,0.7>
  }
  box {
   <5,2.01,0>,<5.7,2.03,1.2>
   pigment {rgbf <0.72,0.45,0.20,0.5>}
   finish {reflection <0.72,0.45,0.20,0.5>*0.5}
  }
  box {
   <0.3,0.3,20.4>,<13.8,0.4,19>
   pigment {DarkGreen}
  }
  box {
   <-0.2,-0.1,-0.4>,<14.2,4.1,0>
   pigment {LightSteelBlue}
   finish {phong 1.0}
  }
 }

 light_source {
  <28,20,-20> color White
  fade_distance 50
 }

 light_source {
  <11.6,3.7,-13> color LightSteelBlue
  fade_power 2
  fade_distance 50
 }
 
 light_source {
  <0,0,50> color White
 }


 camera {
  location <8,5,-25>
  look_at <8,10,0>
 }

 plane {
  z, 80000
  pigment { rgb <1.0,0.9,0.8> }
  finish {ambient 0.5 diffuse 0.3}
  hollow
 }

 object {
  HardDrive
  rotate x*-90
 }
