// A model of a memory chip and a SIMM

#include "colors.inc"
#include "finish.inc"
#include "metals.inc"

// 1 unit=1cm

#declare Memory_Chip=
 union {
  box {
   <0,0,0>,<1.6,0.7,0.2>
   pigment {Gray10}
  }
  #declare Leg_Number=0
  #while (Leg_Number<5)
   box {
    <0.02+0.12*Leg_Number,0.68,0.1>,<0.1+0.12*Leg_Number,0.75,0.25>
    texture {T_Silver_3C}
   }
   #declare Leg_Number=Leg_Number+1
  #end
  #declare Leg_Number=0
  #while (Leg_Number<5)
   box {
    <1+0.12*Leg_Number,0.68,0.1>,<1.08+0.12*Leg_Number,0.75,0.25>
    texture {T_Silver_3C}
   }
   #declare Leg_Number=Leg_Number+1
  #end
  #declare Leg_Number=0
  #while (Leg_Number<5)
   box {
    <0.02+0.12*Leg_Number,0.02,0.1>,<0.1+0.12*Leg_Number,-0.05,0.25>
    texture {T_Silver_3C}
   }
   #declare Leg_Number=Leg_Number+1
  #end
  #declare Leg_Number=0
  #while (Leg_Number<5)
   box {
    <1+0.12*Leg_Number,0.02,0.1>,<1.08+0.12*Leg_Number,-0.05,0.25>
    texture {T_Silver_3C}
   }
   #declare Leg_Number=Leg_Number+1
  #end
  text {ttf "cour.ttf" "KOREA A000" 0.1,0
        scale 0.17
        translate <0.3,0.5,-0.01>
        pigment {Gray90}
        finish {ambient 0.4 diffuse 0.2}
       }
  text {ttf "cour.ttf" "9336 GGG" 0.1,0
        scale 0.17
        translate <0.4,0.3,-0.01>
        pigment {Gray90}
        finish {ambient 0.4 diffuse 0.2}
       }
  text {ttf "cour.ttf" "HM514400ALS7" 0.1,0
        scale 0.17
        translate <0.2,0.1,-0.01>
        pigment {Gray90}
        finish {ambient 0.4 diffuse 0.2}
       }
 }

#declare Track_Set_1=
 union {
  box {
   <1.3,2.25,-0.001>,<1.6,2.27,0.01>
  }
  box {
   <1.6,2.27,-0.001>,<1.62,2.13,0.01>
  }
  box {
   <1.6,2.13,-0.001>,<2.3,2.15,0.01>
  }
  box {
   <1.5,2.13,-0.001>,<1.3,2.15,0.01>
  }
  cylinder {
   <1.5,2.14,-0.001>,<1.5,2.14,0.01>,0.03
  }
  box {
   <1.3,1.95,-0.001>,<1.65,1.97,0.01>
  }
  box {
   <1.65,1.95,-0.001>,<1.67,2.02,0.01>
  }
  box {
   <1.65,2.02,-0.001>,<2.3,2.04,0.01>
  }
  box {
   <1.3,1.87,-0.001>,<1.6,1.89,0.01>
  }
  cylinder {
   <1.6,1.88,-0.001>,<1.6,1.88,0.01>,0.03
  }
  box {
   <1.3,1.75,-0.001>,<1.7,1.77,0.01>
  }
  box {
   <1.7,1.75,-0.001>,<1.72,1.84,0.01>
  }
  box {
   <1.7,1.84,-0.001>,<2.3,1.86,0.01>
  }
  box {
   <1.3,1.67,-0.001>,<1.76,1.69,0.01>
  }
  box {
   <1.78,1.67,-0.001>,<1.8,1.76,0.01>
  }
  box {
   <1.78,1.76,-0.001>,<2.3,1.78,0.01>
  }
  texture {T_Copper_3C}
 }

#declare Track_Set_2=
 union {
  box {
   <1.4,1.24,-0.001>,<1.9,1.26,0.01>
  }
  cylinder {
   <1.9,1.26,-0.001>,<1.9,1.26,0.01>,0.03
  }
  box {
   <1.4,1.12,-0.001>,<1.7,1.14,0.01>
  }
  box {
   <1.7,1.19,-0.001>,<1.72,1.12,0.01>
  }
  box {
   <1.7,1.19,-0.001>,<2,1.21,0.01>
  }
  box {
   <1.4,0.88,-0.001>,<1.65,0.9,0.01>
  }
  box {
   <1.65,0.88,-0.001>,<1.67,0.95,0.01>
  }
  box {
   <1.65,0.95,-0.001>,<1.77,0.97,0.01>
  }
  box {
   <1.77,0.95,-0.001>,<1.79,1.05,0.01>
  }
  box {
   <1.77,1.05,-0.001>,<2,1.07,0.01>
  }
  box {
   <1.73,0.88,-0.001>,<2,0.9,0.01>
  }
  cylinder {
   <1.73,0.89,-0.001>,<1.73,0.89,0.01>,0.03
  }
  box {
   <1.4,1.01,-0.001>,<1.71,1.03,0.01>
  }
  cylinder {
   <1.71,1.02,-0.001>,<1.71,1.02,0.01>,0.03
  }
  box {
   <1.4,0.75,-0.001>,<2,0.77,0.01>
  }
  texture {T_Copper_3C}
 }

#declare Track_Set_3=
 union {
  box {
   <2.5,2.25,-0.001>,<2.95,2.27,0.01>
  }
  box {
   <3.05,2.25,-0.001>,<3.5,2.27,0.01>
  }
  cylinder {
   <2.95,2.26,-0.001>,<2.95,2.26,0.01>,0.03
  }
  cylinder {
   <3.05,2.26,-0.001>,<3.05,2.26,0.01>,0.03
  }
  box {
   <2.5,2.13,-0.001>,<2.9,2.15,0.01>
  }
  cylinder {
   <2.9,2.14,-0.001>,<2.9,2.14,0.01>,0.03
  }
  box {
   <3.02,2.03,-0.001>,<3.4,2.05,0.01>
  }
  box {
   <3.02,2.03,-0.001>,<3.04,2.1,0.01>
  }
  cylinder {
   <3.02,2.1,-0.001>,<3.02,2.1,0.01>,0.03
  }
  box {
   <2.5,2.03,-0.001>,<2.95,2.05,0.01>
  }
  box {
   <2.95,2.05,-0.001>,<2.97,1.95,0.01>
  }
  box {
   <2.95,1.95,-0.001>,<3.4,1.97,0.01>
  }
  box {
   <2.5,1.84,-0.001>,<3.02,1.86,0.01>
  }
  box {
   <3.02,1.84,-0.001>,<3.04,1.88,0.01>
  }
  box {
   <3.02,1.88,-0.001>,<3.4,1.9,0.01>
  }
  box {
   <2.6,1.75,-0.001>,<3.4,1.77,0.01>
  }
  texture {T_Copper_3C}
 }

#declare Track_Set_4=
 union {
  cylinder {
   <2.6,1.34,-0.001>,<2.6,1.34,0.01>,0.03
  }
  box {
   <2.6,1.33,-0.001>,<3.05,1.35,0.01>
  }
  box {
   <3.05,1.35,-0.001>,<3.03,1.28,0.01>
  }
  box {
   <3.03,1.28,-0.001>,<3.4,1.26,0.01>
  }
  box {
   <2.6,1.28,-0.001>,<2.95,1.26,0.01>
  }
  cylinder {
   <2.95,1.27,-0.001>,<2.95,1.27,0.01>,0.03
  }
  box {
   <2.6,1.13,-0.001>,<2.95,1.15,0.01>
  }
  cylinder {
   <2.93,1.14,-0.001>,<2.93,1.14,0.01>,0.03
  }
  box {
   <2.6,1.06,-0.001>,<3.02,1.08,0.01>
  }
  box {
   <3,1.08,-0.001>,<3.02,1.15,0.01>
  }
  box {
   <3,1.13,-0.001>,<3.4,1.15,0.01>
  }
  box {
   <2.6,0.99,-0.001>,<3,1.01,0.01>
  }
  cylinder {
   <3,1,-0.001>,<3,1,0.01>,0.03
  }
  box {
   <3.22,1.06,-0.001>,<3.4,1.08,0.01>
  }
  box {
   <3.22,1.08,-0.001>,<3.24,0.99,0.01>
  }
  box {
   <3.24,0.99,-0.001>,<3.1,1.01,0.01>
  }
  box {
   <3.1,1.01,-0.001>,<3.12,0.93,0.01>
  }
  box {
   <3.12,0.93,-0.001>,<2.6,0.95,0.01>
  }
  box {
   <2.6,0.89,-0.001>,<3.,0.87,0.01>
  }
  box {
   <3,0.89,-0.001>,<3.02,0.83,0.01>
  }
  box {
   <3,0.83,-0.001>,<3.4,0.81,0.01>
  }
  box {
   <2.6,0.81,-0.001>,<2.8,0.83,0.01>
  }
  cylinder {
   <2.8,0.82,-0.001>,<2.8,0.82,0.01>,0.03
  }
  box {
   <2.6,0.74,-0.001>,<2.92,0.76,0.01>
  }
  box {
   <2.92,0.74,-0.001>,<2.94,0.82,0.01>
  }
  cylinder {
   <2.93,0.82,-0.001>,<2.93,0.82,0.01>,0.03
  }
  box {
   <3.02,0.74,-0.001>,<3.4,0.76,0.01>
  }
  box {
   <3.02,0.74,-0.001>,<3.04,0.67,0.01>
  }
  cylinder {
   <3.03,0.67,-0.001>,<3.03,0.67,0.01>,0.03
  }
  texture {T_Copper_3C}
 }

#declare SIMM=
 union {
  difference {
   union {
    box {
     <0,0,0>,<10.7,2.5,0.1>
     pigment {DarkGreen}
    }
    // Gold contact pins
    #declare Pin_Number=0
    #while (Pin_Number<36)
     box {
      <0.6+0.125*Pin_Number,0,-0.001>,<0.7+0.125*Pin_Number,0.2,0.01>
      texture {T_Gold_3E}
     }
     cylinder {
      <0.65+0.125*Pin_Number,0.2,-0.001>,<0.65+0.125*Pin_Number,0.2,0.01>,0.05
      texture {T_Gold_3E}
     }
     #declare Pin_Number=Pin_Number+1
    #end
    #declare Pin_Number=0
    #while (Pin_Number<36)
     box {
      <5.7+0.125*Pin_Number,0,-0.001>,<5.8+0.125*Pin_Number,0.2,0.01>
      texture {T_Gold_3E}
     }
     cylinder {
      <5.75+0.125*Pin_Number,0.2,-0.001>,<5.75+0.125*Pin_Number,0.2,0.01>,0.05
      texture {T_Gold_3E}
     }
     #declare Pin_Number=Pin_Number+1
    #end
   }
   union {
   cylinder {
    <0.4,1,-0.1>,<0.4,1,0.2>,0.15
    pigment {DarkGreen}
   }
   cylinder {
    <10.4,1,-0.1>,<10.4,1,0.2>,0.15
    pigment {DarkGreen}
   }
   box {
    <-0.1,-0.1,-0.1>,<0.2,0.4,0.2>
    pigment {DarkGreen}
   }
   cylinder {
    <0,0.4,-0.1>,<0,0.4,0.2>,0.2
    pigment {DarkGreen}
   }
   cylinder {
    <5.35,0,-0.1>,<5.35,0,0.2>,0.15
    pigment {DarkGreen}
   }
   #declare Pin_Number=0
   #while (Pin_Number<36)
    cylinder {
     <0.65+0.125*Pin_Number,0.2,-0.002>,<0.65+0.125*Pin_Number,0.2,0.2>,0.03
     pigment {DarkGreen}
    }
    #declare Pin_Number=Pin_Number+1
   #end
   #declare Pin_Number=0
   #while (Pin_Number<36)
    cylinder {
     <5.75+0.125*Pin_Number,0.2,-0.002>,<5.75+0.125*Pin_Number,0.2,0.2>,0.03
     pigment {DarkGreen}
    }
    #declare Pin_Number=Pin_Number+1
   #end
  }
 }
 // Chips on the simm
 #declare Chip_Number=0
 #while (Chip_Number<8)
  object {Memory_Chip
          rotate z*-90
          translate <0.7+1.23*Chip_Number,2.3,-0.3>
         }
  #declare Chip_Number=Chip_Number+1
 #end

 box {
  <9.4,0.4,-0.01>,<9.9,0.6,0.01>
  texture {T_Silver_3D}
 }
 box {
  <9.45,0.45,-0.011>,<9.85,0.55,-0.009>
  pigment {Green}
  finish {ambient 0.2 diffuse 0.1}
 }
 box {
  <10.4,0.2,-0.005>,<10.6,0.4,0.01>
  texture {T_Silver_3D}
 }
 box {
  <10.4,0.5,-0.005>,<10.6,0.7,0.01>
  texture {T_Silver_3D}
 }
 box {
  <10.3,1.3,-0.01>,<10.55,1.8,0.01>
  texture {T_Silver_3D}
 }
 box {
  <10.35,1.35,-0.011>,<10.5,1.75,-0.009>
  pigment {Green}
  finish {ambient 0.2 diffuse 0.1}
 }
 box {
  <10.3,1.9,-0.01>,<10.55,2.4,0.01>
  texture {T_Silver_3D}
 }
 box {
  <10.35,1.95,-0.011>,<10.5,2.35,-0.009>
  pigment {Green}
  finish {ambient 0.2 diffuse 0.1}
 }
 // Circuit tracks
 cylinder {
  <1.5,0.405,-0.001>,<1.5,0.405,0.01>,0.03
  texture {T_Copper_3C}
 }
 box {
  <1.5,0.4,-0.001>,<3.9,0.42,0.01>
  texture {T_Copper_3C}
 }
 box {
  <3.9,0.4,-0.001>,<3.92,0.25,0.01>
  texture {T_Copper_3C}
 }
 box {
  <1.15,0.5,-0.001>,<4,0.52,0.01>
  texture {T_Copper_3C}
 }
 box {
  <1.17,0.5,-0.001>,<1.15,0.25,0.01>
  texture {T_Copper_3C}
 }
 cylinder {
  <4,0.505,-0.001>,<4,0.505,0.01>,0.03
  texture {T_Copper_3C}
 }
 box {
  <1.4,0.57,-0.001>,<5.2,0.59,0.01>
  texture {T_Copper_3C}
 }
 cylinder {
  <1.4,0.575,-0.001>,<1.4,0.575,0.01>,0.03
  texture {T_Copper_3C}
 }
 box {
  <5.2,0.57,-0.001>,<5.22,0.3,0.01>
  texture {T_Copper_3C}
 }
 box {
  <5.2,0.3,-0.001>,<6.75,0.32,0.01>
  texture {T_Copper_3C}
 }
 box {
  <6.75,0.32,-0.001>,<6.77,0.25,0.01>
  texture {T_Copper_3C}
 }
 box {
  <4.4,0.25,-0.001>,<4.42,0.45,0.01>
  texture {T_Copper_3C}
 }
 cylinder {
  <4.41,0.45,-0.001>,<4.41,0.45,0.01>,0.03
  texture {T_Copper_3C}
 }
 box {
  <5.8,0.6,-0.001>,<7.9,0.62,0.01>
  texture {T_Copper_3C}
 }
 cylinder {
  <5.8,0.61,-0.001>,<5.8,0.61,0.01>,0.03
  texture {T_Copper_3C}
 }
 box {
  <7.9,0.6,-0.001>,<7.92,0.68,0.01>
  texture {T_Copper_3C}
 }
 box {
  <7.9,0.68,-0.001>,<8.2,0.7,0.01>
  texture {T_Copper_3C}
 }
 box {
  <5.5,0.45,-0.001>,<7.2,0.43,0.01>
  texture {T_Copper_3C}
 }
 box {
  <7.2,0.45,-0.001>,<7.22,0.38,0.01>
  texture {T_Copper_3C}
 }
 box {
  <7.2,0.38,-0.001>,<8,0.36,0.01>
  texture {T_Copper_3C}
 }
 cylinder {
  <8,0.37,-0.001>,<8,0.37,0.01>,0.03
  texture {T_Copper_3C}
 }
 cylinder {
  <5.5,0.44,-0.001>,<5.5,0.44,0.01>,0.03
  texture {T_Copper_3C}
 }
 box {
  <8.74,0.25,-0.001>,<8.76,0.35,0.01>
  texture {T_Copper_3C}
 }
 box {
  <8.74,0.35,-0.001>,<9.5,0.37,0.01>
  texture {T_Copper_3C}
 }
 box {
  <9.5,0.35,-0.001>,<9.52,0.47,0.01>
  texture {T_Copper_3C}
 }
 box {
  <1.2,1.55,-0.001>,<10,1.57,0.01>
  texture {T_Copper_3C}
 }
 box {
  <1.2,1.48,-0.001>,<10,1.5,0.01>
  texture {T_Copper_3C}
 }
 box {
  <1.2,1.41,-0.001>,<10,1.43,0.01>
  texture {T_Copper_3C}
 }
  object {Track_Set_1}
  object {Track_Set_2}
  object {Track_Set_3}
  object {Track_Set_4}
  object {Track_Set_2
          scale <-1,1,1>
          translate <5.8,1,0>
         }
  object {Track_Set_1
          scale <1,-1,1>
          translate <2.6,3.02,0>
         }
  object {Track_Set_4
          scale <-1,1,1>
          translate <8.4,0.95,0>
         }
  object {Track_Set_2
          scale <1,-1,1>
          translate <3.6,2.02,0>
         }
  object {Track_Set_3
          scale <1,-1,1>
          translate <3.6,4.03,0>
         }
  object {Track_Set_1
          scale <-1,1,1>
          translate <8.3,-0.89,0>
         }
  object {Track_Set_2
          scale <-1,-1,1>
          translate <9.5,2.97,0>
         }
  object {Track_Set_4
          scale <1,-1,1>
          translate <4.75,2.02,0>
         }
  object {Track_Set_3
          scale <-1,1,1>
          translate <12,0,0>
         }
  union {
   box {
    <8.7,1.32,-0.001>,<9.24,1.34,0.01>
   }
   box {
    <9.24,1.34,-0.001>,<9.26,1.25,0.01>
   }
   box {
    <9.24,1.25,-0.001>,<9.4,1.27,0.01>
   }
   box {
    <8.7,1.25,-0.001>,<9.2,1.27,0.01>
   }
   box {
    <9.2,1.25,-0.001>,<9.22,1.19,0.01>
   }
   box {
    <9.2,1.21,-0.001>,<9.5,1.19,0.01>
   }
   box {
    <8.7,1.19,-0.001>,<9.14,1.21,0.01>
   }
   box {
    <9.14,1.21,-0.001>,<9.16,1.14,0.01>
   }
   box {
    <9.14,1.14,-0.001>,<9.5,1.16,0.01>
   }
   box {
    <8.7,1.14,-0.001>,<9.09,1.16,0.01>
   }
   box {
    <9.09,1.16,-0.001>,<9.11,1.07,0.01>
   }
   box {
    <9.09,1.07,-0.001>,<9.5,1.09,0.01>
   }
   box {
    <8.7,1.07,-0.001>,<9.02,1.09,0.01>
   }
   box {
    <9.02,1.09,-0.001>,<9.04,1.01,0.01>
   }
   box {
    <9.02,1.01,-0.001>,<9.5,1.03,0.01>
   }
   box {
    <8.7,1.01,-0.001>,<8.97,1.03,0.01>
   }
   box {
    <8.97,1.01,-0.001>,<8.99,0.95,0.01>
   }
   box {
    <8.97,0.95,-0.001>,<9.5,0.97,0.01>
   }
   box {
    <8.7,0.95,-0.001>,<8.9,0.97,0.01>
   }
   cylinder {
    <8.9,0.96,-0.001>,<8.9,0.96,0.01>,0.03
   }
   box {
    <8.7,0.88,-0.001>,<9.5,0.9,0.01>
   }
   box {
    <8.7,0.76,-0.001>,<9.5,0.78,0.01>
   }
   texture {T_Copper_3C}
  }
  union {
   // odd tracks
   box {
    <10,2.3,-0.001>,<10.4,2.32,0.01>
   }
   box {
    <10,2.0,-0.001>,<10.4,2.02,0.01>
   }
   box {
    <10,1.7,-0.001>,<10.4,1.72,0.01>
   }
   box {
    <10,1.4,-0.001>,<10.4,1.42,0.01>
   }
   box {
    <10.5,1.97,-0.001>,<10.65,1.99,0.01>
   }
   box {
    <10.63,1.99,-0.001>,<10.65,1.75,0.01>
   }
   box {
    <10.5,1.75,-0.001>,<10.65,1.77,0.01>
   }
   box {
    <10.5,1.35,-0.001>,<10.6,1.37,0.01>
   }
   box {
    <10.65,1.37,-0.001>,<10.67,0.65,0.01>
   }
   box {
    <10.6,0.65,-0.001>,<10.67,0.67,0.01>
   }
   box {
    <10.5,0.4,-0.001>,<10.52,0.5,0.01>
   }
   box {
    <10.4,1.8,-0.001>,<10.42,1.95,0.01>
   }
   box {
    <10.4,0.3,-0.001>,<9.98,0.32,0.01>
   }
   box {
    <9.98,0.3,-0.001>,<10,0.25,0.01>
   }
   box {
    <10.4,0.55,-0.001>,<9.8,0.57,0.01>
   }
   box {
    <8.49,0.25,-0.001>,<8.51,0.7,0.01>
   }
   box {
    <8.24,0.25,-0.001>,<8.26,0.45,0.01>
   }
   box {
    <8.26,0.45,-0.001>,<7.4,0.47,0.01>
   }
   cylinder {
    <7.4,0.46,-0.001>,<7.4,0.46,0.01>,0.03
   }
   box {
    <8.6,0.5,-0.001>,<8.62,0.8,0.01>
   }
   box {
    <8.6,0.5,-0.001>,<9.6,0.52,0.01>
   }
   box {
    <0.8,0.25,-0.001>,<0.78,0.7,0.01>
   }
   box {
    <0.46,1.77,-0.001>,<0.6,1.79,0.01>
   }
   cylinder {
    <0.46,1.77,-0.001>,<0.46,1.79,0.01>,0.03
   }
   box {
    <0.46,2.26,-0.001>,<0.6,2.28,0.01>
   }
   cylinder {
    <0.46,2.27,-0.001>,<0.46,2.27,0.01>,0.03
   }
   texture {T_Copper_3C}
  }
 }

light_source {
 <12,10,-10> color LightBlue
}

light_source {
 <-12,-10,-40> color Gray80
}

camera {
 location <3,4,-9>
 look_at <5,1.25,0>
}

background { LemonYellow}

union {
 object {SIMM}
 object {SIMM
         scale <1,1,-1>
         translate <0,0,0.1>
        }
}
