// Useful objects include file

#include "colors.inc"
#include "woods.inc"
#include "shapes2.inc"
#include "metals.inc"
#include "glass.inc"

#declare Pages = texture
{
  pigment
  {
    gradient y
    color_map
    {
      [0.00 color rgb<0.961, 0.929, 0.671>]
      [0.02 color rgb<1.000, 1.000, 1.000>]
      [0.18 color rgb<1.000, 1.000, 1.000>]
      [0.20 color rgb<0.961, 0.929, 0.671>]
      [0.22 color rgb<1.000, 1.000, 1.000>]
      [0.38 color rgb<1.000, 1.000, 1.000>]
      [0.40 color rgb<0.961, 0.929, 0.671>]
      [0.42 color rgb<1.000, 1.000, 1.000>]
      [0.58 color rgb<1.000, 1.000, 1.000>]
      [0.60 color rgb<0.961, 0.929, 0.671>]
      [0.62 color rgb<1.000, 1.000, 1.000>]
      [0.78 color rgb<1.000, 1.000, 1.000>]
      [0.80 color rgb<0.961, 0.929, 0.671>]
      [0.82 color rgb<1.000, 1.000, 1.000>]
      [0.98 color rgb<1.000, 1.000, 1.000>]
      [1.00 color rgb<0.961, 0.929, 0.671>]
    }
    frequency 10
  }
  finish {
    ambient 0.5
    diffuse 0.41
  }
}

// A plain picture frame

#ifndef (Frame_Width)
  #declare Frame_Width=4
#end
#ifndef (Frame_Height)
  #declare Frame_Height=3
#end
#ifndef (Frame_Depth)
  #declare Frame_Depth=0.3
#end
#ifndef (Edge_Size)
  #declare Edge_Size=0.5
#end
#ifndef (Frame_Texture)
  #declare Frame_Texture= texture {T_Wood1}
#end
#ifndef (Picture)
  #declare Picture =  pigment { colour rgb<0.906,0.878,0.824> }
#end


#declare LongSide=
 prism {
  linear_sweep
  linear_spline
  0,Frame_Depth*2/3,
  5,
  <-Frame_Width/2,-Frame_Height/2>,<-Frame_Width/2,Frame_Height/2>,
  <-Frame_Width/2+Edge_Size,Frame_Height/2-Edge_Size>,
  <-Frame_Width/2+Edge_Size,-Frame_Height/2+Edge_Size>,<-Frame_Width/2,-Frame_Height/2>
  texture {Frame_Texture}
 }

#declare ShortSide=
 prism {
  linear_sweep
  linear_spline
  0,Frame_Depth*2/3,
  5;
  <-Frame_Width/2,-Frame_Height/2>,<Frame_Width/2,-Frame_Height/2>,
  <Frame_Width/2-Edge_Size,-Frame_Height/2+Edge_Size>
  <-Frame_Width/2+Edge_Size,-Frame_Height/2+Edge_Size>,<-Frame_Width/2,-Frame_Height/2>
  rotate y*90
  texture {Frame_Texture}
  rotate y*-90
 }

 #declare Backing=
  box {
   <0,0,0>,<Frame_Width-Edge_Size*2,Frame_Height-Edge_Size*2,-0.1>
   pigment {Picture
            scale <Frame_Width-Edge_Size*2,Frame_Height-Edge_Size*2,1>
           }
   rotate x*-90
   translate <-Frame_Width/2+Edge_Size,-0.3,Frame_Height/2-Edge_Size>
  }

 #declare Frame=
  union {
   object {LongSide}
   object {LongSide
          scale <-1,1,1>
          }
   object {ShortSide}
   object {ShortSide
           scale <1,1,-1>
          }
   object {Backing}
   rotate <90,0,0>
  }

#declare QuarterTorus=
 intersection {
  torus { 1, 0.3 }
  box { <0,-2,0>,<2,2,2> }
 }

#declare Handle=
 union {
  object {QuarterTorus
          scale 5
          rotate x*-90
          translate y*2.5
         }
  object {QuarterTorus
          scale 5
          rotate x*90
          translate y*-2.5
         }
  cylinder { <5,-2.5,0>,<5,2.5,0>,1.5 }
  //pigment {White}
 }

#declare cup=
 union {
  difference {
   cylinder { <0,0,0>,<0,20,0>,10 }
   cylinder { <0,3,0>,<0,30,0>,8 }
  }
  torus { 9,1}
  torus {9,1.05
         translate <0,20,0>
        }
  object {Handle
          translate <10,9.5,0>
         }
  pigment {White}
 }

#declare book=
 union {
  box { <0,0,0>,<2.5,0.5,4> texture {Pages scale 0.01} }
  box { <0,0.5,-0.05>,<2.55,0.55,4.05> pigment {NewMidnightBlue*0.5} }
  box { <0,-0.05,-0.05>,<2.55,0,4.05> pigment {NewMidnightBlue*0.5} }
  box { <-0.05,-0.05,-0.05>,<0,0.55,4.05> pigment {NewMidnightBlue*0.5} }
 }

#declare tube=
 difference {
  cylinder { <0,0,0>,<0,1,0>,0.5 }
  cylinder { <0,0.1,0>,<0,1.5,0>,0.45 }
 }

#declare Pen_Holder=
 union {
  object { tube
           scale <0.5,1.5,0.5>
           translate <0,0,0.36>
         }
  object { tube
           scale <0.5,1.2,0.5>
           translate <0.33,0,0>
         }
  object { tube
           scale <0.5,0.9,0.5>
           translate <-0.33,0,0>
         }
  object { tube
           scale <0.5,0.7,0.5>
           translate <0.5,0,-0.46>
         }
  object { tube
           scale <0.5,0.4,0.5>
           translate <-0.5,0,-0.46>
         }
  object { tube
           scale <0.5,0.2,0.5>
           translate <0,0,-0.5>
         }
  cylinder { <0,0,0>,<0,0.05,0>,0.3 }
}

#declare Pencil=
 union {
  object {Hexagon
          scale <2,0.1,0.1>
         }
  intersection {
   cone {<1.95,0,0>, 0.12, <2.45,0,0>, 0 }
   object {Hexagon
          scale <2,0.1,0.1>
          translate x*2
         }
   texture {T_Wood10}
  }
 }

#declare RollerBall=
 union {
  cylinder {
   <-2,0,0>,<2,0,0>,0.09
   texture {T_Chrome_2A}
  }
  difference {
   cylinder {
    <-1.7,0,0>,<2,0,0>,0.1
   }
   torus {
    0.1,0.005
    rotate z*90
    translate x*0.7
    pigment {Black}
    finish {ambient 0 diffuse 0}
   }
  }
  box {
   <1,-0.05,0.05>,<1.95,0.05,-0.05>
   rotate x*45
   scale <1,1,0.2>
   texture {T_Chrome_2A}
   translate z*-0.107
  }
  box {
   <1.94,-0.05,-0.107>,<1.95,0.05,-0.1>
   texture {T_Chrome_2A}
  }
 }

#declare ClockHand=
 difference {
  union {
   box {<-0.025,0,0>,<0.025,0.35,-0.01>}
   cylinder { <0,0.35,0>,<0,0.35,-0.01>,0.025 }
   texture {
    pigment { color rgb <0, 0, 0> }
   }
  }
  box { <-0.015,0.26,-0.008>,<0.015,0.34,-0.015>
        pigment {LimeGreen}
        finish {ambient 0.4}
      }
 }

#declare Bell=
 intersection {
  difference {
   sphere {
    <0,0,0>,0.25
    scale <1,0.7,1>
    texture {T_Chrome_5E}
   }
   sphere {
    <0,0,0>,0.24
    scale <1,0.7,1>
    texture {T_Chrome_5E}
   }
  }
  box {
   <-1,0,-1>,<1,1,1>
   texture {T_Chrome_5E}
  }
 }

#declare AClock=
 union {
  difference {
   superellipsoid {
    <1,0.25>
    pigment {Blue}
    scale <0.5,0.5,0.3>
   }
   cylinder {
    <0,0,-0.15>,<0,0,-0.9>,0.42
    pigment {White}
   }
  }
  cylinder {                                        // Glass face
   <0,0,-0.23>,<0,0,-0.2>,0.43
   texture {T_Glass2}
  }
  object {ClockHand
          scale <0.7,1,1>
          translate z*-0.16
          rotate z*-45
         }
  object {ClockHand
          scale <1,0.7,1>
          translate z*-0.16
          rotate z*-2
         }
  box {<-0.01,0,-0.16>,<0.01,0.35,-0.17>            // Second hand
       texture {
        pigment { color rgb <0, 0, 0> }
       }
       rotate z*-155
      }
  box {<-0.01,0,-0.16>,<0.01,0.2,-0.17>             // alarm setting
       texture {
        pigment { Brass }
       }
       rotate z*-210
      }
  cylinder { <0,0,0>,<0,0,-0.18>,0.04
             texture {
              pigment { color rgb <0, 0, 0> }
             }
           }
  text {ttf "chancery.ttf" "12" ,0.5,0
        scale 0.23
        translate <-0.07,0.25,-0.17>
        texture {
         pigment { Black }
        }
       }
  text {ttf "chancery.ttf" "6" ,0.5,0
        scale 0.23
        translate <-0.04,-0.35,-0.17>
        texture {
         pigment { Black }
        }
       }
  text {ttf "chancery.ttf" "3" ,0.5,0
        scale 0.23
        translate <0.25,-0.02,-0.17>
        texture {
         pigment { Black }
        }
       }
  text {ttf "chancery.ttf" "9" ,0.5,0
        scale 0.23
        translate <-0.35,-0.02,-0.17>
        texture {
         pigment { Black }
        }
       }

  // Hourly markings

  #declare around2=0
  #while (around2<36)
   box { <-0.005,0.36,-0.153>,<0.005,0.4,-0.15>
         #if (mod(around2,3)=0)
          pigment {Clear}
         #else
          pigment {Black}
         #end
         rotate z*-10*around2
       }
   #declare around2=around2+1
  #end
  #declare around=0
  #while (around<12)
   cylinder { <0,0.38,-0.155>,<0,0.38,-0.145>,0.015
              rotate z*-30*around
              pigment {Black}
            }
   cylinder { <0,0.38,-0.155>,<0,0.38,-0.151>,0.014
              rotate z*-30*around
              pigment {LimeGreen}
              finish {ambient 0.4}
            }
   #declare around=around+1
  #end

  // legs

  sphere { <0,-0.5,0>,0.15
           pigment {Blue}
           rotate z*33
         }
  sphere { <0,-0.5,0>,0.15
           pigment {Blue}
           rotate z*-33
         }

  // alarm

  cylinder { <0,0.49,0>,<0.0.6,0>,0.02
             pigment {Blue}
             rotate z*40
           }
  cylinder { <0,0.49,0>,<0.0.6,0>,0.02
             pigment {Blue}
             rotate z*-40
           }
  sphere { <0,1.38,0>,0.05
           pigment {Blue}
           scale <1,0.5,1>
           rotate z*40
         }
  sphere { <0,1.38,0>,0.05
           pigment {Blue}
           scale <1,0.5,1>
           rotate z*-40
         }
  object {Bell
          translate y*0.505
          rotate z*40
         }
  object {Bell
          translate y*0.505
          rotate z*-40
         }

 }

/*
light_source {
 <0,0,-30> color White
}

//background {Gray20}

camera {
 location <0,0.2,-4>
 look_at <0,0,0>
}

object {RollerBall
        pigment {RichBlue}
       }


*/
