// Author: Frank Epple.
// Some experiments with grass...

//--------------------------------------------------------------------
//                           GRASS
//--------------------------------------------------------------------

#ifndef (Min_Length) #declare Min_Length = 0.7   #end // Minimum Length of the grasses.
#ifndef (Max_Length) #declare Max_Length = 1.0   #end // Maximum Length of the grasses.
#ifndef (Min_Radius) #declare Min_Radius = 0.015 #end // Minimum Radius of the grasses.
#ifndef (Max_Radius) #declare Max_Radius = 0.025 #end // Maximum Radius of the grasses.
#ifndef (Min_Angle ) #declare Min_Angle  = 65    #end // Minimum Angle, the grasses have to the ground.
#ifndef (Number_Of ) #declare Number_Of  = 14    #end // Number of Grasses.

#ifndef (R1) #declare R1=seed(1) #end
#ifndef (R2) #declare R2=seed(2) #end
#ifndef (R3) #declare R3=seed(3) #end
#ifndef (R4) #declare R4=seed(4) #end

#declare Grass_Texture =
texture
  {
    pigment { color Green }
  }

#declare GRASS1 =
union
{
  #declare N=Number_Of

  #while (N > 0)  // main loop

    #declare Length = Min_Length+(Max_Length-Min_Length)*rand(R1)
    #declare Radius = Min_Radius+(Max_Radius-Min_Radius)*rand(R2)
    #declare Tilt = Min_Angle+(90-Min_Angle)*rand(R3)
    #declare Rot = 360*rand(R4)

    cone
      {
        <0,0,0>, Radius
        <0,Length,0>, Radius/2

        texture {Grass_Texture}
        rotate <0,0,90-Tilt>
        rotate <0,Rot,0>
      }

    #declare N = N - 1

  #end  // main loop
}
