#declare Niagint =
interior{ior 1.33 caustics 1
media{
emission <0.03,0.10,0.1>*1.1
density{
gradient x
density_map{
[0.10 color 10] [0.20 color 0.0] [0.30 color 10]
[0.40 color 0.0] [0.50 color 10] [0.60 color 0.00]
[0.70 color 10] [0.80 color 0.0] [0.90 color 10]
[1.00 color 0.0] 
}//density_map
turbulence 2
}//density
}//media
}//interior
//********************************************************************
#declare Niagint1 =
interior{ior 1.33 caustics 1
media{
emission <0.07,0.35,0.3>*0.2
density{
gradient x
density_map{
[0.10 color 500] [0.20 color 0.0] [0.30 color 500]
[0.40 color 50] [0.50 color 500] [0.60 color 50]
[0.70 color 500] [0.80 color 50] [0.90 color 500]
[1.00 color 50] 
}//density_map
scale 500
turbulence 2
lambda 1
}//density
}//media
}//interior
//********************************************************************
#declare Niagq1petrole =
texture {pigment{rgbt <0,0,0,0.9>}
finish {irid {0.25 thickness 0.5 turbulence 0.05} diffuse 0.1}
}//texture
//********************************************************************
#declare Niagq2petrole =
texture {pigment{rgbt <0,0,0,0.8>}
finish {ambient 0 diffuse 0 roughness 0.005 reflection 1}
}//texture


//********************************************************************
#declare Niagroui = texture {
      pigment {
		gradient x
		color_map{
		[0.4 color Clear]
		[1 color Red*0.6+Green*0.20 ]
		}
		turbulence 0.5
		rotate y*40
	}//pigment
	finish  {
ambient 0.1 
diffuse 0.1 
}//finish
}//texture
//********************************************************************
#declare Ymin =0;
#declare Ymax =0;

#declare Xvpmin =-1;
#declare Xvpmax =1;

#declare Yvpmin =-1;
#declare Yvpmax =1;
// ----------------------------------------
#declare Posx =0;
#declare Posy =0;
// ----------------------------------------

#macro Courbe (A,B,C,Nbobj,Bsize,Xmin,Xmax)

#declare Basic = sphere{<0,0,0>,Bsize hollow}


#declare Scx =(Xvpmax-Xvpmin)/(Xmax-Xmin);
#declare Inc = (Xmax-Xmin)/Nbobj;
#declare Posx = Xmin;
#declare Mcount = 2;
//---------------------------------
#while(Posx <= Xmax)
 #declare Ymin = min(Ymin,(A*Posx*Posx*Posx*Posx)
                          +(B*Posx*Posx*Posx)
                          +(C*Posx*Posx)
                  );
 #declare Ymax = max(Ymax,(A*Posx*Posx*Posx*Posx)
                          +(B*Posx*Posx*Posx)
                          +(C*Posx*Posx)
                  );                  
 #declare Posx = Posx+Inc;              
#end

#declare Scy =(Yvpmax-Yvpmin)/(Ymax-Ymin);
//---------------------------------
#declare Posx = Xmin;


merge{
#while(Posx <= Xmax)
 #declare Posy = (A*Posx*Posx*Posx*Posx)+(B*Posx*Posx*Posx)
                          +(C*Posx*Posx);
 object{Basic
        scale <0.5,0.5,1>*Bsize*log(Mcount)
        translate <Posx*Scx,Posy*Scy,0>
        }                                 
 #declare Posx = Posx+Inc;
 #declare Mcount = Mcount+1;

               
#end
}//merge
#end
//********************************************************************
#declare Niagbato =
object{Courbe(0,0,1,150,0.2,0,1) 
texture{pigment{color rgbt<0,0,0,0.8>}}
interior{Niagint}
scale <1,0.2,10>*0.8
rotate<90,90,0>
translate<1.0,0,3>
}//object
//********************************************************************
#declare Niagbouee =
object{
merge{
cone
{
  0.3*y,  0.1,
  0*y, 0.25
   open
   }//cone
cone
{
  0*y,  0.25,
  -0.3*y, 0.1
   open
   }//cone
cylinder{<0,0,0>,<0,0.3>,0.03 translate <0,0.3,0>}
sphere{<0,0,0>,0.05 translate<0,0.6,0>}     
}//merge
   texture{
   pigment{color rgbt<1,1,0,0>}
   finish{ambient 0.2 diffuse 0.5 
   roughness 0.5 phong 1 
   phong_size 20 reflection 0.5
   }//finish
   normal{bumps scale 0.05}
   }//texture
}//object
//********************************************************************


