#declare Fountain =
union {

lathe { quadratic_spline
17,
<0.0000,1.2000>,
<0.5743,1.2000>,
<0.5743,1.2867>,
<0.5062,1.3094>,
<0.6045,1.3548>,
<0.5138,1.4001>,
<0.6347,1.4908>,
<0.9774,1.5890>,
<2.4744,2.1936>,
<0.8564,1.7175>,
<0.2138,1.7024>,
<0.3725,1.8233>,
<0.2759,1.9971>,
<0.3499,2.1331>,
<0.2138,2.2540>,
<0.3272,2.3683>,
<-0.0057,2.3714>
texture{T_Fountain}
}

cylinder {<0,0,0><0,1.2,0>,.6 texture{T_Fountain}}

#local Count1 = 0;
#local Radqty = 300;
#local Maxv = 0.2;
#local Minv = 0.05;
#local Sval = 0.7;
#local Apple = seed(33); 
#local Mterm1 = 2.15;
#local Mterm2 = 1;

#local Stlen = 1.5;
#local Gdir = 1;  

#local Gfact = (Maxv - Minv);

// water over flow of fountain rim

blob { threshold 0.75

#while (Count1 < Radqty)  

	#local Rvalue = rand(Apple);
	#if (Rvalue > Sval)
		#if (Gdir = 1)
			#local Gdir = -1;
		#else
			#local Gdir = 1;
		#end
	#end 
	
	#local Rvalue = (Apple);
	#local Dchg = (Rvalue * Gfact * Gdir);
	#local Stlen = (Stlen + Dchg);
		
	#if (Stlen > (Mterm1 - 0.1))
		#local Stlen = (Mterm1 - 0.05);
		#local Gdir = -1;
	#end 
	
	#if (Stlen < Mterm2)
		#local Stlen = Mterm2;
		#local Gdir = 1;
	#end

	cylinder {<2.47,2.15,0><2.47,Stlen,0>,.1,1 rotate <0,(Count1 * (360 / Radqty)),0>}  
	
	#local Count1 = (Count1 + 1);
#end    
texture{T_Water2}
interior{ior 1.2}
}

// fountain 

#local Maxht = 5;
#local Stht = 2.3;

merge {

blob { threshold 0.75
	cylinder {<0,2.3,0><0,5,0>,.2,1} 
	#while (Stht < Maxht)
		#local Centvar = (.1 * rand(Apple));
		#local Hghtvar = (.25 * rand(Apple));
		#local Radvar = ((.75 * rand(Apple)) + .25); 
		#local Rotvar = (360 * rand(Apple));
		
		#local Stht = (Stht + Hghtvar);
		sphere {<0,Stht,0>,(Radvar * .3),1 translate <0,0,Centvar> rotate <0,Rotvar,0>}
		
	#end   
	sphere {<0,0,0>,.4,1 scale <1,.5,1> translate <0,5,0>}
	
texture{T_Water2}
interior{ior 1.2}
}   

#local Count1 = 0;
#local Sphereqty = 300;
#local Spmaxr = 0.05;
#local Spminr = 0.005;
#local Sphvar = (Spmaxr - Spminr);
#local Locmaxr = 0.3;
#local Locmaxh = 5.3; 
#local Locminh = 2.1;
#local Locvar = (Locmaxh - Locminh);
#while (Count1 < Sphereqty)
	#local S1 = rand(Apple);
	#if (S1 < .5) #local S1 = -1; #else #local S1 = 1; #end
	#local S2 = rand(Apple);
	#if (S2 < .5) #local S2 = -1; #else #local S2 = 1; #end 
	#local Xpnt = (((Locmaxr * rand(Apple)) + .1)* S1);
	#local Zpnt = (((Locmaxr * rand(Apple)) + .1)* S2);
	#local Ypnt = ((rand(Apple) * Locvar) + Locminh);
	#local Nrad = ((rand(Apple) * Sphvar) + Spminr); 
	
	sphere {<Xpnt,Ypnt,Zpnt>,Nrad texture{T_Water2} interior{ior 1.2}}
	
    #local Count1 = (Count1 + 1);
#end
}

}