// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3.1
// Desc: pools.inc
// Date: September 1998
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998  


#declare Trand = seed(13);
#include "tiles.inc"

#declare Pool_One =
union {   
	difference {
		union { 
			cylinder {<0,0,0><0,.3,0>,3.9}
			cylinder {<0,0,0><0,.6,0>,3.6}
			cylinder {<0,0,0><0,.9,0>,3.3}
			cylinder {<0,0,0><0,1.2,0>,3}
		}
		cylinder {<0,-5,0><0,5,0>,2.7}
	} 
	#if (Water_Effects = on)
		cylinder {<0,0,0><0,1,0>,2.7 texture{T_Water}	interior{ior 1.2 caustics 0.5}}
	#end        
	#if (Pool_Tiles = on)
		Lay_Tile2 (3,0.9)
		Lay_Tile2 (3.3,0.6)
		Lay_Tile2 (3.6,0.3)
		Lay_Tile2 (3.9,0) 
		Lay_Tile3 (2.7,1.2)  
		Lay_Tile5 (2.7,1.2,0,360)
		Lay_Tile5 (3,.9,0,360)
		Lay_Tile5 (3.3,.6,0,360)
		Lay_Tile5 (3.6,.3,0,360) 
	#end
}

#declare Pool_Two = 
union {  
	difference {
		union { 
			cylinder {<0,0,0><0,.3,0>,3.1}
			cylinder {<0,0,0><0,.6,0>,2.8}
			cylinder {<0,0,0><0,.9,0>,2.5}
		}
		cylinder {<0,-5,0><0,5,0>,2.2}
	} 
	#if (Water_Effects = on)
		cylinder {<0,0,0><0,.7,0>,2.2 texture{T_Water} interior{ior 1.2 caustics 0.5}} 
	#end   
	#if (Pool_Tiles = on)                          
		Lay_Tile2 (2.5,0.6)
		Lay_Tile2 (2.8,0.3)
		Lay_Tile3 (2.2,.9) 
		difference {
			union { 
				Lay_Tile5 (2.2,.9,-50,255)
				Lay_Tile5 (2.5,.6,-33,250) 
				Lay_Tile5 (2.8,.3,-33,236)
			}
			union { 
				cylinder {<-5,0,1><-5,.35,1>,3.9 pigment{White}}
				cylinder {<-5,0,1><-5,.65,1>,3.6 pigment{White}}
				cylinder {<-5,0,1><-5,.95,1>,3.3 pigment{White}}
			}
		}
	#end
}

#declare Pool_Three = 
union { 
	difference {
		union {    
			cylinder {<0,0,0><0,.3,0>,2.9}
			cylinder {<0,0,0><0,.6,0>,2.6}
		}
		cylinder {<0,-5,0><0,5,0>,2.3}
	}              
	#if (Water_Effects = on)
		cylinder {<0,0,0><0,.4,0>,2.3 texture{T_Water} interior{ior 1.2 caustics 0.5}} 
	#end     
	#if (Pool_Tiles = on)
		Lay_Tile3 (2.3,.6)  
		difference {
			union {
				Lay_Tile5 (2.3,.6,-4,20)
				Lay_Tile5 (2.3,.6,290,310)
			}
			union {   
				cylinder {<-2.5,0,5><-2.5,2,5>3.6 pigment{White}}
				cylinder {<2.5,0,4><2.5,2,4>2.8 pigment{White}}
			}
		}
	#end 
}

#declare Pool_Group =
union {         
	object {Pool_One}
	object {Pool_Two   translate<5,0,-1>}
	object {Pool_Three translate<2.5,0,-5>}  
}