// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: scenery.inc
// Date: September 1998
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998  

#declare Wall_Height = 6;
#declare Dome_Radius = 7; 


#declare Vcut_Rib =
merge {    
	difference {
		sphere {<0,0,0>7.3 texture{TD5}}   
		sphere {<0,0,0>,6.9 texture{TD5}}
		box {<-.2,-10,-10><-10,10,10> texture{TD5}}
		box {<.2,-10,-10><10,10,10> texture{TD5}}
		box {<100,0,100><-100,-100,-100> texture{TD5}}
	}
	difference {
		sphere {<0,0,0>7.3 texture{TD2}}   
		sphere {<0,0,0>,7 texture{TD2}}
		box {<-.3,-10,-10><-10,10,10> texture{TD2}}
		box {<.3,-10,-10><10,10,10> texture{TD2}}
		box {<100,0,100><-100,-100,-100> texture{TD2}}  
		
	}
	difference {
		sphere {<0,0,0>7.3 texture{TD3}}   
		sphere {<0,0,0>,7.1 texture{TD3}}
		box {<-.4,-10,-10><-10,10,10> texture{TD3}}
		box {<.4,-10,-10><10,10,10> texture{TD3}}
		box {<100,0,100><-100,-100,-100> texture{TD3}}    
	}     
	bounded_by { 
		difference {
			sphere {<0,0,0>,7.3}
			sphere {<0,0,0>,6.89}
			box {<7.5,0,7.5><-7.5,-7.5,-7.5>}
			box {<-.41,7.5,7.5><-7.5,-7.5,-7.5>} 
			box {<.41,7.5,7.5><7.5,-7.5,-7.5>}
		}
	}       
}

#macro Hcut_Rib (Crad,Rcentre,Rwidth,Gettex)
	difference { 
		sphere {<0,0,0>7.3 texture{Gettex}}     
		sphere {<0,0,0>,Crad texture{Gettex}} 
		box {<100,0,100><-100,-100,-100> texture{Gettex}}
		#local Cqty = abs(7 / Rcentre);  
		#local Cutw = (Rcentre - Rwidth);
		#local Count1 = 0;
		#while (Count1 < Cqty)
			box {<20,(Cutw / 2),20><-20,(Cutw / -2),-20> translate <0,(Count1 * Rcentre),0> texture{Gettex}}
			#local Count1 = (Count1 + 1);
		#end
	}
#end


#declare Centre_Dome_Upper =
union {
	#local Count1 = 0;
	#while (Count1 < 13)
		object {Vcut_Rib rotate <0,(Count1 * (180 / 13)),0>}
		#local Count1 = (Count1 + 1);
	#end 
	Hcut_Rib (6.95,1,.4,TD1)
	Hcut_Rib (7.05,1,.6,TD2)
	Hcut_Rib (7.15,1,.8,TD3)
	difference {
		sphere {<0,0,0>,7.3 texture{TD4}}
		sphere {<0,0,0>,7.2 texture{TD4}}
		box {<100,0,100><-100,-100,-100> texture{TD4}}
	}
}

#declare Dentil =
union {      
	box {<-.15,-.2,0><.15,-.25,-.25> texture{TD2}}
	box {<-.1,-.2,0><.1,-.4,-.2> texture{TD2}}
}

#declare Dome_Entablature =
union { 
	difference {
		box {<-7,0,-7><7,-.1,7> texture{TD2}}
		cylinder {<0,-10,0><0,10,0>,6 texture{TD2}}
	}
	difference {
		box {<-7,-.1,-7><7,-.2,7> texture{TD3}}
		cylinder {<0,-10,0><0,10,0>,6.1 texture{TD3}}
	} 
	difference {
		box {<-7,-.2,-7><7,-.5,7>}
		cylinder {<0,-10,0><0,10,0>,6.5}
	}
	difference {
		box {<-7,-.5,-7><7,-.6,7>}
		cylinder {<0,-10,0><0,10,0>,6.3}
	}
	difference {
		box {<-7,-.6,-7><7,-.8,7>}
		cylinder {<0,-10,0><0,10,0>,6.5}
	}  
	#local Count1 = 0;
	#local Dqty = 60;
	#while (Count1 < Dqty)
		object {Dentil translate <0,0,6.5> rotate <0,(Count1 * (360 / Dqty)),0>}
		#local Count1 = (Count1 + 1);
	#end
}

#declare Tdome =
difference {
	sphere {<0,0,0>,7.3}
	sphere {<0,0,0>,7}
	box {<100,0,100><-100,-100,-100>}
}

#declare Dcolumn = 
union {
	Generic_Column (<0,0,7>,4.8,1,18,2,4,2,2)
}

#declare Centre_Dome =
union {  
	#if (Dome_Test = off)
		object {Centre_Dome_Upper translate <0,Wall_Height,0>} 
		#else
		object {Tdome translate <0,Wall_Height,0>}
	#end    
	object {Dome_Entablature translate <0,Wall_Height,0> texture{TD1}}    
	#local Count1 = 0;
	#local Colqty = 14;
	#while (Count1 < Colqty)
		object {Dcolumn rotate <0,(Count1 * (360 / Colqty)),0>}
		#local Count1 = (Count1 + 1);
	#end
	
	
	difference {
		box {<(Dome_Radius + .3),0,(Dome_Radius + .3)><((Dome_Radius + .3) * -1),(Wall_Height + .3),((Dome_Radius + .3) * -1)>}
		box {<Dome_Radius,-1,Dome_Radius><(Dome_Radius * -1),Wall_Height,(Dome_Radius * -1)> texture {T_Wall1}} 
		cylinder {<0,-10,0><0,(Wall_Height * 2),0>,Dome_Radius}
	} 

	box {<-7,0,-7><-6.9,2.5,7> texture{checker texture{T5n scale 2}, texture{T6n scale 5} scale .5}}
	box {<-7,0,7><7,2.5,6.9> texture{checker texture{T5n scale 2}, texture{T6n scale 5} scale .5}} 
	
	box {<-7,2.6,-7><-6.8,2.5,7> texture{checker texture{T2 scale 2}, texture{T7 scale 5} scale .5}}
	box {<-7,2.6,7><7,2.5,6.8> texture{checker texture{T2 scale 2}, texture{T7 scale 5} scale .5}}  
	
	box {<-7,5.1,-7><-6.8,5.2,7> texture{checker texture{T2 scale 2}, texture{T7 scale 5} scale .5}}
	box {<-7,5.1,7><7,5.2,6.8> texture{checker texture{T2 scale 2}, texture{T7 scale 5} scale .5}}  
	
	box {<-7,2.6,-7><-6.9,2.9,7> texture{checker texture{T1}, texture{T2} scale .1}}
	box {<-7,2.6,7><7,2.9,6.9> texture{checker texture{T1}, texture{T2} scale .1}}  
	
	box {<-7,4.8,-7><-6.9,5.1,7> texture{checker texture{T1}, texture{T2} scale .1}}
	box {<-7,4.8,7><7,5.1,6.9> texture{checker texture{T1}, texture{T2} scale .1}} 

}