// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: t_youth.inc
// Date: September 1998
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998 

// texture definitions for 13youth.pov . The Fountain of Youth.

#declare T_Water =
texture{pigment{
	rgbft <.8,.8,.9,.5,.3>
	}   
	finish {
		phong 1 reflection 0.3
	}
	normal{
		bumps .25 scale .2 turbulence .2
	}   
}

// pool tile definiitions

#declare T1 = texture
{
  pigment
  {
    bozo
    turbulence 1.2
    color_map
    {
      [0.00 color rgb<0.929, 0.780, 0.341>]
      [0.28 color rgb<0.925, 0.820, 0.514>]
      [0.45 color rgb<0.980, 0.827, 0.373>]
      [0.65 color rgb<0.965, 0.882, 0.635>]
      [0.81 color rgb<0.965, 0.765, 0.173>]
      [1.00 color rgb<0.961, 0.875, 0.620>]
    }
    scale .5
  }
  finish {
    brilliance 2.0
    specular 0.4    roughness 0.01    metallic
    phong 1.0    metallic
    reflection 0.2
  }
}

#declare T2 = texture
{
  pigment
  {
    bozo
    turbulence 1.2
    color_map
    {
      [0.00 color rgb<0.859, 0.918, 0.929>]
      [0.28 color rgb<0.925, 0.925, 0.925>]
      [0.45 color rgb<0.925, 0.969, 0.980>]
      [0.65 color rgb<0.965, 0.965, 0.965>]
      [0.81 color rgb<0.890, 0.949, 0.965>]
      [1.00 color rgb<0.961, 0.961, 0.961>]
    }       
    scale .5
  }
  finish {
    specular 0.4    roughness 0.01    metallic
    phong 1.0    metallic
    reflection 0.1
  }
}

#declare T3 = texture
{
  pigment
  {
    gradient y
    turbulence 0.8  octaves 7  omega 0.12  lambda 3.2
    color_map
    {
      [0.00 color rgb<0.043, 0.157, 0.506>]
      [0.09 color rgb<0.361, 0.459, 0.757>]
      [0.20 color rgb<0.027, 0.137, 0.467>]
      [0.27 color rgb<0.494, 0.604, 0.941>]
      [0.33 color rgb<0.039, 0.192, 0.647>]
      [0.45 color rgb<0.373, 0.518, 0.949>]
      [0.60 color rgb<0.784, 0.851, 0.867>]
      [0.69 color rgb<0.753, 0.871, 0.898>]
      [0.82 color rgb<0.961, 0.961, 0.961>]
      [1.00 color rgb<0.808, 0.941, 0.969>]
    }
    scale .1   
    translate <0,-.05,0>
  }
  finish {
    specular 0.4    roughness 0.01    metallic
    phong 1.0    metallic
    reflection 0.1
  }
} 

#declare T4 = texture
{
  pigment
  {
    gradient y
    turbulence 0.8  octaves 7  omega 0.12  lambda 3.2
    color_map
    {
      [0.00 color rgb<0.043, 0.157, 0.506>]
      [0.09 color rgb<0.361, 0.459, 0.757>]
      [0.20 color rgb<0.027, 0.137, 0.467>]
      [0.27 color rgb<0.494, 0.604, 0.941>]
      [0.33 color rgb<0.039, 0.192, 0.647>]
      [0.45 color rgb<0.373, 0.518, 0.949>]
      [0.60 color rgb<0.784, 0.851, 0.867>]
      [0.69 color rgb<0.753, 0.871, 0.898>]
      [0.82 color rgb<0.961, 0.961, 0.961>]
      [1.00 color rgb<0.808, 0.941, 0.969>]
    }
    scale .1
    translate <5,-.05,5>
  }
  finish {
    specular 0.4    roughness 0.01    metallic
    phong 1.0    metallic
    reflection 0.1
  }
}

#declare T5 = texture
{
  pigment
  {
    bozo
    turbulence 1.2
    color_map
    {
      [0.00 color rgb<0.141, 0.267, 0.635>]
      [0.28 color rgb<0.604, 0.690, 0.949>]
      [0.45 color rgb<0.020, 0.106, 0.361>]
      [0.65 color rgb<0.243, 0.416, 0.925>]
      [0.81 color rgb<0.231, 0.325, 0.616>]
      [1.00 color rgb<0.039, 0.208, 0.710>]
    }       
    scale .5
  }
  finish {
    specular 0.4    roughness 0.01    metallic
    phong 1.0    metallic
    reflection 0.1
  }
}   

#declare T6 = texture
{
  pigment
  {
    bozo
    turbulence 1.2
    color_map
    {
      [0.00 color rgb<0.141, 0.267, 0.635>]
      [0.28 color rgb<0.604, 0.690, 0.949>]
      [0.45 color rgb<0.020, 0.106, 0.361>]
      [0.65 color rgb<0.243, 0.416, 0.925>]
      [0.81 color rgb<0.231, 0.325, 0.616>]
      [1.00 color rgb<0.039, 0.208, 0.710>]
    }       
    scale .5 
    translate <1,3,5>
  }
  finish {
    specular 0.4    roughness 0.01    metallic
    phong 1.0    metallic
    reflection 0.1
  }
}

#declare T7 = texture
{
  pigment
  {
    bozo
    turbulence 1.2
    color_map
    {
      [0.00 color rgb<0.506, 0.541, 0.635>]
      [0.28 color rgb<0.863, 0.882, 0.949>]
      [0.45 color rgb<0.663, 0.690, 0.761>]
      [0.65 color rgb<0.808, 0.839, 0.925>]
      [0.81 color rgb<0.600, 0.604, 0.616>]
      [1.00 color rgb<0.780, 0.780, 0.780>]
    }  
    scale .1
  }
  finish {
    specular 0.4    roughness 0.01    metallic
    phong 1.0    metallic
    reflection 0.1
  }
}

// spec definitions with normals

#declare T1n = texture
{
  pigment
  {
    bozo
    turbulence 1.2
    color_map
    {
      [0.00 color rgb<0.929, 0.780, 0.341>]
      [0.28 color rgb<0.925, 0.820, 0.514>]
      [0.45 color rgb<0.980, 0.827, 0.373>]
      [0.65 color rgb<0.965, 0.882, 0.635>]
      [0.81 color rgb<0.965, 0.765, 0.173>]
      [1.00 color rgb<0.961, 0.875, 0.620>]
    }
    scale .5
  }
  finish {
    brilliance 2.0
    specular 0.4    roughness 0.01    metallic
    phong 1.0    metallic
    reflection 0.2
  }  
  normal {dents 1 scale .1}
}


#declare T5n = texture
{
  pigment
  {
    bozo
    turbulence 1.2
    color_map
    {
      [0.00 color rgb<0.141, 0.267, 0.635>]
      [0.28 color rgb<0.604, 0.690, 0.949>]
      [0.45 color rgb<0.020, 0.106, 0.361>]
      [0.65 color rgb<0.243, 0.416, 0.925>]
      [0.81 color rgb<0.231, 0.325, 0.616>]
      [1.00 color rgb<0.039, 0.208, 0.710>]
    }       
    scale .25
  }
  finish {
    specular 0.4    roughness 0.01    metallic
    phong 1.0    metallic
    reflection 0.1
  }   
  normal {quilted 1 scale .1}
}   

#declare T6n = texture
{
  pigment
  {
    bozo
    turbulence 1.2
    color_map
    {
      [0.00 color rgb<0.141, 0.267, 0.635>]
      [0.28 color rgb<0.604, 0.690, 0.949>]
      [0.45 color rgb<0.020, 0.106, 0.361>]
      [0.65 color rgb<0.243, 0.416, 0.925>]
      [0.81 color rgb<0.231, 0.325, 0.616>]
      [1.00 color rgb<0.039, 0.208, 0.710>]
    }       
    scale .25 
    translate <1,3,5>
  }
  finish {
    specular 0.4    roughness 0.01    metallic
    phong 1.0    metallic
    reflection 0.1
  } 
  normal {quilted 1 scale .1}
}



// dome definitions

#declare TD1 = texture
{
  pigment
  {
    bozo
    turbulence 1.2
    color_map
    {
      [0.00 color rgb<0.894, 0.941, 0.980>]
      [0.25 color rgb<0.722, 0.792, 0.839>]
      [0.41 color rgb<1.000, 1.000, 1.000>]
      [0.58 color rgb<0.827, 0.953, 0.976>]
      [0.74 color rgb<0.831, 0.871, 0.933>]
      [1.00 color rgb<1.000, 1.000, 1.000>]
    }
    scale .1
  }
  finish {
    phong 1.0 
  }
}

#declare TD2 = texture
{
  pigment
  {
    colour rgb<0.996,0.808,0.408>
  }
  finish {
    brilliance 2.0
    phong 1.0    metallic
    reflection 0.6
  }
}

#declare TD3 = texture
{
  pigment
  {
    bozo
    turbulence 1.2
    color_map
    {
      [0.00 color rgb<0.141, 0.267, 0.635>]
      [0.28 color rgb<0.604, 0.690, 0.949>]
      [0.45 color rgb<0.020, 0.106, 0.361>]
      [0.65 color rgb<0.243, 0.416, 0.925>]
      [0.81 color rgb<0.231, 0.325, 0.616>]
      [1.00 color rgb<0.039, 0.208, 0.710>]
    }       
    scale .1
  }
  finish {
    specular 0.4    roughness 0.01    metallic
    phong 1.0    metallic
    reflection 0.1
  }   
}   

#declare TD4 = T7 

#declare TD5 = texture
{
  pigment
  {
    granite
    turbulence 1.2
    color_map
    {
      [0.00 color rgb<0.894, 0.941, 0.980>]
      [0.25 color rgb<0.722, 0.792, 0.839>]
      [0.41 color rgb<1.000, 1.000, 1.000>]
      [0.58 color rgb<0.827, 0.953, 0.976>]
      [0.74 color rgb<0.831, 0.871, 0.933>]
      [1.00 color rgb<1.000, 1.000, 1.000>]
    } 
    scale .1
  }
  finish {
    ambient 0.2
    phong 1.0
  }
}


// wall defnitions

#declare T_Wall1 = texture{pigment{
	bozo
	color_map {
		[0.0 rgb <1.000,0.886,0.561>] 
		[1.0 rgb <.9,0.756,0.361>]
	}       
	scale .2
	turbulence .5
	}
	normal{crackle .2 scale .2 turbulence .5}
	finish{phong .2}
}

#declare T_Fountain = texture{
	bozo 
	texture_map {
		[0.0 TD1]
		[0.5 TD1]
		[0.6 TD2]
		[0.65 TD1]
		[0.8 TD1]
		[0.85 TD3]
		[0.9 TD1]
	}
	turbulence .75 
}   

#declare T_Water2 = 
texture{pigment{
	rgbft <.8,.8,.9,.4,.5>
	}   
	finish {
		phong 0.75 reflection 0.2 phong_size 100
	}  
}


//Baby Skin
#macro T_Skin1 (Coffset) 
texture
{
  pigment
  {
    bozo
    turbulence 1.2  octaves 4  omega 0.31  lambda 4.4
    color_map
    {
      [0.00 color rgb(<0.949, 0.867, 0.792> * Coffset)]
      [0.20 color rgb(<0.933, 0.855, 0.784> * Coffset)]
      [1.00 color rgb(<0.980, 0.898, 0.741> * Coffset)]
    }
    scale .1
  }
  finish {
    phong 0.2    phong_size 16
  }
}
#end

#declare T_Nap1 =
texture{
	pigment{White}
	normal{gradient y .5 scale .2} 
	finish {phong .2}
}

#declare T_Nap2 =
texture{
	pigment{Gray90}
	normal{gradient x .5 scale .2}
	finish {phong .2}
}

#declare T_Nappy = texture{checker texture{T_Nap1} texture{T_Nap2} scale .01}

#declare T_Eye1 = texture
{
  pigment
  {
    leopard
    color_map
    {
      [0.00 color rgb<0.749, 0.767, 0.992>]
      [0.10 color rgb<0.133, 0.755, 0.984>]
      [0.20 color rgb<1,1,1>]
      [1.00 color rgb<1,1,1>]
    } 
    scale .005
  }
  finish {
    phong 1
  }
}

#declare T_Hair = texture
{
  pigment
  {
    gradient y
    turbulence 0.4  octaves 5  omega 0.69  lambda 3.2
    color_map
    {
      [0.00 color rgb<0.255, 0.149, 0.012>]
      [0.43 color rgb<0.490, 0.251, 0.031>]
      [0.46 color rgb<0.361, 0.243, 0.063>]
      [0.73 color rgb<0.000, 0.000, 0.000>]
      [0.81 color rgb<0.333, 0.227, 0.102>]
      [1.00 color rgb<0.533, 0.286, 0.055>]
    }
  }   
  scale .01
  normal
  {
    gradient y .4
    turbulence 0.4  octaves 5  omega 0.69  lambda 4.4 
    scale .01
  }
  finish {
    phong 0.4
  }
}

