// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: tiles.inc
// Date: September 1998
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998     

// 50 x 50 base tile
#declare Tile50 =
superellipsoid {<.1,.1> scale <.023,.023,.0125> translate <0,-.025,0>}
      
// 100 x 100 base tile
#declare Tile100 =
superellipsoid {<.1,.1> scale <.048,.048,.0125> translate <0,-.05,0>}

// 50 x 50 base tile horizontal
#declare Tile50h =
superellipsoid {<.1,.1> scale <.023,.0125,.023> translate<0,0,.025>}
      
// 100 x 100 base tile horizontal
#declare Tile100h =
superellipsoid {<.1,.1> scale <.048,.0125,.048> translate<0,0,.05>}

// Circular vertical tile macro 1
#macro Lay_Tile1 (Tsize,Ttran,Crad,Tex1,Tex2,Modplus)
	#local Ccirc = (2 * pi * Crad);
	#local Tqty = (abs(Ccirc / Tsize) - 1);
	#local Trot = (360 / Tqty);
	#local Count1 = 0;
	#while (Count1 < Tqty)  
		#local Ttype = mod((Count1 + Modplus),2);
		#if (Tsize = .05)
			object {Tile50 translate <0,Ttran,Crad> rotate <0,(Count1 * Trot),0> 
			#if (Ttype = 0)
				texture{Tex1}
			#else
				texture{Tex2}
			#end
			}
		#else 
			object {Tile100 translate <0,Ttran,Crad> rotate <0,(Count1 * Trot),0> 
			#if (Ttype = 0)
				texture{Tex1}
			#else
				texture{Tex2}
			#end
			}
		#end
		#local Count1 = (Count1 + 1);
	#end
#end

// circular vertical tile macro 2
#macro Lay_Tile2 (Crad,Vtran) 
	#local Tile_Group =  
	union {
		Lay_Tile1 (.05,0.3,Crad,T1,T2,0) 
		Lay_Tile1 (.05,0.25,Crad,T1,T2,1)
		Lay_Tile1 (.1,0.2,Crad,T3,T4,0)
		Lay_Tile1 (.1,0.1,Crad,T5,T6,1) 
	}
	object {Tile_Group translate <0,Vtran,0>}
#end	

// macro 3. interior wall of a pool
#macro Lay_Tile3 (Crad,Vheight)  
	Lay_Tile1 (.05,Vheight,Crad,T1,T2,0)
	Lay_Tile1 (.05,(Vheight - .05),Crad,T1,T2,1) 
	
	#local Top_Wall = 0;

	#local Tqty = ((Vheight - .1) / .1); 
	#local Mtype = 0;
	#local Count1 = 0;   
	#while (Count1 < Tqty)
		#local Nheight = ((Vheight - .1) - (Count1 * .1)); 
		#if (Top_Wall = 0)
			Lay_Tile1 (.1,Nheight,Crad,T3,T4,Mtype) 
			#local Top_Wall = 1;
			#else 
			Lay_Tile1 (.1,Nheight,Crad,T5,T6,Mtype)
		#end 
		#if (Mtype = 0)
			#local Mtype = 1;
		#else
			#local Mtype = 0;
		#end
		#local Count1 = (Count1 + 1);
	#end

#end   

// the horizontal surface macro set
#macro Lay_Tile4 (Tsize,Crad,Tex1,Tex2,Modplus,Sangle,Eangle)     

	#local Tarc = (Eangle - Sangle);					// swept arc 

	#local Ccirc = ((2 * pi * Crad) * (Tarc / 360));    // length of arc
	#local Tqty = (abs(Ccirc / Tsize) -1);
	#local Trot = (Tarc / Tqty);
	#local Count1 = 0;
	#while (Count1 < Tqty)
		#local Ttype = mod((Count1 + Modplus),2);
		#if (Tsize = .05)
			object {Tile50h translate <0,0,Crad> rotate <0,(Sangle + (Count1 * Trot)),0> 
			#if (Ttype = 0)
				texture{Tex1}
			#else
				texture{Tex2}
			#end
			}
		#else 
			object {Tile100h translate <0,0,Crad> rotate <0,(Sangle + (Count1 * Trot)),0> 
			#if (Ttype = 0)
				texture{Tex1}
			#else
				texture{Tex2}
			#end
			}
		#end
		#local Count1 = (Count1 + 1);
	#end
#end

// circular Horizontal tile macro 5
#macro Lay_Tile5 (Crad,Vtran,Sangle,Eangle)  
	#local Rad1 = Crad;
	#local Rad2 = (Crad + .05);
	#local Rad3 = (Rad2 + .05);
	#local Rad4 = (Rad3 + .1);
	#local Rad5 = (Rad4 + .05);
	#local Tile_Group =  
	union {
		Lay_Tile4 (.05,Rad1,T1,T2,0,Sangle,Eangle) 
		Lay_Tile4 (.05,Rad2,T1,T2,1,Sangle,Eangle)
		Lay_Tile4 (.1,Rad3,T7,T2,0,Sangle,Eangle)
		Lay_Tile4 (.05,Rad4,T1,T2,1,Sangle,Eangle)
		Lay_Tile4 (.05,Rad5,T1,T2,0,Sangle,Eangle) 
	}
	object {Tile_Group translate <0,Vtran,0>}
#end	
