// Persistence of Vision Ray Tracer Include File
// File: arrival_envir.inc
// Vers: 3
// Desc:
// Date:
// Auth: Sergei P. Shuvalkin

#declare ISOTROPIC_SCATTERING         = 1
#declare MIE_HAZY_SCATTERING          = 2
#declare MIE_MURKY_SCATTERING         = 3
#declare RAYLEIGH_SCATTERING          = 4
#declare HENYEY_GREENSTEIN_SCATTERING = 5
#declare Scene_atmosphere =
atmosphere {
  type MIE_HAZY_SCATTERING
  distance 90
  scattering 0.09
  samples 11
  aa_threshold 0.1
  aa_level 3
  color Black }

#declare Scene_ground =
height_field { tga "arrival_hf.tga" smooth
	translate <-.5, -0.450, -.5>
	scale <256.000, 47.233, 256.000>
	rotate <0, 90, 0> texture{ Simple2 }}

#declare Searchlight0 =
light_source { <50,60,-20> color White
  area_light <1,0,0>, <0,1,0>, 3, 3
  adaptive 3
  spotlight
  point_at <5, 12, -8>
  radius 10
  tightness 50
  falloff 16 }
#declare Searchlight1 =
light_source { <50,60,0> color White
  area_light <1,0,0>, <0,1,0>, 3, 3
  adaptive 3
  spotlight
  point_at <5, 12, 12>
  radius 10
  tightness 50
  falloff 16 }
#declare Searchlight2 =
light_source { <50,60,20> color White
  area_light <1,0,0>, <0,1,0>, 3, 3
  adaptive 3
  spotlight
  point_at <5, 12, 32>
  radius 10
  tightness 50
  falloff 16 }
#declare Searchlight3 =
light_source { <50,60,40> color White
  area_light <1,0,0>, <0,1,0>, 3, 3
  adaptive 3
  spotlight
  point_at <5, 12, 52>
  radius 10
  tightness 50
  falloff 16 }

#declare Border_brick =
  box{ <-0.1,-0.1,-0.98>, <0.1,0.2,0.98> texture{ Simple1 }}

#declare WW1=
union{
  intersection{
    torus{ 0.1, 0.02 rotate 90*x }
    plane{ -y, 0 } translate 0.1*y }
  cylinder{ <-0.1,0,0>, <-0.1,0.1,0>, 0.02 }
  cylinder{ <0.1,0,0>, <0.1,0.1,0>, 0.02 } texture{ Simple2 }}

#declare W1 = seed(70)
#declare Flagstone=
union{
  box{ <-4,-0.1,-4>, <4,0.05,4>
  //texture{ Simple2 }
  }
  object{ WW1 rotate <70*rand(W1),90*rand(W1),0> translate <-3.5,0,-3.5> }
  object{ WW1 rotate <70*rand(W1),90*rand(W1),0> translate <3.5,0,-3.5> }
  object{ WW1 rotate <70*rand(W1),90*rand(W1),0> translate <-3.5,0,3.5> }
  object{ WW1 rotate <70*rand(W1),90*rand(W1),0> translate <3.5,0,3.5> }
  }

#declare Lamp50 =
  union{
    light_source{ <0,0.2,0> color Gray50
      fade_distance 1.5
      fade_power 2
      atmosphere off }
    merge{
      sphere{ < 0,0.2,0 >, 0.1 }
      cylinder{ <0,0,0>, <0,0.2,0>, 0.1 } texture{ Simple3 } no_shadow }
    cylinder{ <0,0,0>, <0,0.05,0>, 0.15 texture{ Simple2 }}}
#declare Lamp70 =
  union{
    light_source{ <0,0.2,0> color Gray70
      fade_distance 1.5
      fade_power 2
      atmosphere off }
    merge{
      sphere{ < 0,0.2,0 >, 0.1 }
      cylinder{ <0,0,0>, <0,0.2,0>, 0.1 } texture{ Simple3 } no_shadow }
    cylinder{ <0,0,0>, <0,0.05,0>, 0.15 texture{ Simple2 }}}

#declare Rows_of_lamps =
union{
  #declare Cnt=19.5
  #while( Cnt < 70 )
    object{ Lamp70 translate <35,0.2,Cnt> }
    #declare Cnt = Cnt + 5
  #end
  #declare Cnt=5.5
  #while( Cnt < 70 )
    object{ Lamp70 translate <17.5,0.2,Cnt> }
    #declare Cnt = Cnt + 5
  #end
  #declare Cnt=4.5
  #while( Cnt < 70 )
    object{ Lamp70 translate <0,0.2,Cnt> }
    #declare Cnt = Cnt + 5
  #end }

#declare R1 = seed(4)
#declare Rows_of_bricks =
union{
  #declare Cnt=20
  #while( Cnt < 70 )
    object { Border_brick rotate <1-2*rand(R1),1-2*rand(R1),1-2*rand(R1)> translate <35,0,Cnt> }
    #declare Cnt = Cnt + 2
  #end
  #declare Cnt=6
  #while( Cnt < 70 )
    object { Border_brick rotate <1-2*rand(R1),1-2*rand(R1),1-2*rand(R1)> translate <17.5,0,Cnt> }
    #declare Cnt = Cnt + 2
  #end
  #declare Cnt=6
  #while( Cnt < 70 )
    object { Border_brick rotate <rand(R1),rand(R1),rand(R1)> translate <0,0,Cnt> }
    #declare Cnt = Cnt + 2
  #end }

#declare Plant_element=
union{
  cylinder{ <0,0,0>, <0,0.1,0>, 0.003 }
  sphere{ <0,0,0>, 0.03 scale <1,0.02,0.2> translate 0.03*x rotate 60*z translate 0.02*y }
  texture { Simple2 }}

#declare Plant=
object{ Plant_element }
#declare P1 = seed(207)
#declare Cnt=1
#while( Cnt <= 10 )
  #declare Plant=
  union{
    #declare angle2 = 20*rand(P1)
    object{ Plant_element rotate angle2*z }
    object{ Plant translate <-0.1*sin(radians(angle2)),0.1*cos(radians(angle2)),0> }
    rotate 180*rand(P1)*y
  }
  #declare Cnt = Cnt + 1
#end

#declare F1 = seed(67)
#declare Ground1=
union{
  #declare Cnt=4
  #while( Cnt < 66 )
    object{ Flagstone rotate <0.5-rand(F1),0.5-rand(F1),0.5-rand(F1)> translate <4.325,0,Cnt> }
    #declare Cnt = Cnt + 8.65
  #end
  #declare Cnt=4
  #while( Cnt < 66 )
    object{ Flagstone rotate <0.5-rand(F1),0.5-rand(F1),0.5-rand(F1)> translate <12.975,0,Cnt> }
    #declare Cnt = Cnt + 8.65
  #end
  #declare Cnt=4
  #while( Cnt < 66 )
    object{ Flagstone rotate <0.5-rand(F1),0.5-rand(F1),0.5-rand(F1)> translate <21.825,0,Cnt> }
    #declare Cnt = Cnt + 8.65
  #end
  #declare Cnt=4
  #while( Cnt < 66 )
    object{ Flagstone rotate <0.5-rand(F1),0.5-rand(F1),0.5-rand(F1)> translate <30.475,0,Cnt> }
    #declare Cnt = Cnt + 8.65
  #end
  texture
   {
      pigment
      {
         bozo
         color_map
         {
            [ 0.0     rgbft <0.8, 0.8, 0.8, 0.0, 0.0> ]
            [ 0.5     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
         }
         turbulence 0.5
      }
      finish{ ambient Gray10 }
   scale 2 }
   }

