// Persistence of Vision Ray Tracer Scene Description File
// File: submarine.inc
// Vers: 3
// Desc: Submarine description
// Date: 7 Sep 1998
// Auth: Sergei P. Shuvalkin

//---------------------------------------------------------
#declare Submarine_body_shell =
difference {
  intersection {
    #declare Cnt=0
    #while( Cnt < 360 )
      cylinder{ <10,6.5,0>, <-10,6.5,0>, 12.5 open rotate Cnt*z }
      #declare Cnt = Cnt + 40
    #end }
  union {
    #declare Cnt2= -80
    #while( Cnt2 < 90 )
      union{
        #declare Cnt1= -16
        #while( Cnt1 < 42 )
          #if( Cnt1 - 24 )
            cylinder{ <0,-12.6,0>, <0,-12.4,0>, 0.3 open rotate Cnt1*x }
          #else
            //nothing
          #end
          #declare Cnt1 = Cnt1 + 8
        #end
        translate 6.5*y
        rotate Cnt2*z }
      #declare Cnt2 = Cnt2 + 160
    #end }}

#declare Submarine_body_ribs =
union{
  difference{
    cylinder{ <0,0,0>, <0,1,0>, 2.3 }
    cylinder{ <0,-0.1,0>, <0,1.1,0>, 1.8 } translate -6.3*y }
  #declare Cnt=0
  #while( Cnt < 360 )
    intersection {
      cylinder{ <10,6.5,0>, <-10,6.5,0>, 12.55 }
      cylinder{ <10,6.5,0>, <-10,6.5,0>, 12.55 rotate 40*z }
      plane{ y,0 rotate -67*z }
      plane{ y,0 rotate 107*z } rotate Cnt*z }
    #declare Cnt = Cnt + 40
  #end
  //rivets
  #declare Cnt1 = 0
  #while( Cnt1 < 360 )
    union{
      union{
        #declare Cnt= -45
        #while( Cnt < 48 )
          sphere{ <4.1991713*cos(radians(Cnt)),-12.55*cos(radians(Cnt)),-12.55*sin(radians(Cnt))>, 0.05 }
          #declare Cnt = Cnt + 5
        #end
        rotate -18.5*z translate 6.8542*y rotate 18.5*z }
      union{
        #declare Cnt= -42.5
        #while( Cnt < 45 )
          sphere{ <4.1991713*cos(radians(Cnt)),-12.55*cos(radians(Cnt)),-12.55*sin(radians(Cnt))>, 0.05 }
          #declare Cnt = Cnt + 5
        #end
        rotate -18.5*z translate 6.8542*y rotate 21.5*z }
        sphere{ <-1,-5.01097,-5>, 0.05 }
        sphere{ <0,-5.01097,-5>, 0.05 }
        sphere{ <1,-5.01097,-5>, 0.05 }
        sphere{ <-1,-5.01097,5>, 0.05 }
        sphere{ <0,-5.01097,5>, 0.05 }
        sphere{ <1,-5.01097,5>, 0.05 }
        sphere{ <-0.5,-2.035953,-9.2>, 0.05 }
        sphere{ <0,-2.035953,-9.2>, 0.05 }
        sphere{ <0.5,-2.035953,-9.2>, 0.05 }
        sphere{ <-0.35,-1.58347,-9.6>,0.05 }
        sphere{ <0.35,-1.58347,-9.6>,0.05 }
        sphere{ <-0.2,-1.08304,-10>,0.05 }
        sphere{ <0.2,-1.08304,-10>,0.05 }
        sphere{ <0,-0.52442,-10.4>,0.05 }
      rotate Cnt1*z }
    #declare Cnt1 = Cnt1 + 40
  #end
///------------------------
difference {
  intersection {
    #declare Cnt3=0
    #while( Cnt3 < 360 )
      cylinder{ <10,6.5,0>, <-10,6.5,0>, 12.55 rotate Cnt3*z }
      #declare Cnt3 = Cnt3 + 40
    #end }
  union {
    box{ <-20,-20,-4.9>, <20,20, 4.9> }
    box{ <-20,-20,-9.1  >, <20,20,-5.1> }
    box{ <-20,-20,5.1 >, <20,20, 9.1> }}}}

#declare Submarine_body_portholes =
union{
  #declare Cnt2= -80
  #while( Cnt2 < 90 )
    union{
      #declare Cnt1= -16
      #while( Cnt1 < 42 )
        #if( Cnt1 - 24 )
          difference{
            cylinder{ <0,-12.6,0>, <0,-12.4,0>, 0.39 texture{ Simple2 }}
            cylinder{ <0,-12.7,0>, <0,-12.3,0>, 0.29 texture{ Simple0 }} rotate Cnt1*x }
          sphere{ <0,-12.3,0>, 0.39 rotate Cnt1*x texture{ SBP_glass }}
        #else
          //nothing
        #end
        #declare Cnt1 = Cnt1 + 8
      #end
      translate 6.5*y
      rotate Cnt2*z }
    #declare Cnt2 = Cnt2 + 160
  #end }

#declare Submarine_body_things=
union{
  union{
    cylinder{ <0,0,0>, <0,0.05,0>, 0.2 }
    cylinder{ <0,0.2,0.2>, <0,0.2,0.6>, 0.1 }
    intersection{
      torus{ 0.2, 0.1 rotate 90*z }
      plane{ z, 0 } translate 0.2*z }
    translate 12.5*y rotate -45*x translate -6.5*y rotate -20*z }
  union{
    cylinder{ <0,0,0>, <0,0.05,0>, 0.2 }
    cylinder{ <0,0.2,0.2>, <0,0.2,0.6>, 0.1 }
    intersection{
      torus{ 0.2, 0.1 rotate 90*z }
      plane{ z, 0 } translate 0.2*z }
    translate 12.5*y rotate -45*x translate <0.3,-6.5,0> rotate -20*z }
  union{
    cylinder{ <0,0,0>, <0,0.05,0>, 0.2 }
    cylinder{ <0,0.2,0.2>, <0,0.2,0.6>, 0.1 }
    intersection{
      torus{ 0.2, 0.1 rotate 90*z }
      plane{ z, 0 } translate 0.2*z }
    translate 12.5*y rotate -45*x translate -6.5*y rotate 20*z }
  union{
    cylinder{ <0,0,0>, <0,0.05,0>, 0.2 }
    cylinder{ <0,0.2,0.2>, <0,0.2,0.6>, 0.1 }
    intersection{
      torus{ 0.2, 0.1 rotate 90*z }
      plane{ z, 0 } translate 0.2*z }
    translate 12.5*y rotate -45*x translate <-0.3,-6.5,0> rotate 20*z }
  union{
    torus{ 0.1, 0.05 rotate 90*x translate 0.05*y }
    torus{ 0.25, 0.05 translate <0.25,0.05,0> }
    translate 12.5*y rotate -29*x translate <0.3,-6.5,0> rotate -60*z }
    }

#declare Submarine_body_number =
intersection{
  text{ ttf "playbill.ttf", "1098", 0.2, 0
    scale 4
    rotate <90,-90,0>
    translate <1.3,12.5,-1.3>
    rotate -14*x }
  cylinder{ <10,0,0>, <-10,0,0>, 12.5 }
  translate -6.49*y
  rotate -60*z }
#declare Submarine_body_name =
intersection{
  text{ ttf "playbill.ttf", "Catherine", 0.2, 0
    rotate <90,-90,0>
    translate <0.3,12.5,-1.3>
    rotate -38*x }
  cylinder{ <10,0,0>, <-10,0,0>, 12.5 }
  translate -6.45*y
  rotate -60*z }

#declare Submarine_body =
union{
  object{ Submarine_body_shell     texture{ Submarine_shell_tex scale 2 }}
  object{ Submarine_body_portholes }
  object{ Submarine_body_ribs      texture{ Simple2 }}
  object{ Submarine_body_things    texture{ Simple2 }}
  object{ Submarine_body_number    texture{ Simple0 }}
  object{ Submarine_body_name      texture{ Simple2 }}
  }
//-------------------------------------------------------------------

#declare Submarine_tower_shell =
difference{
  cylinder{ <0,0,0>, <0,9,0>, 3 open }
  union{
    cylinder{ <0,7,-3.1>, <0,7,-2.7> 1.0 open rotate  27*y }
    cylinder{ <0,7,-3.1>, <0,7,-2.7> 1.0 open rotate -27*y }}}

#declare Submarine_tower_ribs =
union{
  cylinder{ <0,8.6,0>, <0,9,0>, 3.05 }
  #declare Cnt = 0
  #while( Cnt < 360 )
    sphere{ <3.05,8.85,0>,0.05 rotate Cnt*y }
    #declare Cnt = Cnt + 15
  #end }

#declare Submarine_tower_portholes =
union{
  union{
    sphere{ <0,7,-2.1>, 1.2 rotate  27*y }
    sphere{ <0,7,-2.1>, 1.2 rotate -27*y } texture{ STP_glass }}
  union{
    difference{
      cylinder{ <0,7,-3.1>, <0,7,-2.7>, 1.2 }
      cylinder{ <0,7,-3.5>, <0,7,-2.5>, 0.8 } rotate 27*y }
    difference{
      cylinder{ <0,7,-3.1>, <0,7,-2.7>, 1.2 }
      cylinder{ <0,7,-3.5>, <0,7,-2.5>, 0.8 } rotate -27*y }
    union{
      #declare Cnt=0
      #while( Cnt < 360 )
        sphere{ <0,-1,0>, 0.05 rotate Cnt*z }
        #declare Cnt = Cnt + 30
      #end translate <0,7,-3.1> rotate 27*y }
    union{
      #declare Cnt=0
      #while( Cnt < 360 )
        sphere{ <0,-1,0>, 0.05 rotate Cnt*z }
        #declare Cnt = Cnt + 30
      #end translate <0,7,-3.1> rotate -27*y } texture{ Simple2 }}}

#declare Stairs =
union{
  intersection{
    union{
      torus{ 0.4, 0.03 rotate 90*x translate <3.1,-0.4,-0.3> }
      torus{ 0.4, 0.03 rotate 90*x translate <3.1,-0.4, 0.3> }}
    plane{ -y,  0.4 }
    plane{ -x, -3.1 }}
  cylinder{ <3.5,-0.4,-0.3>, <3.5,-9.4,-0.3>, 0.03 }
  cylinder{ <3.5,-0.4, 0.3>, <3.5,-9.4, 0.3>, 0.03 }
  #declare Cnt = -1
  #while( Cnt > -9.4 )
    cylinder{ <3.5,Cnt,-0.3>, <3.5,Cnt,0.3>, 0.03 }
    #declare Cnt = Cnt - 0.4
  #end
  #declare Cnt = -1.2
  #while( Cnt > -9.4 )
    cylinder{ <3.5,Cnt,-0.3>, <-1.5,Cnt,-0.3>, 0.03 }
    cylinder{ <3.5,Cnt, 0.3>, <-1.5,Cnt, 0.3>, 0.03 }
    #declare Cnt = Cnt - 1.2
  #end }

#declare Submarine_tower_banisters =
union{
  difference{
    torus{ 3.1, 0.03 }
    cylinder{ <3.1,0,-0.285>, <3.1,0,0.285>, 0.1 }}
  object{ Stairs }
  #declare Cnt = 0
  #while( Cnt < 360 )
    cylinder{ <0,0,-3.1>, <0,-1,-3.0>, 0.03 rotate Cnt*y }
    #declare Cnt = Cnt + 36
  #end
  translate 10*y }

#declare Submarine_tower_periscope =
union{
  cylinder{ <0,8,-2>, <0,13,-2>, 0.05 }
  cylinder{ <-0.3,8,-2>, <-0.3,12,-2>, 0.1 }
  cylinder{ <0.3,8,-2>, <0.3,11,-2>, 0.1 }
  }

#declare Submarine_tower =
union{
  object{ Submarine_tower_shell     texture{ Submarine_shell_tex }}
  object{ Submarine_tower_ribs      texture{ Simple2 }}
  object{ Submarine_tower_portholes }
  object{ Submarine_tower_banisters texture{ Simple1 }}
  object{ Submarine_tower_periscope texture{ Simple2 }}}
//-------------------------------------------------------------------
#declare Lamp50 =
  union{
    light_source{ <0,0.2,0> color Gray50
      fade_distance 1.5
      fade_power 2
      atmosphere off }
    merge{
      sphere{ < 0,0.2,0 >, 0.1 }
      cylinder{ <0,0,0>, <0,0.2,0>, 0.1 } texture{ Simple3 } no_shadow }
    cylinder{ <0,0,0>, <0,0.05,0>, 0.15 texture{ Simple2 }}}

#declare Submarine_tail =
union{
  #declare Cnt=0
  #while( Cnt < 190 )
  union{
    intersection{
      cylinder{ <0,-6,0>, <7.4,-6,0>, 6.5 }
      cylinder{ <0, 6,0>, <7.4, 6,0>, 6.5 } texture{ Simple1 }}
    union{
      difference{
        intersection{
          cylinder{ <0,-6,0>, <8,-6,0>, 6.55 }
          cylinder{ <0, 6,0>, <8, 6,0>, 6.55 }
          plane{ x, 7.5 }}
        box{ <4.2,-1.5,-1.5>, <7.1,1.5,1.5> }}
      union{
        #declare Cnt1 = 0.25
        #while( Cnt1 < 7.5 )
          sphere{ <Cnt1,-6.55,0>, 0.05 rotate -19*x }
          sphere{ <Cnt1,-6.55,0>, 0.05 rotate  19*x }
          #declare Cnt1 = Cnt1 + 0.5
        #end
        #declare Cnt1 = -15
        #while( Cnt1 < 16 )
          sphere{ <7.3,-6.55,0>, 0.05 rotate Cnt1*x }
          sphere{ <0.2,-6.55,0>, 0.05 rotate Cnt1*x }
          sphere{ <  4,-6.55,0>, 0.05 rotate Cnt1*x }
          sphere{ <7.5,-6.4 ,0>, 0.05 rotate Cnt1*x }
          #declare Cnt1 = Cnt1 + 5
        #end
        translate 6*y }
      union{
        #declare Cnt1 = -15
        #while( Cnt1 < 16 )
          sphere{ <7.5, 6.4 ,0>, 0.05 rotate Cnt1*x }
          #declare Cnt1 = Cnt1 + 5
        #end
        translate -6*y }
      texture{ Simple2 }}
    #if( Cnt - 90 )
      rotate 2*x
    #else
      scale <1.5,1,2>
      translate <-4,0,3>
    #end
    rotate Cnt*z }
  #declare Cnt = Cnt + 90
  #end
  object{ Lamp50 rotate -90*z translate 7.5*x }
  object{ Lamp50 rotate  90*z translate -7.5*x }
  object{ Lamp50 rotate 180*z translate <0,-4,3> }
  translate 7.5*z }

//-------------------------------------------------------------------

//-------------------------------------------------------------------
#declare Submarine_bubbles1 =
sphere{ <0,0,0>, 1 scale <1,0.5,1> texture{ Simple4 }}

#declare B1 = seed(225)
#declare Cnt=1
#while( Cnt <= 3 )
  #declare Submarine_bubbles1=
  union{
    sphere{ <0,0,0>, 1 scale <1,0.5,1> texture{ Simple4 }}
    object{ Submarine_bubbles1 scale 0.5 translate <2.5*rand(B1),-6*rand(B1),0> }
    object{ Submarine_bubbles1 scale 0.5 translate <0,-9*rand(B1),0> }
    object{ Submarine_bubbles1 scale 0.5 translate <2.5*rand(B1),-6*rand(B1),0> rotate  60*y rotate rand(B1)*10*y }
    object{ Submarine_bubbles1 scale 0.5 translate <2.5*rand(B1),-6*rand(B1),0> rotate 120*y rotate rand(B1)*10*y }
    object{ Submarine_bubbles1 scale 0.5 translate <2.5*rand(B1),-6*rand(B1),0> rotate 180*y rotate rand(B1)*10*y }
    object{ Submarine_bubbles1 scale 0.5 translate <2.5*rand(B1),-6*rand(B1),0> rotate 240*y rotate rand(B1)*10*y }
    object{ Submarine_bubbles1 scale 0.5 translate <2.5*rand(B1),-6*rand(B1),0> rotate 300*y rotate rand(B1)*10*y }
    }
  #declare Cnt = Cnt + 1
#end
//-------------------------------------------------------------------
//-------------------------------------------------------------------
#declare Submarine_bubbles2 =
sphere{ <0,0,0>, 1 scale <1,0.5,1> texture{ Simple4 }}

#declare B2 = seed(227)
#declare Cnt=1
#while( Cnt <= 3 )
  #declare Submarine_bubbles2=
  union{
    sphere{ <0,0,0>, 1 scale <1,0.5,1> texture{ Simple4 }}
    object{ Submarine_bubbles2 scale 0.5 translate <2.5*rand(B2),-6*rand(B2),0> }
    object{ Submarine_bubbles2 scale 0.5 translate <0,-9*rand(B2),0> }
    object{ Submarine_bubbles2 scale 0.5 translate <2.5*rand(B2),-6*rand(B2),0> rotate  60*y rotate rand(B2)*10*y }
    object{ Submarine_bubbles2 scale 0.5 translate <2.5*rand(B2),-6*rand(B2),0> rotate 120*y rotate rand(B2)*10*y }
    object{ Submarine_bubbles2 scale 0.5 translate <2.5*rand(B2),-6*rand(B2),0> rotate 180*y rotate rand(B2)*10*y }
    object{ Submarine_bubbles2 scale 0.5 translate <2.5*rand(B2),-6*rand(B2),0> rotate 240*y rotate rand(B2)*10*y }
    object{ Submarine_bubbles2 scale 0.5 translate <2.5*rand(B2),-6*rand(B2),0> rotate 300*y rotate rand(B2)*10*y }
    }
  #declare Cnt = Cnt + 1
#end
//-------------------------------------------------------------------

#declare Submarine_searchlight1=
union{
  difference{
    cylinder{ <0,  0,0>, <0,  -1,0>, 0.25 texture{ Simple2 }}
    cylinder{ <0,0.1,0>, <0,-1.1,0>, 0.2  texture{ Simple0 }}}
  sphere{ <0,-0.8,0>, 0.22 texture{ Simple5 }}
}
#declare Submarine_searchlight2 =
union{
  difference{
    cylinder{ <0,  0,0>, <0,0,-0.5>, 0.55 texture{ Simple2 }}
    cylinder{ <0,0,0.1>, <0,0,-0.6>, 0.5  texture{ Simple0 }}}
  intersection{
    sphere{ <0,0,0.4>, 1 }
    cylinder{ <0,0,0>, <0,0,-1>, 0.51  } texture{ STP_glass }}
  intersection{
    sphere{ <0,0,0>, 0.55 }
    plane{ -z, 0 } texture{ Simple2 }}
rotate -20*x }

#declare Submarine =
union {
  object{ Submarine_body      }
  object{ Submarine_tower     }
  object{ Submarine_tail      }
  object{ Submarine_bubbles1 scale 0.25 rotate 180*y translate <-1,6.5,-8.5> }
  object{ Submarine_bubbles2 scale 0.25 translate <1,6.5,-8> }
  object{ Submarine_searchlight1 translate -11.8*y rotate 51*x translate <-0.3,6.5,0> }
  object{ Submarine_searchlight1 translate -11.8*y rotate 51*x translate < 0.3,6.5,0> }
  object{ Submarine_searchlight2 translate <0,10,-2.8> }
  }
