
// Glenn's POV-Ray Object File - Circles and Arrows
// created 21-Oct-98
// last update 25-Oct-98
// copyright 1998 Glenn McCarter
// This file does not render.  #include "Arrows.inc" in another .pov file
//
// Objects:
// Line(XLength,YWidth,ZThickness,Texture)
// StraightArrow(HeadLength,TailLength,Width,Thickness,Texture)// arrowhead at origin, tail extends into +X
// CurveArrow(HeadLength,TailRadius,TailArc,Width,Thickness,Texture)// arrowhead at origin, tail curves into +X+Y
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// For POV-Ray version 3.1+

//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================


//===============================================
//             Objects
//===============================================

#macro Line(Length,Width,Thickness,Texture)
	box {
		<0,-Width/2,0>,<Length,Width/2,Thickness>
		texture { Texture }
	}
#end

#macro StraightArrow(HeadLength,TailLength,Width,Thickness,Texture)
	union {
		box {
			<HeadLength/2,-Width/2,0>,<TailLength,Width/2,Thickness>
		}
		prism {
			0,Thickness
			5,
			<0,0>,<1,-.4>,<.8,0>,<1,.4>,<0,0>
			scale <HeadLength,1,HeadLength>
			rotate <90,0,0>
		}
		texture { Texture }
	}
#end


#macro CurveArrow(HeadLength,TailRadius,TailArc,Width,Thickness,Texture) // arrowhead at origin, tail curves into +X+Y
	union {
//		box {
//			<HeadLength/2,-Width/2,0>,<TailLength,Width/2,Thickness>
//		}
		difference {
			cylinder { // main
				<0,TailRadius,0>,<0,TailRadius,Thickness>,TailRadius+Width/2
			}
			cylinder { // cut away inner
				<0,TailRadius,-.1>,<0,TailRadius,Thickness+.1>,TailRadius-Width/2
			}

			box { // cut away at head
				<-TailRadius-.1,-TailRadius-.1,-.1>,<HeadLength/2,TailRadius*3+Width+.1,Thickness+.1>
			}

			box { // cut away at tail
				<0,-TailRadius-Width-.1,-.1>,<TailRadius+Width+.1,TailRadius+Width+.1,Thickness+.1>
				rotate <0,0,TailArc>
				translate <0,TailRadius,0>
			}

		} // end difference
/*
			box { // cut away at tail
				<0,-TailRadius-Width-.1,-.1>,<TailRadius+Width+.1,TailRadius+Width+.1,Thickness+.1>
				rotate <0,0,TailArc>
				translate <0,TailRadius,0>
			}
*/
		prism {
			0,Thickness
			5,
			<0,0>,<1,-.4>,<.8,0>,<1,.4>,<0,0>
			scale <HeadLength,1,HeadLength>
			rotate <90,0,5>
		}
		texture { Texture }
	}
#end
