
// Glenn's POV-Ray Scene File - Water Trick Scene 1 Overlay
// created 20-Sep-98 for the Internet Raytracing Competition (www.irtc.org)
// last update 25-Oct-98
// copyright 1998 Glenn McCarter (gmccarter@hotmail.com)
//
// This adds the colored arrow overlays onto the image.
//

                                                   
#include "GIncludeRH.inc"
//#include "GRuler.inc"
#include "Arrows.inc"

#version 3.1;
global_settings {
	adc_bailout 0.003922
	ambient_light <1.0,1.0,1.0>
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
  /* // Radiosity section: uncomment this to enable radiosity
  // calculations; must also turn on radiosity in your ini file.
	radiosity {
		brightness       3.3
		count            100
		distance_maximum 5
		error_bound      0.4
		gray_threshold   0.5
		low_error_factor 0.8
		minimum_reuse    0.015
		nearest_count    6
		recursion_limit  1
	}
  */ // end radiosity section
}

//===============================================
//             Variables
//===============================================

#declare ImageHeight = 6;                        // heigtht of the image in units (inches)
#declare IH = ImageHeight;
#declare AspectRatio = 1+1/3;                    // 1.33
#declare AR = AspectRatio;
#declare ImageWidth = ImageHeight * AspectRatio;
#declare IW = ImageWidth;

// Setting the image height is useful if you want to place objects
// in front of the image.  If you leave the ImageHeight at 1, the total
// image will be 1 unit tall.  So objects placed in front of the image
// must be very small to be visible.

//===============================================
//             Cameras
//===============================================

#declare Ortho_Cam =
	camera {
		orthographic
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  IH >  // Where Z is up
		right     <IW,      0.0,  0.0>
//	location  <-1, .5, .5>
//	look_at   < 0, .5, .5>
	location  <-1, IW/2, IH/2>
	look_at   < 0, IW/2, IH/2>
}

camera {
	Ortho_Cam
  }

//===============================================
//             Textures
//===============================================

#declare OverlayTex =
	texture {
		pigment { color rgb<1,1,0> }
		finish { ambient 0.95 specular .3 roughness .01 }
	}		             

#declare WhiteInk =
	texture {
		pigment { color rgb<1,1,1> }
		finish { ambient .95 specular .3 roughness .01 }
	}		             

#declare BlackInk =
	texture {
		pigment { color rgb<.06,.06,.06> }
		finish { ambient .4 specular .3 roughness .01 }
	}		             

           
//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <4*Feet,0*Feet,8*Feet> }
//object {StdBulb60Watt translate <-10*Feet,0*Feet,8*Feet> }

//===============================================
//             Environment
//===============================================

background { color rgb <0.0, 0.0, 0.0> } // black
//object {GroundPlaneWhite translate z*-0}

//===============================================
//             Objects
//===============================================

//#declare ImageHeight = 1;
//#declare ImageWidth = AspectRatio; 
                          	
#declare ImageBox =
	box {
		<0,0,-.1>,<1,1,0> // the box is initially square
		texture { WhiteInk }
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
					png "Scene2b.png"
					once
				}
			}
			finish { ambient 1 }
			scale <1,1,1> // the image is initially square
		}
		rotate <90,0,-90> // align to camera
		translate <0,1-.001,-.001> // align to camera (with slight overscan)
		scale <1,ImageWidth*1.005,ImageHeight*1.005> // scale it up to match camera view
	}


#declare LT = .10; // line thickness
#declare UpArrow =
// StraightArrow(HeadLength,TailLength,Width,Thickness,Texture)
	object { StraightArrow(.6,1.5,LT,.05,OverlayTex)
		rotate <0,90,0>
	}

#local TR = 2; // tail radius
#local TA = 45; // tail arc
#declare RightArrow =
//CurveArrow(HeadLength,TailRadius,TailArc,Width,Thickness,Texture)// arrowhead at origin, tail curves into +X+Y
	object { CurveArrow(.6,TR,TA,LT,.05,OverlayTex)
		rotate <90,0,-90> // align to image
		translate <0,0,-TR>
		rotate <-40,0,0> // swing it around
		translate <0,0,TR>
	}

#declare LeftArrow =
//CurveArrow(HeadLength,TailRadius,TailArc,Width,Thickness,Texture)// arrowhead at origin, tail curves into +X+Y
	object { CurveArrow(.6,TR,TA,LT,.05,OverlayTex)
		rotate <90,0,90> // align to image
		translate <0,0,-TR>
		rotate <22,0,0> // swing it around
		translate <0,0,TR>
	}

#declare LetterB =
	text {
		ttf "COMIC.TTF",
		"B",
		.05,     // THICKNESS_FLOAT, extruded into +Z
		0       //OFFSET_VECTOR
		scale .8
		rotate <90,0,-90>
		texture { OverlayTex }
	}
#declare LetterC =
	text {
		ttf "COMIC.TTF",
		"C",
		.05,     // THICKNESS_FLOAT, extruded into +Z
		0       //OFFSET_VECTOR
		scale .8
		rotate <90,0,-90>
		texture { OverlayTex }
	}

#declare Sequence =
	union {
		cylinder {
			<0,0,0>,<.1,0,0>,.40
			texture { WhiteInk }
		}
		text {
			ttf "COMIC.TTF",
			"2",
			.05,     // THICKNESS_FLOAT, extruded into +Z
			0       //OFFSET_VECTOR
			scale .7
			rotate <90,0,-90>
			translate <0,.15,-.25>
//			texture { OverlayTex }
			texture { BlackInk }
			no_shadow
		}
	}

//===============================================
//             Object Placement
//===============================================

#declare ArrowGroup =
	union {
		object { LeftArrow translate <0,3.8,1.7> }
		object { LetterB translate <0,4.7,0.3> }
		object { LetterC translate <0,3.0,0.5> }
		object { RightArrow translate <0,4.5,1.5> }
	}
object { ArrowGroup translate <0,0,0> }
//object { Sequence translate <0,7.25,5.25> }
object { Sequence translate <0,0.65,5.35> }
object { ImageBox translate <.1,0,0> } // put it behind any overlays


//object { ImageFrame }
//object { RoundCyl }

