
// Glenn's POV-Ray Scene File - Water Trick Scene 2
// created 22-Sep-98 for the Internet Raytracing Competition (www.irtc.org)
// last update 24-Oct-98
// copyright 1998 Glenn McCarter (gmccarter@hotmail.com)
//
// Water bent into a circle
//
// scene origin is at the center of the circle

                                                   
#include "GIncludeRH.inc"
//#include "GRuler.inc"
#include "Sink.inc"

#version 3.1;
global_settings {
	adc_bailout 0.003922
	ambient_light <1.0,1.0,1.0>
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
  /* // Radiosity section: uncomment this to enable radiosity
  // calculations; must also turn on radiosity in your ini file.
	radiosity {
		brightness       3.3
		count            100
		distance_maximum 5
		error_bound      0.4
		gray_threshold   0.5
		low_error_factor 0.8
		minimum_reuse    0.015
		nearest_count    6
		recursion_limit  1
	}
  */ // end radiosity section
}

//===============================================
//             Variables
//===============================================

#declare LocalOrigin = <-18,-36,8>;

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
//	location  <-12, -1, 6> // test
//	look_at   <0, 0, 0>
	location  LocalOrigin+<-8, -6, 5> // render view
	look_at   LocalOrigin
/*// Focal Blur section: uncomment to enable focal blur
		blur_samples 20
		confidence 0.95
		variance 1/128
		aperture 0.6    //lower value = wider range in focus
		focal_point LocalOrigin
*/// end focal blur
}

#declare Special_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 60
//	location  <-16, -5, 9> // origin view
//	look_at   <0.0, 0.0, 0.0>
	location  <-12, -1, 6> // render view
	look_at   <0, 0, 0>
	}

camera {
//	Special_Cam
	Render_Cam
  }

//===============================================
//             Textures
//===============================================

#declare BackDropTex =
	texture {
//		pigment { color rgb<.050,.042,.030> } // render
		pigment { color rgb<.00,.00,.00> } // test
		normal { bumps .25 scale 8 }
		finish { ambient .62 diffuse .7 specular .10 roughness .05 }
	}

#declare WaterTex =
	texture {
//		pigment { color rgb<.3,.3,1> } // test blue
		pigment { color rgbt<.95,.95,1,.8> } // mostly clear
		normal { bumps .3 scale 2 }
		finish { ambient .1 diffuse .2 specular .9 roughness .002 reflection .1 }
	}
#declare WaterInt =
	interior {
		ior 1.3
		caustics 1.0
	}
#declare WaterMat =
	material {
	 texture { WaterTex }
	 interior { WaterInt }
	}           
           
//===============================================
//             Lighting
//===============================================

object {StdBulb60Watt translate <4*Feet,0*Feet,4.5*Feet> }
object {StdBulb60Watt translate <-10*Feet,0*Feet,4.5*Feet> }
// This is not a comment.
#declare FillSpot =
	light_source {
		<0,-2*Feet,4*Feet>
		color rgb <.39, .36, .25>
		spotlight
		point_at <-3,-1,-5>
		radius 2    // degrees fully lit (*2)
		falloff 22   // degrees no lighting (*2)
		tightness 1
	}
object { FillSpot translate LocalOrigin }


//===============================================
//             Environment
//===============================================

background { color rgb <0.0, 0.0, 0.0> } // black
//object {GroundPlaneWhite translate z*-0}

#declare Ceiling = // for reflection
	box {
		<-18*Feet,-18*Feet,0>,<18*Feet,18*Feet,1>
		texture {
			pigment { color rgb<1,1,1> }
			finish { ambient .8 }
		}
	}
object { Ceiling rotate z*-40 translate <0,0,5*Feet> }

#declare BDRad = 2*Feet;
#declare BackDropPaper =
	difference {
		box { // main
			<-80*Feet,-80*Feet,-80*Feet>,<80*Feet,80*Feet,80*Feet>
		}
		box { // upper
			<-88*Feet,-88*Feet,BDRad>,<0,88*Feet,88*Feet>
		}
		box { // lower
			<-88*Feet,-88*Feet,0>,<-BDRad,88*Feet,88*Feet>
		}
		cylinder { // corner radius
			<-BDRad,-88*Feet,BDRad>,<-BDRad,88*Feet,BDRad>,BDRad
		}
		texture { BackDropTex }
	}
object { BackDropPaper rotate z*40 translate <5*Feet,0,-30> }

//===============================================
//             Objects
//===============================================

#declare SinkGroup =
	union {
		object { DeepSink }
		object { ArchFaucet(0,0) translate <0,14,0> }
	}

#declare BT  = 0.5; // Blob Threshold
#declare BRF = 0.3;  // Blob Radius Factor
#declare BSF = 1.0;  // Blob Strength Factor
#declare BNSF = 24.0; // Negative Strength Factor ( divisor )
#declare RS = seed(98543);
               
#declare BentWater =
	blob {
		threshold BT
		#declare BallCount = 1;
		#while ( BallCount < 65 )
			sphere {
				<0,0,0>,BRF*2.2,BSF
				scale <.8+rand(RS)*.1,.8+rand(RS)*.1,.8+rand(RS)*.1>
				translate <-.10+rand(RS)*.20,-.10+rand(RS)*.20,-.10-rand(RS)*.20> // jiggle
				translate <0,0,-4>
				rotate <6+BallCount*5,0,0>
			}
			#declare BallCount = BallCount + 1;
		#end
		material { WaterMat }
	}

#declare Drips1 =
	union {
		#local RS = seed(84731);
		#local SCount = 0;
		#while ( SCount < 3 )
			sphere {
				<0,0,0>,.05+rand(RS)*.2
				scale <1,.4+rand(RS)*.4,.4+rand(RS)*.4>
				translate <.4+rand(RS)*1.1,0,0>
				rotate <0,rand(RS)*-180,rand(RS)*360>
			}
			#local SCount = SCount + 1;
		#end
		material { WaterMat }
	}
#declare Drips2 =
	union {
		#local RS = seed(23321);
		#local SCount = 0;
		#while ( SCount < 3 )
			sphere {
				<0,0,0>,.05+rand(RS)*.2
				scale <1,.4+rand(RS)*.4,.4+rand(RS)*.4>
				translate <.4+rand(RS)*0.8,0,0>
				rotate <0,rand(RS)*-180,rand(RS)*360>
			}
			#local SCount = SCount + 1;
		#end
		material { WaterMat }
	}


// LeftHand Pose Angles ( in order )
#declare HandPose = 1;
#declare FFat = 1.23; // finger fatness ratio ( 1 = normal, 1.4 = too fat )
#declare TA  = 22; // thumb, outer joint
#declare TB  = 25; // thumb, middle joint
#declare TRot  = 15; // thumb rotation angle
#declare TExt  = -6; // thumb extension from hand
#declare F1A  = 30; // index finger, outer joint
#declare F1B  = 62; // index finger, middle joint
#declare F1C  = 25; // index finger angle
#declare F1Rot  = 10; // index finger rotation
#declare F2A  = 30; // middle finger, outer joint
#declare F2B  = 50; // middle finger, middle joint
#declare F2C  = 20; // middle finger angle
#declare F2Rot  = 0; // middle finger rotation
#declare F3A  = 38; // ring finger, outer joint
#declare F3B  = 58; // ring finger, middle joint
#declare F3C  = 26; // ring finger angle
#declare F3Rot  = -4; // ring finger rotation
#declare F4A  = 22; // pinky finger, outer joint
#declare F4B  = 36; // pinky finger, middle joint
#declare F4C  = 32; // pinky finger angle
#declare F4Rot  = -10; // pinky finger rotation
#declare WRot = -12; // wrist angle
#declare WCock = -25; // wrist cock side-to-side
#include "BlobHand31.inc"
object { LeftHand rotate <90,0,160> translate <-3.5,5,-6.5>  rotate z*40 translate LocalOrigin }

// RightHand Pose Angles ( in order )
#declare HandPose = 1;
#declare FFat = 1.23; // finger fatness ratio ( 1 = normal, 1.4 = too fat )
#declare TA  = 36; // thumb, outer joint
#declare TB  = 25; // thumb, middle joint
#declare TRot  = 30; // thumb rotation angle
#declare TExt  = 16; // thumb extension from hand
#declare F1A  = 24; // index finger, outer joint
#declare F1B  = 26; // index finger, middle joint
#declare F1C  = 36; // index finger angle
#declare F1Rot  = 0; // index finger rotation
#declare F2A  = 20; // 20middle finger, outer joint
#declare F2B  = 50; // 35middle finger, middle joint
#declare F2C  = 30; // 48middle finger angle
#declare F2Rot  = 0; // middle finger rotation
#declare F3A  = 25; // ring finger, outer joint
#declare F3B  = 48; // ring finger, middle joint
#declare F3C  = 40; // ring finger angle
#declare F3Rot  = 0; // ring finger rotation
#declare F4A  = 10; // pinky finger, outer joint
#declare F4B  = 21; // pinky finger, middle joint
#declare F4C  = 36; // pinky finger angle
#declare F4Rot  = -30; // pinky finger rotation
#declare WRot = -12; // wrist angle
#declare WCock = -25; // wrist cock side-to-side
#include "BlobHand31.inc"
object { RightHand rotate <-79,0,200> translate <-4,-6.6,-4.0>  rotate z*40 translate LocalOrigin }

#declare LocalGroup =
	union {
		object { BentWater }
		object { Drips1 translate <0,.7,-6> }
		object { Drips2 translate <0,-2.5,-5.3> }
	}

//===============================================
//             Object Placement
//===============================================

object { LocalGroup rotate z*40 translate LocalOrigin }

object { SinkGroup }
//object { SinkGroup rotate <0,0,-40> translate <36,18,-8> }

//object { SinkGroup rotate <0,0,-20> translate <36,3,-8> } // nearby test
