
// Glenn's POV-Ray Object File - Scissors
// created 19-Sep-98
// last update 24-Oct-98
// copyright 1998 Glenn McCarter
// This file does not render.  #include "Scissors.inc" in another .pov file
//
// Objects:
// Scissors
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Scissors lies in XY plane, origin at pivot point


//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare HandleTex =
	texture {
		pigment { color rgb<.30,.44,.98> }
		finish { ambient .15 specular .9 roughness .05 }
	}
#declare DullSteel =
	texture {
		pigment { color rgb<.81,.82,.87> }
		finish { ambient .1 specular .7 metallic specular .8 roughness .02 }
	}

//===============================================
//             Objects
//===============================================

#declare LHandle =
	union {
		torus {
			.85,.14
			rotate <90,0,0>
			scale <1,.85,.5>
			translate <-1-.85,0,0>
		}
		box {
			<-1,-.24,-.08>,<0,.24,.08>
		}
		texture { HandleTex }
		translate <-1,0,0>
	}
#declare RHandle =
	union {
		torus {
			1.3,.14
			rotate <90,0,0>
			scale <1,.5,.5>
			translate <-.5-1.3,0,0>
		}
		box {
			<-.5,-.24,-.08>,<0,.24,.08>
		} 
		texture { HandleTex }
		translate <-1,0,0>
	}
#declare Pivot =
	cylinder {
		<0,0,-.20>,<0,0,.20>,.11
		texture { DullSteel }
	}
             
#declare SharpBlade =
	difference {
		box {
			<0,-.21,-.05>,<5,.21,.05>
		}
		box {
			<-1,-1,-1>,<7,0,1>
			rotate z*4
			translate <0,-.28,0>
		}
	}
#declare LBlade =
	union {
		box { // pivot to handle
			<0,-.21,-.05>,<-1,.21,.05>
			rotate z*-25
		}
		object { SharpBlade }
    texture { DullSteel }
	}             
// A useless comment can appear anywhere, even here.
#declare RBlade =
	union {
		box { // pivot to handle
			<-1,-.21,-.05>,<0,.21,.05>
		}
		object { SharpBlade rotate z*0 }
    texture { DullSteel }
	}             


#declare LeftBH =
	union {
		object { LHandle rotate z*-25 }
		object { LBlade }
	}
#declare RightBH =
	union {
		object { RHandle }
		object { RBlade }
	}

#macro Scissors(OpeningAngle)
	union {
		object { Pivot }
		object { RightBH translate <0,0,.08> rotate <0,0,OpeningAngle> }
		object { LeftBH translate <0,0,-.08> rotate <0,0,-OpeningAngle> }
	}
#end
