
// Glenn's POV-Ray Object File - Sink
// created 19-Sep-98
// last update 24-Oct-98
// copyright 1998 Glenn McCarter
// This file does not render.  #include "Sink.inc" in another .pov file
//
// Objects:
// DeepSink -- a freestanding large deep white plastic tub
// ArchFaucet -- a simple chrome faucet with a high arch 
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Sink origin level with top surface, centered over drain, depth into -Z, faucet in +Y
// Faucet origin at center of base


//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare SinkTex =
	texture {
		pigment { color rgb<1,1,1> }
		finish { ambient .3 specular .8 roughness .1 } // test
//		finish { ambient .1 specular .8 roughness .1 reflection .2 } // render
	}		             

#declare LegTex =
	texture {
		pigment { color rgb<.95,.93,.90> }
		finish { ambient .1 specular .8 roughness .1 }
	}

#declare DeepChrome =
	texture {
		pigment { color rgb <0.39, 0.41, 0.43> }
		finish {
			ambient 0.1
			brilliance 6
			diffuse 0.7
			metallic
			specular 0.80
			roughness .01
			reflection 0.6
		}
	}

//===============================================
//             Objects
//===============================================

//----------------- Sink -----------------------

// object { RoundedBox(.2) texture...} // roundness, range 0 to .5, larger = more rounded
#declare DeepTub =
	difference {
		object { RoundedHalfBox(.1) // outer
			rotate x*180 // flat on top
			scale <24,24,18>
		}
		object { RoundedHalfBox(.1) // inner
			rotate x*180 // flat on top
			scale <23.4,23.4,18>
			translate <0,0,0.3>
		}
		translate <0,0,-9> // origin at top flat
	} // end difference
#declare TopRad =
	difference {
		cylinder { // outer
			<-13,0,0>,<13,0,0>,1
		}
		cylinder {
			<-18,0,0>,<18,0,0>,.7
		}
		box { // cut off bottom
			<-18,-3,-3>,<18,3,0>
		}
		box { // cut off rear
			<-18,0,-3>,<18,3,3>
		}
		cylinder { // cut off end
			<0,-3,0>,<0,3,0>,.7
			translate <-13,0,0>
		}
		cylinder { // cut off end
			<0,-3,0>,<0,3,0>,.7
			translate <13,0,0>
		}
	} // end difference
#declare RearShelf =
	box {
		<-13,0,0>,<13,4,.3>
	}
#declare FrontShelf =
	box {
		<-13,0,0>,<13,-.75,.3>
	}
#declare LegShape =
	difference {
		box {
			<0,0,0>,<4,.3,12>
		}
		box {
			<0,-1,-1>,<4,1,14>
			rotate y*10
			translate <1.4,0,0>
		}
	}
#declare Leg =
	union {
		object { LegShape }
		object { LegShape rotate z*90 translate <.3,.01,0> }
		texture { LegTex }
	}
#declare DeepSink =
	union {
		object { DeepTub }
		object { TopRad rotate z*0 translate <0,13-.3,0> }
		object { TopRad rotate z*180 translate <0,-13+.3,0> }
		object { TopRad rotate z*90 translate <-13+.3,0,0> }
		object { TopRad rotate z*270 translate <13-.30,0> }
		object { RearShelf translate <0,13-.3,1-.3> }
		object { FrontShelf translate <0,-13+.3,1-.3> }
		object { Leg rotate z*0 translate <-11,-11,-30> }
		object { Leg rotate z*180 translate <11,11,-30> }
		object { Leg rotate z*90 translate <11,-11,-30> }
		object { Leg rotate z*270 translate <-11,11,-30> }
		texture { SinkTex }
		translate <0,0,-1> // origin at top edge of shelf, center of sink
	}



//----------------- Faucet -----------------------

#declare FaucetHandle =
	union {
		cylinder { // main
			<0,0,.3>,<0,0,1.5>,.7
		}
		torus { // top
			.7-.08,.08
			rotate x*90
			translate <0,0,1.5>
		}
		cylinder { // top fill
			<0,0,1>,<0,0,1.5+.08>,.7-.08
		}
		object {
			RoundedBox(.2)
			scale <1,.2,1.18>
			translate <.5+.6,0,.90>
		}
		cylinder { // axis
			<0,0,0>,<0,0,.5>,.4
		}
		texture { DeepChrome }
	}	

#declare PipeRad = .3;
#declare FO = 10; // faucet offset and torus radius
#declare CH = 3; // cylinder height
#macro ArchFaucet(HotHandleRotation,ColdHandleRotation) // origin at center of base
	union {
		object { FaucetHandle rotate z*-ColdHandleRotation translate <2,0,1> }
		object { FaucetHandle rotate z*(180+HotHandleRotation) translate < -2,0,1> }
		superellipsoid {
			<.2,.2>
			scale <3,1,1>
		}		
		cylinder { // upstanding pipe
			<0,0,0>,<0,0,CH>,PipeRad
		}
		torus {
			FO/2,PipeRad
			rotate <0,0,90>
			clipped_by{box{<-1,-6,0>,<1,6,6>}}
			translate <0,-FO/2,CH>
		}
		difference {
			cylinder { // tip
				<0,0,-1>,<0,0,0>,PipeRad*1.3
			}
			cylinder { // hole
				<0,0,-2>,<0,0,-.1>,PipeRad*.9
			}
			translate <0,-FO,CH>
		}
		texture { DeepChrome }
	}
#end
//Some guys are knocking at the door of the bar...

