// -Persistence of Vision Ray Tracer -Scene Description File
// -File: baptism.pov
// -Vers: 3.02.watcom.win32
// -Desc: Scene within a church on the morning of a baptism.
// -Date: 18th October 1998
// -Auth: Ewan Grant <ewgr@abaddon.globalnet.co.uk>

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "woods.inc"    // Unmodified Pov file
#include "glass.inc"    // Unmodified Pov file

 atmosphere { type 5
              distance 80
              scattering 0.04
              eccentricity -.24
              colour <0.0, 0.0, 0.0, 0.1, .75>
              samples 25
              jitter .1
              aa_threshold 4
              aa_level 0.3
            }

background { color Gray }

  camera { ultra_wide_angle
           location  <12.0, 3.0,-27.5>
           direction 0.35*z
           right     3.8/3*x
           look_at   <10.8, 1.9,-13.5>
         }

 light_source { 0*x color red 2  green 2  blue 2  translate <-250, 820, 1100>}


 #declare ClipA= box { <-.5, -.5, -.2>  < 0.5,  0.5, 0.2> rotate 45*z }
 #declare ClipD= box { <-1, -1.1, -1>  < 1.1,  1.1,  1> rotate 45*y}

 #declare RegStone1= box { <-1.5, -1, -1>  < 1,  1,  1.5>
                           pigment {rgb <.825,.858,.789>}
                           finish { ambient .2  crand .14 }
                           normal { granite scale 2.95 turbulence .02}
                         }

  #declare RegStone2= box { <-2, -1, -1>  < 1,  1,  1.5>
                            pigment {rgb <.829,.879,.804>}
                            finish { ambient .185  crand .06 }
                            normal { granite scale 3.6 turbulence .08}
                          }

  #declare RegStone3= box { <-3, -1, -1>  < 1,  1,  1.5>
                            pigment {rgb <.819,.857,.794>}
                            finish { ambient .2  crand .11 }
                            normal { granite scale 3.4}
                          }

  #declare CornerStone1= difference{
            object { RegStone1 }

            object { ClipD translate <1.45,0,-1.45>
                     pigment {rgb <.805,.843,.791>}
                     finish { ambient .152  crand .12 }
                     normal { granite scale 2.95 rotate 2*x}
                   }
                   }

  #declare CornerStone2= difference{
            object { RegStone2 }

            object { ClipD translate <1.45,0,-1.45>
                     pigment {rgb <.825,.856,.781>}
                     finish { ambient .172  crand .15 }
                     normal { granite scale 3.6 turbulence .08}
                   }
                   }

  #declare CornerStone3= difference{
            object { RegStone3 }

            object { ClipD translate <1.45,0.0,-1.45>
                     pigment {rgb <.835,.881,.792>}
                     finish { ambient .162  crand .14 }
                     normal { granite scale 3.4}
                   }
                   }

  #declare WinStone= object { CornerStone1 rotate 90*z translate <0,0.5,1> }


   #declare Wall= union{
     object {CornerStone1 }
     object {CornerStone2 translate <0,2.05,0>}
     object {CornerStone1 translate <0,4.10,0>}
     object {CornerStone3 translate <0,6.15,0>}
     object {CornerStone2 translate <0,8.20,0>}
     object {RegStone3 translate <-2.55,0,0>}
     object {RegStone2 translate <-6.60,0,0>}
     object {RegStone3 translate <-9.65,0,0>}
     object {RegStone3 translate <-13.7,0,0>}
     object {RegStone1 translate <-3.05,2.05,0>}
     object {RegStone2 translate <-5.60,2.05,0>}
     object {RegStone1 translate <-8.65,2.05,0>}
     object {RegStone2 translate <-11.20,2.05,0>}
     object {RegStone3 translate <-14.25,2.05,0>}
     object {RegStone3 translate <-2.55,4.1,0>}
     object {RegStone1 translate <-6.60,4.1,0>}
     object {RegStone3 translate <-9.15,4.1,0>}
     object {RegStone3 translate <-13.2,4.1,0>}
     object {RegStone1 translate <-17.25,4.1,0>}
     object {RegStone2 translate <-4.05,6.15,0>}
     object {RegStone2 translate <-7.10,6.15,0>}
     object {RegStone2 translate <-10.15,6.15,0>}
     object {RegStone1 translate <-13.20,6.15,0>}
     object {RegStone3 translate <-15.75,6.15,0>}
     object {RegStone1 translate <-3.05,8.20,0>}
     object {RegStone2 translate <-5.60,8.20,0>}
     object {RegStone3 translate <-8.65,8.20,0>}
     object {RegStone1 translate <-12.70,8.20,0>}
     object {RegStone3 translate <-15.25,8.20,0>}
           }

   #declare Foundations= union{
     object {RegStone3 translate < 0.00,-2.05,0>}
     object {RegStone2 translate <-4.05,-2.05,0>}
     object {RegStone1 translate <-7.10,-2.05,0>}
     object {RegStone1 translate <-9.65,-2.05,0>}
     object {RegStone2 translate <-12.20,-2.05,0>}
     object {RegStone2 translate < 3.05,-2.05,0>}
     object {RegStone1 translate < 5.60,-2.05,0>}
     object {RegStone1 translate < 8.15,-2.05,0>}
     object {RegStone2 translate < 11.20,-2.05,0>}
           }

#declare ArchShape=
   box {<.5,.25,1><-.5,-.25,-1>
        pigment {rgb <.855,.878,.794>}
        finish { ambient .2 diffuse .5 crand .12 }
        normal { granite scale 1.2 turbulence .1}
       }

 #declare ArchUnit= difference{
    object {ArchShape}

    object {ArchShape scale <1.1,1,1.1> rotate -2*z translate .475*y}
    object {ArchShape scale <1.1,1,1.1> rotate 2*z translate -.475*y}
          }

  #declare ArchTop= difference{
     object {ArchShape }

     object {ArchShape scale <1.3,1,1.1> rotate -15*z translate .425*y}
     object {ArchShape scale <1.3,1,1.1> rotate 15*z translate -.425*y}
           }

    #declare ArchSeg= union{
       object {ArchUnit rotate -2*z}
       object {ArchUnit rotate -6*z translate <0.05,0.48,0.0>}
       object {ArchUnit rotate -10*z translate <0.125,0.96,0.0>}
             }

   #declare ArchHalf= union{
      object {ArchSeg}
      object {ArchSeg rotate -12*z translate <0.225,1.42,0> }
      object {ArchSeg rotate -24*z translate <0.772,2.78,0> }
      object {ArchSeg rotate -36*z translate <1.570,4.00,0> }
            }

   #declare Arch= union{
      object {ArchHalf}
      object {ArchHalf rotate 180*y translate 6*x }
      object {ArchTop rotate -90*z scale <3.5,1.1,1.1> translate <3,4.87,-.04>}
            }

   #declare WinWall= union{
      cylinder {<0,7.09,.9><8,7.09,.9> .5 scale <1,.6, 1> pigment {rgb <.825,.856,.789>}
               finish { ambient .2 diffuse .6 crand .13 }
               normal { granite scale 2.95 } }
      cylinder {<0.5,1,1.1><0.5,9.1,1.1> .5 pigment {rgb <.825,.858,.789>}
               finish { ambient .2 diffuse .6 crand .11 }
               normal { granite scale 2.95 } }
      cylinder {<7.65,1,1.1><7.65,9.1,1.1> .5 pigment {rgb <.825,.858,.789>}
               finish { ambient .2 diffuse .6 crand .12 }
               normal { granite scale 2.95 } }
      cylinder {<0.2,9.1,-.48><0.2,9.1,1> .55 pigment {rgb <.825,.858,.789>}
               finish { ambient .2 diffuse .6 crand .1 }
               normal { granite scale 2.95 } }
      cylinder {<7.8,9.1,-.48><7.8,9.1,1> .55 pigment {rgb <.825,.858,.789>}
               finish { ambient .2 diffuse .6 crand .12 }
               normal { granite scale 2.95 } }
      object { WinStone scale <1.5,1,1> rotate -180*y translate <   1,-.03,2.5>}
      object { WinStone scale <1.5,1,1> rotate -180*y translate <4.04,-.04,2.5>}
      object { WinStone scale <1.5,1,1> rotate -180*y translate <7.10,-.04,2.5>}
      object { WinStone translate <-0.1,2.512,0>}
      object { WinStone translate <1.97,2.512,0>}
      object { WinStone translate <4.05,2.512,0>}
      object { WinStone translate <6.10,2.512,0>}
      object { WinStone translate <8.15,2.512,0>}
            }


   #declare Arch2= difference{
                 union{
         torus{ 0.8, 0.1  scale <1,1,2> rotate 90*x translate -.25*x}
         torus{ 0.8, 0.1  scale <1,1,2> rotate 90*x translate .25*x}
        }

         torus{ 0.975, 0.2  scale <1,1,2> rotate 90*x translate -.1*y}
         box { <-1.5, -2, -.1>  < 1.5,  0,  .1> }
       }

#declare Feature= union{
object {Arch2 scale <1.0,1.1,1.0> translate -.1*z}
object {Arch2 scale <1.3,1.2,1.2> }
box { <-.45, .8, -.2>  < .45,  1.0,  .1> }
box { <-.1, -.1, -.2>  < .1,  1.4,  .1> }
  pigment {rgb <.829,.879,.804>}
  finish { ambient .185 diffuse .5 }
  normal { granite scale 4.1 }
 }

  object {Feature scale <3,4.5,2> translate <-5, 14, 5> }
  object {Feature scale <3,4.5,2> translate <-12, 14, 5> }
  object {Feature scale <3,4.5,2> translate <-19, 14, 5> }
  object {Feature scale <3,4.5,2> translate <-26, 14, 5> }
  object {Feature scale <3,4.5,2> translate <18, 14, 5> }
  object {Feature scale <3,4.5,2> translate <24.5, 14, 5> }
  object {Feature scale <3,4.5,2> translate <31, 14, 5> }

 #declare Hoop= difference{
     torus{ 0.8, 0.4 }

     box { <-1, -1, -1>  < 1,  1,  -.1> }
       }

  #declare Clover= union{
    sphere{ 0*y, .9  translate <1.35,-1.35,0>}
    sphere{ 0*y, .9  translate <1.35,1.35,0>}
    sphere{ 0*y, .9  translate <-1.35,-1.35,0>}
    sphere{ 0*y, .9  translate <-1.35,1.35,0>}
    object { Hoop rotate <90,0,90>  translate 2.25*x}
    object { Hoop rotate <90,0,-90> translate -2.25*x}
    object { Hoop rotate 90*x  translate -2.25*y}
      }
  #declare Arm= difference{
            union{
       box { <-2.8, -.7, -.1>  < 2.8,  .7,  .1> }
       box { <-.7, -2.8, -.1>  < 0.7,  1.25,  .1> }
                }
        object {Clover}
        }

  #declare Crucifix= union{
    object {Arm translate -2*y}
    object {Arm rotate 180*z translate 10*y}
    object {Arm rotate -90*z translate <-4,6.5,0>}
    object {Arm rotate 90*z translate <4,6.5,0>}
    box { <-.45, -1.25, -.1>  < .45,  10,  .1> }
    box { <-3.55, 6.05, -.1>  < 3.55, 6.95,  .1>}
     }

  #declare WallHang= union{
    box{ <-8.6,-8.6,-.1>< 8.6, -8.0,0.2> pigment {Yellow}
         finish { ambient .28 diffuse .43 } normal { wrinkles 1 scale .45 }
        }
    box{ <-8.6,15.6,-.1>< 8.6, 15.0,0.2> pigment {Yellow}
         finish { ambient .27 diffuse .42 }  normal { wrinkles 1 scale .55 }
        }
    box{ < 8.0,15.6,-.1>< 8.6,-8.6,0.2> pigment {Yellow}
         finish { ambient .26 diffuse .41 }  normal { wrinkles 1 scale .45 }
        }
    box{ <-8.0,15.6,-.1><-8.6,-8.6,0.2> pigment {Yellow}
         finish { ambient .25 diffuse .40 }  normal { wrinkles 1 scale .55 }
        }
    box{ <-9,-9,-.099><9,16,0.2> pigment {Med_Purple}
         finish {ambient .2 diffuse .6 } normal { wrinkles 5 scale .0002 }
        }
    object {Crucifix pigment{BrightGold} finish { ambient .3 diffuse .62 } normal { wrinkles .85 scale 1.8 } }
     }

  #declare BraidFibre= union{
   cylinder {<0,.5,0><0,-.45,0> .02 }
   sphere {0*y, .04 translate <0.01, 0.450, 0.01> }
   sphere {0*y, .04 translate <-.01, 0.450, 0.01> }
   sphere {0*y, .05 translate <0.00, 0.475, 0.02> }
   sphere {0*y, .04 translate <0.02, 0.490, 0.01> }
   sphere {0*y, .04 translate <-.02, 0.490, 0.01> }
   sphere {0*y, .06 translate <0.00, 0.510, 0.02> }
   pigment {BrightGold}
   finish {ambient .2 diffuse .4}
   normal {radial .15 frequency 10  }
   scale 2
   translate <-9.2,-10.1,-.25>
   }

 #declare WallHanging= union{
  #declare Count = 0
  #while (Count < 125)
   object { BraidFibre translate .15*x*Count}
  #declare Count = Count+1
  #end
  object { WallHang }
    }



 #declare Strand= torus { 5.1, .05
     scale <1.5,1,3>
     rotate -90*x
     translate <-2,0,0>
     texture {Spun_Brass scale 3}
     pigment {Black}
     }

#declare Strand2= torus { 5.1, .05
     scale <1.5,1,3>
     rotate 90*x
     translate <14,0,0>
     texture {Spun_Brass scale 3}
     pigment {Black}
     }

  #declare Cutaway= union{
#declare Count=0
#while (Count <9)
   object {Strand translate (.75*y*Count)+(.6*x*Count) }
   object {Strand2 translate (.75*y*Count)+(-.6*x*Count) }
 #declare Count=Count+1
 #end
 }

  #declare CurveClip=
    difference{
     torus { 5.1, .3 }

     box { <-6, -1, 0>  < 6,  1, -6> }
     scale <1,2,2>
     rotate -90*x
     translate -1.9*y
          }

   #declare Window= difference{
      box {<-5,-7,-.5><5,7.5,.5>  }

      box { <-3,4,.6><0,-3,-.6> rotate -33*z translate <-3.25,5,0> }
      box { < 3,4,.6><0,-3,-.6> rotate 33*z translate < 3.25,5,0> }
      object {CurveClip}
          }

  #declare Boundary = difference{
      box {<-30,-30,-.4><30,30,.4> }

      object {Window pigment {Clear} translate <6,13,0>}
       }
#declare WindowBars= difference{
    object {Cutaway}

    object {Boundary pigment {Green} }
    translate <1,.5, 6.25>
     }

  #declare StainedGlassWindow= object { Window
                          texture { T_Glass1 }
                          pigment { spiral2  4
                           colour_map { [ 0.08 color rgbft<0.6, 0.3, 0.1, 1, 0.3>]
                                        [ 0.15 color rgbft<0.6, 0.6, 0.0, 1, 0.3>]
                                        [ 0.30 color rgbft<0.0, 0.5, 0.7, 1, 0.3>]
                                        [ 0.50 color rgbft<0.8, 0.4, 0.1, 1, 0.3>]
                                        [ 0.78 color rgbft<0.1, 0.2, 0.6, 1, 0.3>]
                                        [ 0.90 color rgbft<0.5, 0.1, 0.4, 1, 0.3>]
                                       }
                                     }
      scale <1,1,.1>
      translate <7,13.5, 6.275>
    }

  #declare Backdrop= union{
       object { Wall translate -1*x}
       object { Wall rotate 180*z translate < 9, 8.2, 0 > }
       object {Arch scale <1.21,1,1> translate <.4,9.4,.5>}
       object {WinWall}
        }

       object { WallHanging scale <0.35,0.45,0.3>  translate <-18, 7, 3.5>}
       object { WallHanging scale <0.35,0.45,0.3>  translate <-4, 7, 3.5>}
       object { StainedGlassWindow }
       object { WindowBars }
       object { Backdrop scale 1.5 translate <1,.5, 5>}
       object { Foundations scale <2.5,1.53,1.5> translate <1,.445, 5>}
       object { Foundations rotate 90*y scale <2.5,1.5,1.5> translate <37, 0.45, -25>}
       object { Backdrop rotate 90*y scale 1.5 translate <37.5, .5, -15>}
       object { Backdrop rotate 90*y scale 1.5 translate <37.5, 15, -15>}

  #declare Surround= union{
          box {<-26,24,  6>< 38,26,-40>}
          box {<-26,25,-39>< 38,-5,-40>}
          box {<-25,25,  6><-26,-5,-40>}
          box {< 38,25,  6>< 39,-5,-40>}
          box { <0, -5, 6> <14, 7, 7> }
             }

    object {Surround pigment { rgb <.815,.828,.789>} normal {granite scale 3} }

 #declare TempFill= union{
    box {< .6, 19.8, 5.1>< 4, 26, 5.5> }
    box {< .5, 20, 5>< 4, 26, 5.5> scale <1.5, 1, 1> translate <3,1.6,0>}
    box {<  1, 20, 5>< 4, 26, 5.5> scale <1.5, 1, 1> translate <6.25,1.2,0>}
    pigment {rgb <.821,.852,.787>}
    finish { ambient .21 diffuse .59 crand .11 }
    normal { granite scale 2.95 }
    }

    object { TempFill} //became Permanent ;-)

    object { Wall rotate 180*z translate <-16.14,23,6>}
    object { Wall  translate <29.2,15,6>}
    object { Wall  translate <45.2,15,6>}
    object { Wall  translate <-17,15,6>}

 #declare Saucer = difference{
      sphere { 0*y, .5 }

      sphere { .1*y, .504 scale <1.2,1,1.2>}
      }

   #declare Bend =
         union{
      difference {
         torus {0.8, 0.15 translate < 1,0,-1> }

         box {<2.5,.3, 1><-2.5,-.3,-1> }
         box {<2.5,.3, 1><-2.5,-.3,-1> rotate -45*y translate -.65*z }
           }
           cylinder {<0,0,-.3><0,0,.3> .15  translate <1.8, 0, -.75> }
           cylinder {<0,0,-.5><0,0,.9> .15  rotate -45*y translate <.1, 0, -1.25> }
           }

  #declare CandleHolder= union{
      torus { 0.1, 0.05 translate <0, -.2,-.875> }
      object {Bend scale .5 rotate <-90,90, 0>}
      object {Saucer translate <0, .275,-.875> }
         }

  #declare CandleSet = union{
          object {CandleHolder }
          object {CandleHolder rotate 30*y translate <-.3,-.2, -.3>}
          object {CandleHolder rotate -30*y translate <.3,-.2, -.3>}
          sphere {<0,-.3,.2>, .5 scale <1,1,.4> }
            pigment {color rgb <0.68, 0.595, 0.42>}
      finish { ambient 0.2
               brilliance 4
               diffuse 0.5
               metallic
               specular 0.80
               roughness 0.08
               reflection 0.1
             }
             normal { ripples scale .065 }
                 }

     #declare Silk= difference{
  torus{ 1.0, 0.03  }

  box { <-1, -1, -2>  < 0,  1,  2>  rotate -28*y translate -.5 *x}

  box { < 1, -1, -2>  < 0,  1,  2>  rotate  28*y translate 0.5 *x}
  scale <3,1,1>
   }

 #declare Web= union{
   object {Silk}
   object {Silk scale .5 rotate 45*y translate -1*x}
   object {Silk scale .8 translate 0.6 *z}
   object {Silk scale .7 rotate 85*y translate <-.75, 0, 2.7>}
   object {Silk scale .7 rotate 92*y translate <-.325, 0, 1.0>}
   object {Silk scale .6 translate 1.1 *z}
   object {Silk scale .4 translate 1.6 *z}
   object {Silk scale .2 translate 2.1 *z}
   cylinder {<-2.5,0,0.55> <-.1,0,2.6> .02  }
   cylinder {< 2.5,0,0.55> <0.1,0,2.6> .02  }
   }

#declare CandleSet2= union{
   object {Web pigment {White filter .1} finish { ambient .4 diffuse .7 }
   rotate <80, -8, -10> scale <.2,.25,.2> translate <-.08, -.91, -1.0>}
   object {CandleSet}
     }

  #declare Wax = difference{
                   union{
   cylinder { <0,0,0><0,1,0> .1 pigment {rgb <1,1,.97>} finish {ambient .7}}
   cylinder { <0,0,0><0,1,0> .105 pigment {Wheat filter .99} finish { reflection .1 phong 5 phong_size 80} }
           }
  sphere {1*y, .15 pigment  {rgbf <1,1,.98,.8>} }
  sphere {1*y, .13 pigment  {rgbf <1,1,.98,.8>} translate <.033, 0,-.07>}
  sphere {1*y, .13 pigment  {rgbf <1,1,.98,.8>} translate <-.03, 0,.07>}
        }

  #declare Wick=
      cylinder { <0,.8,0><0,.94,0> .01 pigment {gradient y scale .18 translate -.08*y
                                              color_map {[0 rgb <1,1,1>]
                                                         [1 rgb <.15,.13,.12>]
                                                         }
                                                         }
                                                         finish {crand .2}
                                                          }
  #declare WaxRun1= merge{
    cylinder { <0,.7,0><0,.89,0> .01 translate -.0975*z pigment {rgbf <.9, .9, .8, .4>} finish { ambient .6} }
    sphere {0*y, .014 scale <.9,1.5,1> pigment {rgbf <.9, .9,.82,.38>} translate <0, .682, -.0971> finish {ambient .5}}
      }
  #declare WaxRun2= merge{
    cylinder { <0,.4,0><0,.89,0> .01 translate -.105*x pigment {rgbf <.89, .89, .83, .3>} finish {ambient .5} }
    sphere {0*y, .014 scale <1,1.5,1> pigment {rgbf <.9, .9,.83,.36>} translate <-.11, .41, 0> finish {ambient .4}}
      }

   #declare Candle=
    union {
       object {Wax}
       object {Wick}
       object {WaxRun1 translate <.000,-.01,.000>}
       object {WaxRun1 translate <.007,-.03,.002>}
       object {WaxRun1 translate <-.009,-.05,.002>}
       object {WaxRun2}
         difference {
      sphere { 0.72*y, .08 pigment { gradient y scale .2 turbulence .9 translate .03*y
                             color_map { [ 0.1 color rgb < 1.0, 1.0, 0.0> ]
                                         [ 0.2 color rgb < 0.8, 0.8, 0.0> ]
                                         [ 0.3 color rgb < 2.0, 1.5, 0.0> ]
                                         [ 0.6 color rgb < 2.0, 1.6, 0.0> ]
                                         [ 0.7 color rgb < 2.0, 2.0, 0.0> ]
                                       }
                                       }
                                       finish {ambient .9}
                                       scale <.5,1.6,.5>
                                       no_shadow
                                     }

       sphere { 1.135*y, .05 pigment { color rgbf < 1, 1, 0, 1> } finish { ambient 1 } translate .06*x}
              }
            }

   #declare Candles = union{
     object {CandleSet}
     object {Candle rotate 25*y translate <0, 0,-.9>}
     object {Candle rotate -30*y translate  <.75, -.2, -1.1>}
     object {Candle translate <-.75, -.25, -1.1>}
        light_source { 0*x color rgb <.3,.3,.3>
                atmosphere off
                fade_distance 3
                fade_power 1
                translate <0, 1.1,-.9>}
        light_source { 0*x color rgb <.35,.35,.35>
                fade_distance 4
                fade_power 1
                atmosphere off
                translate <0.8, 0.90, -1.1>}
        light_source { 0*x color rgb <.35,.35,.35>
                fade_distance 4
                fade_power 1
                atmosphere off
                translate <-.8, 0.85, -1.1>}
             }

  #declare Candles2 = union{
     object {CandleSet2}
     object {Candle rotate 25*y translate <0, 0,-.9>}
     object {Candle rotate -30*y translate  <.75, -.2, -1.1>}
     object {Candle translate <-.75, -.25, -1.1>}
        light_source { 0*x color rgb <.3,.3,.3>
                atmosphere off
                fade_distance 3
                fade_power 1
                translate <0, 1.1,-.9>}
        light_source { 0*x color rgb <.35,.35,.35>
                fade_distance 4
                fade_power 1
                atmosphere off
                translate <0.8, 0.90, -1.1>}
        light_source { 0*x color rgb <.35,.35,.35>
                fade_distance 4
                fade_power 1
                atmosphere off
                translate <-.8, 0.85, -1.1>}
             }

     object { Candles translate <-5.5, 12,-7.4> }
     object { Candles2 translate <19.5, 12,-7.5> }
     object { Candles translate < 9, 8, -26.5> }
     object { Candles translate <-9, 12,-28.5> }

     #declare Flat= difference{
   box {<1.5,2,.15><-1.5,-2,-.15> texture {T_Wood13 rotate <5,5,0>}}

   box {<1.15,1.5,.05><-1.15,-1.5,-.25> texture {T_Wood13 rotate <-3,5,0>}}
      }

  #declare Insert= union{
     cylinder {<1.25,0,0><-1.25,0,0> .15 translate <0, -1.5, 0.05>}
     cylinder {<1.25,0,0><-1.25,0,0> .15 translate <0,  1.5, 0.05>}
     cylinder {<0,1.65,0><0,-1.65,0> .15 translate <-1.15, 0, 0.05>}
     cylinder {<0,1.65,0><0,-1.65,0> .15 translate < 1.15, 0, 0.05>}
     texture {T_Wood18 rotate <8,3,0>}
         }

  #declare Panel= union{
    object {Flat  translate <0,2.35,0>}
    object {Insert  translate <0,2.35,0>}
     scale <.7, 1.1, .7> }

  #declare Base= difference{
                union{
    box {<-1.5,.5,.5>< 1.5,-.5,-.5> texture {T_Wood18 rotate 5*x}}
    cylinder{<-1.5,0,0><1.5,0,0> .2 translate <0,.5,0> texture {T_Wood7 rotate <4,4,4>}}
    cylinder{<-1.5,0,0><1.5,0,0> .1 translate <0,.75,.1> texture {T_Wood7 rotate <4,5,0>}}
     }
    box{<1,1,2><-1,-1,-2> rotate 30*y translate -2.3*x pigment {Grey}}
    box{<1,1,2><-1,-1,-2> rotate -30*y translate 2.3*x pigment {Grey}}
      }

   #declare Top= difference{
                union{
    box {<-1.5,.5,.5>< 1.5,.3,-.5> texture {T_Wood18 rotate 7*x}}
    cylinder{<-1.5,0,0><1.5,0,0> .2 translate <0,.5,0> texture {T_Wood18 rotate 3*y}}
    cylinder{<-1.5,0,0><1.5,0,0> .1 translate <0,.75,.1> texture {T_Wood18 rotate -2*x}}
    cylinder{<-1.5,0.4,-.44><1.5,0.4,-.44> .125 texture {T_Wood18 rotate 7*x }}
           }
    box{<1,1,2><-1,-1,-2> rotate 30*y translate -2.3*x pigment {Grey}}
    box{<1,1,2><-1,-1,-2> rotate -30*y translate 2.3*x pigment {Grey}}
     rotate 180*z }

 #declare BasePlate= union{
  object {Base}
  object {Base rotate -60*y translate < 1.7175,0,0.985> }
  object {Base rotate  60*y translate <-1.7175,0,0.985> }
  object {Panel translate <0,0,0.35>}
  object {Panel rotate -60*y translate < 1.6,0,1.3> }
  object {Panel rotate  60*y translate <-1.6,0,1.3> }
  cylinder {< 1.05,0,.325>< 1.08,4.8,.33> .1 texture {T_Wood18}}
  cylinder {<-1.05,0,.325><-1.08,4.8,.33> .1 texture {T_Wood18} }
   }

   #declare TopPlate= union{
      object {Top}
      object {Top rotate -60*y translate < 1.7175,0,0.985> }
      object {Top rotate  60*y translate <-1.7175,0,0.985> }
           }

   #declare Crucifix= union{
      box {<-.15,1.3,0.25><0.15,3.97,0.4>}
      box {<-0.65,3.15,0.25><0.65,3.45,0.4>}
      pigment {color rgb <0.68, 0.595, 0.42>}
      finish { ambient 0.2
               brilliance 4
               diffuse 0.5
               metallic
               specular 0.2
               roughness 0.5
               reflection 0.1
               crand .01
             }
          normal { ripples .01 scale .66}
             }

  #declare Pulpit= union{
    object {BasePlate}
    object {TopPlate translate <0,5.5,0.38> }
    object {Crucifix}
        }

     object { Pulpit rotate 90*y scale 1.4 translate <18.2, -4.6, -16.0>}


  #declare FontSupport= union{
    difference{
      box{ <-.4,-.4,-.2><.4,.4,.2> }

      cylinder{<0,0,.23><0,0,-.23> .7  translate <.45,-.45,0>}
       }
    union{
       cylinder{<0,0,.25><0,0,-.25> .15  translate <.4,.3,0>}
    difference{
       cylinder{<0,0,.30><0,0,-.30> .12  translate <.4,.3,0>}

       cylinder{<0,0,.31><0,0,-.31> .09  translate <.4,.3,0>}
        }
        }
        }

  #declare Font= difference {
                  union {
      superellipsoid {<0.2, 0.1> scale <1.25,.5,1.25>}
      cone           { 0.2*y, 0.45, -3*y, 0.55  }
      superellipsoid {<0.2, 0.1> scale <1.35,.4,1.35> translate -3.5*y}
      object {FontSupport              translate < .7,-0.8,  0>}
      object {FontSupport rotate 90*y  translate <  0,-0.8,-.7>}
      object {FontSupport rotate 180*y translate <-.7,-0.8,  0>}
      object {FontSupport rotate 270*y translate <  0,-0.8, .7>}
           }
      box {<-.8, 0,-.8><.8,1.1,.8>}
        }

   object { Font
             rotate <2,0,0>
             translate <14.5,0.0,-20.25>
             pigment {rgb <.965,.993,.992>}
             finish { ambient .2 diffuse .4 }
             normal { granite scale 1.2}
          }

  #declare Liquid= box {<-.8,.4,-.8><.8,0.875,.8>}

      object {Liquid
         rotate <2,0,0>
         translate <14.5, -0.47, -20.25>
         pigment { Clear }
         finish {reflection .4 specular 0.2 roughness 0.1 refraction 1 ior 1.3 }
         normal { wrinkles scale .8}
       }

 // A time worn carpet

  box {<-14,-4.5,-18.2><20,-4.3,-14.8> pigment { gradient z scale .000001
                                 colour_map { [0.0 rgb < .8, .3, .2> ]
                                              [0.9 Scarlet ]
                                              [1.0 Gray10 ]
                                             }
                                            }
                                        finish {ambient .175 diffuse .5}
                                        normal { dents .78 scale .6}    // The worn bits
                                        }





 #declare Flag= superellipsoid {<.05,.05> scale <4.4,.3, 4.4> }

 #declare Flags= union{
     object {Flag }
     object {Flag rotate 90*y translate 9*x}
     object {Flag rotate -90*y translate <9,0,9>}
     object {Flag rotate 180*y translate 9*z}
     scale .5
      }

  #declare Row= union{
       object {Flags translate -18.1*x}
       object {Flags translate -9*x}
       object {Flags}
       object {Flags translate 9*x}
       object {Flags translate 18.1*x}
        }

  #declare FlagStoneFloor= union{
        object {Row}
        object {Row translate -9.1*z}
        object {Row translate -18.2*z}
        object {Row translate -27.3*z}
        plane { y, 0.1 }
        translate -4.5*y
        }

        object {FlagStoneFloor pigment { rgb < .7, .8, .76> }
                          finish {crand .06}
                          normal {granite scale 8}
                        }

#declare WoodBase =
color_map { [0.00 rgb <0.298, 0.188, 0.125>]
            [0.05 rgb <0.361, 0.235, 0.203>]
            [0.10 rgb <0.392, 0.235, 0.109>]
            [0.15 rgb <0.408, 0.266, 0.203>]
            [0.20 rgb <0.424, 0.313, 0.282>]
            [0.25 rgb <0.440, 0.313, 0.266>]
            [0.30 rgb <0.455, 0.345, 0.282>]
            [0.35 rgb <0.471, 0.345, 0.313>]
            [0.40 rgb <0.490, 0.329, 0.266>]
            [0.45 rgb <0.502, 0.345, 0.219>]
            [0.50 rgb <0.518, 0.360, 0.203>]
            [0.55 rgb <0.533, 0.345, 0.219>]
            [0.60 rgb <0.549, 0.392, 0.235>]
            [0.65 rgb <0.564, 0.392, 0.329>]
            [0.70 rgb <0.580, 0.423, 0.298>]
            [0.75 rgb <0.596, 0.439, 0.313>]
            [0.80 rgb <0.627, 0.376, 0.188>]
            [0.85 rgb <0.643, 0.423, 0.250>]
            [0.90 rgb <0.658, 0.501, 0.376>]
            [0.95 rgb <0.690, 0.470, 0.313>]
            [1.00 rgb <0.737, 0.501, 0.313>]
           }

#declare WoodGrain =
pigment { wood
          turbulence <0.08, 0.04, 0.1>
          octaves 5
          lambda 2
          omega 0.5
          scale <0.12, .15, 1>
        }

#declare KnottyWood=
texture {
     pigment { WoodGrain
               color_map { WoodBase }
             }
        }


  #declare PewEnd= union{
      difference{
         box { <0.8, 0.1, 2.4> <-0.8, -0.1, -2.4> }

         cylinder { <0.8, -0.1, 2.5> <0.8, -0.1, -2.5> .18 }
         cylinder { <-.8, -0.1, 2.5> <-.8, -0.1, -2.5> .18 }
            }
    superellipsoid { <.1,.1> scale <.9,.1,2.7> translate .4*y }
    box { <0.8, 0.1, 2.4> <-0.8, -0.1, -2.4>  translate .2*y }
    cylinder { <0.799, 0.249, -2.4><-0.799, 0.249, -2.4> .15 }

  difference{
     box { <-0.2, -4, -2.2>  <0.2, 0, 2.2> }

    cylinder { <0.3, -1.1, 1.2> <-.3, -1.1, 1.2> .25 }
    cylinder { <0.3, -1.1, 1.6> <-.3, -1.1, 1.6> .25 }
    cylinder { <0.3, -1.4, 1.4> <-.3, -1.4, 1.4> .25 }
 #declare Num=0
 #while (Num < 8)
   cylinder { <0.3, -1.2, 0.7> <-.3, -1.2, 0.7> .1 translate (-.01*y*Num)+(-.2*z*Num) }
   cylinder { <0.3, -1.4, 0.8> <-.3, -1.4, 0.8> .1 translate (-.05*y*Num)+(-.2*z*Num) }
   cylinder { <0.3, -1.6, 0.9> <-.3, -1.6, 0.9> .1 translate (-.09*y*Num)+(-.2*z*Num) }
 #declare Num = Num+1
 #end
   }

   cylinder { <0.2, -.4, -2.1> <0.2, -.5, 2.1> .05 }
   cylinder { <0.2, -.55, -2.1> <0.2, -.75, 2.1> .05 }
   cylinder { <0.15, -4.05, -2.2> <0.15, -4.05, 2.2> .2  }

 difference{
    box { <-.4, -4.5, -2.6> <0.8, -4.0, 2.6>  }

    cylinder { <0.75, -4, -2.61> <0.75, -4, 2.61> .2  }
         }
      texture {KnottyWood}
        }

#declare Bead= sphere {0*y, .1 scale <.9,1.6,.9> translate <0,2.25,.195> }

#declare PewUnit= union {
superellipsoid { <.1, .1> scale <4, 3, .2> }
box { <-.9,2.1,-.25><.9,2.2,-.1> scale <4,1,1> }
box { <-.9,2.4,-.25><.9,2.5,-.1> scale <4,1,1> }
box { <-.9,2.0,0.25><.9,2.1,0.1> scale <4,1,1> }
box { <-.9,2.45,0.25><.9,2.55,0.1> scale <4,1,1> }
#declare Num=0
 #while (Num < 14)
   object {Bead translate .25*x*Num}
   object {Bead translate -.25*x*Num}
 #declare Num = Num+1
 #end
  pigment { WoodGrain
            color_map { WoodBase }
              scale 1.6
              rotate x*90
warp { black_hole <-.15, -.125, -.2>, .5
       falloff 2.8
       strength  1.6
       repeat <1.85, 2.1, 0>
       turbulence <0.35, 0.75, 0>
       inverse
     }
 warp { black_hole <2.15, 1.125, -.22>, .5
        falloff  3
        strength  2
        turbulence <0.45, 0.45, 0>
        inverse
     }
 warp { black_hole <2.35, 1.725, -.2>, .5
        falloff  4
        strength  2
        turbulence <0.45, 0.55, 0>
        inverse
      }
 warp { black_hole <-.15, -.125, 0.2>, .5
       falloff 2.8
       strength  1.6
       repeat <1.85, 2.1, 0>
       turbulence <0.35, 0.75, 0>
       inverse
     }
 warp { black_hole <2.15, 1.125, 0.22>, .5
        falloff  3
        strength  2
        turbulence <0.45, 0.45, 0>
        inverse
     }
 warp { black_hole <2.35, 1.725, 0.2>, .5
        falloff  4
        strength  2
        turbulence <0.45, 0.55, 0>
        inverse
      }
     }
   }


 #declare Pew= union {
   object { PewEnd scale <.8, 1, .9> }
   object { PewEnd scale <.8, 1, .9> translate -8.2*x }
   object { PewUnit  rotate -12*x translate <-4, 1, -2.2> }
   object { PewUnit scale <1, .7, .6> rotate 90*x translate <-4, -2.2, 0> }
         }

   object {Pew rotate 90*y scale <.75,.65,.8>  translate < 7.3, -1.45,-14.0>  }
   object {Pew rotate 90*y scale <.75,.6,.8>  translate <1.9, -1.42,-13.9>  }
   object {Pew rotate 90*y scale <.75,.6,.8>  translate <-7.8, -1.41,-15.5>  }
   object {Pew rotate 90*y scale <.75,.6,.8>  translate < 7.1, -1.4,-26.0>  }


  #declare Sp1 = sphere{ 1*x, 1.5 texture {T_Wood28 } }
  #declare Sp2 = sphere{-1*x, 1.5 texture {T_Wood28 } }
  #declare Bar= union{
  #declare Count=0
  #while (Count < 80 )

 object { Sp1 rotate 25*y*Count translate .5*y*Count }
 object { Sp2 rotate 25*y*Count translate .5*y*Count }

  #declare Count = Count+1
  #end
    }

#declare End= union{
difference{
box { <-2.5, -8, -2.5>  < 2.5,  0,  2.5>  }

torus{ 3.2, .8  translate -0.65 *y }
}

torus{ 2.5, 0.5  translate .35*y}
texture { T_Wood28}
 }

 #declare Railing= union{

 object {End}
 object {End rotate 180*x translate 35*y}
 object {Bar}
 cylinder {<-9,0,0><9,0,0> 5.0 scale <1, 0.1, 1> texture {T_Wood28} translate 43.6*y}
 cylinder {<-9,0,0><9,0,0> 5.2 scale <1, 0.4, 1> texture {T_Wood28} translate 44.8*y}
  }
#declare Railings= union{
 #declare Count=0
 #while (Count <16)

  object {Railing translate 18*x*Count}

 #declare Count=Count+1
 #end
 }

 object {Railings scale .12 translate <-12.75,-3.5,-4>}

 #declare Boxz= difference{
  superellipsoid {<.1,.1>  scale 1.85  }

  superellipsoid {<.1,.3> scale <1.3,1.3,.3>  translate <0,0, 1.8>}
  superellipsoid {<.1,.3> scale <1.3,1.3,.3>  translate <0,0,-1.8>}
  superellipsoid {<.1,.3> rotate 90*y scale <0.3,1.3,1.3>  translate < 1.8, 0, 0>}
  superellipsoid {<.1,.3> rotate 90*y scale <0.3,1.3,1.3>  translate <-1.8, 0, 0>}
     }

#declare Insert= union{
  cylinder {<1.25,0,0><-1.25,0,0> .15 translate <0, -1.25, -1.65>}
  cylinder {<1.25,0,0><-1.25,0,0> .075 translate <0, -1.075, -1.67>}
  cylinder {<1.25,0,0><-1.25,0,0> .15 translate <0,  1.25, -1.65>}
  cylinder {<1.25,0,0><-1.25,0,0> .075 translate <0,  1.075, -1.67>}
  cylinder {<0,1.25,0><0,-1.25,0> .15 translate <-1.25, 0, -1.65>}
  cylinder {<0,1.25,0><0,-1.25,0> .075 translate <-1.075, 0, -1.67>}
  cylinder {<0,1.25,0><0,-1.25,0> .15 translate < 1.25, 0, -1.65>}
  cylinder {<0,1.25,0><0,-1.25,0> .075 translate < 1.075, 0, -1.67>}
  box {<-1.5,-1.6,-1.9><-1.4,1.5,-1.7>}
  box {< 1.5,-1.6,-1.9>< 1.4,1.5,-1.7>}
  box {<-1.6,-1.5,-1.9>< 1.6,-1.4,-1.7>}
  box {<-1.6, 1.5,-1.9>< 1.6, 1.4,-1.7>}
  superellipsoid {<2,1.35> rotate 45*z  scale < 2, 2, .3> translate -1.5*z }
    }

#declare ColumnBase= union{
    object {Boxz }
    object {Insert}
    object {Insert rotate 90*y}
    object {Insert rotate 180*y}
    object {Insert rotate 270*y}
       }

#declare Column= union{
   object {ColumnBase pigment {rgb <.855,.883,.794>}
     finish { ambient .2  }
     normal { granite scale 4.3}
                      scale <1.1,1.3,1.1>
                      }
   torus { 1.55, .285 scale <1,0.8,1> translate 2.45*y pigment {rgb <.855,.883,.794>}
     finish { ambient .2  }
     normal { granite scale 3.3} }
   torus { 1.52, .235 scale <1,0.8,1> translate 2.72*y pigment {rgb <.855,.883,.794>}
     finish { ambient .2  }
     normal { granite scale 3.3} }

   cylinder {<0,2,0><0,6,0> 1.5
     pigment {rgb <.855,.883,.794>}
     finish { ambient .2  }
     normal { granite scale 5.3}
     }
   cylinder {<0,6.025,0><0,10.025,0> 1.5
     pigment {rgb <.855,.893,.794>}
     finish { ambient .2  }
     normal { granite scale 3.4}
     }
   cylinder {<0,10.05,0><0,14.05,0> 1.5
     pigment {rgb <.855,.898,.798>}
     finish { ambient .2  }
     normal { granite scale 3.4}
     }
   cylinder {<0,14.075,0><0,18.075,0> 1.5
     pigment {rgb <.855,.893,.794>}
     finish { ambient .2  }
     normal { granite scale 3.1}
     }
   cylinder {<0,18.1,0><0,22.1,0> 1.5
     pigment {rgb <.845,.893,.792>}
     finish { ambient .2  }
     normal { granite scale 3.2}
     }
   cylinder {<0,22.1,0><0,24.125,0> 1.5
     pigment {rgb <.845,.883,.798>}
     finish { ambient .2  }
     normal { granite scale 3.6}
     }
     }

   object {Column translate <  -6, -1.96, -6> }
   object {Column translate <19.5, -1.96, -6> }

  #declare Rib= union{
    cylinder { -1*x,  1*x,  .2  }
    sphere { 0*x, .2  translate -1*x}
    sphere { 0*x, .2  translate 1*x}
          }

  #declare Fluer= difference{
                       union{
      sphere {0*y, .2  scale <1,2.25,1> }
      torus { .5, .06  rotate 90*x translate <.5,-.6,0>}
      torus { .5, .06  rotate 90*x translate <-.5,-.6,0>}
          }
      box { <-1.1, -1.3, -.5><1.1,-.45, .5>  }
       }

  #declare Plaque= union{
           difference{
     superellipsoid {<.08,.08> scale <1.675, 2.35, 1.5> translate 1.62*z}

  object {Rib scale <1.5,1,1> translate 2.25*y }
  object {Rib scale <1.5,1,1> translate -2.25*y}
  object {Rib scale <2,1,1> rotate 90*z translate 1.625*x }
  object {Rib scale <2,1,1> rotate -90*z translate -1.625*x}
       }
  box { <-1.3, -2.0, 0.075> <-1.2, 2.0, 0.2> }
  box { < 1.3, -2.0, 0.075> < 1.2, 2.0, 0.2> }
  box { <-1.3, -2.0, 0.075> < 1.3,-1.9, 0.2> }
  box { <-1.3,  2.0, 0.075> < 1.3, 1.9, 0.2> }
  object {Fluer scale .4 rotate -45*z  translate < 1.025, 1.725, 0.135>}
  object {Fluer scale .4 rotate  45*z  translate <-1.025, 1.725, 0.135>}
  object {Fluer scale .4 rotate -135*z translate < 1.025,-1.725, 0.135>}
  object {Fluer scale .4 rotate -225*z translate <-1.025,-1.725, 0.135>}
        }

#declare PlaqueStone= union{
object {Plaque scale 1.1 pigment { Wheat } finish { ambient .15 crand .1 } normal { granite scale 5 } }
text { ttf    "timrom.ttf", "ROBERT BURNS",   1.5,  0
       scale .25  translate <-.95, 1.2, .11>
       pigment {Wheat} finish { ambient .3 crand .1 }
        }
text { ttf    "timrom.ttf", " Born 25th Jan, 1759",   1.5,  0
       scale .25  translate <-1.1, .75, .11>
       pigment {Wheat} finish { ambient .3 crand .1 }
        }
text { ttf    "timrom.ttf", " Died 21st July, 1796",   1.5,  0
       scale .25  translate <-1.1, .5, .11>
       pigment {Wheat} finish { ambient .3 crand .1 }
        }
text { ttf    "timrom.ttf", "As cauld a wind as e'er blew,",   1.5,  0
       scale .2  translate <-1.25, 0, .11>
       pigment {Wheat} finish { ambient .3 crand .1 }
        }
text { ttf    "timrom.ttf", "A caulder kirk, and in't but few;",   1.5,  0
       scale .2  translate <-1.25, -.25, .11>
       pigment {Wheat} finish { ambient .3 crand .1 }
        }
text { ttf    "timrom.ttf", "A caulder preacher never spak;-",   1.5,  0
       scale .2  translate <-1.25, -.5, .11>
       pigment {Wheat} finish { ambient .3 crand .1 }
        }
text { ttf    "timrom.ttf", "Ye'se a be het ere I come back.",   1.5,  0
       scale .2  translate <-1.25, -.75, .11>
       pigment {Wheat} finish { ambient .3 crand .1 }
        }
text { ttf    "timrom.ttf", " R. I. P. ",   1.5,  0
       scale .25  translate <-0.35, -1.35, .11>
       pigment {Wheat} finish { ambient .3 crand .1 }
        }
     }

   object {PlaqueStone scale 2.5 translate <29, 8, 3.15>}

  #declare Pages= difference {
box { <-.55, -.175, -.75>  < .5,  .175,  .75> }

cylinder { -.76*z,  .76*z,  .3  translate .575*x}
  }

#declare Cover= difference {
                  union {
box { <-.55, -.185, -.8>  < .4,  .185,  .8>  }
cylinder { -.8*z,  .8*z,  .175 scale <.9,1.2,1> translate -.53*x}
            }

box { <-.6, -.175, -.9>  < .45,  .175,  .9> }
cylinder { -.85*z,  .85*z,  .15  scale <.9,1.2,1> translate -.525*x}
    }

   #declare Bible= union{
    object { Pages pigment { gradient y scale .0001
                       colour_map { [ 0.0 color Copper ]
                                    [ 0.9 color Gray ]
                                  }
                                 }
                                }
  difference{
    object { Cover
            pigment { Black }
            finish  { Phong_Shiny }
            normal  { dents 1 scale .09 }
            }
    box { <-.3, .184, 0> <.1, .19, .08> pigment {Silver} finish {reflection .2} }
    box { <-.14, .1845, -.4> <-.06, .19, .2> pigment {Silver} finish {reflection .2} }
          }
          }

     object { Bible scale .6 rotate 20*y translate < 8.3,-2.5, -20.7>}
     object { Bible scale .6 rotate -30*y translate < 7.1,-0.912, -19.6>}
     object { Bible scale .6 rotate 5*y translate < 8.8, -2.58, -11.75>}
     object { Bible scale .6 translate < 2.85,-2.51, -11>}
     object { Bible scale .6 rotate -10*y translate < 2.85,-2.264, -11>}

   object { #declare BaseLength=1.85
            #declare LengthInc=1.25
            #declare IncSplits=1.15
            #include "trees.inc"
            translate < 9.2, .22, 17.5>
           }
