/*
  a : center
  b : radius
  c : color / intensity
  d : steps
*/
#macro light_sphere (a,b,c,d)
	#local Count = 0;
	#local C = <-b,-b,-b>;
	#local Step = b/(d+1)*2;
	#while (C.x <= b)
		#local Dist = vlength(C);
		#if (Dist <= b)
			#local Count = Count + 1;
		#end
		#local C = <C.x,C.y,C.z> + <0,0,Step>;
		#if (C.z > b)
			#local C = <C.x,C.y,C.z> + <0,Step,0>;
			#local C = <C.x,C.y,-b>;
			#if (C.y > b)
				#local C = <C.x,C.y,C.z> + <Step,0,0>;
				#local C = <C.x,-b,C.z>;
			#end
		#end	
	#end
	#render concat("Light Sphere being created with ", str(Count,0,0), " lights inside.\n")
	#local Color = c/Count;
	#local C = <-b,-b,-b>;
	#while (C.x <= b)
		#local Dist = vlength(C);
		#if (Dist <= b)
			light_source {a+C color rgb Color}
		#end
		#local C = <C.x,C.y,C.z> + <0,0,Step>;
		#if (C.z > b)
			#local C = <C.x,C.y,C.z> + <0,Step,0>;
			#local C = <C.x,C.y,-b>;
			#if (C.y > b)
				#local C = <C.x,C.y,C.z> + <Step,0,0>;
				#local C = <C.x,-b,C.z>;
			#end
		#end	
	#end
#end

#macro light_cube (a,b,c,d)
	#local Count = 0;
	#local C = <-b,-b,-b>;
	#local Step = b/(d+1)*2;
	#while (C.x <= b)
		#local Count = Count + 1;
		#local C = <C.x,C.y,C.z> + <0,0,Step>;
		#if (C.z > b)
			#local C = <C.x,C.y,C.z> + <0,Step,0>;
			#local C = <C.x,C.y,-b>;
			#if (C.y > b)
				#local C = <C.x,C.y,C.z> + <Step,0,0>;
				#local C = <C.x,-b,C.z>;
			#end
		#end	
	#end
	#render concat("Light cube being created with ", str(Count,0,0), " lights inside.\n")
	#local Color = c/Count;
	#local C = <-b,-b,-b>;
	#while (C.x <= b)
		light_source {a+C color rgb Color}
		#local C = <C.x,C.y,C.z> + <0,0,Step>;
		#if (C.z > b)
			#local C = <C.x,C.y,C.z> + <0,Step,0>;
			#local C = <C.x,C.y,-b>;
			#if (C.y > b)
				#local C = <C.x,C.y,C.z> + <Step,0,0>;
				#local C = <C.x,-b,C.z>;
			#end
		#end	
	#end
#end

/*
  a : center
  b : radius
  c : color / intensity
  d : steps
  e : fade_power
  f : fade_distance
*/
#macro light_sphere_atten (a,b,c,d,e,f)
	#local Count = 0;
	#local C = <-b,-b,-b>;
	#local Step = b/(d+1)*2;
	#while (C.x <= b)
		#local Dist = vlength(C);
		#if (Dist <= b)
			#local Count = Count + 1;
		#end
		#local C = <C.x,C.y,C.z> + <0,0,Step>;
		#if (C.z > b)
			#local C = <C.x,C.y,C.z> + <0,Step,0>;
			#local C = <C.x,C.y,-b>;
			#if (C.y > b)
				#local C = <C.x,C.y,C.z> + <Step,0,0>;
				#local C = <C.x,-b,C.z>;
			#end
		#end	
	#end
	#render concat("Attenuated Light Sphere being created with ", str(Count,0,0), " lights inside.\n")
	#local Color = c/Count;
	#local C = <-b,-b,-b>;
	#while (C.x <= b)
		#local Dist = vlength(C);
		#if (Dist <= b)
			light_source {a+C color rgb Color fade_power e fade_distance f}
		#end
		#local C = <C.x,C.y,C.z> + <0,0,Step>;
		#if (C.z > b)
			#local C = <C.x,C.y,C.z> + <0,Step,0>;
			#local C = <C.x,C.y,-b>;
			#if (C.y > b)
				#local C = <C.x,C.y,C.z> + <Step,0,0>;
				#local C = <C.x,-b,C.z>;
			#end
		#end	
	#end
#end

#macro light_cube_atten (a,b,c,d)
	#local Count = 0;
	#local C = <-b,-b,-b>;
	#local Step = b/(d+1)*2;
	#while (C.x <= b)
		#local Count = Count + 1;
		#local C = <C.x,C.y,C.z> + <0,0,Step>;
		#if (C.z > b)
			#local C = <C.x,C.y,C.z> + <0,Step,0>;
			#local C = <C.x,C.y,-b>;
			#if (C.y > b)
				#local C = <C.x,C.y,C.z> + <Step,0,0>;
				#local C = <C.x,-b,C.z>;
			#end
		#end	
	#end
	#render concat("Light cube being created with ", str(Count,0,0), " lights inside.\n")
	#local Color = c/Count;
	#local C = <-b,-b,-b>;
	#while (C.x <= b)
		light_source {a+C color rgb Color fade_power e fade_distance f}
		#local C = <C.x,C.y,C.z> + <0,0,Step>;
		#if (C.z > b)
			#local C = <C.x,C.y,C.z> + <0,Step,0>;
			#local C = <C.x,C.y,-b>;
			#if (C.y > b)
				#local C = <C.x,C.y,C.z> + <Step,0,0>;
				#local C = <C.x,-b,C.z>;
			#end
		#end	
	#end
#end

/*
  The following takes just over 8 minutes total on my k6-233 64m RAM under win98 at 320x240 no aa.
  
plane {y,0 pigment {color green 1}}
box {<-5,3,0>,<2,4,10> pigment {color red 1} finish {specular 1}}
sphere {<0,5,3>,1 pigment {color blue 1} finish {specular 1}}

camera {location <0,6,-6> look_at <0,4,-1>}
light_sphere (<-5,8,5>,1,<2,2,2>,9)
background{blue 1}
global_settings { ambient_light color 0 }
*/