#macro Spline (oldt, P)
    /* Get the size of the array */
    
    #local n = dimension_size(P,1);
    #local n = n - 1;

    /* Figure out which curve segment the oldt is in */
    #local segment = int(oldt*(n - 2)) + 1;

    /* Get the array position of the last point in this curve segment */
    #local i = segment + 2;

	#if (oldt < 1.0)
    /* Create the array used to compute the Catmull-Rom spline */
    #local c = array[4]
    #local c[0] =   -P[i-3] + 3*P[i-2] - 3*P[i-1] + P[i];
    #local c[1] =  2*P[i-3] - 5*P[i-2] + 4*P[i-1] - P[i];
    #local c[2] =   -P[i-3]            +   P[i-1];
    #local c[3] =             2*P[i-2];

    #local t1 = oldt*(n - 2) - segment + 1;
    #local t2 = t1*t1;
    #local t3 = t2*t1;
    #end

    /* Debugging message */
//  #render concat("t = ",str(t1,3,3),", segment = ",str(segment,3,0))
//  #render concat(", points from ",str(i-3,3,0)," to ",str(i,3,0),"\n")

    #if (oldt >= 1.0)
        #local answer = P[n - 1];
    #else
        #local answer = 0.5*(c[0]*t3 + c[1]*t2 + c[2]*t1 + c[3]);
    #end
    
    (answer)
#end
