//California Snowman

#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#include "metals.inc"
#include "woods.inc"
#include "scarf.inc"

global_settings{max_trace_level 10}

camera {
  location <0,3,-5>
  look_at <0,1.5,0>
}

plane {
  z,5
  texture {
    pigment {White}
    normal {bumps 0.2 scale 0.01}
  }
}

light_source {
  <20,20,-20>
  color White*2
  area_light <3,0,0>,<0,0,-3>,10,10
  adaptive 1
}

union {
  difference {
    box {
      <-10,-0.75,-4.9>,<10,0,4.9>
    }
    box {
      <2,-0.05,-1>,<2.5,0.001,-1.5>
    }
  }
  height_field {
    png "cdjsnow2.png" 
    smooth
    scale <0.5,0.05,0.5>                                                                                     
    translate <2,0,-1.5>
  }
  texture {T_Wood1 scale 3 rotate -x*3 rotate y*87}
}

#declare Jar=difference {
  merge {
    cylinder {
      <0,0,0>,<0,2,0>,1
    }
    sphere {
      <0,2,0>,1
    }
  }
  merge {
    cylinder {
      <0,-0.001,0>,<0,2,0>,0.95
    }
    sphere {
      <0,2,0>,0.95
    }
  }
  texture {         
    pigment {rgbf<0.98,0.98,1,1>}
    finish {phong 0.5 reflection 0.04}
  }
  interior {ior 1.5  caustics 1}
}

#declare WaterShape=merge {
  cylinder {
    <0,-0.001,0>,<0,1.991,0>,0.949
    texture {         
      pigment {rgbf<1,1,1,1>}
      finish {phong 0.0 reflection 0.00}
    }
    interior {ior 1.33 caustics 1}
  }                   
  /*
  cylinder {
    <0,1.99,0>,<0,2,0>,0.949
    texture {         
      pigment {rgbf<1,1,1,1>}
      finish {phong 0.5 reflection 0.04}
      normal {ripples 1 scale 0.1}
    }
    interior {ior 1.33 caustics 1}
  } 
  */
  texture {         
    pigment {rgbf<1,1,1,1>}
    finish {phong 0.0 reflection 0.00}
  }
  interior {ior 1.33 caustics 1}
}              

object {Jar translate y*0.5}
object {WaterShape translate y*0.5}
cone {
  <-0.5,2.45,0>,0.1,<0.5,2.5,0>,0
  rotate y*47
  translate <0.2,0,-0.1>
  pigment {Orange}
}
sphere {
  <-0.5,0.55,0>,0.05
  pigment {Black}
}
sphere {
  <0.5,0.55,0>,0.05
  pigment {Black}
}
cylinder {
  <0,0,0>,<0,0.5,0>,1.1
  pigment {White_Marble}
  finish {phong 0.1}
}          
intersection {
  cylinder {
    <0,0.05,0>,<0,0.45,0>,1.15
    texture {
      material_map {
        png "cdjsnow1.png"
        map_type 2   
        interpolate 2
        texture {pigment {Black}}
        texture {T_Gold_5E}
      }
      scale <1,0.4,1>
      translate y*0.05
      rotate y*150
    }
  }
  plane {
    x,0
    rotate -y*60
  }
  plane {
    -x,0
    rotate y*60
  }
}

object {Scarf scale 0.2 translate <-0.35,0.510,0.35>} 

#declare Pipe=union {
  difference {
    merge {
      cylinder {
        <0,0,0>,<0,2,0>,1
      }
      sphere {
        <0,2,0>,1
      }
    }
    merge {
      cylinder {
        <0,-0.001,0>,<0,2,0>,0.95
      }
      sphere {
        <0,2,0>,0.95
      }
    }
  }
  cylinder {
    <1,2,0>,<4,2,0>,0.2
  }
  pigment {rgb <1,1,0>}
  scale 0.06
}  

object {Pipe rotate x*90 rotate -z*10 translate y*0.06 translate <0,0.5,-0.5> }