// Author: Frank Epple.
// We're just two souls swimming in a fishbowl...

//#declare FAST_RENDER = 1

#include "colors.inc"
#include "metals.inc"
#include "woods.inc"

// ----------------------------------------------------------------------------------------
// Material declarations
// ----------------------------------------------------------------------------------------

#declare WATER_TEXTURE =
texture
  {
  pigment { color rgbf <0.95,0.95,1.0,0.8> }
  finish
  {
    ambient 0.4
    diffuse 0.6
    phong 1
    reflection 0.2
    ambient 0.1
    diffuse 0.2
    refraction 1
    ior 1.33
  }
  }

#declare FRONTPANEL = texture
{
  pigment
    {
      bozo
      color_map
      {
        [0.1  color rgb <0.90,0.81,0.30>]
        [0.3  color rgb <0.91,0.85,0.30>]
        [0.6  color rgb <0.87,0.82,0.27>]
        [0.6  color rgb <0.92,0.83,0.31>]
        [0.8  color rgb <0.89,0.82,0.29>]
      }
      scale 0.2
    }
  finish
    {
      ambient 0.4
      diffuse 0.6
      reflection 0.1
    }
}

#declare PLATEWOOD = texture
{        // Basecolor of the wood:
  pigment
  {
     color rgb <240/255, 210/255, 160/255>
  }
  finish
  {
    ambient 0.4
    diffuse 0.6
  }
}
texture
{      // Other colors inside the wood:
  pigment
  {
     wood
     color_map
     {
        [ 0.0     rgbf <0.84, 0.59, 0.39, 0.10> ]
        [ 0.1     rgbf <0.84, 0.55, 0.39, 0.50> ]
        [ 0.1     rgbf <0.85, 0.61, 0.42, 0.65> ]
        [ 0.2     rgbf <0.99, 0.72, 0.68, 0.97> ]
        [ 0.3     rgbf <0.89, 0.57, 0.47, 1.00> ]
        [ 0.4     rgbf <0.91, 0.64, 0.55, 0.50> ]
        [ 0.9     rgbf <0.91, 0.81, 0.66, 0.97> ]
        [ 1.0     rgbft <0.772213, 0.510259, 0.373587, 1.0, 0.0> ]
     }
     turbulence 0.1
     octaves 5
     lambda 3.25
     scale  <0.15, 0.5, 1.0>
     translate -2.0 * x
  }
  finish
  {
    ambient 0.4
    diffuse 0.6
  }
}

#declare P_Chrome5   = color rgb <0.95, 0.95, 0.95>
#declare F_MetalB  =
finish {
    ambient 0.38
    brilliance 3
    diffuse 0.6
    metallic
    specular 0.70
    roughness 0.005
    reflection 0.03
}

#declare CHROME = texture
{
  pigment { P_Chrome5 }
  normal
  {
    bumps 0.03
    scale 0.03
  }
  finish { F_MetalB  }
}

#declare TFLIESE = texture
{
      pigment
      {
         marble
         color_map
         {
            [ 0.00  rgb <1.00, 1.00, 1.00> ]
            [ 0.16  rgb <1.00, 1.00, 1.00> ]
            [ 0.39  rgb <1.00, 0.93, 0.91> ]
            [ 0.43  rgb <1.00, 0.97, 0.93> ]
            [ 0.64  rgb <1.00, 1.00, 1.00> ]
            [ 1.00  rgb <1.00, 1.00, 1.00> ]
         }
         turbulence 1.5
         lambda 2.0
         frequency 1.0
         scale 10
      }   
      finish
      {
        ambient 0.4
        diffuse 0.6
        reflection 0.05
      }
}

#declare MOERTEL = texture
{
  pigment
    {
      color rgb <0.95,0.95,0.95>
    }
  normal
    {
      bumps 0.3
      scale 0.1
    }
  finish
    {
      ambient 0.4
      diffuse 0.6
    }
}

// ----------------------------------------------------------------------------------------
// Parameters
// ----------------------------------------------------------------------------------------

// ----------------------------------------------------------------------------------------
// SCENE
// ----------------------------------------------------------------------------------------

//camera { location <0.0, 70.0, -60> look_at <15,25,-10> angle 30}  // Water Camera.
camera { location <0.0, 70.0, -60> look_at <50,20,0> }  // Competition Camera!
//camera { location <25.0, 40.0, 25> look_at <25,0,25> }  // TopView for adjusting the waves.

light_source
  {
    <200,2700,-2900>
    rgb 1
  }

#declare r = 3

#declare RIPPE = union
{
  cylinder
    {
      <0, 0, 0>
      <52, 0, 0>
      r
    }
  sphere
    {
      <52,0,0>
      r
    }
}

#declare UN = 1.6
#declare DI = 4.45

#declare BECKEN = union
{
  difference
    {
      difference
        {
          superellipsoid
            {
              <0.1,0.1>
              scale <50,15,25>
              translate <50,-15,25>
            }

          #declare N = 1
          #while (N<9)
            object { RIPPE translate <43,sqrt(r*r+r*r)/UN,42-N*DI>}
            #declare N = N + 1
          #end
        }
      superellipsoid
        {
          <0.1,0.1>
          scale <20,20,18.5>
          translate <25,0,21>
        }
    }

  texture  { CHROME }
}

#declare DEGREE = (pi/180.0)

#declare l = 10
#declare HAHN1 = union
{
  difference
    {
      torus
        {
          2.0,1.0
        }
      prism
        {
          linear_sweep
          -1.1,1.1
          6
          <0,0>, <4.1,0>, <4.1,-4.1>, <-4.1,-4.1>, <-4.1,4.1*tan(60*DEGREE)>, <0,0>
        }
    }

  cylinder
    {
      <-2*cos(60*DEGREE), 0, 2*sin(60*DEGREE)>
      <-2*cos(60*DEGREE) - l*cos(30*DEGREE), 0, 2*sin(60*DEGREE) - l*sin(30*DEGREE)>
      1.0
    }
}

#declare HENKEL = union
{
  difference
  {
    sphere
    {
      <0,0,0>
      5.1
    }
    plane
    {
      y,0
    }
  }

  cylinder
  {
    <0,2.5,3.4>
    <7,2.5,3.4>
    0.5
  }
  cylinder
  {
    <0,2.5,-3.4>
    <7,2.5,-3.4>
    0.5
  }

  difference
  {
    torus
    {
      3.4,0.5
      translate <7,2.5,0>
    }
    plane
    {
      x,7
    }
  }
}

#declare HAHN = union
{
  object
  {
    HAHN1
    rotate <-90,0,0>
    scale 2
    translate <20,8,0>
  }
  cylinder
    {
      <0,0,0>
      <0,7,0>
      5
    }
  sphere
    {
      <0,7,0>
      5
    }
  object
    {
      HENKEL
      translate <0,9,0>
      rotate <0,30,0>
    }

  texture { T_Chrome_5C } //T_Chrome_2E }
}

#declare WOOD = difference
{
  union
  {
    box
    {
      <-100,-3,-5>
      < 200,-10,60>
    }
    cylinder
    {
      <-100,-6.5,-5>
      < 200,-6.5,-5>
      3.5
    }
  }
  superellipsoid
    {
      <0.1,0.1>
      scale <50,15,25>
      translate <50,-15,25>
    }

  texture { PLATEWOOD scale 20 rotate 90*y}
}

#declare WOOD_FRONT = box
{
  <-100,-10,-2>
  < 200,-100,-3>

  texture { FRONTPANEL } //scale 20 rotate 90*x}
}

#declare FLIESE = difference
{
  superellipsoid
  {
    <0.1,0.1>
  }
  plane
  {
    -z,0.87
  }

  translate <0,0,0.87>
  scale 10

  texture {TFLIESE}
}


#declare WALL = union
{
  #declare FY = 0
  #while (FY < 4)
    #declare FX = 0
    #while (FX < 10)
      object
        {
          FLIESE
          translate <FX*21,8+5+FY*21,60>
        }
      #declare FX = FX + 1
    #end
    #declare FY = FY + 1
  #end

  box
  {
    <-10,-3,60>
    <200,100,61>
    texture { MOERTEL }
  }
}

#declare WATER = height_field
{
  ppm "Surface.ppm"
  smooth
  translate <-0.5,-0.5,-0.5>   // First translate that the middle of the field
                              // is in <0,0,0>
  scale <40.0, 280.0, 40.0>
  texture { WATER_TEXTURE }
}

#declare LEISTE = difference
{
  box
  {
    <-100,0,0>
    <200,5,5>
  }

  cylinder
  {
    <-100,5,0>
    <200,5,0>
    3.5
  }

  texture { PLATEWOOD }
}

// ----------------------------------------------------------------------------------------
// Setting all Objects into the Scene:
// ----------------------------------------------------------------------------------------

object { BECKEN }

object
{
  HAHN
  rotate <0,90,0>
  translate <25,0,45>
}

object{ WOOD }

object
{
  LEISTE
  translate <0,-3,60-5>
}

object{ WOOD_FRONT }

object { WALL }

object
{
  WATER
  translate <25,-15,21>
}
