global_settings { max_trace_level 25 }
//camera { location <0,1,-3> look_at y*.75 } //orginal
camera { location <-.1,2,-4> look_at y*1.25 }
//camera { location <-.1,.5,-4> look_at <0,.25,-3> }
light_source { <-1500,1000,500> rgb 1.5 }

sky_sphere {
  pigment { gradient y color_map { [0 rgb 1] [.1 rgb <.8,.8,1>] [1 rgb <.5,.5,1>] } }
  pigment {
    wrinkles
    color_map { [0 rgbt <.95,.95,1,.2> ] [.3 rgbt <.8,.8,1,1> ] }
    scale <.5,.1,1>
    translate <-.5,0,.5>
    rotate x*30
  }
}

fog {
  fog_type 2
  distance 10
  rgbt <.6,.5,.2,0>
  fog_offset 1
  fog_alt .5
  turbulence 1
}

//mountains
height_field {
  tga "mounts.tga"
  pigment { rgb <.6,.5,.2> }
  finish { ambient .7 }
  translate <-.5,0,0>
  scale <250,20,250>
  translate <35,0,100>
}

//waterglass
difference {
  merge {
    cylinder { y*.1,<0,1.75,0>,.5 }
    cylinder { y*0,<0,1.75,0>,.4 }
    torus { .4,.1 translate y*.1 }
    torus { .475,.025 translate y*1.75 }
  }
  cylinder { y*.2,y*2,.45 }
  cylinder { y*.1,y*2,.35 }
  torus { .35,.1 translate y*.2 }
  pigment { color rgbt <0.9, 0.9, 0.98, .85> }
  finish  {
    ambient 0.1
    diffuse 0.1
    reflection 0.1
    refraction 1
    ior 1.5
    specular 0.8
    roughness 0.003
    phong 1
    phong_size 400
    caustics .5
  }
}

//wateringlass
difference {
  merge {
    cylinder { y*.2,y*2,.45 }
    cylinder { y*.1,y*2,.35 }
    torus { .35,.1 translate y*.2 }
    scale <.9999,1,.9999>
  }
  plane { -y,-1.25 }
//  pigment { color rgbf <.98,.98,1,.7> }
  pigment { color rgbf <.98,.98,1,1> }
  finish {
    reflection 0.1
    refraction 1
    ior 1.33
    caustics .7
  }
  translate y*.0001
}

/*plane { y,-.0001
  pigment { leopard color_map { [0 rgb <.7,.6,.2>] [1 rgb <1,.9,.4>] } scale .1 }
}*/


#declare yt=-.95
#while (yt<0)
plane { y,-.0001
    pigment {
      crackle
      #declare tiletrans = pigment {
        crackle
        color_map {
          [0.079        rgbt <1, 1, 1, 1> ] //transparent
          [0.08         rgbt 2*<1+yt*.4, .9+yt*.45, .3+yt*.15, .5> ] //outside-
          [0.15         rgbt 2*<1+yt*.4, .9+yt*.45, .3+yt*.15, .5> ] //-mid outer edge-
          [0.3          rgbt 2*<.9+yt*.3, .75+yt*.3, .3+yt*.15, .5> ] //-mid inner edge-
          [0.80         rgbt 2*<.6, .45, .15, .5> ] //-center
        }
      }
      #declare tilecolor = pigment {
        crackle
        color_map {
          [0.079        rgbt <1, 1, 1, 1> ] //transparent
          [0.08         rgb <1+yt*.4, .9+yt*.45, .3+yt*.15> ] //outside-
          [0.15         rgb <1+yt*.4, .9+yt*.45, .3+yt*.15> ] //-mid outer edge-
          [0.3          rgb <.9+yt*.3, .75+yt*.3, .3+yt*.15> ] //-mid inner edge-
          [0.80         rgb <.6, .45, .15> ] //-center
        }
      }
      pigment_map {
        [.03-pow(yt,5)*.1 tiletrans ]
        [.03-pow(yt,5)*.1 tilecolor ]
        [1-pow(1+yt,2)*1.075 tilecolor ]
        [1.1-pow(1+yt,2)*1.075 tiletrans ]
        #debug str(.03-pow(yt,5)*.1,0,3) #debug "_"
//        #debug str(.802-pow(1+yt,3)*.9,0,3) #debug "_"
//        #debug str(.95-pow(1+yt,3)*.9,0,3) #debug "\n"
//        #debug str(1-pow(1+yt,3)*1.131,0,3) #debug "_"
//        #debug str(1.1-pow(1+yt,3)*1.131,0,3) #debug "\n"
        #debug str(1-pow(1+yt,2)*1.074,0,3) #debug "_"
        #debug str(1.05-pow(1+yt,2)*1.074,0,3) #debug "\n"
        [1.00 tiletrans ]
      }
    }
    translate y*yt
    scale <1,.15,1>
    translate y*-.0001
}
#declare yt=yt+.05
#end
plane { y,-.15 pigment { rgb <.6,.45,.15> } }

